var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
(function() {
  "use strict";
  /**
  * @vue/shared v3.5.18
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function makeMap(str) {
    const map = /* @__PURE__ */ Object.create(null);
    for (const key of str.split(",")) map[key] = 1;
    return (val) => val in map;
  }
  const EMPTY_OBJ = {};
  const EMPTY_ARR = [];
  const NOOP = () => {
  };
  const NO = () => false;
  const isOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // uppercase letter
  (key.charCodeAt(2) > 122 || key.charCodeAt(2) < 97);
  const isModelListener = (key) => key.startsWith("onUpdate:");
  const extend = Object.assign;
  const remove = (arr, el) => {
    const i = arr.indexOf(el);
    if (i > -1) {
      arr.splice(i, 1);
    }
  };
  const hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  const hasOwn = (val, key) => hasOwnProperty$1.call(val, key);
  const isArray = Array.isArray;
  const isMap = (val) => toTypeString(val) === "[object Map]";
  const isSet = (val) => toTypeString(val) === "[object Set]";
  const isDate = (val) => toTypeString(val) === "[object Date]";
  const isRegExp = (val) => toTypeString(val) === "[object RegExp]";
  const isFunction = (val) => typeof val === "function";
  const isString = (val) => typeof val === "string";
  const isSymbol = (val) => typeof val === "symbol";
  const isObject$1 = (val) => val !== null && typeof val === "object";
  const isPromise$1 = (val) => {
    return (isObject$1(val) || isFunction(val)) && isFunction(val.then) && isFunction(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const isPlainObject = (val) => toTypeString(val) === "[object Object]";
  const isIntegerKey = (key) => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  const isReservedProp = /* @__PURE__ */ makeMap(
    // the leading comma is intentional so empty string "" is also included
    ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
  );
  const cacheStringFunction = (fn) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str) => {
      const hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  };
  const camelizeRE = /-(\w)/g;
  const camelize = cacheStringFunction(
    (str) => {
      return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : "");
    }
  );
  const hyphenateRE = /\B([A-Z])/g;
  const hyphenate = cacheStringFunction(
    (str) => str.replace(hyphenateRE, "-$1").toLowerCase()
  );
  const capitalize = cacheStringFunction((str) => {
    return str.charAt(0).toUpperCase() + str.slice(1);
  });
  const toHandlerKey = cacheStringFunction(
    (str) => {
      const s = str ? `on${capitalize(str)}` : ``;
      return s;
    }
  );
  const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
  const invokeArrayFns = (fns, ...arg) => {
    for (let i = 0; i < fns.length; i++) {
      fns[i](...arg);
    }
  };
  const def = (obj, key, value, writable = false) => {
    Object.defineProperty(obj, key, {
      configurable: true,
      enumerable: false,
      writable,
      value
    });
  };
  const looseToNumber = (val) => {
    const n = parseFloat(val);
    return isNaN(n) ? val : n;
  };
  const toNumber = (val) => {
    const n = isString(val) ? Number(val) : NaN;
    return isNaN(n) ? val : n;
  };
  let _globalThis;
  const getGlobalThis = () => {
    return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
  };
  function normalizeStyle(value) {
    if (isArray(value)) {
      const res = {};
      for (let i = 0; i < value.length; i++) {
        const item = value[i];
        const normalized = isString(item) ? parseStringStyle(item) : normalizeStyle(item);
        if (normalized) {
          for (const key in normalized) {
            res[key] = normalized[key];
          }
        }
      }
      return res;
    } else if (isString(value) || isObject$1(value)) {
      return value;
    }
  }
  const listDelimiterRE = /;(?![^(]*\))/g;
  const propertyDelimiterRE = /:([^]+)/;
  const styleCommentRE = /\/\*[^]*?\*\//g;
  function parseStringStyle(cssText) {
    const ret = {};
    cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
      if (item) {
        const tmp = item.split(propertyDelimiterRE);
        tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
      }
    });
    return ret;
  }
  function normalizeClass(value) {
    let res = "";
    if (isString(value)) {
      res = value;
    } else if (isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        const normalized = normalizeClass(value[i]);
        if (normalized) {
          res += normalized + " ";
        }
      }
    } else if (isObject$1(value)) {
      for (const name in value) {
        if (value[name]) {
          res += name + " ";
        }
      }
    }
    return res.trim();
  }
  const specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
  const isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
  function includeBooleanAttr(value) {
    return !!value || value === "";
  }
  function looseCompareArrays(a, b) {
    if (a.length !== b.length) return false;
    let equal = true;
    for (let i = 0; equal && i < a.length; i++) {
      equal = looseEqual(a[i], b[i]);
    }
    return equal;
  }
  function looseEqual(a, b) {
    if (a === b) return true;
    let aValidType = isDate(a);
    let bValidType = isDate(b);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? a.getTime() === b.getTime() : false;
    }
    aValidType = isSymbol(a);
    bValidType = isSymbol(b);
    if (aValidType || bValidType) {
      return a === b;
    }
    aValidType = isArray(a);
    bValidType = isArray(b);
    if (aValidType || bValidType) {
      return aValidType && bValidType ? looseCompareArrays(a, b) : false;
    }
    aValidType = isObject$1(a);
    bValidType = isObject$1(b);
    if (aValidType || bValidType) {
      if (!aValidType || !bValidType) {
        return false;
      }
      const aKeysCount = Object.keys(a).length;
      const bKeysCount = Object.keys(b).length;
      if (aKeysCount !== bKeysCount) {
        return false;
      }
      for (const key in a) {
        const aHasKey = a.hasOwnProperty(key);
        const bHasKey = b.hasOwnProperty(key);
        if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a[key], b[key])) {
          return false;
        }
      }
    }
    return String(a) === String(b);
  }
  function looseIndexOf(arr, val) {
    return arr.findIndex((item) => looseEqual(item, val));
  }
  const isRef$1 = (val) => {
    return !!(val && val["__v_isRef"] === true);
  };
  const toDisplayString = (val) => {
    return isString(val) ? val : val == null ? "" : isArray(val) || isObject$1(val) && (val.toString === objectToString || !isFunction(val.toString)) ? isRef$1(val) ? toDisplayString(val.value) : JSON.stringify(val, replacer, 2) : String(val);
  };
  const replacer = (_key, val) => {
    if (isRef$1(val)) {
      return replacer(_key, val.value);
    } else if (isMap(val)) {
      return {
        [`Map(${val.size})`]: [...val.entries()].reduce(
          (entries, [key, val2], i) => {
            entries[stringifySymbol(key, i) + " =>"] = val2;
            return entries;
          },
          {}
        )
      };
    } else if (isSet(val)) {
      return {
        [`Set(${val.size})`]: [...val.values()].map((v) => stringifySymbol(v))
      };
    } else if (isSymbol(val)) {
      return stringifySymbol(val);
    } else if (isObject$1(val) && !isArray(val) && !isPlainObject(val)) {
      return String(val);
    }
    return val;
  };
  const stringifySymbol = (v, i = "") => {
    var _a;
    return (
      // Symbol.description in es2019+ so we need to cast here to pass
      // the lib: es2016 check
      isSymbol(v) ? `Symbol(${(_a = v.description) != null ? _a : i})` : v
    );
  };
  function normalizeCssVarValue(value) {
    if (value == null) {
      return "initial";
    }
    if (typeof value === "string") {
      return value === "" ? " " : value;
    }
    return String(value);
  }
  /**
  * @vue/reactivity v3.5.18
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  let activeEffectScope;
  class EffectScope {
    constructor(detached = false) {
      this.detached = detached;
      this._active = true;
      this._on = 0;
      this.effects = [];
      this.cleanups = [];
      this._isPaused = false;
      this.parent = activeEffectScope;
      if (!detached && activeEffectScope) {
        this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(
          this
        ) - 1;
      }
    }
    get active() {
      return this._active;
    }
    pause() {
      if (this._active) {
        this._isPaused = true;
        let i, l;
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].pause();
          }
        }
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].pause();
        }
      }
    }
    /**
     * Resumes the effect scope, including all child scopes and effects.
     */
    resume() {
      if (this._active) {
        if (this._isPaused) {
          this._isPaused = false;
          let i, l;
          if (this.scopes) {
            for (i = 0, l = this.scopes.length; i < l; i++) {
              this.scopes[i].resume();
            }
          }
          for (i = 0, l = this.effects.length; i < l; i++) {
            this.effects[i].resume();
          }
        }
      }
    }
    run(fn) {
      if (this._active) {
        const currentEffectScope = activeEffectScope;
        try {
          activeEffectScope = this;
          return fn();
        } finally {
          activeEffectScope = currentEffectScope;
        }
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    on() {
      if (++this._on === 1) {
        this.prevScope = activeEffectScope;
        activeEffectScope = this;
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    off() {
      if (this._on > 0 && --this._on === 0) {
        activeEffectScope = this.prevScope;
        this.prevScope = void 0;
      }
    }
    stop(fromParent) {
      if (this._active) {
        this._active = false;
        let i, l;
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].stop();
        }
        this.effects.length = 0;
        for (i = 0, l = this.cleanups.length; i < l; i++) {
          this.cleanups[i]();
        }
        this.cleanups.length = 0;
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].stop(true);
          }
          this.scopes.length = 0;
        }
        if (!this.detached && this.parent && !fromParent) {
          const last = this.parent.scopes.pop();
          if (last && last !== this) {
            this.parent.scopes[this.index] = last;
            last.index = this.index;
          }
        }
        this.parent = void 0;
      }
    }
  }
  function effectScope(detached) {
    return new EffectScope(detached);
  }
  function getCurrentScope() {
    return activeEffectScope;
  }
  let activeSub;
  const pausedQueueEffects = /* @__PURE__ */ new WeakSet();
  class ReactiveEffect {
    constructor(fn) {
      this.fn = fn;
      this.deps = void 0;
      this.depsTail = void 0;
      this.flags = 1 | 4;
      this.next = void 0;
      this.cleanup = void 0;
      this.scheduler = void 0;
      if (activeEffectScope && activeEffectScope.active) {
        activeEffectScope.effects.push(this);
      }
    }
    pause() {
      this.flags |= 64;
    }
    resume() {
      if (this.flags & 64) {
        this.flags &= -65;
        if (pausedQueueEffects.has(this)) {
          pausedQueueEffects.delete(this);
          this.trigger();
        }
      }
    }
    /**
     * @internal
     */
    notify() {
      if (this.flags & 2 && !(this.flags & 32)) {
        return;
      }
      if (!(this.flags & 8)) {
        batch(this);
      }
    }
    run() {
      if (!(this.flags & 1)) {
        return this.fn();
      }
      this.flags |= 2;
      cleanupEffect(this);
      prepareDeps(this);
      const prevEffect = activeSub;
      const prevShouldTrack = shouldTrack;
      activeSub = this;
      shouldTrack = true;
      try {
        return this.fn();
      } finally {
        cleanupDeps(this);
        activeSub = prevEffect;
        shouldTrack = prevShouldTrack;
        this.flags &= -3;
      }
    }
    stop() {
      if (this.flags & 1) {
        for (let link2 = this.deps; link2; link2 = link2.nextDep) {
          removeSub(link2);
        }
        this.deps = this.depsTail = void 0;
        cleanupEffect(this);
        this.onStop && this.onStop();
        this.flags &= -2;
      }
    }
    trigger() {
      if (this.flags & 64) {
        pausedQueueEffects.add(this);
      } else if (this.scheduler) {
        this.scheduler();
      } else {
        this.runIfDirty();
      }
    }
    /**
     * @internal
     */
    runIfDirty() {
      if (isDirty(this)) {
        this.run();
      }
    }
    get dirty() {
      return isDirty(this);
    }
  }
  let batchDepth = 0;
  let batchedSub;
  let batchedComputed;
  function batch(sub, isComputed = false) {
    sub.flags |= 8;
    if (isComputed) {
      sub.next = batchedComputed;
      batchedComputed = sub;
      return;
    }
    sub.next = batchedSub;
    batchedSub = sub;
  }
  function startBatch() {
    batchDepth++;
  }
  function endBatch() {
    if (--batchDepth > 0) {
      return;
    }
    if (batchedComputed) {
      let e = batchedComputed;
      batchedComputed = void 0;
      while (e) {
        const next = e.next;
        e.next = void 0;
        e.flags &= -9;
        e = next;
      }
    }
    let error;
    while (batchedSub) {
      let e = batchedSub;
      batchedSub = void 0;
      while (e) {
        const next = e.next;
        e.next = void 0;
        e.flags &= -9;
        if (e.flags & 1) {
          try {
            ;
            e.trigger();
          } catch (err) {
            if (!error) error = err;
          }
        }
        e = next;
      }
    }
    if (error) throw error;
  }
  function prepareDeps(sub) {
    for (let link2 = sub.deps; link2; link2 = link2.nextDep) {
      link2.version = -1;
      link2.prevActiveLink = link2.dep.activeLink;
      link2.dep.activeLink = link2;
    }
  }
  function cleanupDeps(sub) {
    let head;
    let tail = sub.depsTail;
    let link2 = tail;
    while (link2) {
      const prev = link2.prevDep;
      if (link2.version === -1) {
        if (link2 === tail) tail = prev;
        removeSub(link2);
        removeDep(link2);
      } else {
        head = link2;
      }
      link2.dep.activeLink = link2.prevActiveLink;
      link2.prevActiveLink = void 0;
      link2 = prev;
    }
    sub.deps = head;
    sub.depsTail = tail;
  }
  function isDirty(sub) {
    for (let link2 = sub.deps; link2; link2 = link2.nextDep) {
      if (link2.dep.version !== link2.version || link2.dep.computed && (refreshComputed(link2.dep.computed) || link2.dep.version !== link2.version)) {
        return true;
      }
    }
    if (sub._dirty) {
      return true;
    }
    return false;
  }
  function refreshComputed(computed2) {
    if (computed2.flags & 4 && !(computed2.flags & 16)) {
      return;
    }
    computed2.flags &= -17;
    if (computed2.globalVersion === globalVersion) {
      return;
    }
    computed2.globalVersion = globalVersion;
    if (!computed2.isSSR && computed2.flags & 128 && (!computed2.deps && !computed2._dirty || !isDirty(computed2))) {
      return;
    }
    computed2.flags |= 2;
    const dep = computed2.dep;
    const prevSub = activeSub;
    const prevShouldTrack = shouldTrack;
    activeSub = computed2;
    shouldTrack = true;
    try {
      prepareDeps(computed2);
      const value = computed2.fn(computed2._value);
      if (dep.version === 0 || hasChanged(value, computed2._value)) {
        computed2.flags |= 128;
        computed2._value = value;
        dep.version++;
      }
    } catch (err) {
      dep.version++;
      throw err;
    } finally {
      activeSub = prevSub;
      shouldTrack = prevShouldTrack;
      cleanupDeps(computed2);
      computed2.flags &= -3;
    }
  }
  function removeSub(link2, soft = false) {
    const { dep, prevSub, nextSub } = link2;
    if (prevSub) {
      prevSub.nextSub = nextSub;
      link2.prevSub = void 0;
    }
    if (nextSub) {
      nextSub.prevSub = prevSub;
      link2.nextSub = void 0;
    }
    if (dep.subs === link2) {
      dep.subs = prevSub;
      if (!prevSub && dep.computed) {
        dep.computed.flags &= -5;
        for (let l = dep.computed.deps; l; l = l.nextDep) {
          removeSub(l, true);
        }
      }
    }
    if (!soft && !--dep.sc && dep.map) {
      dep.map.delete(dep.key);
    }
  }
  function removeDep(link2) {
    const { prevDep, nextDep } = link2;
    if (prevDep) {
      prevDep.nextDep = nextDep;
      link2.prevDep = void 0;
    }
    if (nextDep) {
      nextDep.prevDep = prevDep;
      link2.nextDep = void 0;
    }
  }
  let shouldTrack = true;
  const trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
  }
  function cleanupEffect(e) {
    const { cleanup } = e;
    e.cleanup = void 0;
    if (cleanup) {
      const prevSub = activeSub;
      activeSub = void 0;
      try {
        cleanup();
      } finally {
        activeSub = prevSub;
      }
    }
  }
  let globalVersion = 0;
  class Link {
    constructor(sub, dep) {
      this.sub = sub;
      this.dep = dep;
      this.version = dep.version;
      this.nextDep = this.prevDep = this.nextSub = this.prevSub = this.prevActiveLink = void 0;
    }
  }
  class Dep {
    // TODO isolatedDeclarations "__v_skip"
    constructor(computed2) {
      this.computed = computed2;
      this.version = 0;
      this.activeLink = void 0;
      this.subs = void 0;
      this.map = void 0;
      this.key = void 0;
      this.sc = 0;
      this.__v_skip = true;
    }
    track(debugInfo) {
      if (!activeSub || !shouldTrack || activeSub === this.computed) {
        return;
      }
      let link2 = this.activeLink;
      if (link2 === void 0 || link2.sub !== activeSub) {
        link2 = this.activeLink = new Link(activeSub, this);
        if (!activeSub.deps) {
          activeSub.deps = activeSub.depsTail = link2;
        } else {
          link2.prevDep = activeSub.depsTail;
          activeSub.depsTail.nextDep = link2;
          activeSub.depsTail = link2;
        }
        addSub(link2);
      } else if (link2.version === -1) {
        link2.version = this.version;
        if (link2.nextDep) {
          const next = link2.nextDep;
          next.prevDep = link2.prevDep;
          if (link2.prevDep) {
            link2.prevDep.nextDep = next;
          }
          link2.prevDep = activeSub.depsTail;
          link2.nextDep = void 0;
          activeSub.depsTail.nextDep = link2;
          activeSub.depsTail = link2;
          if (activeSub.deps === link2) {
            activeSub.deps = next;
          }
        }
      }
      return link2;
    }
    trigger(debugInfo) {
      this.version++;
      globalVersion++;
      this.notify(debugInfo);
    }
    notify(debugInfo) {
      startBatch();
      try {
        if (false) ;
        for (let link2 = this.subs; link2; link2 = link2.prevSub) {
          if (link2.sub.notify()) {
            ;
            link2.sub.dep.notify();
          }
        }
      } finally {
        endBatch();
      }
    }
  }
  function addSub(link2) {
    link2.dep.sc++;
    if (link2.sub.flags & 4) {
      const computed2 = link2.dep.computed;
      if (computed2 && !link2.dep.subs) {
        computed2.flags |= 4 | 16;
        for (let l = computed2.deps; l; l = l.nextDep) {
          addSub(l);
        }
      }
      const currentTail = link2.dep.subs;
      if (currentTail !== link2) {
        link2.prevSub = currentTail;
        if (currentTail) currentTail.nextSub = link2;
      }
      link2.dep.subs = link2;
    }
  }
  const targetMap = /* @__PURE__ */ new WeakMap();
  const ITERATE_KEY = Symbol(
    ""
  );
  const MAP_KEY_ITERATE_KEY = Symbol(
    ""
  );
  const ARRAY_ITERATE_KEY = Symbol(
    ""
  );
  function track(target, type, key) {
    if (shouldTrack && activeSub) {
      let depsMap = targetMap.get(target);
      if (!depsMap) {
        targetMap.set(target, depsMap = /* @__PURE__ */ new Map());
      }
      let dep = depsMap.get(key);
      if (!dep) {
        depsMap.set(key, dep = new Dep());
        dep.map = depsMap;
        dep.key = key;
      }
      {
        dep.track();
      }
    }
  }
  function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) {
      globalVersion++;
      return;
    }
    const run = (dep) => {
      if (dep) {
        {
          dep.trigger();
        }
      }
    };
    startBatch();
    if (type === "clear") {
      depsMap.forEach(run);
    } else {
      const targetIsArray = isArray(target);
      const isArrayIndex = targetIsArray && isIntegerKey(key);
      if (targetIsArray && key === "length") {
        const newLength = Number(newValue);
        depsMap.forEach((dep, key2) => {
          if (key2 === "length" || key2 === ARRAY_ITERATE_KEY || !isSymbol(key2) && key2 >= newLength) {
            run(dep);
          }
        });
      } else {
        if (key !== void 0 || depsMap.has(void 0)) {
          run(depsMap.get(key));
        }
        if (isArrayIndex) {
          run(depsMap.get(ARRAY_ITERATE_KEY));
        }
        switch (type) {
          case "add":
            if (!targetIsArray) {
              run(depsMap.get(ITERATE_KEY));
              if (isMap(target)) {
                run(depsMap.get(MAP_KEY_ITERATE_KEY));
              }
            } else if (isArrayIndex) {
              run(depsMap.get("length"));
            }
            break;
          case "delete":
            if (!targetIsArray) {
              run(depsMap.get(ITERATE_KEY));
              if (isMap(target)) {
                run(depsMap.get(MAP_KEY_ITERATE_KEY));
              }
            }
            break;
          case "set":
            if (isMap(target)) {
              run(depsMap.get(ITERATE_KEY));
            }
            break;
        }
      }
    }
    endBatch();
  }
  function reactiveReadArray(array) {
    const raw = toRaw(array);
    if (raw === array) return raw;
    track(raw, "iterate", ARRAY_ITERATE_KEY);
    return isShallow(array) ? raw : raw.map(toReactive);
  }
  function shallowReadArray(arr) {
    track(arr = toRaw(arr), "iterate", ARRAY_ITERATE_KEY);
    return arr;
  }
  const arrayInstrumentations = {
    __proto__: null,
    [Symbol.iterator]() {
      return iterator(this, Symbol.iterator, toReactive);
    },
    concat(...args) {
      return reactiveReadArray(this).concat(
        ...args.map((x) => isArray(x) ? reactiveReadArray(x) : x)
      );
    },
    entries() {
      return iterator(this, "entries", (value) => {
        value[1] = toReactive(value[1]);
        return value;
      });
    },
    every(fn, thisArg) {
      return apply(this, "every", fn, thisArg, void 0, arguments);
    },
    filter(fn, thisArg) {
      return apply(this, "filter", fn, thisArg, (v) => v.map(toReactive), arguments);
    },
    find(fn, thisArg) {
      return apply(this, "find", fn, thisArg, toReactive, arguments);
    },
    findIndex(fn, thisArg) {
      return apply(this, "findIndex", fn, thisArg, void 0, arguments);
    },
    findLast(fn, thisArg) {
      return apply(this, "findLast", fn, thisArg, toReactive, arguments);
    },
    findLastIndex(fn, thisArg) {
      return apply(this, "findLastIndex", fn, thisArg, void 0, arguments);
    },
    // flat, flatMap could benefit from ARRAY_ITERATE but are not straight-forward to implement
    forEach(fn, thisArg) {
      return apply(this, "forEach", fn, thisArg, void 0, arguments);
    },
    includes(...args) {
      return searchProxy(this, "includes", args);
    },
    indexOf(...args) {
      return searchProxy(this, "indexOf", args);
    },
    join(separator) {
      return reactiveReadArray(this).join(separator);
    },
    // keys() iterator only reads `length`, no optimisation required
    lastIndexOf(...args) {
      return searchProxy(this, "lastIndexOf", args);
    },
    map(fn, thisArg) {
      return apply(this, "map", fn, thisArg, void 0, arguments);
    },
    pop() {
      return noTracking(this, "pop");
    },
    push(...args) {
      return noTracking(this, "push", args);
    },
    reduce(fn, ...args) {
      return reduce(this, "reduce", fn, args);
    },
    reduceRight(fn, ...args) {
      return reduce(this, "reduceRight", fn, args);
    },
    shift() {
      return noTracking(this, "shift");
    },
    // slice could use ARRAY_ITERATE but also seems to beg for range tracking
    some(fn, thisArg) {
      return apply(this, "some", fn, thisArg, void 0, arguments);
    },
    splice(...args) {
      return noTracking(this, "splice", args);
    },
    toReversed() {
      return reactiveReadArray(this).toReversed();
    },
    toSorted(comparer) {
      return reactiveReadArray(this).toSorted(comparer);
    },
    toSpliced(...args) {
      return reactiveReadArray(this).toSpliced(...args);
    },
    unshift(...args) {
      return noTracking(this, "unshift", args);
    },
    values() {
      return iterator(this, "values", toReactive);
    }
  };
  function iterator(self2, method, wrapValue) {
    const arr = shallowReadArray(self2);
    const iter = arr[method]();
    if (arr !== self2 && !isShallow(self2)) {
      iter._next = iter.next;
      iter.next = () => {
        const result = iter._next();
        if (result.value) {
          result.value = wrapValue(result.value);
        }
        return result;
      };
    }
    return iter;
  }
  const arrayProto = Array.prototype;
  function apply(self2, method, fn, thisArg, wrappedRetFn, args) {
    const arr = shallowReadArray(self2);
    const needsWrap = arr !== self2 && !isShallow(self2);
    const methodFn = arr[method];
    if (methodFn !== arrayProto[method]) {
      const result2 = methodFn.apply(self2, args);
      return needsWrap ? toReactive(result2) : result2;
    }
    let wrappedFn = fn;
    if (arr !== self2) {
      if (needsWrap) {
        wrappedFn = function(item, index) {
          return fn.call(this, toReactive(item), index, self2);
        };
      } else if (fn.length > 2) {
        wrappedFn = function(item, index) {
          return fn.call(this, item, index, self2);
        };
      }
    }
    const result = methodFn.call(arr, wrappedFn, thisArg);
    return needsWrap && wrappedRetFn ? wrappedRetFn(result) : result;
  }
  function reduce(self2, method, fn, args) {
    const arr = shallowReadArray(self2);
    let wrappedFn = fn;
    if (arr !== self2) {
      if (!isShallow(self2)) {
        wrappedFn = function(acc, item, index) {
          return fn.call(this, acc, toReactive(item), index, self2);
        };
      } else if (fn.length > 3) {
        wrappedFn = function(acc, item, index) {
          return fn.call(this, acc, item, index, self2);
        };
      }
    }
    return arr[method](wrappedFn, ...args);
  }
  function searchProxy(self2, method, args) {
    const arr = toRaw(self2);
    track(arr, "iterate", ARRAY_ITERATE_KEY);
    const res = arr[method](...args);
    if ((res === -1 || res === false) && isProxy(args[0])) {
      args[0] = toRaw(args[0]);
      return arr[method](...args);
    }
    return res;
  }
  function noTracking(self2, method, args = []) {
    pauseTracking();
    startBatch();
    const res = toRaw(self2)[method].apply(self2, args);
    endBatch();
    resetTracking();
    return res;
  }
  const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
  const builtInSymbols = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol)
  );
  function hasOwnProperty(key) {
    if (!isSymbol(key)) key = String(key);
    const obj = toRaw(this);
    track(obj, "has", key);
    return obj.hasOwnProperty(key);
  }
  class BaseReactiveHandler {
    constructor(_isReadonly = false, _isShallow = false) {
      this._isReadonly = _isReadonly;
      this._isShallow = _isShallow;
    }
    get(target, key, receiver) {
      if (key === "__v_skip") return target["__v_skip"];
      const isReadonly2 = this._isReadonly, isShallow2 = this._isShallow;
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_isShallow") {
        return isShallow2;
      } else if (key === "__v_raw") {
        if (receiver === (isReadonly2 ? isShallow2 ? shallowReadonlyMap : readonlyMap : isShallow2 ? shallowReactiveMap : reactiveMap).get(target) || // receiver is not the reactive proxy, but has the same prototype
        // this means the receiver is a user proxy of the reactive proxy
        Object.getPrototypeOf(target) === Object.getPrototypeOf(receiver)) {
          return target;
        }
        return;
      }
      const targetIsArray = isArray(target);
      if (!isReadonly2) {
        let fn;
        if (targetIsArray && (fn = arrayInstrumentations[key])) {
          return fn;
        }
        if (key === "hasOwnProperty") {
          return hasOwnProperty;
        }
      }
      const res = Reflect.get(
        target,
        key,
        // if this is a proxy wrapping a ref, return methods using the raw ref
        // as receiver so that we don't have to call `toRaw` on the ref in all
        // its class methods
        isRef(target) ? target : receiver
      );
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly2) {
        track(target, "get", key);
      }
      if (isShallow2) {
        return res;
      }
      if (isRef(res)) {
        return targetIsArray && isIntegerKey(key) ? res : res.value;
      }
      if (isObject$1(res)) {
        return isReadonly2 ? readonly(res) : reactive(res);
      }
      return res;
    }
  }
  class MutableReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(false, isShallow2);
    }
    set(target, key, value, receiver) {
      let oldValue = target[key];
      if (!this._isShallow) {
        const isOldValueReadonly = isReadonly(oldValue);
        if (!isShallow(value) && !isReadonly(value)) {
          oldValue = toRaw(oldValue);
          value = toRaw(value);
        }
        if (!isArray(target) && isRef(oldValue) && !isRef(value)) {
          if (isOldValueReadonly) {
            return false;
          } else {
            oldValue.value = value;
            return true;
          }
        }
      }
      const hadKey = isArray(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn(target, key);
      const result = Reflect.set(
        target,
        key,
        value,
        isRef(target) ? target : receiver
      );
      if (target === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if (hasChanged(value, oldValue)) {
          trigger(target, "set", key, value);
        }
      }
      return result;
    }
    deleteProperty(target, key) {
      const hadKey = hasOwn(target, key);
      target[key];
      const result = Reflect.deleteProperty(target, key);
      if (result && hadKey) {
        trigger(target, "delete", key, void 0);
      }
      return result;
    }
    has(target, key) {
      const result = Reflect.has(target, key);
      if (!isSymbol(key) || !builtInSymbols.has(key)) {
        track(target, "has", key);
      }
      return result;
    }
    ownKeys(target) {
      track(
        target,
        "iterate",
        isArray(target) ? "length" : ITERATE_KEY
      );
      return Reflect.ownKeys(target);
    }
  }
  class ReadonlyReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(true, isShallow2);
    }
    set(target, key) {
      return true;
    }
    deleteProperty(target, key) {
      return true;
    }
  }
  const mutableHandlers = /* @__PURE__ */ new MutableReactiveHandler();
  const readonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler();
  const shallowReactiveHandlers = /* @__PURE__ */ new MutableReactiveHandler(true);
  const shallowReadonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler(true);
  const toShallow = (value) => value;
  const getProto = (v) => Reflect.getPrototypeOf(v);
  function createIterableMethod(method, isReadonly2, isShallow2) {
    return function(...args) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target[method](...args);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(
        rawTarget,
        "iterate",
        isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
      );
      return {
        // iterator protocol
        next() {
          const { value, done } = innerIterator.next();
          return done ? { value, done } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        // iterable protocol
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function(...args) {
      return type === "delete" ? false : type === "clear" ? void 0 : this;
    };
  }
  function createInstrumentations(readonly2, shallow) {
    const instrumentations = {
      get(key) {
        const target = this["__v_raw"];
        const rawTarget = toRaw(target);
        const rawKey = toRaw(key);
        if (!readonly2) {
          if (hasChanged(key, rawKey)) {
            track(rawTarget, "get", key);
          }
          track(rawTarget, "get", rawKey);
        }
        const { has } = getProto(rawTarget);
        const wrap = shallow ? toShallow : readonly2 ? toReadonly : toReactive;
        if (has.call(rawTarget, key)) {
          return wrap(target.get(key));
        } else if (has.call(rawTarget, rawKey)) {
          return wrap(target.get(rawKey));
        } else if (target !== rawTarget) {
          target.get(key);
        }
      },
      get size() {
        const target = this["__v_raw"];
        !readonly2 && track(toRaw(target), "iterate", ITERATE_KEY);
        return Reflect.get(target, "size", target);
      },
      has(key) {
        const target = this["__v_raw"];
        const rawTarget = toRaw(target);
        const rawKey = toRaw(key);
        if (!readonly2) {
          if (hasChanged(key, rawKey)) {
            track(rawTarget, "has", key);
          }
          track(rawTarget, "has", rawKey);
        }
        return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
      },
      forEach(callback, thisArg) {
        const observed = this;
        const target = observed["__v_raw"];
        const rawTarget = toRaw(target);
        const wrap = shallow ? toShallow : readonly2 ? toReadonly : toReactive;
        !readonly2 && track(rawTarget, "iterate", ITERATE_KEY);
        return target.forEach((value, key) => {
          return callback.call(thisArg, wrap(value), wrap(key), observed);
        });
      }
    };
    extend(
      instrumentations,
      readonly2 ? {
        add: createReadonlyMethod("add"),
        set: createReadonlyMethod("set"),
        delete: createReadonlyMethod("delete"),
        clear: createReadonlyMethod("clear")
      } : {
        add(value) {
          if (!shallow && !isShallow(value) && !isReadonly(value)) {
            value = toRaw(value);
          }
          const target = toRaw(this);
          const proto = getProto(target);
          const hadKey = proto.has.call(target, value);
          if (!hadKey) {
            target.add(value);
            trigger(target, "add", value, value);
          }
          return this;
        },
        set(key, value) {
          if (!shallow && !isShallow(value) && !isReadonly(value)) {
            value = toRaw(value);
          }
          const target = toRaw(this);
          const { has, get } = getProto(target);
          let hadKey = has.call(target, key);
          if (!hadKey) {
            key = toRaw(key);
            hadKey = has.call(target, key);
          }
          const oldValue = get.call(target, key);
          target.set(key, value);
          if (!hadKey) {
            trigger(target, "add", key, value);
          } else if (hasChanged(value, oldValue)) {
            trigger(target, "set", key, value);
          }
          return this;
        },
        delete(key) {
          const target = toRaw(this);
          const { has, get } = getProto(target);
          let hadKey = has.call(target, key);
          if (!hadKey) {
            key = toRaw(key);
            hadKey = has.call(target, key);
          }
          get ? get.call(target, key) : void 0;
          const result = target.delete(key);
          if (hadKey) {
            trigger(target, "delete", key, void 0);
          }
          return result;
        },
        clear() {
          const target = toRaw(this);
          const hadItems = target.size !== 0;
          const result = target.clear();
          if (hadItems) {
            trigger(
              target,
              "clear",
              void 0,
              void 0
            );
          }
          return result;
        }
      }
    );
    const iteratorMethods = [
      "keys",
      "values",
      "entries",
      Symbol.iterator
    ];
    iteratorMethods.forEach((method) => {
      instrumentations[method] = createIterableMethod(method, readonly2, shallow);
    });
    return instrumentations;
  }
  function createInstrumentationGetter(isReadonly2, shallow) {
    const instrumentations = createInstrumentations(isReadonly2, shallow);
    return (target, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_raw") {
        return target;
      }
      return Reflect.get(
        hasOwn(instrumentations, key) && key in target ? instrumentations : target,
        key,
        receiver
      );
    };
  }
  const mutableCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, false)
  };
  const shallowCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, true)
  };
  const readonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, false)
  };
  const shallowReadonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, true)
  };
  const reactiveMap = /* @__PURE__ */ new WeakMap();
  const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
  const readonlyMap = /* @__PURE__ */ new WeakMap();
  const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2;
      default:
        return 0;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
  }
  function reactive(target) {
    if (isReadonly(target)) {
      return target;
    }
    return createReactiveObject(
      target,
      false,
      mutableHandlers,
      mutableCollectionHandlers,
      reactiveMap
    );
  }
  function shallowReactive(target) {
    return createReactiveObject(
      target,
      false,
      shallowReactiveHandlers,
      shallowCollectionHandlers,
      shallowReactiveMap
    );
  }
  function readonly(target) {
    return createReactiveObject(
      target,
      true,
      readonlyHandlers,
      readonlyCollectionHandlers,
      readonlyMap
    );
  }
  function shallowReadonly(target) {
    return createReactiveObject(
      target,
      true,
      shallowReadonlyHandlers,
      shallowReadonlyCollectionHandlers,
      shallowReadonlyMap
    );
  }
  function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject$1(target)) {
      return target;
    }
    if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
      return target;
    }
    const targetType = getTargetType(target);
    if (targetType === 0) {
      return target;
    }
    const existingProxy = proxyMap.get(target);
    if (existingProxy) {
      return existingProxy;
    }
    const proxy = new Proxy(
      target,
      targetType === 2 ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target, proxy);
    return proxy;
  }
  function isReactive(value) {
    if (isReadonly(value)) {
      return isReactive(value["__v_raw"]);
    }
    return !!(value && value["__v_isReactive"]);
  }
  function isReadonly(value) {
    return !!(value && value["__v_isReadonly"]);
  }
  function isShallow(value) {
    return !!(value && value["__v_isShallow"]);
  }
  function isProxy(value) {
    return value ? !!value["__v_raw"] : false;
  }
  function toRaw(observed) {
    const raw = observed && observed["__v_raw"];
    return raw ? toRaw(raw) : observed;
  }
  function markRaw(value) {
    if (!hasOwn(value, "__v_skip") && Object.isExtensible(value)) {
      def(value, "__v_skip", true);
    }
    return value;
  }
  const toReactive = (value) => isObject$1(value) ? reactive(value) : value;
  const toReadonly = (value) => isObject$1(value) ? readonly(value) : value;
  function isRef(r) {
    return r ? r["__v_isRef"] === true : false;
  }
  function ref(value) {
    return createRef(value, false);
  }
  function createRef(rawValue, shallow) {
    if (isRef(rawValue)) {
      return rawValue;
    }
    return new RefImpl(rawValue, shallow);
  }
  class RefImpl {
    constructor(value, isShallow2) {
      this.dep = new Dep();
      this["__v_isRef"] = true;
      this["__v_isShallow"] = false;
      this._rawValue = isShallow2 ? value : toRaw(value);
      this._value = isShallow2 ? value : toReactive(value);
      this["__v_isShallow"] = isShallow2;
    }
    get value() {
      {
        this.dep.track();
      }
      return this._value;
    }
    set value(newValue) {
      const oldValue = this._rawValue;
      const useDirectValue = this["__v_isShallow"] || isShallow(newValue) || isReadonly(newValue);
      newValue = useDirectValue ? newValue : toRaw(newValue);
      if (hasChanged(newValue, oldValue)) {
        this._rawValue = newValue;
        this._value = useDirectValue ? newValue : toReactive(newValue);
        {
          this.dep.trigger();
        }
      }
    }
  }
  function unref(ref2) {
    return isRef(ref2) ? ref2.value : ref2;
  }
  const shallowUnwrapHandlers = {
    get: (target, key, receiver) => key === "__v_raw" ? target : unref(Reflect.get(target, key, receiver)),
    set: (target, key, value, receiver) => {
      const oldValue = target[key];
      if (isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      } else {
        return Reflect.set(target, key, value, receiver);
      }
    }
  };
  function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
  }
  class CustomRefImpl {
    constructor(factory) {
      this["__v_isRef"] = true;
      this._value = void 0;
      const dep = this.dep = new Dep();
      const { get, set } = factory(dep.track.bind(dep), dep.trigger.bind(dep));
      this._get = get;
      this._set = set;
    }
    get value() {
      return this._value = this._get();
    }
    set value(newVal) {
      this._set(newVal);
    }
  }
  function customRef(factory) {
    return new CustomRefImpl(factory);
  }
  class ComputedRefImpl {
    constructor(fn, setter, isSSR) {
      this.fn = fn;
      this.setter = setter;
      this._value = void 0;
      this.dep = new Dep(this);
      this.__v_isRef = true;
      this.deps = void 0;
      this.depsTail = void 0;
      this.flags = 16;
      this.globalVersion = globalVersion - 1;
      this.next = void 0;
      this.effect = this;
      this["__v_isReadonly"] = !setter;
      this.isSSR = isSSR;
    }
    /**
     * @internal
     */
    notify() {
      this.flags |= 16;
      if (!(this.flags & 8) && // avoid infinite self recursion
      activeSub !== this) {
        batch(this, true);
        return true;
      }
    }
    get value() {
      const link2 = this.dep.track();
      refreshComputed(this);
      if (link2) {
        link2.version = this.dep.version;
      }
      return this._value;
    }
    set value(newValue) {
      if (this.setter) {
        this.setter(newValue);
      }
    }
  }
  function computed$1(getterOrOptions, debugOptions, isSSR = false) {
    let getter;
    let setter;
    if (isFunction(getterOrOptions)) {
      getter = getterOrOptions;
    } else {
      getter = getterOrOptions.get;
      setter = getterOrOptions.set;
    }
    const cRef = new ComputedRefImpl(getter, setter, isSSR);
    return cRef;
  }
  const INITIAL_WATCHER_VALUE = {};
  const cleanupMap = /* @__PURE__ */ new WeakMap();
  let activeWatcher = void 0;
  function onWatcherCleanup(cleanupFn, failSilently = false, owner = activeWatcher) {
    if (owner) {
      let cleanups = cleanupMap.get(owner);
      if (!cleanups) cleanupMap.set(owner, cleanups = []);
      cleanups.push(cleanupFn);
    }
  }
  function watch$1(source, cb, options = EMPTY_OBJ) {
    const { immediate, deep, once, scheduler, augmentJob, call } = options;
    const reactiveGetter = (source2) => {
      if (deep) return source2;
      if (isShallow(source2) || deep === false || deep === 0)
        return traverse(source2, 1);
      return traverse(source2);
    };
    let effect2;
    let getter;
    let cleanup;
    let boundCleanup;
    let forceTrigger = false;
    let isMultiSource = false;
    if (isRef(source)) {
      getter = () => source.value;
      forceTrigger = isShallow(source);
    } else if (isReactive(source)) {
      getter = () => reactiveGetter(source);
      forceTrigger = true;
    } else if (isArray(source)) {
      isMultiSource = true;
      forceTrigger = source.some((s) => isReactive(s) || isShallow(s));
      getter = () => source.map((s) => {
        if (isRef(s)) {
          return s.value;
        } else if (isReactive(s)) {
          return reactiveGetter(s);
        } else if (isFunction(s)) {
          return call ? call(s, 2) : s();
        } else ;
      });
    } else if (isFunction(source)) {
      if (cb) {
        getter = call ? () => call(source, 2) : source;
      } else {
        getter = () => {
          if (cleanup) {
            pauseTracking();
            try {
              cleanup();
            } finally {
              resetTracking();
            }
          }
          const currentEffect = activeWatcher;
          activeWatcher = effect2;
          try {
            return call ? call(source, 3, [boundCleanup]) : source(boundCleanup);
          } finally {
            activeWatcher = currentEffect;
          }
        };
      }
    } else {
      getter = NOOP;
    }
    if (cb && deep) {
      const baseGetter = getter;
      const depth = deep === true ? Infinity : deep;
      getter = () => traverse(baseGetter(), depth);
    }
    const scope = getCurrentScope();
    const watchHandle = () => {
      effect2.stop();
      if (scope && scope.active) {
        remove(scope.effects, effect2);
      }
    };
    if (once && cb) {
      const _cb = cb;
      cb = (...args) => {
        _cb(...args);
        watchHandle();
      };
    }
    let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
    const job = (immediateFirstRun) => {
      if (!(effect2.flags & 1) || !effect2.dirty && !immediateFirstRun) {
        return;
      }
      if (cb) {
        const newValue = effect2.run();
        if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i) => hasChanged(v, oldValue[i])) : hasChanged(newValue, oldValue))) {
          if (cleanup) {
            cleanup();
          }
          const currentWatcher = activeWatcher;
          activeWatcher = effect2;
          try {
            const args = [
              newValue,
              // pass undefined as the old value when it's changed for the first time
              oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
              boundCleanup
            ];
            oldValue = newValue;
            call ? call(cb, 3, args) : (
              // @ts-expect-error
              cb(...args)
            );
          } finally {
            activeWatcher = currentWatcher;
          }
        }
      } else {
        effect2.run();
      }
    };
    if (augmentJob) {
      augmentJob(job);
    }
    effect2 = new ReactiveEffect(getter);
    effect2.scheduler = scheduler ? () => scheduler(job, false) : job;
    boundCleanup = (fn) => onWatcherCleanup(fn, false, effect2);
    cleanup = effect2.onStop = () => {
      const cleanups = cleanupMap.get(effect2);
      if (cleanups) {
        if (call) {
          call(cleanups, 4);
        } else {
          for (const cleanup2 of cleanups) cleanup2();
        }
        cleanupMap.delete(effect2);
      }
    };
    if (cb) {
      if (immediate) {
        job(true);
      } else {
        oldValue = effect2.run();
      }
    } else if (scheduler) {
      scheduler(job.bind(null, true), true);
    } else {
      effect2.run();
    }
    watchHandle.pause = effect2.pause.bind(effect2);
    watchHandle.resume = effect2.resume.bind(effect2);
    watchHandle.stop = watchHandle;
    return watchHandle;
  }
  function traverse(value, depth = Infinity, seen) {
    if (depth <= 0 || !isObject$1(value) || value["__v_skip"]) {
      return value;
    }
    seen = seen || /* @__PURE__ */ new Set();
    if (seen.has(value)) {
      return value;
    }
    seen.add(value);
    depth--;
    if (isRef(value)) {
      traverse(value.value, depth, seen);
    } else if (isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        traverse(value[i], depth, seen);
      }
    } else if (isSet(value) || isMap(value)) {
      value.forEach((v) => {
        traverse(v, depth, seen);
      });
    } else if (isPlainObject(value)) {
      for (const key in value) {
        traverse(value[key], depth, seen);
      }
      for (const key of Object.getOwnPropertySymbols(value)) {
        if (Object.prototype.propertyIsEnumerable.call(value, key)) {
          traverse(value[key], depth, seen);
        }
      }
    }
    return value;
  }
  /**
  * @vue/runtime-core v3.5.18
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  const stack = [];
  let isWarning = false;
  function warn$1(msg, ...args) {
    if (isWarning) return;
    isWarning = true;
    pauseTracking();
    const instance = stack.length ? stack[stack.length - 1].component : null;
    const appWarnHandler = instance && instance.appContext.config.warnHandler;
    const trace = getComponentTrace();
    if (appWarnHandler) {
      callWithErrorHandling(
        appWarnHandler,
        instance,
        11,
        [
          // eslint-disable-next-line no-restricted-syntax
          msg + args.map((a) => {
            var _a, _b;
            return (_b = (_a = a.toString) == null ? void 0 : _a.call(a)) != null ? _b : JSON.stringify(a);
          }).join(""),
          instance && instance.proxy,
          trace.map(
            ({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`
          ).join("\n"),
          trace
        ]
      );
    } else {
      const warnArgs = [`[Vue warn]: ${msg}`, ...args];
      if (trace.length && // avoid spamming console during tests
      true) {
        warnArgs.push(`
`, ...formatTrace(trace));
      }
      console.warn(...warnArgs);
    }
    resetTracking();
    isWarning = false;
  }
  function getComponentTrace() {
    let currentVNode = stack[stack.length - 1];
    if (!currentVNode) {
      return [];
    }
    const normalizedStack = [];
    while (currentVNode) {
      const last = normalizedStack[0];
      if (last && last.vnode === currentVNode) {
        last.recurseCount++;
      } else {
        normalizedStack.push({
          vnode: currentVNode,
          recurseCount: 0
        });
      }
      const parentInstance = currentVNode.component && currentVNode.component.parent;
      currentVNode = parentInstance && parentInstance.vnode;
    }
    return normalizedStack;
  }
  function formatTrace(trace) {
    const logs = [];
    trace.forEach((entry, i) => {
      logs.push(...i === 0 ? [] : [`
`], ...formatTraceEntry(entry));
    });
    return logs;
  }
  function formatTraceEntry({ vnode, recurseCount }) {
    const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
    const isRoot = vnode.component ? vnode.component.parent == null : false;
    const open = ` at <${formatComponentName(
      vnode.component,
      vnode.type,
      isRoot
    )}`;
    const close = `>` + postfix;
    return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
  }
  function formatProps(props) {
    const res = [];
    const keys = Object.keys(props);
    keys.slice(0, 3).forEach((key) => {
      res.push(...formatProp(key, props[key]));
    });
    if (keys.length > 3) {
      res.push(` ...`);
    }
    return res;
  }
  function formatProp(key, value, raw) {
    if (isString(value)) {
      value = JSON.stringify(value);
      return raw ? value : [`${key}=${value}`];
    } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
      return raw ? value : [`${key}=${value}`];
    } else if (isRef(value)) {
      value = formatProp(key, toRaw(value.value), true);
      return raw ? value : [`${key}=Ref<`, value, `>`];
    } else if (isFunction(value)) {
      return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
    } else {
      value = toRaw(value);
      return raw ? value : [`${key}=`, value];
    }
  }
  function callWithErrorHandling(fn, instance, type, args) {
    try {
      return args ? fn(...args) : fn();
    } catch (err) {
      handleError(err, instance, type);
    }
  }
  function callWithAsyncErrorHandling(fn, instance, type, args) {
    if (isFunction(fn)) {
      const res = callWithErrorHandling(fn, instance, type, args);
      if (res && isPromise$1(res)) {
        res.catch((err) => {
          handleError(err, instance, type);
        });
      }
      return res;
    }
    if (isArray(fn)) {
      const values = [];
      for (let i = 0; i < fn.length; i++) {
        values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));
      }
      return values;
    }
  }
  function handleError(err, instance, type, throwInDev = true) {
    const contextVNode = instance ? instance.vnode : null;
    const { errorHandler, throwUnhandledErrorInProduction } = instance && instance.appContext.config || EMPTY_OBJ;
    if (instance) {
      let cur = instance.parent;
      const exposedInstance = instance.proxy;
      const errorInfo = `https://vuejs.org/error-reference/#runtime-${type}`;
      while (cur) {
        const errorCapturedHooks = cur.ec;
        if (errorCapturedHooks) {
          for (let i = 0; i < errorCapturedHooks.length; i++) {
            if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {
              return;
            }
          }
        }
        cur = cur.parent;
      }
      if (errorHandler) {
        pauseTracking();
        callWithErrorHandling(errorHandler, null, 10, [
          err,
          exposedInstance,
          errorInfo
        ]);
        resetTracking();
        return;
      }
    }
    logError(err, type, contextVNode, throwInDev, throwUnhandledErrorInProduction);
  }
  function logError(err, type, contextVNode, throwInDev = true, throwInProd = false) {
    if (throwInProd) {
      throw err;
    } else {
      console.error(err);
    }
  }
  const queue = [];
  let flushIndex = -1;
  const pendingPostFlushCbs = [];
  let activePostFlushCbs = null;
  let postFlushIndex = 0;
  const resolvedPromise = /* @__PURE__ */ Promise.resolve();
  let currentFlushPromise = null;
  function nextTick(fn) {
    const p2 = currentFlushPromise || resolvedPromise;
    return fn ? p2.then(this ? fn.bind(this) : fn) : p2;
  }
  function findInsertionIndex(id) {
    let start = flushIndex + 1;
    let end = queue.length;
    while (start < end) {
      const middle = start + end >>> 1;
      const middleJob = queue[middle];
      const middleJobId = getId(middleJob);
      if (middleJobId < id || middleJobId === id && middleJob.flags & 2) {
        start = middle + 1;
      } else {
        end = middle;
      }
    }
    return start;
  }
  function queueJob(job) {
    if (!(job.flags & 1)) {
      const jobId = getId(job);
      const lastJob = queue[queue.length - 1];
      if (!lastJob || // fast path when the job id is larger than the tail
      !(job.flags & 2) && jobId >= getId(lastJob)) {
        queue.push(job);
      } else {
        queue.splice(findInsertionIndex(jobId), 0, job);
      }
      job.flags |= 1;
      queueFlush();
    }
  }
  function queueFlush() {
    if (!currentFlushPromise) {
      currentFlushPromise = resolvedPromise.then(flushJobs);
    }
  }
  function queuePostFlushCb(cb) {
    if (!isArray(cb)) {
      if (activePostFlushCbs && cb.id === -1) {
        activePostFlushCbs.splice(postFlushIndex + 1, 0, cb);
      } else if (!(cb.flags & 1)) {
        pendingPostFlushCbs.push(cb);
        cb.flags |= 1;
      }
    } else {
      pendingPostFlushCbs.push(...cb);
    }
    queueFlush();
  }
  function flushPreFlushCbs(instance, seen, i = flushIndex + 1) {
    for (; i < queue.length; i++) {
      const cb = queue[i];
      if (cb && cb.flags & 2) {
        if (instance && cb.id !== instance.uid) {
          continue;
        }
        queue.splice(i, 1);
        i--;
        if (cb.flags & 4) {
          cb.flags &= -2;
        }
        cb();
        if (!(cb.flags & 4)) {
          cb.flags &= -2;
        }
      }
    }
  }
  function flushPostFlushCbs(seen) {
    if (pendingPostFlushCbs.length) {
      const deduped = [...new Set(pendingPostFlushCbs)].sort(
        (a, b) => getId(a) - getId(b)
      );
      pendingPostFlushCbs.length = 0;
      if (activePostFlushCbs) {
        activePostFlushCbs.push(...deduped);
        return;
      }
      activePostFlushCbs = deduped;
      for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
        const cb = activePostFlushCbs[postFlushIndex];
        if (cb.flags & 4) {
          cb.flags &= -2;
        }
        if (!(cb.flags & 8)) cb();
        cb.flags &= -2;
      }
      activePostFlushCbs = null;
      postFlushIndex = 0;
    }
  }
  const getId = (job) => job.id == null ? job.flags & 2 ? -1 : Infinity : job.id;
  function flushJobs(seen) {
    try {
      for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
        const job = queue[flushIndex];
        if (job && !(job.flags & 8)) {
          if (false) ;
          if (job.flags & 4) {
            job.flags &= ~1;
          }
          callWithErrorHandling(
            job,
            job.i,
            job.i ? 15 : 14
          );
          if (!(job.flags & 4)) {
            job.flags &= ~1;
          }
        }
      }
    } finally {
      for (; flushIndex < queue.length; flushIndex++) {
        const job = queue[flushIndex];
        if (job) {
          job.flags &= -2;
        }
      }
      flushIndex = -1;
      queue.length = 0;
      flushPostFlushCbs();
      currentFlushPromise = null;
      if (queue.length || pendingPostFlushCbs.length) {
        flushJobs();
      }
    }
  }
  let currentRenderingInstance = null;
  let currentScopeId = null;
  function setCurrentRenderingInstance(instance) {
    const prev = currentRenderingInstance;
    currentRenderingInstance = instance;
    currentScopeId = instance && instance.type.__scopeId || null;
    return prev;
  }
  function withCtx(fn, ctx = currentRenderingInstance, isNonScopedSlot) {
    if (!ctx) return fn;
    if (fn._n) {
      return fn;
    }
    const renderFnWithContext = (...args) => {
      if (renderFnWithContext._d) {
        setBlockTracking(-1);
      }
      const prevInstance = setCurrentRenderingInstance(ctx);
      let res;
      try {
        res = fn(...args);
      } finally {
        setCurrentRenderingInstance(prevInstance);
        if (renderFnWithContext._d) {
          setBlockTracking(1);
        }
      }
      return res;
    };
    renderFnWithContext._n = true;
    renderFnWithContext._c = true;
    renderFnWithContext._d = true;
    return renderFnWithContext;
  }
  function withDirectives(vnode, directives) {
    if (currentRenderingInstance === null) {
      return vnode;
    }
    const instance = getComponentPublicInstance(currentRenderingInstance);
    const bindings = vnode.dirs || (vnode.dirs = []);
    for (let i = 0; i < directives.length; i++) {
      let [dir, value, arg, modifiers = EMPTY_OBJ] = directives[i];
      if (dir) {
        if (isFunction(dir)) {
          dir = {
            mounted: dir,
            updated: dir
          };
        }
        if (dir.deep) {
          traverse(value);
        }
        bindings.push({
          dir,
          instance,
          value,
          oldValue: void 0,
          arg,
          modifiers
        });
      }
    }
    return vnode;
  }
  function invokeDirectiveHook(vnode, prevVNode, instance, name) {
    const bindings = vnode.dirs;
    const oldBindings = prevVNode && prevVNode.dirs;
    for (let i = 0; i < bindings.length; i++) {
      const binding = bindings[i];
      if (oldBindings) {
        binding.oldValue = oldBindings[i].value;
      }
      let hook = binding.dir[name];
      if (hook) {
        pauseTracking();
        callWithAsyncErrorHandling(hook, instance, 8, [
          vnode.el,
          binding,
          vnode,
          prevVNode
        ]);
        resetTracking();
      }
    }
  }
  const TeleportEndKey = Symbol("_vte");
  const isTeleport = (type) => type.__isTeleport;
  const leaveCbKey = Symbol("_leaveCb");
  const enterCbKey$1 = Symbol("_enterCb");
  function useTransitionState() {
    const state2 = {
      isMounted: false,
      isLeaving: false,
      isUnmounting: false,
      leavingVNodes: /* @__PURE__ */ new Map()
    };
    onMounted(() => {
      state2.isMounted = true;
    });
    onBeforeUnmount(() => {
      state2.isUnmounting = true;
    });
    return state2;
  }
  const TransitionHookValidator = [Function, Array];
  const BaseTransitionPropsValidators = {
    mode: String,
    appear: Boolean,
    persisted: Boolean,
    // enter
    onBeforeEnter: TransitionHookValidator,
    onEnter: TransitionHookValidator,
    onAfterEnter: TransitionHookValidator,
    onEnterCancelled: TransitionHookValidator,
    // leave
    onBeforeLeave: TransitionHookValidator,
    onLeave: TransitionHookValidator,
    onAfterLeave: TransitionHookValidator,
    onLeaveCancelled: TransitionHookValidator,
    // appear
    onBeforeAppear: TransitionHookValidator,
    onAppear: TransitionHookValidator,
    onAfterAppear: TransitionHookValidator,
    onAppearCancelled: TransitionHookValidator
  };
  const recursiveGetSubtree = (instance) => {
    const subTree = instance.subTree;
    return subTree.component ? recursiveGetSubtree(subTree.component) : subTree;
  };
  const BaseTransitionImpl = {
    name: `BaseTransition`,
    props: BaseTransitionPropsValidators,
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const state2 = useTransitionState();
      return () => {
        const children = slots.default && getTransitionRawChildren(slots.default(), true);
        if (!children || !children.length) {
          return;
        }
        const child = findNonCommentChild(children);
        const rawProps = toRaw(props);
        const { mode } = rawProps;
        if (state2.isLeaving) {
          return emptyPlaceholder(child);
        }
        const innerChild = getInnerChild$1(child);
        if (!innerChild) {
          return emptyPlaceholder(child);
        }
        let enterHooks = resolveTransitionHooks(
          innerChild,
          rawProps,
          state2,
          instance,
          // #11061, ensure enterHooks is fresh after clone
          (hooks) => enterHooks = hooks
        );
        if (innerChild.type !== Comment) {
          setTransitionHooks(innerChild, enterHooks);
        }
        let oldInnerChild = instance.subTree && getInnerChild$1(instance.subTree);
        if (oldInnerChild && oldInnerChild.type !== Comment && !isSameVNodeType(innerChild, oldInnerChild) && recursiveGetSubtree(instance).type !== Comment) {
          let leavingHooks = resolveTransitionHooks(
            oldInnerChild,
            rawProps,
            state2,
            instance
          );
          setTransitionHooks(oldInnerChild, leavingHooks);
          if (mode === "out-in" && innerChild.type !== Comment) {
            state2.isLeaving = true;
            leavingHooks.afterLeave = () => {
              state2.isLeaving = false;
              if (!(instance.job.flags & 8)) {
                instance.update();
              }
              delete leavingHooks.afterLeave;
              oldInnerChild = void 0;
            };
            return emptyPlaceholder(child);
          } else if (mode === "in-out" && innerChild.type !== Comment) {
            leavingHooks.delayLeave = (el, earlyRemove, delayedLeave) => {
              const leavingVNodesCache = getLeavingNodesForType(
                state2,
                oldInnerChild
              );
              leavingVNodesCache[String(oldInnerChild.key)] = oldInnerChild;
              el[leaveCbKey] = () => {
                earlyRemove();
                el[leaveCbKey] = void 0;
                delete enterHooks.delayedLeave;
                oldInnerChild = void 0;
              };
              enterHooks.delayedLeave = () => {
                delayedLeave();
                delete enterHooks.delayedLeave;
                oldInnerChild = void 0;
              };
            };
          } else {
            oldInnerChild = void 0;
          }
        } else if (oldInnerChild) {
          oldInnerChild = void 0;
        }
        return child;
      };
    }
  };
  function findNonCommentChild(children) {
    let child = children[0];
    if (children.length > 1) {
      for (const c of children) {
        if (c.type !== Comment) {
          child = c;
          break;
        }
      }
    }
    return child;
  }
  const BaseTransition = BaseTransitionImpl;
  function getLeavingNodesForType(state2, vnode) {
    const { leavingVNodes } = state2;
    let leavingVNodesCache = leavingVNodes.get(vnode.type);
    if (!leavingVNodesCache) {
      leavingVNodesCache = /* @__PURE__ */ Object.create(null);
      leavingVNodes.set(vnode.type, leavingVNodesCache);
    }
    return leavingVNodesCache;
  }
  function resolveTransitionHooks(vnode, props, state2, instance, postClone) {
    const {
      appear,
      mode,
      persisted = false,
      onBeforeEnter,
      onEnter,
      onAfterEnter,
      onEnterCancelled,
      onBeforeLeave,
      onLeave,
      onAfterLeave,
      onLeaveCancelled,
      onBeforeAppear,
      onAppear,
      onAfterAppear,
      onAppearCancelled
    } = props;
    const key = String(vnode.key);
    const leavingVNodesCache = getLeavingNodesForType(state2, vnode);
    const callHook2 = (hook, args) => {
      hook && callWithAsyncErrorHandling(
        hook,
        instance,
        9,
        args
      );
    };
    const callAsyncHook = (hook, args) => {
      const done = args[1];
      callHook2(hook, args);
      if (isArray(hook)) {
        if (hook.every((hook2) => hook2.length <= 1)) done();
      } else if (hook.length <= 1) {
        done();
      }
    };
    const hooks = {
      mode,
      persisted,
      beforeEnter(el) {
        let hook = onBeforeEnter;
        if (!state2.isMounted) {
          if (appear) {
            hook = onBeforeAppear || onBeforeEnter;
          } else {
            return;
          }
        }
        if (el[leaveCbKey]) {
          el[leaveCbKey](
            true
            /* cancelled */
          );
        }
        const leavingVNode = leavingVNodesCache[key];
        if (leavingVNode && isSameVNodeType(vnode, leavingVNode) && leavingVNode.el[leaveCbKey]) {
          leavingVNode.el[leaveCbKey]();
        }
        callHook2(hook, [el]);
      },
      enter(el) {
        let hook = onEnter;
        let afterHook = onAfterEnter;
        let cancelHook = onEnterCancelled;
        if (!state2.isMounted) {
          if (appear) {
            hook = onAppear || onEnter;
            afterHook = onAfterAppear || onAfterEnter;
            cancelHook = onAppearCancelled || onEnterCancelled;
          } else {
            return;
          }
        }
        let called = false;
        const done = el[enterCbKey$1] = (cancelled) => {
          if (called) return;
          called = true;
          if (cancelled) {
            callHook2(cancelHook, [el]);
          } else {
            callHook2(afterHook, [el]);
          }
          if (hooks.delayedLeave) {
            hooks.delayedLeave();
          }
          el[enterCbKey$1] = void 0;
        };
        if (hook) {
          callAsyncHook(hook, [el, done]);
        } else {
          done();
        }
      },
      leave(el, remove2) {
        const key2 = String(vnode.key);
        if (el[enterCbKey$1]) {
          el[enterCbKey$1](
            true
            /* cancelled */
          );
        }
        if (state2.isUnmounting) {
          return remove2();
        }
        callHook2(onBeforeLeave, [el]);
        let called = false;
        const done = el[leaveCbKey] = (cancelled) => {
          if (called) return;
          called = true;
          remove2();
          if (cancelled) {
            callHook2(onLeaveCancelled, [el]);
          } else {
            callHook2(onAfterLeave, [el]);
          }
          el[leaveCbKey] = void 0;
          if (leavingVNodesCache[key2] === vnode) {
            delete leavingVNodesCache[key2];
          }
        };
        leavingVNodesCache[key2] = vnode;
        if (onLeave) {
          callAsyncHook(onLeave, [el, done]);
        } else {
          done();
        }
      },
      clone(vnode2) {
        const hooks2 = resolveTransitionHooks(
          vnode2,
          props,
          state2,
          instance,
          postClone
        );
        if (postClone) postClone(hooks2);
        return hooks2;
      }
    };
    return hooks;
  }
  function emptyPlaceholder(vnode) {
    if (isKeepAlive(vnode)) {
      vnode = cloneVNode(vnode);
      vnode.children = null;
      return vnode;
    }
  }
  function getInnerChild$1(vnode) {
    if (!isKeepAlive(vnode)) {
      if (isTeleport(vnode.type) && vnode.children) {
        return findNonCommentChild(vnode.children);
      }
      return vnode;
    }
    if (vnode.component) {
      return vnode.component.subTree;
    }
    const { shapeFlag, children } = vnode;
    if (children) {
      if (shapeFlag & 16) {
        return children[0];
      }
      if (shapeFlag & 32 && isFunction(children.default)) {
        return children.default();
      }
    }
  }
  function setTransitionHooks(vnode, hooks) {
    if (vnode.shapeFlag & 6 && vnode.component) {
      vnode.transition = hooks;
      setTransitionHooks(vnode.component.subTree, hooks);
    } else if (vnode.shapeFlag & 128) {
      vnode.ssContent.transition = hooks.clone(vnode.ssContent);
      vnode.ssFallback.transition = hooks.clone(vnode.ssFallback);
    } else {
      vnode.transition = hooks;
    }
  }
  function getTransitionRawChildren(children, keepComment = false, parentKey) {
    let ret = [];
    let keyedFragmentCount = 0;
    for (let i = 0; i < children.length; i++) {
      let child = children[i];
      const key = parentKey == null ? child.key : String(parentKey) + String(child.key != null ? child.key : i);
      if (child.type === Fragment) {
        if (child.patchFlag & 128) keyedFragmentCount++;
        ret = ret.concat(
          getTransitionRawChildren(child.children, keepComment, key)
        );
      } else if (keepComment || child.type !== Comment) {
        ret.push(key != null ? cloneVNode(child, { key }) : child);
      }
    }
    if (keyedFragmentCount > 1) {
      for (let i = 0; i < ret.length; i++) {
        ret[i].patchFlag = -2;
      }
    }
    return ret;
  }
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function defineComponent(options, extraOptions) {
    return isFunction(options) ? (
      // #8236: extend call and options.name access are considered side-effects
      // by Rollup, so we have to wrap it in a pure-annotated IIFE.
      /* @__PURE__ */ (() => extend({ name: options.name }, extraOptions, { setup: options }))()
    ) : options;
  }
  function markAsyncBoundary(instance) {
    instance.ids = [instance.ids[0] + instance.ids[2]++ + "-", 0, 0];
  }
  function setRef(rawRef, oldRawRef, parentSuspense, vnode, isUnmount = false) {
    if (isArray(rawRef)) {
      rawRef.forEach(
        (r, i) => setRef(
          r,
          oldRawRef && (isArray(oldRawRef) ? oldRawRef[i] : oldRawRef),
          parentSuspense,
          vnode,
          isUnmount
        )
      );
      return;
    }
    if (isAsyncWrapper(vnode) && !isUnmount) {
      if (vnode.shapeFlag & 512 && vnode.type.__asyncResolved && vnode.component.subTree.component) {
        setRef(rawRef, oldRawRef, parentSuspense, vnode.component.subTree);
      }
      return;
    }
    const refValue = vnode.shapeFlag & 4 ? getComponentPublicInstance(vnode.component) : vnode.el;
    const value = isUnmount ? null : refValue;
    const { i: owner, r: ref3 } = rawRef;
    const oldRef = oldRawRef && oldRawRef.r;
    const refs = owner.refs === EMPTY_OBJ ? owner.refs = {} : owner.refs;
    const setupState = owner.setupState;
    const rawSetupState = toRaw(setupState);
    const canSetSetupRef = setupState === EMPTY_OBJ ? () => false : (key) => {
      return hasOwn(rawSetupState, key);
    };
    if (oldRef != null && oldRef !== ref3) {
      if (isString(oldRef)) {
        refs[oldRef] = null;
        if (canSetSetupRef(oldRef)) {
          setupState[oldRef] = null;
        }
      } else if (isRef(oldRef)) {
        oldRef.value = null;
      }
    }
    if (isFunction(ref3)) {
      callWithErrorHandling(ref3, owner, 12, [value, refs]);
    } else {
      const _isString = isString(ref3);
      const _isRef = isRef(ref3);
      if (_isString || _isRef) {
        const doSet = () => {
          if (rawRef.f) {
            const existing = _isString ? canSetSetupRef(ref3) ? setupState[ref3] : refs[ref3] : ref3.value;
            if (isUnmount) {
              isArray(existing) && remove(existing, refValue);
            } else {
              if (!isArray(existing)) {
                if (_isString) {
                  refs[ref3] = [refValue];
                  if (canSetSetupRef(ref3)) {
                    setupState[ref3] = refs[ref3];
                  }
                } else {
                  ref3.value = [refValue];
                  if (rawRef.k) refs[rawRef.k] = ref3.value;
                }
              } else if (!existing.includes(refValue)) {
                existing.push(refValue);
              }
            }
          } else if (_isString) {
            refs[ref3] = value;
            if (canSetSetupRef(ref3)) {
              setupState[ref3] = value;
            }
          } else if (_isRef) {
            ref3.value = value;
            if (rawRef.k) refs[rawRef.k] = value;
          } else ;
        };
        if (value) {
          doSet.id = -1;
          queuePostRenderEffect(doSet, parentSuspense);
        } else {
          doSet();
        }
      }
    }
  }
  getGlobalThis().requestIdleCallback || ((cb) => setTimeout(cb, 1));
  getGlobalThis().cancelIdleCallback || ((id) => clearTimeout(id));
  const isAsyncWrapper = (i) => !!i.type.__asyncLoader;
  const isKeepAlive = (vnode) => vnode.type.__isKeepAlive;
  const KeepAliveImpl = {
    name: `KeepAlive`,
    // Marker for special handling inside the renderer. We are not using a ===
    // check directly on KeepAlive in the renderer, because importing it directly
    // would prevent it from being tree-shaken.
    __isKeepAlive: true,
    props: {
      include: [String, RegExp, Array],
      exclude: [String, RegExp, Array],
      max: [String, Number]
    },
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const sharedContext = instance.ctx;
      if (!sharedContext.renderer) {
        return () => {
          const children = slots.default && slots.default();
          return children && children.length === 1 ? children[0] : children;
        };
      }
      const cache = /* @__PURE__ */ new Map();
      const keys = /* @__PURE__ */ new Set();
      let current = null;
      const parentSuspense = instance.suspense;
      const {
        renderer: {
          p: patch,
          m: move,
          um: _unmount,
          o: { createElement }
        }
      } = sharedContext;
      const storageContainer = createElement("div");
      sharedContext.activate = (vnode, container, anchor, namespace, optimized) => {
        const instance2 = vnode.component;
        move(vnode, container, anchor, 0, parentSuspense);
        patch(
          instance2.vnode,
          vnode,
          container,
          anchor,
          instance2,
          parentSuspense,
          namespace,
          vnode.slotScopeIds,
          optimized
        );
        queuePostRenderEffect(() => {
          instance2.isDeactivated = false;
          if (instance2.a) {
            invokeArrayFns(instance2.a);
          }
          const vnodeHook = vnode.props && vnode.props.onVnodeMounted;
          if (vnodeHook) {
            invokeVNodeHook(vnodeHook, instance2.parent, vnode);
          }
        }, parentSuspense);
      };
      sharedContext.deactivate = (vnode) => {
        const instance2 = vnode.component;
        invalidateMount(instance2.m);
        invalidateMount(instance2.a);
        move(vnode, storageContainer, null, 1, parentSuspense);
        queuePostRenderEffect(() => {
          if (instance2.da) {
            invokeArrayFns(instance2.da);
          }
          const vnodeHook = vnode.props && vnode.props.onVnodeUnmounted;
          if (vnodeHook) {
            invokeVNodeHook(vnodeHook, instance2.parent, vnode);
          }
          instance2.isDeactivated = true;
        }, parentSuspense);
      };
      function unmount(vnode) {
        resetShapeFlag(vnode);
        _unmount(vnode, instance, parentSuspense, true);
      }
      function pruneCache(filter) {
        cache.forEach((vnode, key) => {
          const name = getComponentName(vnode.type);
          if (name && !filter(name)) {
            pruneCacheEntry(key);
          }
        });
      }
      function pruneCacheEntry(key) {
        const cached = cache.get(key);
        if (cached && (!current || !isSameVNodeType(cached, current))) {
          unmount(cached);
        } else if (current) {
          resetShapeFlag(current);
        }
        cache.delete(key);
        keys.delete(key);
      }
      watch(
        () => [props.include, props.exclude],
        ([include, exclude]) => {
          include && pruneCache((name) => matches(include, name));
          exclude && pruneCache((name) => !matches(exclude, name));
        },
        // prune post-render after `current` has been updated
        { flush: "post", deep: true }
      );
      let pendingCacheKey = null;
      const cacheSubtree = () => {
        if (pendingCacheKey != null) {
          if (isSuspense(instance.subTree.type)) {
            queuePostRenderEffect(() => {
              cache.set(pendingCacheKey, getInnerChild(instance.subTree));
            }, instance.subTree.suspense);
          } else {
            cache.set(pendingCacheKey, getInnerChild(instance.subTree));
          }
        }
      };
      onMounted(cacheSubtree);
      onUpdated(cacheSubtree);
      onBeforeUnmount(() => {
        cache.forEach((cached) => {
          const { subTree, suspense } = instance;
          const vnode = getInnerChild(subTree);
          if (cached.type === vnode.type && cached.key === vnode.key) {
            resetShapeFlag(vnode);
            const da = vnode.component.da;
            da && queuePostRenderEffect(da, suspense);
            return;
          }
          unmount(cached);
        });
      });
      return () => {
        pendingCacheKey = null;
        if (!slots.default) {
          return current = null;
        }
        const children = slots.default();
        const rawVNode = children[0];
        if (children.length > 1) {
          current = null;
          return children;
        } else if (!isVNode(rawVNode) || !(rawVNode.shapeFlag & 4) && !(rawVNode.shapeFlag & 128)) {
          current = null;
          return rawVNode;
        }
        let vnode = getInnerChild(rawVNode);
        if (vnode.type === Comment) {
          current = null;
          return vnode;
        }
        const comp = vnode.type;
        const name = getComponentName(
          isAsyncWrapper(vnode) ? vnode.type.__asyncResolved || {} : comp
        );
        const { include, exclude, max } = props;
        if (include && (!name || !matches(include, name)) || exclude && name && matches(exclude, name)) {
          vnode.shapeFlag &= -257;
          current = vnode;
          return rawVNode;
        }
        const key = vnode.key == null ? comp : vnode.key;
        const cachedVNode = cache.get(key);
        if (vnode.el) {
          vnode = cloneVNode(vnode);
          if (rawVNode.shapeFlag & 128) {
            rawVNode.ssContent = vnode;
          }
        }
        pendingCacheKey = key;
        if (cachedVNode) {
          vnode.el = cachedVNode.el;
          vnode.component = cachedVNode.component;
          if (vnode.transition) {
            setTransitionHooks(vnode, vnode.transition);
          }
          vnode.shapeFlag |= 512;
          keys.delete(key);
          keys.add(key);
        } else {
          keys.add(key);
          if (max && keys.size > parseInt(max, 10)) {
            pruneCacheEntry(keys.values().next().value);
          }
        }
        vnode.shapeFlag |= 256;
        current = vnode;
        return isSuspense(rawVNode.type) ? rawVNode : vnode;
      };
    }
  };
  const KeepAlive = KeepAliveImpl;
  function matches(pattern, name) {
    if (isArray(pattern)) {
      return pattern.some((p2) => matches(p2, name));
    } else if (isString(pattern)) {
      return pattern.split(",").includes(name);
    } else if (isRegExp(pattern)) {
      pattern.lastIndex = 0;
      return pattern.test(name);
    }
    return false;
  }
  function onActivated(hook, target) {
    registerKeepAliveHook(hook, "a", target);
  }
  function onDeactivated(hook, target) {
    registerKeepAliveHook(hook, "da", target);
  }
  function registerKeepAliveHook(hook, type, target = currentInstance) {
    const wrappedHook = hook.__wdc || (hook.__wdc = () => {
      let current = target;
      while (current) {
        if (current.isDeactivated) {
          return;
        }
        current = current.parent;
      }
      return hook();
    });
    injectHook(type, wrappedHook, target);
    if (target) {
      let current = target.parent;
      while (current && current.parent) {
        if (isKeepAlive(current.parent.vnode)) {
          injectToKeepAliveRoot(wrappedHook, type, target, current);
        }
        current = current.parent;
      }
    }
  }
  function injectToKeepAliveRoot(hook, type, target, keepAliveRoot) {
    const injected = injectHook(
      type,
      hook,
      keepAliveRoot,
      true
      /* prepend */
    );
    onUnmounted(() => {
      remove(keepAliveRoot[type], injected);
    }, target);
  }
  function resetShapeFlag(vnode) {
    vnode.shapeFlag &= -257;
    vnode.shapeFlag &= -513;
  }
  function getInnerChild(vnode) {
    return vnode.shapeFlag & 128 ? vnode.ssContent : vnode;
  }
  function injectHook(type, hook, target = currentInstance, prepend = false) {
    if (target) {
      const hooks = target[type] || (target[type] = []);
      const wrappedHook = hook.__weh || (hook.__weh = (...args) => {
        pauseTracking();
        const reset = setCurrentInstance(target);
        const res = callWithAsyncErrorHandling(hook, target, type, args);
        reset();
        resetTracking();
        return res;
      });
      if (prepend) {
        hooks.unshift(wrappedHook);
      } else {
        hooks.push(wrappedHook);
      }
      return wrappedHook;
    }
  }
  const createHook = (lifecycle) => (hook, target = currentInstance) => {
    if (!isInSSRComponentSetup || lifecycle === "sp") {
      injectHook(lifecycle, (...args) => hook(...args), target);
    }
  };
  const onBeforeMount = createHook("bm");
  const onMounted = createHook("m");
  const onBeforeUpdate = createHook(
    "bu"
  );
  const onUpdated = createHook("u");
  const onBeforeUnmount = createHook(
    "bum"
  );
  const onUnmounted = createHook("um");
  const onServerPrefetch = createHook(
    "sp"
  );
  const onRenderTriggered = createHook("rtg");
  const onRenderTracked = createHook("rtc");
  function onErrorCaptured(hook, target = currentInstance) {
    injectHook("ec", hook, target);
  }
  const COMPONENTS = "components";
  function resolveComponent(name, maybeSelfReference) {
    return resolveAsset(COMPONENTS, name, true, maybeSelfReference) || name;
  }
  const NULL_DYNAMIC_COMPONENT = Symbol.for("v-ndc");
  function resolveDynamicComponent(component) {
    if (isString(component)) {
      return resolveAsset(COMPONENTS, component, false) || component;
    } else {
      return component || NULL_DYNAMIC_COMPONENT;
    }
  }
  function resolveAsset(type, name, warnMissing = true, maybeSelfReference = false) {
    const instance = currentRenderingInstance || currentInstance;
    if (instance) {
      const Component = instance.type;
      {
        const selfName = getComponentName(
          Component,
          false
        );
        if (selfName && (selfName === name || selfName === camelize(name) || selfName === capitalize(camelize(name)))) {
          return Component;
        }
      }
      const res = (
        // local registration
        // check instance[type] first which is resolved for options API
        resolve(instance[type] || Component[type], name) || // global registration
        resolve(instance.appContext[type], name)
      );
      if (!res && maybeSelfReference) {
        return Component;
      }
      return res;
    }
  }
  function resolve(registry, name) {
    return registry && (registry[name] || registry[camelize(name)] || registry[capitalize(camelize(name))]);
  }
  function renderList(source, renderItem, cache, index) {
    let ret;
    const cached = cache;
    const sourceIsArray = isArray(source);
    if (sourceIsArray || isString(source)) {
      const sourceIsReactiveArray = sourceIsArray && isReactive(source);
      let needsWrap = false;
      let isReadonlySource = false;
      if (sourceIsReactiveArray) {
        needsWrap = !isShallow(source);
        isReadonlySource = isReadonly(source);
        source = shallowReadArray(source);
      }
      ret = new Array(source.length);
      for (let i = 0, l = source.length; i < l; i++) {
        ret[i] = renderItem(
          needsWrap ? isReadonlySource ? toReadonly(toReactive(source[i])) : toReactive(source[i]) : source[i],
          i,
          void 0,
          cached
        );
      }
    } else if (typeof source === "number") {
      ret = new Array(source);
      for (let i = 0; i < source; i++) {
        ret[i] = renderItem(i + 1, i, void 0, cached);
      }
    } else if (isObject$1(source)) {
      if (source[Symbol.iterator]) {
        ret = Array.from(
          source,
          (item, i) => renderItem(item, i, void 0, cached)
        );
      } else {
        const keys = Object.keys(source);
        ret = new Array(keys.length);
        for (let i = 0, l = keys.length; i < l; i++) {
          const key = keys[i];
          ret[i] = renderItem(source[key], key, i, cached);
        }
      }
    } else {
      ret = [];
    }
    return ret;
  }
  function renderSlot(slots, name, props = {}, fallback, noSlotted) {
    if (currentRenderingInstance.ce || currentRenderingInstance.parent && isAsyncWrapper(currentRenderingInstance.parent) && currentRenderingInstance.parent.ce) {
      if (name !== "default") props.name = name;
      return openBlock(), createBlock(
        Fragment,
        null,
        [createVNode("slot", props, fallback && fallback())],
        64
      );
    }
    let slot = slots[name];
    if (slot && slot._c) {
      slot._d = false;
    }
    openBlock();
    const validSlotContent = slot && ensureValidVNode(slot(props));
    const slotKey = props.key || // slot content array of a dynamic conditional slot may have a branch
    // key attached in the `createSlots` helper, respect that
    validSlotContent && validSlotContent.key;
    const rendered = createBlock(
      Fragment,
      {
        key: (slotKey && !isSymbol(slotKey) ? slotKey : `_${name}`) + // #7256 force differentiate fallback content from actual content
        (!validSlotContent && fallback ? "_fb" : "")
      },
      validSlotContent || (fallback ? fallback() : []),
      validSlotContent && slots._ === 1 ? 64 : -2
    );
    if (!noSlotted && rendered.scopeId) {
      rendered.slotScopeIds = [rendered.scopeId + "-s"];
    }
    if (slot && slot._c) {
      slot._d = true;
    }
    return rendered;
  }
  function ensureValidVNode(vnodes) {
    return vnodes.some((child) => {
      if (!isVNode(child)) return true;
      if (child.type === Comment) return false;
      if (child.type === Fragment && !ensureValidVNode(child.children))
        return false;
      return true;
    }) ? vnodes : null;
  }
  const getPublicInstance = (i) => {
    if (!i) return null;
    if (isStatefulComponent(i)) return getComponentPublicInstance(i);
    return getPublicInstance(i.parent);
  };
  const publicPropertiesMap = (
    // Move PURE marker to new line to workaround compiler discarding it
    // due to type annotation
    /* @__PURE__ */ extend(/* @__PURE__ */ Object.create(null), {
      $: (i) => i,
      $el: (i) => i.vnode.el,
      $data: (i) => i.data,
      $props: (i) => i.props,
      $attrs: (i) => i.attrs,
      $slots: (i) => i.slots,
      $refs: (i) => i.refs,
      $parent: (i) => getPublicInstance(i.parent),
      $root: (i) => getPublicInstance(i.root),
      $host: (i) => i.ce,
      $emit: (i) => i.emit,
      $options: (i) => resolveMergedOptions(i),
      $forceUpdate: (i) => i.f || (i.f = () => {
        queueJob(i.update);
      }),
      $nextTick: (i) => i.n || (i.n = nextTick.bind(i.proxy)),
      $watch: (i) => instanceWatch.bind(i)
    })
  );
  const hasSetupBinding = (state2, key) => state2 !== EMPTY_OBJ && !state2.__isScriptSetup && hasOwn(state2, key);
  const PublicInstanceProxyHandlers = {
    get({ _: instance }, key) {
      if (key === "__v_skip") {
        return true;
      }
      const { ctx, setupState, data, props, accessCache, type, appContext } = instance;
      let normalizedProps;
      if (key[0] !== "$") {
        const n = accessCache[key];
        if (n !== void 0) {
          switch (n) {
            case 1:
              return setupState[key];
            case 2:
              return data[key];
            case 4:
              return ctx[key];
            case 3:
              return props[key];
          }
        } else if (hasSetupBinding(setupState, key)) {
          accessCache[key] = 1;
          return setupState[key];
        } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
          accessCache[key] = 2;
          return data[key];
        } else if (
          // only cache other properties when instance has declared (thus stable)
          // props
          (normalizedProps = instance.propsOptions[0]) && hasOwn(normalizedProps, key)
        ) {
          accessCache[key] = 3;
          return props[key];
        } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
          accessCache[key] = 4;
          return ctx[key];
        } else if (shouldCacheAccess) {
          accessCache[key] = 0;
        }
      }
      const publicGetter = publicPropertiesMap[key];
      let cssModule, globalProperties;
      if (publicGetter) {
        if (key === "$attrs") {
          track(instance.attrs, "get", "");
        }
        return publicGetter(instance);
      } else if (
        // css module (injected by vue-loader)
        (cssModule = type.__cssModules) && (cssModule = cssModule[key])
      ) {
        return cssModule;
      } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
        accessCache[key] = 4;
        return ctx[key];
      } else if (
        // global properties
        globalProperties = appContext.config.globalProperties, hasOwn(globalProperties, key)
      ) {
        {
          return globalProperties[key];
        }
      } else ;
    },
    set({ _: instance }, key, value) {
      const { data, setupState, ctx } = instance;
      if (hasSetupBinding(setupState, key)) {
        setupState[key] = value;
        return true;
      } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
        data[key] = value;
        return true;
      } else if (hasOwn(instance.props, key)) {
        return false;
      }
      if (key[0] === "$" && key.slice(1) in instance) {
        return false;
      } else {
        {
          ctx[key] = value;
        }
      }
      return true;
    },
    has({
      _: { data, setupState, accessCache, ctx, appContext, propsOptions }
    }, key) {
      let normalizedProps;
      return !!accessCache[key] || data !== EMPTY_OBJ && hasOwn(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn(normalizedProps, key) || hasOwn(ctx, key) || hasOwn(publicPropertiesMap, key) || hasOwn(appContext.config.globalProperties, key);
    },
    defineProperty(target, key, descriptor) {
      if (descriptor.get != null) {
        target._.accessCache[key] = 0;
      } else if (hasOwn(descriptor, "value")) {
        this.set(target, key, descriptor.value, null);
      }
      return Reflect.defineProperty(target, key, descriptor);
    }
  };
  function normalizePropsOrEmits(props) {
    return isArray(props) ? props.reduce(
      (normalized, p2) => (normalized[p2] = null, normalized),
      {}
    ) : props;
  }
  let shouldCacheAccess = true;
  function applyOptions(instance) {
    const options = resolveMergedOptions(instance);
    const publicThis = instance.proxy;
    const ctx = instance.ctx;
    shouldCacheAccess = false;
    if (options.beforeCreate) {
      callHook$1(options.beforeCreate, instance, "bc");
    }
    const {
      // state
      data: dataOptions,
      computed: computedOptions,
      methods,
      watch: watchOptions,
      provide: provideOptions,
      inject: injectOptions,
      // lifecycle
      created,
      beforeMount,
      mounted,
      beforeUpdate,
      updated,
      activated,
      deactivated,
      beforeDestroy,
      beforeUnmount,
      destroyed,
      unmounted,
      render,
      renderTracked,
      renderTriggered,
      errorCaptured,
      serverPrefetch,
      // public API
      expose,
      inheritAttrs,
      // assets
      components,
      directives,
      filters
    } = options;
    const checkDuplicateProperties = null;
    if (injectOptions) {
      resolveInjections(injectOptions, ctx, checkDuplicateProperties);
    }
    if (methods) {
      for (const key in methods) {
        const methodHandler = methods[key];
        if (isFunction(methodHandler)) {
          {
            ctx[key] = methodHandler.bind(publicThis);
          }
        }
      }
    }
    if (dataOptions) {
      const data = dataOptions.call(publicThis, publicThis);
      if (!isObject$1(data)) ;
      else {
        instance.data = reactive(data);
      }
    }
    shouldCacheAccess = true;
    if (computedOptions) {
      for (const key in computedOptions) {
        const opt = computedOptions[key];
        const get = isFunction(opt) ? opt.bind(publicThis, publicThis) : isFunction(opt.get) ? opt.get.bind(publicThis, publicThis) : NOOP;
        const set = !isFunction(opt) && isFunction(opt.set) ? opt.set.bind(publicThis) : NOOP;
        const c = computed({
          get,
          set
        });
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => c.value,
          set: (v) => c.value = v
        });
      }
    }
    if (watchOptions) {
      for (const key in watchOptions) {
        createWatcher(watchOptions[key], ctx, publicThis, key);
      }
    }
    if (provideOptions) {
      const provides = isFunction(provideOptions) ? provideOptions.call(publicThis) : provideOptions;
      Reflect.ownKeys(provides).forEach((key) => {
        provide(key, provides[key]);
      });
    }
    if (created) {
      callHook$1(created, instance, "c");
    }
    function registerLifecycleHook(register, hook) {
      if (isArray(hook)) {
        hook.forEach((_hook) => register(_hook.bind(publicThis)));
      } else if (hook) {
        register(hook.bind(publicThis));
      }
    }
    registerLifecycleHook(onBeforeMount, beforeMount);
    registerLifecycleHook(onMounted, mounted);
    registerLifecycleHook(onBeforeUpdate, beforeUpdate);
    registerLifecycleHook(onUpdated, updated);
    registerLifecycleHook(onActivated, activated);
    registerLifecycleHook(onDeactivated, deactivated);
    registerLifecycleHook(onErrorCaptured, errorCaptured);
    registerLifecycleHook(onRenderTracked, renderTracked);
    registerLifecycleHook(onRenderTriggered, renderTriggered);
    registerLifecycleHook(onBeforeUnmount, beforeUnmount);
    registerLifecycleHook(onUnmounted, unmounted);
    registerLifecycleHook(onServerPrefetch, serverPrefetch);
    if (isArray(expose)) {
      if (expose.length) {
        const exposed = instance.exposed || (instance.exposed = {});
        expose.forEach((key) => {
          Object.defineProperty(exposed, key, {
            get: () => publicThis[key],
            set: (val) => publicThis[key] = val,
            enumerable: true
          });
        });
      } else if (!instance.exposed) {
        instance.exposed = {};
      }
    }
    if (render && instance.render === NOOP) {
      instance.render = render;
    }
    if (inheritAttrs != null) {
      instance.inheritAttrs = inheritAttrs;
    }
    if (components) instance.components = components;
    if (directives) instance.directives = directives;
    if (serverPrefetch) {
      markAsyncBoundary(instance);
    }
  }
  function resolveInjections(injectOptions, ctx, checkDuplicateProperties = NOOP) {
    if (isArray(injectOptions)) {
      injectOptions = normalizeInject(injectOptions);
    }
    for (const key in injectOptions) {
      const opt = injectOptions[key];
      let injected;
      if (isObject$1(opt)) {
        if ("default" in opt) {
          injected = inject(
            opt.from || key,
            opt.default,
            true
          );
        } else {
          injected = inject(opt.from || key);
        }
      } else {
        injected = inject(opt);
      }
      if (isRef(injected)) {
        Object.defineProperty(ctx, key, {
          enumerable: true,
          configurable: true,
          get: () => injected.value,
          set: (v) => injected.value = v
        });
      } else {
        ctx[key] = injected;
      }
    }
  }
  function callHook$1(hook, instance, type) {
    callWithAsyncErrorHandling(
      isArray(hook) ? hook.map((h2) => h2.bind(instance.proxy)) : hook.bind(instance.proxy),
      instance,
      type
    );
  }
  function createWatcher(raw, ctx, publicThis, key) {
    let getter = key.includes(".") ? createPathGetter(publicThis, key) : () => publicThis[key];
    if (isString(raw)) {
      const handler = ctx[raw];
      if (isFunction(handler)) {
        {
          watch(getter, handler);
        }
      }
    } else if (isFunction(raw)) {
      {
        watch(getter, raw.bind(publicThis));
      }
    } else if (isObject$1(raw)) {
      if (isArray(raw)) {
        raw.forEach((r) => createWatcher(r, ctx, publicThis, key));
      } else {
        const handler = isFunction(raw.handler) ? raw.handler.bind(publicThis) : ctx[raw.handler];
        if (isFunction(handler)) {
          watch(getter, handler, raw);
        }
      }
    } else ;
  }
  function resolveMergedOptions(instance) {
    const base = instance.type;
    const { mixins, extends: extendsOptions } = base;
    const {
      mixins: globalMixins,
      optionsCache: cache,
      config: { optionMergeStrategies }
    } = instance.appContext;
    const cached = cache.get(base);
    let resolved;
    if (cached) {
      resolved = cached;
    } else if (!globalMixins.length && !mixins && !extendsOptions) {
      {
        resolved = base;
      }
    } else {
      resolved = {};
      if (globalMixins.length) {
        globalMixins.forEach(
          (m) => mergeOptions(resolved, m, optionMergeStrategies, true)
        );
      }
      mergeOptions(resolved, base, optionMergeStrategies);
    }
    if (isObject$1(base)) {
      cache.set(base, resolved);
    }
    return resolved;
  }
  function mergeOptions(to, from, strats, asMixin = false) {
    const { mixins, extends: extendsOptions } = from;
    if (extendsOptions) {
      mergeOptions(to, extendsOptions, strats, true);
    }
    if (mixins) {
      mixins.forEach(
        (m) => mergeOptions(to, m, strats, true)
      );
    }
    for (const key in from) {
      if (asMixin && key === "expose") ;
      else {
        const strat = internalOptionMergeStrats[key] || strats && strats[key];
        to[key] = strat ? strat(to[key], from[key]) : from[key];
      }
    }
    return to;
  }
  const internalOptionMergeStrats = {
    data: mergeDataFn,
    props: mergeEmitsOrPropsOptions,
    emits: mergeEmitsOrPropsOptions,
    // objects
    methods: mergeObjectOptions,
    computed: mergeObjectOptions,
    // lifecycle
    beforeCreate: mergeAsArray,
    created: mergeAsArray,
    beforeMount: mergeAsArray,
    mounted: mergeAsArray,
    beforeUpdate: mergeAsArray,
    updated: mergeAsArray,
    beforeDestroy: mergeAsArray,
    beforeUnmount: mergeAsArray,
    destroyed: mergeAsArray,
    unmounted: mergeAsArray,
    activated: mergeAsArray,
    deactivated: mergeAsArray,
    errorCaptured: mergeAsArray,
    serverPrefetch: mergeAsArray,
    // assets
    components: mergeObjectOptions,
    directives: mergeObjectOptions,
    // watch
    watch: mergeWatchOptions,
    // provide / inject
    provide: mergeDataFn,
    inject: mergeInject
  };
  function mergeDataFn(to, from) {
    if (!from) {
      return to;
    }
    if (!to) {
      return from;
    }
    return function mergedDataFn() {
      return extend(
        isFunction(to) ? to.call(this, this) : to,
        isFunction(from) ? from.call(this, this) : from
      );
    };
  }
  function mergeInject(to, from) {
    return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
  }
  function normalizeInject(raw) {
    if (isArray(raw)) {
      const res = {};
      for (let i = 0; i < raw.length; i++) {
        res[raw[i]] = raw[i];
      }
      return res;
    }
    return raw;
  }
  function mergeAsArray(to, from) {
    return to ? [...new Set([].concat(to, from))] : from;
  }
  function mergeObjectOptions(to, from) {
    return to ? extend(/* @__PURE__ */ Object.create(null), to, from) : from;
  }
  function mergeEmitsOrPropsOptions(to, from) {
    if (to) {
      if (isArray(to) && isArray(from)) {
        return [.../* @__PURE__ */ new Set([...to, ...from])];
      }
      return extend(
        /* @__PURE__ */ Object.create(null),
        normalizePropsOrEmits(to),
        normalizePropsOrEmits(from != null ? from : {})
      );
    } else {
      return from;
    }
  }
  function mergeWatchOptions(to, from) {
    if (!to) return from;
    if (!from) return to;
    const merged = extend(/* @__PURE__ */ Object.create(null), to);
    for (const key in from) {
      merged[key] = mergeAsArray(to[key], from[key]);
    }
    return merged;
  }
  function createAppContext() {
    return {
      app: null,
      config: {
        isNativeTag: NO,
        performance: false,
        globalProperties: {},
        optionMergeStrategies: {},
        errorHandler: void 0,
        warnHandler: void 0,
        compilerOptions: {}
      },
      mixins: [],
      components: {},
      directives: {},
      provides: /* @__PURE__ */ Object.create(null),
      optionsCache: /* @__PURE__ */ new WeakMap(),
      propsCache: /* @__PURE__ */ new WeakMap(),
      emitsCache: /* @__PURE__ */ new WeakMap()
    };
  }
  let uid$1 = 0;
  function createAppAPI(render, hydrate) {
    return function createApp2(rootComponent, rootProps = null) {
      if (!isFunction(rootComponent)) {
        rootComponent = extend({}, rootComponent);
      }
      if (rootProps != null && !isObject$1(rootProps)) {
        rootProps = null;
      }
      const context = createAppContext();
      const installedPlugins = /* @__PURE__ */ new WeakSet();
      const pluginCleanupFns = [];
      let isMounted = false;
      const app2 = context.app = {
        _uid: uid$1++,
        _component: rootComponent,
        _props: rootProps,
        _container: null,
        _context: context,
        _instance: null,
        version,
        get config() {
          return context.config;
        },
        set config(v) {
        },
        use(plugin, ...options) {
          if (installedPlugins.has(plugin)) ;
          else if (plugin && isFunction(plugin.install)) {
            installedPlugins.add(plugin);
            plugin.install(app2, ...options);
          } else if (isFunction(plugin)) {
            installedPlugins.add(plugin);
            plugin(app2, ...options);
          } else ;
          return app2;
        },
        mixin(mixin) {
          {
            if (!context.mixins.includes(mixin)) {
              context.mixins.push(mixin);
            }
          }
          return app2;
        },
        component(name, component) {
          if (!component) {
            return context.components[name];
          }
          context.components[name] = component;
          return app2;
        },
        directive(name, directive) {
          if (!directive) {
            return context.directives[name];
          }
          context.directives[name] = directive;
          return app2;
        },
        mount(rootContainer, isHydrate, namespace) {
          if (!isMounted) {
            const vnode = app2._ceVNode || createVNode(rootComponent, rootProps);
            vnode.appContext = context;
            if (namespace === true) {
              namespace = "svg";
            } else if (namespace === false) {
              namespace = void 0;
            }
            {
              render(vnode, rootContainer, namespace);
            }
            isMounted = true;
            app2._container = rootContainer;
            rootContainer.__vue_app__ = app2;
            return getComponentPublicInstance(vnode.component);
          }
        },
        onUnmount(cleanupFn) {
          pluginCleanupFns.push(cleanupFn);
        },
        unmount() {
          if (isMounted) {
            callWithAsyncErrorHandling(
              pluginCleanupFns,
              app2._instance,
              16
            );
            render(null, app2._container);
            delete app2._container.__vue_app__;
          }
        },
        provide(key, value) {
          context.provides[key] = value;
          return app2;
        },
        runWithContext(fn) {
          const lastApp = currentApp;
          currentApp = app2;
          try {
            return fn();
          } finally {
            currentApp = lastApp;
          }
        }
      };
      return app2;
    };
  }
  let currentApp = null;
  function provide(key, value) {
    if (!currentInstance) ;
    else {
      let provides = currentInstance.provides;
      const parentProvides = currentInstance.parent && currentInstance.parent.provides;
      if (parentProvides === provides) {
        provides = currentInstance.provides = Object.create(parentProvides);
      }
      provides[key] = value;
    }
  }
  function inject(key, defaultValue, treatDefaultAsFactory = false) {
    const instance = getCurrentInstance();
    if (instance || currentApp) {
      let provides = currentApp ? currentApp._context.provides : instance ? instance.parent == null || instance.ce ? instance.vnode.appContext && instance.vnode.appContext.provides : instance.parent.provides : void 0;
      if (provides && key in provides) {
        return provides[key];
      } else if (arguments.length > 1) {
        return treatDefaultAsFactory && isFunction(defaultValue) ? defaultValue.call(instance && instance.proxy) : defaultValue;
      } else ;
    }
  }
  const internalObjectProto = {};
  const createInternalObject = () => Object.create(internalObjectProto);
  const isInternalObject = (obj) => Object.getPrototypeOf(obj) === internalObjectProto;
  function initProps(instance, rawProps, isStateful, isSSR = false) {
    const props = {};
    const attrs = createInternalObject();
    instance.propsDefaults = /* @__PURE__ */ Object.create(null);
    setFullProps(instance, rawProps, props, attrs);
    for (const key in instance.propsOptions[0]) {
      if (!(key in props)) {
        props[key] = void 0;
      }
    }
    if (isStateful) {
      instance.props = isSSR ? props : shallowReactive(props);
    } else {
      if (!instance.type.props) {
        instance.props = attrs;
      } else {
        instance.props = props;
      }
    }
    instance.attrs = attrs;
  }
  function updateProps(instance, rawProps, rawPrevProps, optimized) {
    const {
      props,
      attrs,
      vnode: { patchFlag }
    } = instance;
    const rawCurrentProps = toRaw(props);
    const [options] = instance.propsOptions;
    let hasAttrsChanged = false;
    if (
      // always force full diff in dev
      // - #1942 if hmr is enabled with sfc component
      // - vite#872 non-sfc component used by sfc component
      (optimized || patchFlag > 0) && !(patchFlag & 16)
    ) {
      if (patchFlag & 8) {
        const propsToUpdate = instance.vnode.dynamicProps;
        for (let i = 0; i < propsToUpdate.length; i++) {
          let key = propsToUpdate[i];
          if (isEmitListener(instance.emitsOptions, key)) {
            continue;
          }
          const value = rawProps[key];
          if (options) {
            if (hasOwn(attrs, key)) {
              if (value !== attrs[key]) {
                attrs[key] = value;
                hasAttrsChanged = true;
              }
            } else {
              const camelizedKey = camelize(key);
              props[camelizedKey] = resolvePropValue(
                options,
                rawCurrentProps,
                camelizedKey,
                value,
                instance,
                false
              );
            }
          } else {
            if (value !== attrs[key]) {
              attrs[key] = value;
              hasAttrsChanged = true;
            }
          }
        }
      }
    } else {
      if (setFullProps(instance, rawProps, props, attrs)) {
        hasAttrsChanged = true;
      }
      let kebabKey;
      for (const key in rawCurrentProps) {
        if (!rawProps || // for camelCase
        !hasOwn(rawProps, key) && // it's possible the original props was passed in as kebab-case
        // and converted to camelCase (#955)
        ((kebabKey = hyphenate(key)) === key || !hasOwn(rawProps, kebabKey))) {
          if (options) {
            if (rawPrevProps && // for camelCase
            (rawPrevProps[key] !== void 0 || // for kebab-case
            rawPrevProps[kebabKey] !== void 0)) {
              props[key] = resolvePropValue(
                options,
                rawCurrentProps,
                key,
                void 0,
                instance,
                true
              );
            }
          } else {
            delete props[key];
          }
        }
      }
      if (attrs !== rawCurrentProps) {
        for (const key in attrs) {
          if (!rawProps || !hasOwn(rawProps, key) && true) {
            delete attrs[key];
            hasAttrsChanged = true;
          }
        }
      }
    }
    if (hasAttrsChanged) {
      trigger(instance.attrs, "set", "");
    }
  }
  function setFullProps(instance, rawProps, props, attrs) {
    const [options, needCastKeys] = instance.propsOptions;
    let hasAttrsChanged = false;
    let rawCastValues;
    if (rawProps) {
      for (let key in rawProps) {
        if (isReservedProp(key)) {
          continue;
        }
        const value = rawProps[key];
        let camelKey;
        if (options && hasOwn(options, camelKey = camelize(key))) {
          if (!needCastKeys || !needCastKeys.includes(camelKey)) {
            props[camelKey] = value;
          } else {
            (rawCastValues || (rawCastValues = {}))[camelKey] = value;
          }
        } else if (!isEmitListener(instance.emitsOptions, key)) {
          if (!(key in attrs) || value !== attrs[key]) {
            attrs[key] = value;
            hasAttrsChanged = true;
          }
        }
      }
    }
    if (needCastKeys) {
      const rawCurrentProps = toRaw(props);
      const castValues = rawCastValues || EMPTY_OBJ;
      for (let i = 0; i < needCastKeys.length; i++) {
        const key = needCastKeys[i];
        props[key] = resolvePropValue(
          options,
          rawCurrentProps,
          key,
          castValues[key],
          instance,
          !hasOwn(castValues, key)
        );
      }
    }
    return hasAttrsChanged;
  }
  function resolvePropValue(options, props, key, value, instance, isAbsent) {
    const opt = options[key];
    if (opt != null) {
      const hasDefault = hasOwn(opt, "default");
      if (hasDefault && value === void 0) {
        const defaultValue = opt.default;
        if (opt.type !== Function && !opt.skipFactory && isFunction(defaultValue)) {
          const { propsDefaults } = instance;
          if (key in propsDefaults) {
            value = propsDefaults[key];
          } else {
            const reset = setCurrentInstance(instance);
            value = propsDefaults[key] = defaultValue.call(
              null,
              props
            );
            reset();
          }
        } else {
          value = defaultValue;
        }
        if (instance.ce) {
          instance.ce._setProp(key, value);
        }
      }
      if (opt[
        0
        /* shouldCast */
      ]) {
        if (isAbsent && !hasDefault) {
          value = false;
        } else if (opt[
          1
          /* shouldCastTrue */
        ] && (value === "" || value === hyphenate(key))) {
          value = true;
        }
      }
    }
    return value;
  }
  const mixinPropsCache = /* @__PURE__ */ new WeakMap();
  function normalizePropsOptions(comp, appContext, asMixin = false) {
    const cache = asMixin ? mixinPropsCache : appContext.propsCache;
    const cached = cache.get(comp);
    if (cached) {
      return cached;
    }
    const raw = comp.props;
    const normalized = {};
    const needCastKeys = [];
    let hasExtends = false;
    if (!isFunction(comp)) {
      const extendProps = (raw2) => {
        hasExtends = true;
        const [props, keys] = normalizePropsOptions(raw2, appContext, true);
        extend(normalized, props);
        if (keys) needCastKeys.push(...keys);
      };
      if (!asMixin && appContext.mixins.length) {
        appContext.mixins.forEach(extendProps);
      }
      if (comp.extends) {
        extendProps(comp.extends);
      }
      if (comp.mixins) {
        comp.mixins.forEach(extendProps);
      }
    }
    if (!raw && !hasExtends) {
      if (isObject$1(comp)) {
        cache.set(comp, EMPTY_ARR);
      }
      return EMPTY_ARR;
    }
    if (isArray(raw)) {
      for (let i = 0; i < raw.length; i++) {
        const normalizedKey = camelize(raw[i]);
        if (validatePropName(normalizedKey)) {
          normalized[normalizedKey] = EMPTY_OBJ;
        }
      }
    } else if (raw) {
      for (const key in raw) {
        const normalizedKey = camelize(key);
        if (validatePropName(normalizedKey)) {
          const opt = raw[key];
          const prop = normalized[normalizedKey] = isArray(opt) || isFunction(opt) ? { type: opt } : extend({}, opt);
          const propType = prop.type;
          let shouldCast = false;
          let shouldCastTrue = true;
          if (isArray(propType)) {
            for (let index = 0; index < propType.length; ++index) {
              const type = propType[index];
              const typeName = isFunction(type) && type.name;
              if (typeName === "Boolean") {
                shouldCast = true;
                break;
              } else if (typeName === "String") {
                shouldCastTrue = false;
              }
            }
          } else {
            shouldCast = isFunction(propType) && propType.name === "Boolean";
          }
          prop[
            0
            /* shouldCast */
          ] = shouldCast;
          prop[
            1
            /* shouldCastTrue */
          ] = shouldCastTrue;
          if (shouldCast || hasOwn(prop, "default")) {
            needCastKeys.push(normalizedKey);
          }
        }
      }
    }
    const res = [normalized, needCastKeys];
    if (isObject$1(comp)) {
      cache.set(comp, res);
    }
    return res;
  }
  function validatePropName(key) {
    if (key[0] !== "$" && !isReservedProp(key)) {
      return true;
    }
    return false;
  }
  const isInternalKey = (key) => key === "_" || key === "__" || key === "_ctx" || key === "$stable";
  const normalizeSlotValue = (value) => isArray(value) ? value.map(normalizeVNode) : [normalizeVNode(value)];
  const normalizeSlot = (key, rawSlot, ctx) => {
    if (rawSlot._n) {
      return rawSlot;
    }
    const normalized = withCtx((...args) => {
      if (false) ;
      return normalizeSlotValue(rawSlot(...args));
    }, ctx);
    normalized._c = false;
    return normalized;
  };
  const normalizeObjectSlots = (rawSlots, slots, instance) => {
    const ctx = rawSlots._ctx;
    for (const key in rawSlots) {
      if (isInternalKey(key)) continue;
      const value = rawSlots[key];
      if (isFunction(value)) {
        slots[key] = normalizeSlot(key, value, ctx);
      } else if (value != null) {
        const normalized = normalizeSlotValue(value);
        slots[key] = () => normalized;
      }
    }
  };
  const normalizeVNodeSlots = (instance, children) => {
    const normalized = normalizeSlotValue(children);
    instance.slots.default = () => normalized;
  };
  const assignSlots = (slots, children, optimized) => {
    for (const key in children) {
      if (optimized || !isInternalKey(key)) {
        slots[key] = children[key];
      }
    }
  };
  const initSlots = (instance, children, optimized) => {
    const slots = instance.slots = createInternalObject();
    if (instance.vnode.shapeFlag & 32) {
      const cacheIndexes = children.__;
      if (cacheIndexes) def(slots, "__", cacheIndexes, true);
      const type = children._;
      if (type) {
        assignSlots(slots, children, optimized);
        if (optimized) {
          def(slots, "_", type, true);
        }
      } else {
        normalizeObjectSlots(children, slots);
      }
    } else if (children) {
      normalizeVNodeSlots(instance, children);
    }
  };
  const updateSlots = (instance, children, optimized) => {
    const { vnode, slots } = instance;
    let needDeletionCheck = true;
    let deletionComparisonTarget = EMPTY_OBJ;
    if (vnode.shapeFlag & 32) {
      const type = children._;
      if (type) {
        if (optimized && type === 1) {
          needDeletionCheck = false;
        } else {
          assignSlots(slots, children, optimized);
        }
      } else {
        needDeletionCheck = !children.$stable;
        normalizeObjectSlots(children, slots);
      }
      deletionComparisonTarget = children;
    } else if (children) {
      normalizeVNodeSlots(instance, children);
      deletionComparisonTarget = { default: 1 };
    }
    if (needDeletionCheck) {
      for (const key in slots) {
        if (!isInternalKey(key) && deletionComparisonTarget[key] == null) {
          delete slots[key];
        }
      }
    }
  };
  const queuePostRenderEffect = queueEffectWithSuspense;
  function createRenderer(options) {
    return baseCreateRenderer(options);
  }
  function baseCreateRenderer(options, createHydrationFns) {
    const target = getGlobalThis();
    target.__VUE__ = true;
    const {
      insert: hostInsert,
      remove: hostRemove,
      patchProp: hostPatchProp,
      createElement: hostCreateElement,
      createText: hostCreateText,
      createComment: hostCreateComment,
      setText: hostSetText,
      setElementText: hostSetElementText,
      parentNode: hostParentNode,
      nextSibling: hostNextSibling,
      setScopeId: hostSetScopeId = NOOP,
      insertStaticContent: hostInsertStaticContent
    } = options;
    const patch = (n1, n2, container, anchor = null, parentComponent = null, parentSuspense = null, namespace = void 0, slotScopeIds = null, optimized = !!n2.dynamicChildren) => {
      if (n1 === n2) {
        return;
      }
      if (n1 && !isSameVNodeType(n1, n2)) {
        anchor = getNextHostNode(n1);
        unmount(n1, parentComponent, parentSuspense, true);
        n1 = null;
      }
      if (n2.patchFlag === -2) {
        optimized = false;
        n2.dynamicChildren = null;
      }
      const { type, ref: ref3, shapeFlag } = n2;
      switch (type) {
        case Text:
          processText(n1, n2, container, anchor);
          break;
        case Comment:
          processCommentNode(n1, n2, container, anchor);
          break;
        case Static:
          if (n1 == null) {
            mountStaticNode(n2, container, anchor, namespace);
          }
          break;
        case Fragment:
          processFragment(
            n1,
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          break;
        default:
          if (shapeFlag & 1) {
            processElement(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (shapeFlag & 6) {
            processComponent(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (shapeFlag & 64) {
            type.process(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized,
              internals
            );
          } else if (shapeFlag & 128) {
            type.process(
              n1,
              n2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized,
              internals
            );
          } else ;
      }
      if (ref3 != null && parentComponent) {
        setRef(ref3, n1 && n1.ref, parentSuspense, n2 || n1, !n2);
      } else if (ref3 == null && n1 && n1.ref != null) {
        setRef(n1.ref, null, parentSuspense, n1, true);
      }
    };
    const processText = (n1, n2, container, anchor) => {
      if (n1 == null) {
        hostInsert(
          n2.el = hostCreateText(n2.children),
          container,
          anchor
        );
      } else {
        const el = n2.el = n1.el;
        if (n2.children !== n1.children) {
          hostSetText(el, n2.children);
        }
      }
    };
    const processCommentNode = (n1, n2, container, anchor) => {
      if (n1 == null) {
        hostInsert(
          n2.el = hostCreateComment(n2.children || ""),
          container,
          anchor
        );
      } else {
        n2.el = n1.el;
      }
    };
    const mountStaticNode = (n2, container, anchor, namespace) => {
      [n2.el, n2.anchor] = hostInsertStaticContent(
        n2.children,
        container,
        anchor,
        namespace,
        n2.el,
        n2.anchor
      );
    };
    const moveStaticNode = ({ el, anchor }, container, nextSibling) => {
      let next;
      while (el && el !== anchor) {
        next = hostNextSibling(el);
        hostInsert(el, container, nextSibling);
        el = next;
      }
      hostInsert(anchor, container, nextSibling);
    };
    const removeStaticNode = ({ el, anchor }) => {
      let next;
      while (el && el !== anchor) {
        next = hostNextSibling(el);
        hostRemove(el);
        el = next;
      }
      hostRemove(anchor);
    };
    const processElement = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      if (n2.type === "svg") {
        namespace = "svg";
      } else if (n2.type === "math") {
        namespace = "mathml";
      }
      if (n1 == null) {
        mountElement(
          n2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        patchElement(
          n1,
          n2,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
    };
    const mountElement = (vnode, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      let el;
      let vnodeHook;
      const { props, shapeFlag, transition, dirs } = vnode;
      el = vnode.el = hostCreateElement(
        vnode.type,
        namespace,
        props && props.is,
        props
      );
      if (shapeFlag & 8) {
        hostSetElementText(el, vnode.children);
      } else if (shapeFlag & 16) {
        mountChildren(
          vnode.children,
          el,
          null,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(vnode, namespace),
          slotScopeIds,
          optimized
        );
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "created");
      }
      setScopeId(el, vnode, vnode.scopeId, slotScopeIds, parentComponent);
      if (props) {
        for (const key in props) {
          if (key !== "value" && !isReservedProp(key)) {
            hostPatchProp(el, key, null, props[key], namespace, parentComponent);
          }
        }
        if ("value" in props) {
          hostPatchProp(el, "value", null, props.value, namespace);
        }
        if (vnodeHook = props.onVnodeBeforeMount) {
          invokeVNodeHook(vnodeHook, parentComponent, vnode);
        }
      }
      if (dirs) {
        invokeDirectiveHook(vnode, null, parentComponent, "beforeMount");
      }
      const needCallTransitionHooks = needTransition(parentSuspense, transition);
      if (needCallTransitionHooks) {
        transition.beforeEnter(el);
      }
      hostInsert(el, container, anchor);
      if ((vnodeHook = props && props.onVnodeMounted) || needCallTransitionHooks || dirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
          needCallTransitionHooks && transition.enter(el);
          dirs && invokeDirectiveHook(vnode, null, parentComponent, "mounted");
        }, parentSuspense);
      }
    };
    const setScopeId = (el, vnode, scopeId, slotScopeIds, parentComponent) => {
      if (scopeId) {
        hostSetScopeId(el, scopeId);
      }
      if (slotScopeIds) {
        for (let i = 0; i < slotScopeIds.length; i++) {
          hostSetScopeId(el, slotScopeIds[i]);
        }
      }
      if (parentComponent) {
        let subTree = parentComponent.subTree;
        if (vnode === subTree || isSuspense(subTree.type) && (subTree.ssContent === vnode || subTree.ssFallback === vnode)) {
          const parentVNode = parentComponent.vnode;
          setScopeId(
            el,
            parentVNode,
            parentVNode.scopeId,
            parentVNode.slotScopeIds,
            parentComponent.parent
          );
        }
      }
    };
    const mountChildren = (children, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized, start = 0) => {
      for (let i = start; i < children.length; i++) {
        const child = children[i] = optimized ? cloneIfMounted(children[i]) : normalizeVNode(children[i]);
        patch(
          null,
          child,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
    };
    const patchElement = (n1, n2, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      const el = n2.el = n1.el;
      let { patchFlag, dynamicChildren, dirs } = n2;
      patchFlag |= n1.patchFlag & 16;
      const oldProps = n1.props || EMPTY_OBJ;
      const newProps = n2.props || EMPTY_OBJ;
      let vnodeHook;
      parentComponent && toggleRecurse(parentComponent, false);
      if (vnodeHook = newProps.onVnodeBeforeUpdate) {
        invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
      }
      if (dirs) {
        invokeDirectiveHook(n2, n1, parentComponent, "beforeUpdate");
      }
      parentComponent && toggleRecurse(parentComponent, true);
      if (oldProps.innerHTML && newProps.innerHTML == null || oldProps.textContent && newProps.textContent == null) {
        hostSetElementText(el, "");
      }
      if (dynamicChildren) {
        patchBlockChildren(
          n1.dynamicChildren,
          dynamicChildren,
          el,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(n2, namespace),
          slotScopeIds
        );
      } else if (!optimized) {
        patchChildren(
          n1,
          n2,
          el,
          null,
          parentComponent,
          parentSuspense,
          resolveChildrenNamespace(n2, namespace),
          slotScopeIds,
          false
        );
      }
      if (patchFlag > 0) {
        if (patchFlag & 16) {
          patchProps(el, oldProps, newProps, parentComponent, namespace);
        } else {
          if (patchFlag & 2) {
            if (oldProps.class !== newProps.class) {
              hostPatchProp(el, "class", null, newProps.class, namespace);
            }
          }
          if (patchFlag & 4) {
            hostPatchProp(el, "style", oldProps.style, newProps.style, namespace);
          }
          if (patchFlag & 8) {
            const propsToUpdate = n2.dynamicProps;
            for (let i = 0; i < propsToUpdate.length; i++) {
              const key = propsToUpdate[i];
              const prev = oldProps[key];
              const next = newProps[key];
              if (next !== prev || key === "value") {
                hostPatchProp(el, key, prev, next, namespace, parentComponent);
              }
            }
          }
        }
        if (patchFlag & 1) {
          if (n1.children !== n2.children) {
            hostSetElementText(el, n2.children);
          }
        }
      } else if (!optimized && dynamicChildren == null) {
        patchProps(el, oldProps, newProps, parentComponent, namespace);
      }
      if ((vnodeHook = newProps.onVnodeUpdated) || dirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, n2, n1);
          dirs && invokeDirectiveHook(n2, n1, parentComponent, "updated");
        }, parentSuspense);
      }
    };
    const patchBlockChildren = (oldChildren, newChildren, fallbackContainer, parentComponent, parentSuspense, namespace, slotScopeIds) => {
      for (let i = 0; i < newChildren.length; i++) {
        const oldVNode = oldChildren[i];
        const newVNode = newChildren[i];
        const container = (
          // oldVNode may be an errored async setup() component inside Suspense
          // which will not have a mounted element
          oldVNode.el && // - In the case of a Fragment, we need to provide the actual parent
          // of the Fragment itself so it can move its children.
          (oldVNode.type === Fragment || // - In the case of different nodes, there is going to be a replacement
          // which also requires the correct parent container
          !isSameVNodeType(oldVNode, newVNode) || // - In the case of a component, it could contain anything.
          oldVNode.shapeFlag & (6 | 64 | 128)) ? hostParentNode(oldVNode.el) : (
            // In other cases, the parent container is not actually used so we
            // just pass the block element here to avoid a DOM parentNode call.
            fallbackContainer
          )
        );
        patch(
          oldVNode,
          newVNode,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          true
        );
      }
    };
    const patchProps = (el, oldProps, newProps, parentComponent, namespace) => {
      if (oldProps !== newProps) {
        if (oldProps !== EMPTY_OBJ) {
          for (const key in oldProps) {
            if (!isReservedProp(key) && !(key in newProps)) {
              hostPatchProp(
                el,
                key,
                oldProps[key],
                null,
                namespace,
                parentComponent
              );
            }
          }
        }
        for (const key in newProps) {
          if (isReservedProp(key)) continue;
          const next = newProps[key];
          const prev = oldProps[key];
          if (next !== prev && key !== "value") {
            hostPatchProp(el, key, prev, next, namespace, parentComponent);
          }
        }
        if ("value" in newProps) {
          hostPatchProp(el, "value", oldProps.value, newProps.value, namespace);
        }
      }
    };
    const processFragment = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      const fragmentStartAnchor = n2.el = n1 ? n1.el : hostCreateText("");
      const fragmentEndAnchor = n2.anchor = n1 ? n1.anchor : hostCreateText("");
      let { patchFlag, dynamicChildren, slotScopeIds: fragmentSlotScopeIds } = n2;
      if (fragmentSlotScopeIds) {
        slotScopeIds = slotScopeIds ? slotScopeIds.concat(fragmentSlotScopeIds) : fragmentSlotScopeIds;
      }
      if (n1 == null) {
        hostInsert(fragmentStartAnchor, container, anchor);
        hostInsert(fragmentEndAnchor, container, anchor);
        mountChildren(
          // #10007
          // such fragment like `<></>` will be compiled into
          // a fragment which doesn't have a children.
          // In this case fallback to an empty array
          n2.children || [],
          container,
          fragmentEndAnchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      } else {
        if (patchFlag > 0 && patchFlag & 64 && dynamicChildren && // #2715 the previous fragment could've been a BAILed one as a result
        // of renderSlot() with no valid children
        n1.dynamicChildren) {
          patchBlockChildren(
            n1.dynamicChildren,
            dynamicChildren,
            container,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds
          );
          if (
            // #2080 if the stable fragment has a key, it's a <template v-for> that may
            //  get moved around. Make sure all root level vnodes inherit el.
            // #2134 or if it's a component root, it may also get moved around
            // as the component is being moved.
            n2.key != null || parentComponent && n2 === parentComponent.subTree
          ) {
            traverseStaticChildren(
              n1,
              n2,
              true
              /* shallow */
            );
          }
        } else {
          patchChildren(
            n1,
            n2,
            container,
            fragmentEndAnchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        }
      }
    };
    const processComponent = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      n2.slotScopeIds = slotScopeIds;
      if (n1 == null) {
        if (n2.shapeFlag & 512) {
          parentComponent.ctx.activate(
            n2,
            container,
            anchor,
            namespace,
            optimized
          );
        } else {
          mountComponent(
            n2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            optimized
          );
        }
      } else {
        updateComponent(n1, n2, optimized);
      }
    };
    const mountComponent = (initialVNode, container, anchor, parentComponent, parentSuspense, namespace, optimized) => {
      const instance = initialVNode.component = createComponentInstance(
        initialVNode,
        parentComponent,
        parentSuspense
      );
      if (isKeepAlive(initialVNode)) {
        instance.ctx.renderer = internals;
      }
      {
        setupComponent(instance, false, optimized);
      }
      if (instance.asyncDep) {
        parentSuspense && parentSuspense.registerDep(instance, setupRenderEffect, optimized);
        if (!initialVNode.el) {
          const placeholder = instance.subTree = createVNode(Comment);
          processCommentNode(null, placeholder, container, anchor);
          initialVNode.placeholder = placeholder.el;
        }
      } else {
        setupRenderEffect(
          instance,
          initialVNode,
          container,
          anchor,
          parentSuspense,
          namespace,
          optimized
        );
      }
    };
    const updateComponent = (n1, n2, optimized) => {
      const instance = n2.component = n1.component;
      if (shouldUpdateComponent(n1, n2, optimized)) {
        if (instance.asyncDep && !instance.asyncResolved) {
          updateComponentPreRender(instance, n2, optimized);
          return;
        } else {
          instance.next = n2;
          instance.update();
        }
      } else {
        n2.el = n1.el;
        instance.vnode = n2;
      }
    };
    const setupRenderEffect = (instance, initialVNode, container, anchor, parentSuspense, namespace, optimized) => {
      const componentUpdateFn = () => {
        if (!instance.isMounted) {
          let vnodeHook;
          const { el, props } = initialVNode;
          const { bm, m, parent, root, type } = instance;
          const isAsyncWrapperVNode = isAsyncWrapper(initialVNode);
          toggleRecurse(instance, false);
          if (bm) {
            invokeArrayFns(bm);
          }
          if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeBeforeMount)) {
            invokeVNodeHook(vnodeHook, parent, initialVNode);
          }
          toggleRecurse(instance, true);
          {
            if (root.ce && // @ts-expect-error _def is private
            root.ce._def.shadowRoot !== false) {
              root.ce._injectChildStyle(type);
            }
            const subTree = instance.subTree = renderComponentRoot(instance);
            patch(
              null,
              subTree,
              container,
              anchor,
              instance,
              parentSuspense,
              namespace
            );
            initialVNode.el = subTree.el;
          }
          if (m) {
            queuePostRenderEffect(m, parentSuspense);
          }
          if (!isAsyncWrapperVNode && (vnodeHook = props && props.onVnodeMounted)) {
            const scopedInitialVNode = initialVNode;
            queuePostRenderEffect(
              () => invokeVNodeHook(vnodeHook, parent, scopedInitialVNode),
              parentSuspense
            );
          }
          if (initialVNode.shapeFlag & 256 || parent && isAsyncWrapper(parent.vnode) && parent.vnode.shapeFlag & 256) {
            instance.a && queuePostRenderEffect(instance.a, parentSuspense);
          }
          instance.isMounted = true;
          initialVNode = container = anchor = null;
        } else {
          let { next, bu, u, parent, vnode } = instance;
          {
            const nonHydratedAsyncRoot = locateNonHydratedAsyncRoot(instance);
            if (nonHydratedAsyncRoot) {
              if (next) {
                next.el = vnode.el;
                updateComponentPreRender(instance, next, optimized);
              }
              nonHydratedAsyncRoot.asyncDep.then(() => {
                if (!instance.isUnmounted) {
                  componentUpdateFn();
                }
              });
              return;
            }
          }
          let originNext = next;
          let vnodeHook;
          toggleRecurse(instance, false);
          if (next) {
            next.el = vnode.el;
            updateComponentPreRender(instance, next, optimized);
          } else {
            next = vnode;
          }
          if (bu) {
            invokeArrayFns(bu);
          }
          if (vnodeHook = next.props && next.props.onVnodeBeforeUpdate) {
            invokeVNodeHook(vnodeHook, parent, next, vnode);
          }
          toggleRecurse(instance, true);
          const nextTree = renderComponentRoot(instance);
          const prevTree = instance.subTree;
          instance.subTree = nextTree;
          patch(
            prevTree,
            nextTree,
            // parent may have changed if it's in a teleport
            hostParentNode(prevTree.el),
            // anchor may have changed if it's in a fragment
            getNextHostNode(prevTree),
            instance,
            parentSuspense,
            namespace
          );
          next.el = nextTree.el;
          if (originNext === null) {
            updateHOCHostEl(instance, nextTree.el);
          }
          if (u) {
            queuePostRenderEffect(u, parentSuspense);
          }
          if (vnodeHook = next.props && next.props.onVnodeUpdated) {
            queuePostRenderEffect(
              () => invokeVNodeHook(vnodeHook, parent, next, vnode),
              parentSuspense
            );
          }
        }
      };
      instance.scope.on();
      const effect2 = instance.effect = new ReactiveEffect(componentUpdateFn);
      instance.scope.off();
      const update = instance.update = effect2.run.bind(effect2);
      const job = instance.job = effect2.runIfDirty.bind(effect2);
      job.i = instance;
      job.id = instance.uid;
      effect2.scheduler = () => queueJob(job);
      toggleRecurse(instance, true);
      update();
    };
    const updateComponentPreRender = (instance, nextVNode, optimized) => {
      nextVNode.component = instance;
      const prevProps = instance.vnode.props;
      instance.vnode = nextVNode;
      instance.next = null;
      updateProps(instance, nextVNode.props, prevProps, optimized);
      updateSlots(instance, nextVNode.children, optimized);
      pauseTracking();
      flushPreFlushCbs(instance);
      resetTracking();
    };
    const patchChildren = (n1, n2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized = false) => {
      const c1 = n1 && n1.children;
      const prevShapeFlag = n1 ? n1.shapeFlag : 0;
      const c2 = n2.children;
      const { patchFlag, shapeFlag } = n2;
      if (patchFlag > 0) {
        if (patchFlag & 128) {
          patchKeyedChildren(
            c1,
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          return;
        } else if (patchFlag & 256) {
          patchUnkeyedChildren(
            c1,
            c2,
            container,
            anchor,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
          return;
        }
      }
      if (shapeFlag & 8) {
        if (prevShapeFlag & 16) {
          unmountChildren(c1, parentComponent, parentSuspense);
        }
        if (c2 !== c1) {
          hostSetElementText(container, c2);
        }
      } else {
        if (prevShapeFlag & 16) {
          if (shapeFlag & 16) {
            patchKeyedChildren(
              c1,
              c2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else {
            unmountChildren(c1, parentComponent, parentSuspense, true);
          }
        } else {
          if (prevShapeFlag & 8) {
            hostSetElementText(container, "");
          }
          if (shapeFlag & 16) {
            mountChildren(
              c2,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          }
        }
      }
    };
    const patchUnkeyedChildren = (c1, c2, container, anchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      c1 = c1 || EMPTY_ARR;
      c2 = c2 || EMPTY_ARR;
      const oldLength = c1.length;
      const newLength = c2.length;
      const commonLength = Math.min(oldLength, newLength);
      let i;
      for (i = 0; i < commonLength; i++) {
        const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
        patch(
          c1[i],
          nextChild,
          container,
          null,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized
        );
      }
      if (oldLength > newLength) {
        unmountChildren(
          c1,
          parentComponent,
          parentSuspense,
          true,
          false,
          commonLength
        );
      } else {
        mountChildren(
          c2,
          container,
          anchor,
          parentComponent,
          parentSuspense,
          namespace,
          slotScopeIds,
          optimized,
          commonLength
        );
      }
    };
    const patchKeyedChildren = (c1, c2, container, parentAnchor, parentComponent, parentSuspense, namespace, slotScopeIds, optimized) => {
      let i = 0;
      const l2 = c2.length;
      let e1 = c1.length - 1;
      let e2 = l2 - 1;
      while (i <= e1 && i <= e2) {
        const n1 = c1[i];
        const n2 = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
        if (isSameVNodeType(n1, n2)) {
          patch(
            n1,
            n2,
            container,
            null,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else {
          break;
        }
        i++;
      }
      while (i <= e1 && i <= e2) {
        const n1 = c1[e1];
        const n2 = c2[e2] = optimized ? cloneIfMounted(c2[e2]) : normalizeVNode(c2[e2]);
        if (isSameVNodeType(n1, n2)) {
          patch(
            n1,
            n2,
            container,
            null,
            parentComponent,
            parentSuspense,
            namespace,
            slotScopeIds,
            optimized
          );
        } else {
          break;
        }
        e1--;
        e2--;
      }
      if (i > e1) {
        if (i <= e2) {
          const nextPos = e2 + 1;
          const anchor = nextPos < l2 ? c2[nextPos].el : parentAnchor;
          while (i <= e2) {
            patch(
              null,
              c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]),
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
            i++;
          }
        }
      } else if (i > e2) {
        while (i <= e1) {
          unmount(c1[i], parentComponent, parentSuspense, true);
          i++;
        }
      } else {
        const s1 = i;
        const s2 = i;
        const keyToNewIndexMap = /* @__PURE__ */ new Map();
        for (i = s2; i <= e2; i++) {
          const nextChild = c2[i] = optimized ? cloneIfMounted(c2[i]) : normalizeVNode(c2[i]);
          if (nextChild.key != null) {
            keyToNewIndexMap.set(nextChild.key, i);
          }
        }
        let j;
        let patched = 0;
        const toBePatched = e2 - s2 + 1;
        let moved = false;
        let maxNewIndexSoFar = 0;
        const newIndexToOldIndexMap = new Array(toBePatched);
        for (i = 0; i < toBePatched; i++) newIndexToOldIndexMap[i] = 0;
        for (i = s1; i <= e1; i++) {
          const prevChild = c1[i];
          if (patched >= toBePatched) {
            unmount(prevChild, parentComponent, parentSuspense, true);
            continue;
          }
          let newIndex;
          if (prevChild.key != null) {
            newIndex = keyToNewIndexMap.get(prevChild.key);
          } else {
            for (j = s2; j <= e2; j++) {
              if (newIndexToOldIndexMap[j - s2] === 0 && isSameVNodeType(prevChild, c2[j])) {
                newIndex = j;
                break;
              }
            }
          }
          if (newIndex === void 0) {
            unmount(prevChild, parentComponent, parentSuspense, true);
          } else {
            newIndexToOldIndexMap[newIndex - s2] = i + 1;
            if (newIndex >= maxNewIndexSoFar) {
              maxNewIndexSoFar = newIndex;
            } else {
              moved = true;
            }
            patch(
              prevChild,
              c2[newIndex],
              container,
              null,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
            patched++;
          }
        }
        const increasingNewIndexSequence = moved ? getSequence(newIndexToOldIndexMap) : EMPTY_ARR;
        j = increasingNewIndexSequence.length - 1;
        for (i = toBePatched - 1; i >= 0; i--) {
          const nextIndex = s2 + i;
          const nextChild = c2[nextIndex];
          const anchorVNode = c2[nextIndex + 1];
          const anchor = nextIndex + 1 < l2 ? (
            // #13559, fallback to el placeholder for unresolved async component
            anchorVNode.el || anchorVNode.placeholder
          ) : parentAnchor;
          if (newIndexToOldIndexMap[i] === 0) {
            patch(
              null,
              nextChild,
              container,
              anchor,
              parentComponent,
              parentSuspense,
              namespace,
              slotScopeIds,
              optimized
            );
          } else if (moved) {
            if (j < 0 || i !== increasingNewIndexSequence[j]) {
              move(nextChild, container, anchor, 2);
            } else {
              j--;
            }
          }
        }
      }
    };
    const move = (vnode, container, anchor, moveType, parentSuspense = null) => {
      const { el, type, transition, children, shapeFlag } = vnode;
      if (shapeFlag & 6) {
        move(vnode.component.subTree, container, anchor, moveType);
        return;
      }
      if (shapeFlag & 128) {
        vnode.suspense.move(container, anchor, moveType);
        return;
      }
      if (shapeFlag & 64) {
        type.move(vnode, container, anchor, internals);
        return;
      }
      if (type === Fragment) {
        hostInsert(el, container, anchor);
        for (let i = 0; i < children.length; i++) {
          move(children[i], container, anchor, moveType);
        }
        hostInsert(vnode.anchor, container, anchor);
        return;
      }
      if (type === Static) {
        moveStaticNode(vnode, container, anchor);
        return;
      }
      const needTransition2 = moveType !== 2 && shapeFlag & 1 && transition;
      if (needTransition2) {
        if (moveType === 0) {
          transition.beforeEnter(el);
          hostInsert(el, container, anchor);
          queuePostRenderEffect(() => transition.enter(el), parentSuspense);
        } else {
          const { leave, delayLeave, afterLeave } = transition;
          const remove22 = () => {
            if (vnode.ctx.isUnmounted) {
              hostRemove(el);
            } else {
              hostInsert(el, container, anchor);
            }
          };
          const performLeave = () => {
            leave(el, () => {
              remove22();
              afterLeave && afterLeave();
            });
          };
          if (delayLeave) {
            delayLeave(el, remove22, performLeave);
          } else {
            performLeave();
          }
        }
      } else {
        hostInsert(el, container, anchor);
      }
    };
    const unmount = (vnode, parentComponent, parentSuspense, doRemove = false, optimized = false) => {
      const {
        type,
        props,
        ref: ref3,
        children,
        dynamicChildren,
        shapeFlag,
        patchFlag,
        dirs,
        cacheIndex
      } = vnode;
      if (patchFlag === -2) {
        optimized = false;
      }
      if (ref3 != null) {
        pauseTracking();
        setRef(ref3, null, parentSuspense, vnode, true);
        resetTracking();
      }
      if (cacheIndex != null) {
        parentComponent.renderCache[cacheIndex] = void 0;
      }
      if (shapeFlag & 256) {
        parentComponent.ctx.deactivate(vnode);
        return;
      }
      const shouldInvokeDirs = shapeFlag & 1 && dirs;
      const shouldInvokeVnodeHook = !isAsyncWrapper(vnode);
      let vnodeHook;
      if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeBeforeUnmount)) {
        invokeVNodeHook(vnodeHook, parentComponent, vnode);
      }
      if (shapeFlag & 6) {
        unmountComponent(vnode.component, parentSuspense, doRemove);
      } else {
        if (shapeFlag & 128) {
          vnode.suspense.unmount(parentSuspense, doRemove);
          return;
        }
        if (shouldInvokeDirs) {
          invokeDirectiveHook(vnode, null, parentComponent, "beforeUnmount");
        }
        if (shapeFlag & 64) {
          vnode.type.remove(
            vnode,
            parentComponent,
            parentSuspense,
            internals,
            doRemove
          );
        } else if (dynamicChildren && // #5154
        // when v-once is used inside a block, setBlockTracking(-1) marks the
        // parent block with hasOnce: true
        // so that it doesn't take the fast path during unmount - otherwise
        // components nested in v-once are never unmounted.
        !dynamicChildren.hasOnce && // #1153: fast path should not be taken for non-stable (v-for) fragments
        (type !== Fragment || patchFlag > 0 && patchFlag & 64)) {
          unmountChildren(
            dynamicChildren,
            parentComponent,
            parentSuspense,
            false,
            true
          );
        } else if (type === Fragment && patchFlag & (128 | 256) || !optimized && shapeFlag & 16) {
          unmountChildren(children, parentComponent, parentSuspense);
        }
        if (doRemove) {
          remove2(vnode);
        }
      }
      if (shouldInvokeVnodeHook && (vnodeHook = props && props.onVnodeUnmounted) || shouldInvokeDirs) {
        queuePostRenderEffect(() => {
          vnodeHook && invokeVNodeHook(vnodeHook, parentComponent, vnode);
          shouldInvokeDirs && invokeDirectiveHook(vnode, null, parentComponent, "unmounted");
        }, parentSuspense);
      }
    };
    const remove2 = (vnode) => {
      const { type, el, anchor, transition } = vnode;
      if (type === Fragment) {
        {
          removeFragment(el, anchor);
        }
        return;
      }
      if (type === Static) {
        removeStaticNode(vnode);
        return;
      }
      const performRemove = () => {
        hostRemove(el);
        if (transition && !transition.persisted && transition.afterLeave) {
          transition.afterLeave();
        }
      };
      if (vnode.shapeFlag & 1 && transition && !transition.persisted) {
        const { leave, delayLeave } = transition;
        const performLeave = () => leave(el, performRemove);
        if (delayLeave) {
          delayLeave(vnode.el, performRemove, performLeave);
        } else {
          performLeave();
        }
      } else {
        performRemove();
      }
    };
    const removeFragment = (cur, end) => {
      let next;
      while (cur !== end) {
        next = hostNextSibling(cur);
        hostRemove(cur);
        cur = next;
      }
      hostRemove(end);
    };
    const unmountComponent = (instance, parentSuspense, doRemove) => {
      const {
        bum,
        scope,
        job,
        subTree,
        um,
        m,
        a,
        parent,
        slots: { __: slotCacheKeys }
      } = instance;
      invalidateMount(m);
      invalidateMount(a);
      if (bum) {
        invokeArrayFns(bum);
      }
      if (parent && isArray(slotCacheKeys)) {
        slotCacheKeys.forEach((v) => {
          parent.renderCache[v] = void 0;
        });
      }
      scope.stop();
      if (job) {
        job.flags |= 8;
        unmount(subTree, instance, parentSuspense, doRemove);
      }
      if (um) {
        queuePostRenderEffect(um, parentSuspense);
      }
      queuePostRenderEffect(() => {
        instance.isUnmounted = true;
      }, parentSuspense);
      if (parentSuspense && parentSuspense.pendingBranch && !parentSuspense.isUnmounted && instance.asyncDep && !instance.asyncResolved && instance.suspenseId === parentSuspense.pendingId) {
        parentSuspense.deps--;
        if (parentSuspense.deps === 0) {
          parentSuspense.resolve();
        }
      }
    };
    const unmountChildren = (children, parentComponent, parentSuspense, doRemove = false, optimized = false, start = 0) => {
      for (let i = start; i < children.length; i++) {
        unmount(children[i], parentComponent, parentSuspense, doRemove, optimized);
      }
    };
    const getNextHostNode = (vnode) => {
      if (vnode.shapeFlag & 6) {
        return getNextHostNode(vnode.component.subTree);
      }
      if (vnode.shapeFlag & 128) {
        return vnode.suspense.next();
      }
      const el = hostNextSibling(vnode.anchor || vnode.el);
      const teleportEnd = el && el[TeleportEndKey];
      return teleportEnd ? hostNextSibling(teleportEnd) : el;
    };
    let isFlushing = false;
    const render = (vnode, container, namespace) => {
      if (vnode == null) {
        if (container._vnode) {
          unmount(container._vnode, null, null, true);
        }
      } else {
        patch(
          container._vnode || null,
          vnode,
          container,
          null,
          null,
          null,
          namespace
        );
      }
      container._vnode = vnode;
      if (!isFlushing) {
        isFlushing = true;
        flushPreFlushCbs();
        flushPostFlushCbs();
        isFlushing = false;
      }
    };
    const internals = {
      p: patch,
      um: unmount,
      m: move,
      r: remove2,
      mt: mountComponent,
      mc: mountChildren,
      pc: patchChildren,
      pbc: patchBlockChildren,
      n: getNextHostNode,
      o: options
    };
    let hydrate;
    return {
      render,
      hydrate,
      createApp: createAppAPI(render)
    };
  }
  function resolveChildrenNamespace({ type, props }, currentNamespace) {
    return currentNamespace === "svg" && type === "foreignObject" || currentNamespace === "mathml" && type === "annotation-xml" && props && props.encoding && props.encoding.includes("html") ? void 0 : currentNamespace;
  }
  function toggleRecurse({ effect: effect2, job }, allowed) {
    if (allowed) {
      effect2.flags |= 32;
      job.flags |= 4;
    } else {
      effect2.flags &= -33;
      job.flags &= -5;
    }
  }
  function needTransition(parentSuspense, transition) {
    return (!parentSuspense || parentSuspense && !parentSuspense.pendingBranch) && transition && !transition.persisted;
  }
  function traverseStaticChildren(n1, n2, shallow = false) {
    const ch1 = n1.children;
    const ch2 = n2.children;
    if (isArray(ch1) && isArray(ch2)) {
      for (let i = 0; i < ch1.length; i++) {
        const c1 = ch1[i];
        let c2 = ch2[i];
        if (c2.shapeFlag & 1 && !c2.dynamicChildren) {
          if (c2.patchFlag <= 0 || c2.patchFlag === 32) {
            c2 = ch2[i] = cloneIfMounted(ch2[i]);
            c2.el = c1.el;
          }
          if (!shallow && c2.patchFlag !== -2)
            traverseStaticChildren(c1, c2);
        }
        if (c2.type === Text) {
          c2.el = c1.el;
        }
        if (c2.type === Comment && !c2.el) {
          c2.el = c1.el;
        }
      }
    }
  }
  function getSequence(arr) {
    const p2 = arr.slice();
    const result = [0];
    let i, j, u, v, c;
    const len = arr.length;
    for (i = 0; i < len; i++) {
      const arrI = arr[i];
      if (arrI !== 0) {
        j = result[result.length - 1];
        if (arr[j] < arrI) {
          p2[i] = j;
          result.push(i);
          continue;
        }
        u = 0;
        v = result.length - 1;
        while (u < v) {
          c = u + v >> 1;
          if (arr[result[c]] < arrI) {
            u = c + 1;
          } else {
            v = c;
          }
        }
        if (arrI < arr[result[u]]) {
          if (u > 0) {
            p2[i] = result[u - 1];
          }
          result[u] = i;
        }
      }
    }
    u = result.length;
    v = result[u - 1];
    while (u-- > 0) {
      result[u] = v;
      v = p2[v];
    }
    return result;
  }
  function locateNonHydratedAsyncRoot(instance) {
    const subComponent = instance.subTree.component;
    if (subComponent) {
      if (subComponent.asyncDep && !subComponent.asyncResolved) {
        return subComponent;
      } else {
        return locateNonHydratedAsyncRoot(subComponent);
      }
    }
  }
  function invalidateMount(hooks) {
    if (hooks) {
      for (let i = 0; i < hooks.length; i++)
        hooks[i].flags |= 8;
    }
  }
  const ssrContextKey = Symbol.for("v-scx");
  const useSSRContext = () => {
    {
      const ctx = inject(ssrContextKey);
      return ctx;
    }
  };
  function watchSyncEffect(effect2, options) {
    return doWatch(
      effect2,
      null,
      { flush: "sync" }
    );
  }
  function watch(source, cb, options) {
    return doWatch(source, cb, options);
  }
  function doWatch(source, cb, options = EMPTY_OBJ) {
    const { immediate, deep, flush, once } = options;
    const baseWatchOptions = extend({}, options);
    const runsImmediately = cb && immediate || !cb && flush !== "post";
    let ssrCleanup;
    if (isInSSRComponentSetup) {
      if (flush === "sync") {
        const ctx = useSSRContext();
        ssrCleanup = ctx.__watcherHandles || (ctx.__watcherHandles = []);
      } else if (!runsImmediately) {
        const watchStopHandle = () => {
        };
        watchStopHandle.stop = NOOP;
        watchStopHandle.resume = NOOP;
        watchStopHandle.pause = NOOP;
        return watchStopHandle;
      }
    }
    const instance = currentInstance;
    baseWatchOptions.call = (fn, type, args) => callWithAsyncErrorHandling(fn, instance, type, args);
    let isPre = false;
    if (flush === "post") {
      baseWatchOptions.scheduler = (job) => {
        queuePostRenderEffect(job, instance && instance.suspense);
      };
    } else if (flush !== "sync") {
      isPre = true;
      baseWatchOptions.scheduler = (job, isFirstRun) => {
        if (isFirstRun) {
          job();
        } else {
          queueJob(job);
        }
      };
    }
    baseWatchOptions.augmentJob = (job) => {
      if (cb) {
        job.flags |= 4;
      }
      if (isPre) {
        job.flags |= 2;
        if (instance) {
          job.id = instance.uid;
          job.i = instance;
        }
      }
    };
    const watchHandle = watch$1(source, cb, baseWatchOptions);
    if (isInSSRComponentSetup) {
      if (ssrCleanup) {
        ssrCleanup.push(watchHandle);
      } else if (runsImmediately) {
        watchHandle();
      }
    }
    return watchHandle;
  }
  function instanceWatch(source, value, options) {
    const publicThis = this.proxy;
    const getter = isString(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
    let cb;
    if (isFunction(value)) {
      cb = value;
    } else {
      cb = value.handler;
      options = value;
    }
    const reset = setCurrentInstance(this);
    const res = doWatch(getter, cb.bind(publicThis), options);
    reset();
    return res;
  }
  function createPathGetter(ctx, path) {
    const segments = path.split(".");
    return () => {
      let cur = ctx;
      for (let i = 0; i < segments.length && cur; i++) {
        cur = cur[segments[i]];
      }
      return cur;
    };
  }
  function useModel(props, name, options = EMPTY_OBJ) {
    const i = getCurrentInstance();
    const camelizedName = camelize(name);
    const hyphenatedName = hyphenate(name);
    const modifiers = getModelModifiers(props, camelizedName);
    const res = customRef((track2, trigger2) => {
      let localValue;
      let prevSetValue = EMPTY_OBJ;
      let prevEmittedValue;
      watchSyncEffect(() => {
        const propValue = props[camelizedName];
        if (hasChanged(localValue, propValue)) {
          localValue = propValue;
          trigger2();
        }
      });
      return {
        get() {
          track2();
          return options.get ? options.get(localValue) : localValue;
        },
        set(value) {
          const emittedValue = options.set ? options.set(value) : value;
          if (!hasChanged(emittedValue, localValue) && !(prevSetValue !== EMPTY_OBJ && hasChanged(value, prevSetValue))) {
            return;
          }
          const rawProps = i.vnode.props;
          if (!(rawProps && // check if parent has passed v-model
          (name in rawProps || camelizedName in rawProps || hyphenatedName in rawProps) && (`onUpdate:${name}` in rawProps || `onUpdate:${camelizedName}` in rawProps || `onUpdate:${hyphenatedName}` in rawProps))) {
            localValue = value;
            trigger2();
          }
          i.emit(`update:${name}`, emittedValue);
          if (hasChanged(value, emittedValue) && hasChanged(value, prevSetValue) && !hasChanged(emittedValue, prevEmittedValue)) {
            trigger2();
          }
          prevSetValue = value;
          prevEmittedValue = emittedValue;
        }
      };
    });
    res[Symbol.iterator] = () => {
      let i2 = 0;
      return {
        next() {
          if (i2 < 2) {
            return { value: i2++ ? modifiers || EMPTY_OBJ : res, done: false };
          } else {
            return { done: true };
          }
        }
      };
    };
    return res;
  }
  const getModelModifiers = (props, modelName) => {
    return modelName === "modelValue" || modelName === "model-value" ? props.modelModifiers : props[`${modelName}Modifiers`] || props[`${camelize(modelName)}Modifiers`] || props[`${hyphenate(modelName)}Modifiers`];
  };
  function emit(instance, event, ...rawArgs) {
    if (instance.isUnmounted) return;
    const props = instance.vnode.props || EMPTY_OBJ;
    let args = rawArgs;
    const isModelListener2 = event.startsWith("update:");
    const modifiers = isModelListener2 && getModelModifiers(props, event.slice(7));
    if (modifiers) {
      if (modifiers.trim) {
        args = rawArgs.map((a) => isString(a) ? a.trim() : a);
      }
      if (modifiers.number) {
        args = rawArgs.map(looseToNumber);
      }
    }
    let handlerName;
    let handler = props[handlerName = toHandlerKey(event)] || // also try camelCase event handler (#2249)
    props[handlerName = toHandlerKey(camelize(event))];
    if (!handler && isModelListener2) {
      handler = props[handlerName = toHandlerKey(hyphenate(event))];
    }
    if (handler) {
      callWithAsyncErrorHandling(
        handler,
        instance,
        6,
        args
      );
    }
    const onceHandler = props[handlerName + `Once`];
    if (onceHandler) {
      if (!instance.emitted) {
        instance.emitted = {};
      } else if (instance.emitted[handlerName]) {
        return;
      }
      instance.emitted[handlerName] = true;
      callWithAsyncErrorHandling(
        onceHandler,
        instance,
        6,
        args
      );
    }
  }
  function normalizeEmitsOptions(comp, appContext, asMixin = false) {
    const cache = appContext.emitsCache;
    const cached = cache.get(comp);
    if (cached !== void 0) {
      return cached;
    }
    const raw = comp.emits;
    let normalized = {};
    let hasExtends = false;
    if (!isFunction(comp)) {
      const extendEmits = (raw2) => {
        const normalizedFromExtend = normalizeEmitsOptions(raw2, appContext, true);
        if (normalizedFromExtend) {
          hasExtends = true;
          extend(normalized, normalizedFromExtend);
        }
      };
      if (!asMixin && appContext.mixins.length) {
        appContext.mixins.forEach(extendEmits);
      }
      if (comp.extends) {
        extendEmits(comp.extends);
      }
      if (comp.mixins) {
        comp.mixins.forEach(extendEmits);
      }
    }
    if (!raw && !hasExtends) {
      if (isObject$1(comp)) {
        cache.set(comp, null);
      }
      return null;
    }
    if (isArray(raw)) {
      raw.forEach((key) => normalized[key] = null);
    } else {
      extend(normalized, raw);
    }
    if (isObject$1(comp)) {
      cache.set(comp, normalized);
    }
    return normalized;
  }
  function isEmitListener(options, key) {
    if (!options || !isOn(key)) {
      return false;
    }
    key = key.slice(2).replace(/Once$/, "");
    return hasOwn(options, key[0].toLowerCase() + key.slice(1)) || hasOwn(options, hyphenate(key)) || hasOwn(options, key);
  }
  function markAttrsAccessed() {
  }
  function renderComponentRoot(instance) {
    const {
      type: Component,
      vnode,
      proxy,
      withProxy,
      propsOptions: [propsOptions],
      slots,
      attrs,
      emit: emit2,
      render,
      renderCache,
      props,
      data,
      setupState,
      ctx,
      inheritAttrs
    } = instance;
    const prev = setCurrentRenderingInstance(instance);
    let result;
    let fallthroughAttrs;
    try {
      if (vnode.shapeFlag & 4) {
        const proxyToUse = withProxy || proxy;
        const thisProxy = false ? new Proxy(proxyToUse, {
          get(target, key, receiver) {
            warn$1(
              `Property '${String(
                key
              )}' was accessed via 'this'. Avoid using 'this' in templates.`
            );
            return Reflect.get(target, key, receiver);
          }
        }) : proxyToUse;
        result = normalizeVNode(
          render.call(
            thisProxy,
            proxyToUse,
            renderCache,
            false ? shallowReadonly(props) : props,
            setupState,
            data,
            ctx
          )
        );
        fallthroughAttrs = attrs;
      } else {
        const render2 = Component;
        if (false) ;
        result = normalizeVNode(
          render2.length > 1 ? render2(
            false ? shallowReadonly(props) : props,
            false ? {
              get attrs() {
                markAttrsAccessed();
                return shallowReadonly(attrs);
              },
              slots,
              emit: emit2
            } : { attrs, slots, emit: emit2 }
          ) : render2(
            false ? shallowReadonly(props) : props,
            null
          )
        );
        fallthroughAttrs = Component.props ? attrs : getFunctionalFallthrough(attrs);
      }
    } catch (err) {
      blockStack.length = 0;
      handleError(err, instance, 1);
      result = createVNode(Comment);
    }
    let root = result;
    if (fallthroughAttrs && inheritAttrs !== false) {
      const keys = Object.keys(fallthroughAttrs);
      const { shapeFlag } = root;
      if (keys.length) {
        if (shapeFlag & (1 | 6)) {
          if (propsOptions && keys.some(isModelListener)) {
            fallthroughAttrs = filterModelListeners(
              fallthroughAttrs,
              propsOptions
            );
          }
          root = cloneVNode(root, fallthroughAttrs, false, true);
        }
      }
    }
    if (vnode.dirs) {
      root = cloneVNode(root, null, false, true);
      root.dirs = root.dirs ? root.dirs.concat(vnode.dirs) : vnode.dirs;
    }
    if (vnode.transition) {
      setTransitionHooks(root, vnode.transition);
    }
    {
      result = root;
    }
    setCurrentRenderingInstance(prev);
    return result;
  }
  const getFunctionalFallthrough = (attrs) => {
    let res;
    for (const key in attrs) {
      if (key === "class" || key === "style" || isOn(key)) {
        (res || (res = {}))[key] = attrs[key];
      }
    }
    return res;
  };
  const filterModelListeners = (attrs, props) => {
    const res = {};
    for (const key in attrs) {
      if (!isModelListener(key) || !(key.slice(9) in props)) {
        res[key] = attrs[key];
      }
    }
    return res;
  };
  function shouldUpdateComponent(prevVNode, nextVNode, optimized) {
    const { props: prevProps, children: prevChildren, component } = prevVNode;
    const { props: nextProps, children: nextChildren, patchFlag } = nextVNode;
    const emits = component.emitsOptions;
    if (nextVNode.dirs || nextVNode.transition) {
      return true;
    }
    if (optimized && patchFlag >= 0) {
      if (patchFlag & 1024) {
        return true;
      }
      if (patchFlag & 16) {
        if (!prevProps) {
          return !!nextProps;
        }
        return hasPropsChanged(prevProps, nextProps, emits);
      } else if (patchFlag & 8) {
        const dynamicProps = nextVNode.dynamicProps;
        for (let i = 0; i < dynamicProps.length; i++) {
          const key = dynamicProps[i];
          if (nextProps[key] !== prevProps[key] && !isEmitListener(emits, key)) {
            return true;
          }
        }
      }
    } else {
      if (prevChildren || nextChildren) {
        if (!nextChildren || !nextChildren.$stable) {
          return true;
        }
      }
      if (prevProps === nextProps) {
        return false;
      }
      if (!prevProps) {
        return !!nextProps;
      }
      if (!nextProps) {
        return true;
      }
      return hasPropsChanged(prevProps, nextProps, emits);
    }
    return false;
  }
  function hasPropsChanged(prevProps, nextProps, emitsOptions) {
    const nextKeys = Object.keys(nextProps);
    if (nextKeys.length !== Object.keys(prevProps).length) {
      return true;
    }
    for (let i = 0; i < nextKeys.length; i++) {
      const key = nextKeys[i];
      if (nextProps[key] !== prevProps[key] && !isEmitListener(emitsOptions, key)) {
        return true;
      }
    }
    return false;
  }
  function updateHOCHostEl({ vnode, parent }, el) {
    while (parent) {
      const root = parent.subTree;
      if (root.suspense && root.suspense.activeBranch === vnode) {
        root.el = vnode.el;
      }
      if (root === vnode) {
        (vnode = parent.vnode).el = el;
        parent = parent.parent;
      } else {
        break;
      }
    }
  }
  const isSuspense = (type) => type.__isSuspense;
  function queueEffectWithSuspense(fn, suspense) {
    if (suspense && suspense.pendingBranch) {
      if (isArray(fn)) {
        suspense.effects.push(...fn);
      } else {
        suspense.effects.push(fn);
      }
    } else {
      queuePostFlushCb(fn);
    }
  }
  const Fragment = Symbol.for("v-fgt");
  const Text = Symbol.for("v-txt");
  const Comment = Symbol.for("v-cmt");
  const Static = Symbol.for("v-stc");
  const blockStack = [];
  let currentBlock = null;
  function openBlock(disableTracking = false) {
    blockStack.push(currentBlock = disableTracking ? null : []);
  }
  function closeBlock() {
    blockStack.pop();
    currentBlock = blockStack[blockStack.length - 1] || null;
  }
  let isBlockTreeEnabled = 1;
  function setBlockTracking(value, inVOnce = false) {
    isBlockTreeEnabled += value;
    if (value < 0 && currentBlock && inVOnce) {
      currentBlock.hasOnce = true;
    }
  }
  function setupBlock(vnode) {
    vnode.dynamicChildren = isBlockTreeEnabled > 0 ? currentBlock || EMPTY_ARR : null;
    closeBlock();
    if (isBlockTreeEnabled > 0 && currentBlock) {
      currentBlock.push(vnode);
    }
    return vnode;
  }
  function createElementBlock(type, props, children, patchFlag, dynamicProps, shapeFlag) {
    return setupBlock(
      createBaseVNode(
        type,
        props,
        children,
        patchFlag,
        dynamicProps,
        shapeFlag,
        true
      )
    );
  }
  function createBlock(type, props, children, patchFlag, dynamicProps) {
    return setupBlock(
      createVNode(
        type,
        props,
        children,
        patchFlag,
        dynamicProps,
        true
      )
    );
  }
  function isVNode(value) {
    return value ? value.__v_isVNode === true : false;
  }
  function isSameVNodeType(n1, n2) {
    return n1.type === n2.type && n1.key === n2.key;
  }
  const normalizeKey = ({ key }) => key != null ? key : null;
  const normalizeRef = ({
    ref: ref3,
    ref_key,
    ref_for
  }) => {
    if (typeof ref3 === "number") {
      ref3 = "" + ref3;
    }
    return ref3 != null ? isString(ref3) || isRef(ref3) || isFunction(ref3) ? { i: currentRenderingInstance, r: ref3, k: ref_key, f: !!ref_for } : ref3 : null;
  };
  function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
    const vnode = {
      __v_isVNode: true,
      __v_skip: true,
      type,
      props,
      key: props && normalizeKey(props),
      ref: props && normalizeRef(props),
      scopeId: currentScopeId,
      slotScopeIds: null,
      children,
      component: null,
      suspense: null,
      ssContent: null,
      ssFallback: null,
      dirs: null,
      transition: null,
      el: null,
      anchor: null,
      target: null,
      targetStart: null,
      targetAnchor: null,
      staticCount: 0,
      shapeFlag,
      patchFlag,
      dynamicProps,
      dynamicChildren: null,
      appContext: null,
      ctx: currentRenderingInstance
    };
    if (needFullChildrenNormalization) {
      normalizeChildren(vnode, children);
      if (shapeFlag & 128) {
        type.normalize(vnode);
      }
    } else if (children) {
      vnode.shapeFlag |= isString(children) ? 8 : 16;
    }
    if (isBlockTreeEnabled > 0 && // avoid a block node from tracking itself
    !isBlockNode && // has current parent block
    currentBlock && // presence of a patch flag indicates this node needs patching on updates.
    // component nodes also should always be patched, because even if the
    // component doesn't need to update, it needs to persist the instance on to
    // the next vnode so that it can be properly unmounted later.
    (vnode.patchFlag > 0 || shapeFlag & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
    // vnode should not be considered dynamic due to handler caching.
    vnode.patchFlag !== 32) {
      currentBlock.push(vnode);
    }
    return vnode;
  }
  const createVNode = _createVNode;
  function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
    if (!type || type === NULL_DYNAMIC_COMPONENT) {
      type = Comment;
    }
    if (isVNode(type)) {
      const cloned = cloneVNode(
        type,
        props,
        true
        /* mergeRef: true */
      );
      if (children) {
        normalizeChildren(cloned, children);
      }
      if (isBlockTreeEnabled > 0 && !isBlockNode && currentBlock) {
        if (cloned.shapeFlag & 6) {
          currentBlock[currentBlock.indexOf(type)] = cloned;
        } else {
          currentBlock.push(cloned);
        }
      }
      cloned.patchFlag = -2;
      return cloned;
    }
    if (isClassComponent(type)) {
      type = type.__vccOpts;
    }
    if (props) {
      props = guardReactiveProps(props);
      let { class: klass, style } = props;
      if (klass && !isString(klass)) {
        props.class = normalizeClass(klass);
      }
      if (isObject$1(style)) {
        if (isProxy(style) && !isArray(style)) {
          style = extend({}, style);
        }
        props.style = normalizeStyle(style);
      }
    }
    const shapeFlag = isString(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : isObject$1(type) ? 4 : isFunction(type) ? 2 : 0;
    return createBaseVNode(
      type,
      props,
      children,
      patchFlag,
      dynamicProps,
      shapeFlag,
      isBlockNode,
      true
    );
  }
  function guardReactiveProps(props) {
    if (!props) return null;
    return isProxy(props) || isInternalObject(props) ? extend({}, props) : props;
  }
  function cloneVNode(vnode, extraProps, mergeRef = false, cloneTransition = false) {
    const { props, ref: ref3, patchFlag, children, transition } = vnode;
    const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
    const cloned = {
      __v_isVNode: true,
      __v_skip: true,
      type: vnode.type,
      props: mergedProps,
      key: mergedProps && normalizeKey(mergedProps),
      ref: extraProps && extraProps.ref ? (
        // #2078 in the case of <component :is="vnode" ref="extra"/>
        // if the vnode itself already has a ref, cloneVNode will need to merge
        // the refs so the single vnode can be set on multiple refs
        mergeRef && ref3 ? isArray(ref3) ? ref3.concat(normalizeRef(extraProps)) : [ref3, normalizeRef(extraProps)] : normalizeRef(extraProps)
      ) : ref3,
      scopeId: vnode.scopeId,
      slotScopeIds: vnode.slotScopeIds,
      children,
      target: vnode.target,
      targetStart: vnode.targetStart,
      targetAnchor: vnode.targetAnchor,
      staticCount: vnode.staticCount,
      shapeFlag: vnode.shapeFlag,
      // if the vnode is cloned with extra props, we can no longer assume its
      // existing patch flag to be reliable and need to add the FULL_PROPS flag.
      // note: preserve flag for fragments since they use the flag for children
      // fast paths only.
      patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
      dynamicProps: vnode.dynamicProps,
      dynamicChildren: vnode.dynamicChildren,
      appContext: vnode.appContext,
      dirs: vnode.dirs,
      transition,
      // These should technically only be non-null on mounted VNodes. However,
      // they *should* be copied for kept-alive vnodes. So we just always copy
      // them since them being non-null during a mount doesn't affect the logic as
      // they will simply be overwritten.
      component: vnode.component,
      suspense: vnode.suspense,
      ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
      ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
      placeholder: vnode.placeholder,
      el: vnode.el,
      anchor: vnode.anchor,
      ctx: vnode.ctx,
      ce: vnode.ce
    };
    if (transition && cloneTransition) {
      setTransitionHooks(
        cloned,
        transition.clone(cloned)
      );
    }
    return cloned;
  }
  function createTextVNode(text = " ", flag = 0) {
    return createVNode(Text, null, text, flag);
  }
  function createStaticVNode(content, numberOfNodes) {
    const vnode = createVNode(Static, null, content);
    vnode.staticCount = numberOfNodes;
    return vnode;
  }
  function createCommentVNode(text = "", asBlock = false) {
    return asBlock ? (openBlock(), createBlock(Comment, null, text)) : createVNode(Comment, null, text);
  }
  function normalizeVNode(child) {
    if (child == null || typeof child === "boolean") {
      return createVNode(Comment);
    } else if (isArray(child)) {
      return createVNode(
        Fragment,
        null,
        // #3666, avoid reference pollution when reusing vnode
        child.slice()
      );
    } else if (isVNode(child)) {
      return cloneIfMounted(child);
    } else {
      return createVNode(Text, null, String(child));
    }
  }
  function cloneIfMounted(child) {
    return child.el === null && child.patchFlag !== -1 || child.memo ? child : cloneVNode(child);
  }
  function normalizeChildren(vnode, children) {
    let type = 0;
    const { shapeFlag } = vnode;
    if (children == null) {
      children = null;
    } else if (isArray(children)) {
      type = 16;
    } else if (typeof children === "object") {
      if (shapeFlag & (1 | 64)) {
        const slot = children.default;
        if (slot) {
          slot._c && (slot._d = false);
          normalizeChildren(vnode, slot());
          slot._c && (slot._d = true);
        }
        return;
      } else {
        type = 32;
        const slotFlag = children._;
        if (!slotFlag && !isInternalObject(children)) {
          children._ctx = currentRenderingInstance;
        } else if (slotFlag === 3 && currentRenderingInstance) {
          if (currentRenderingInstance.slots._ === 1) {
            children._ = 1;
          } else {
            children._ = 2;
            vnode.patchFlag |= 1024;
          }
        }
      }
    } else if (isFunction(children)) {
      children = { default: children, _ctx: currentRenderingInstance };
      type = 32;
    } else {
      children = String(children);
      if (shapeFlag & 64) {
        type = 16;
        children = [createTextVNode(children)];
      } else {
        type = 8;
      }
    }
    vnode.children = children;
    vnode.shapeFlag |= type;
  }
  function mergeProps(...args) {
    const ret = {};
    for (let i = 0; i < args.length; i++) {
      const toMerge = args[i];
      for (const key in toMerge) {
        if (key === "class") {
          if (ret.class !== toMerge.class) {
            ret.class = normalizeClass([ret.class, toMerge.class]);
          }
        } else if (key === "style") {
          ret.style = normalizeStyle([ret.style, toMerge.style]);
        } else if (isOn(key)) {
          const existing = ret[key];
          const incoming = toMerge[key];
          if (incoming && existing !== incoming && !(isArray(existing) && existing.includes(incoming))) {
            ret[key] = existing ? [].concat(existing, incoming) : incoming;
          }
        } else if (key !== "") {
          ret[key] = toMerge[key];
        }
      }
    }
    return ret;
  }
  function invokeVNodeHook(hook, instance, vnode, prevVNode = null) {
    callWithAsyncErrorHandling(hook, instance, 7, [
      vnode,
      prevVNode
    ]);
  }
  const emptyAppContext = createAppContext();
  let uid = 0;
  function createComponentInstance(vnode, parent, suspense) {
    const type = vnode.type;
    const appContext = (parent ? parent.appContext : vnode.appContext) || emptyAppContext;
    const instance = {
      uid: uid++,
      vnode,
      type,
      parent,
      appContext,
      root: null,
      // to be immediately set
      next: null,
      subTree: null,
      // will be set synchronously right after creation
      effect: null,
      update: null,
      // will be set synchronously right after creation
      job: null,
      scope: new EffectScope(
        true
        /* detached */
      ),
      render: null,
      proxy: null,
      exposed: null,
      exposeProxy: null,
      withProxy: null,
      provides: parent ? parent.provides : Object.create(appContext.provides),
      ids: parent ? parent.ids : ["", 0, 0],
      accessCache: null,
      renderCache: [],
      // local resolved assets
      components: null,
      directives: null,
      // resolved props and emits options
      propsOptions: normalizePropsOptions(type, appContext),
      emitsOptions: normalizeEmitsOptions(type, appContext),
      // emit
      emit: null,
      // to be set immediately
      emitted: null,
      // props default value
      propsDefaults: EMPTY_OBJ,
      // inheritAttrs
      inheritAttrs: type.inheritAttrs,
      // state
      ctx: EMPTY_OBJ,
      data: EMPTY_OBJ,
      props: EMPTY_OBJ,
      attrs: EMPTY_OBJ,
      slots: EMPTY_OBJ,
      refs: EMPTY_OBJ,
      setupState: EMPTY_OBJ,
      setupContext: null,
      // suspense related
      suspense,
      suspenseId: suspense ? suspense.pendingId : 0,
      asyncDep: null,
      asyncResolved: false,
      // lifecycle hooks
      // not using enums here because it results in computed properties
      isMounted: false,
      isUnmounted: false,
      isDeactivated: false,
      bc: null,
      c: null,
      bm: null,
      m: null,
      bu: null,
      u: null,
      um: null,
      bum: null,
      da: null,
      a: null,
      rtg: null,
      rtc: null,
      ec: null,
      sp: null
    };
    {
      instance.ctx = { _: instance };
    }
    instance.root = parent ? parent.root : instance;
    instance.emit = emit.bind(null, instance);
    if (vnode.ce) {
      vnode.ce(instance);
    }
    return instance;
  }
  let currentInstance = null;
  const getCurrentInstance = () => currentInstance || currentRenderingInstance;
  let internalSetCurrentInstance;
  let setInSSRSetupState;
  {
    const g2 = getGlobalThis();
    const registerGlobalSetter = (key, setter) => {
      let setters;
      if (!(setters = g2[key])) setters = g2[key] = [];
      setters.push(setter);
      return (v) => {
        if (setters.length > 1) setters.forEach((set) => set(v));
        else setters[0](v);
      };
    };
    internalSetCurrentInstance = registerGlobalSetter(
      `__VUE_INSTANCE_SETTERS__`,
      (v) => currentInstance = v
    );
    setInSSRSetupState = registerGlobalSetter(
      `__VUE_SSR_SETTERS__`,
      (v) => isInSSRComponentSetup = v
    );
  }
  const setCurrentInstance = (instance) => {
    const prev = currentInstance;
    internalSetCurrentInstance(instance);
    instance.scope.on();
    return () => {
      instance.scope.off();
      internalSetCurrentInstance(prev);
    };
  };
  const unsetCurrentInstance = () => {
    currentInstance && currentInstance.scope.off();
    internalSetCurrentInstance(null);
  };
  function isStatefulComponent(instance) {
    return instance.vnode.shapeFlag & 4;
  }
  let isInSSRComponentSetup = false;
  function setupComponent(instance, isSSR = false, optimized = false) {
    isSSR && setInSSRSetupState(isSSR);
    const { props, children } = instance.vnode;
    const isStateful = isStatefulComponent(instance);
    initProps(instance, props, isStateful, isSSR);
    initSlots(instance, children, optimized || isSSR);
    const setupResult = isStateful ? setupStatefulComponent(instance, isSSR) : void 0;
    isSSR && setInSSRSetupState(false);
    return setupResult;
  }
  function setupStatefulComponent(instance, isSSR) {
    const Component = instance.type;
    instance.accessCache = /* @__PURE__ */ Object.create(null);
    instance.proxy = new Proxy(instance.ctx, PublicInstanceProxyHandlers);
    const { setup } = Component;
    if (setup) {
      pauseTracking();
      const setupContext = instance.setupContext = setup.length > 1 ? createSetupContext(instance) : null;
      const reset = setCurrentInstance(instance);
      const setupResult = callWithErrorHandling(
        setup,
        instance,
        0,
        [
          instance.props,
          setupContext
        ]
      );
      const isAsyncSetup = isPromise$1(setupResult);
      resetTracking();
      reset();
      if ((isAsyncSetup || instance.sp) && !isAsyncWrapper(instance)) {
        markAsyncBoundary(instance);
      }
      if (isAsyncSetup) {
        setupResult.then(unsetCurrentInstance, unsetCurrentInstance);
        if (isSSR) {
          return setupResult.then((resolvedResult) => {
            handleSetupResult(instance, resolvedResult);
          }).catch((e) => {
            handleError(e, instance, 0);
          });
        } else {
          instance.asyncDep = setupResult;
        }
      } else {
        handleSetupResult(instance, setupResult);
      }
    } else {
      finishComponentSetup(instance);
    }
  }
  function handleSetupResult(instance, setupResult, isSSR) {
    if (isFunction(setupResult)) {
      if (instance.type.__ssrInlineRender) {
        instance.ssrRender = setupResult;
      } else {
        instance.render = setupResult;
      }
    } else if (isObject$1(setupResult)) {
      instance.setupState = proxyRefs(setupResult);
    } else ;
    finishComponentSetup(instance);
  }
  function finishComponentSetup(instance, isSSR, skipOptions) {
    const Component = instance.type;
    if (!instance.render) {
      instance.render = Component.render || NOOP;
    }
    {
      const reset = setCurrentInstance(instance);
      pauseTracking();
      try {
        applyOptions(instance);
      } finally {
        resetTracking();
        reset();
      }
    }
  }
  const attrsProxyHandlers = {
    get(target, key) {
      track(target, "get", "");
      return target[key];
    }
  };
  function createSetupContext(instance) {
    const expose = (exposed) => {
      instance.exposed = exposed || {};
    };
    {
      return {
        attrs: new Proxy(instance.attrs, attrsProxyHandlers),
        slots: instance.slots,
        emit: instance.emit,
        expose
      };
    }
  }
  function getComponentPublicInstance(instance) {
    if (instance.exposed) {
      return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
        get(target, key) {
          if (key in target) {
            return target[key];
          } else if (key in publicPropertiesMap) {
            return publicPropertiesMap[key](instance);
          }
        },
        has(target, key) {
          return key in target || key in publicPropertiesMap;
        }
      }));
    } else {
      return instance.proxy;
    }
  }
  const classifyRE = /(?:^|[-_])(\w)/g;
  const classify = (str) => str.replace(classifyRE, (c) => c.toUpperCase()).replace(/[-_]/g, "");
  function getComponentName(Component, includeInferred = true) {
    return isFunction(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
  }
  function formatComponentName(instance, Component, isRoot = false) {
    let name = getComponentName(Component);
    if (!name && Component.__file) {
      const match = Component.__file.match(/([^/\\]+)\.\w+$/);
      if (match) {
        name = match[1];
      }
    }
    if (!name && instance && instance.parent) {
      const inferFromRegistry = (registry) => {
        for (const key in registry) {
          if (registry[key] === Component) {
            return key;
          }
        }
      };
      name = inferFromRegistry(
        instance.components || instance.parent.type.components
      ) || inferFromRegistry(instance.appContext.components);
    }
    return name ? classify(name) : isRoot ? `App` : `Anonymous`;
  }
  function isClassComponent(value) {
    return isFunction(value) && "__vccOpts" in value;
  }
  const computed = (getterOrOptions, debugOptions) => {
    const c = computed$1(getterOrOptions, debugOptions, isInSSRComponentSetup);
    return c;
  };
  function h(type, propsOrChildren, children) {
    const l = arguments.length;
    if (l === 2) {
      if (isObject$1(propsOrChildren) && !isArray(propsOrChildren)) {
        if (isVNode(propsOrChildren)) {
          return createVNode(type, null, [propsOrChildren]);
        }
        return createVNode(type, propsOrChildren);
      } else {
        return createVNode(type, null, propsOrChildren);
      }
    } else {
      if (l > 3) {
        children = Array.prototype.slice.call(arguments, 2);
      } else if (l === 3 && isVNode(children)) {
        children = [children];
      }
      return createVNode(type, propsOrChildren, children);
    }
  }
  const version = "3.5.18";
  /**
  * @vue/runtime-dom v3.5.18
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  let policy = void 0;
  const tt$1 = typeof window !== "undefined" && window.trustedTypes;
  if (tt$1) {
    try {
      policy = /* @__PURE__ */ tt$1.createPolicy("vue", {
        createHTML: (val) => val
      });
    } catch (e) {
    }
  }
  const unsafeToTrustedHTML = policy ? (val) => policy.createHTML(val) : (val) => val;
  const svgNS = "http://www.w3.org/2000/svg";
  const mathmlNS = "http://www.w3.org/1998/Math/MathML";
  const doc = typeof document !== "undefined" ? document : null;
  const templateContainer = doc && /* @__PURE__ */ doc.createElement("template");
  const nodeOps = {
    insert: (child, parent, anchor) => {
      parent.insertBefore(child, anchor || null);
    },
    remove: (child) => {
      const parent = child.parentNode;
      if (parent) {
        parent.removeChild(child);
      }
    },
    createElement: (tag, namespace, is, props) => {
      const el = namespace === "svg" ? doc.createElementNS(svgNS, tag) : namespace === "mathml" ? doc.createElementNS(mathmlNS, tag) : is ? doc.createElement(tag, { is }) : doc.createElement(tag);
      if (tag === "select" && props && props.multiple != null) {
        el.setAttribute("multiple", props.multiple);
      }
      return el;
    },
    createText: (text) => doc.createTextNode(text),
    createComment: (text) => doc.createComment(text),
    setText: (node, text) => {
      node.nodeValue = text;
    },
    setElementText: (el, text) => {
      el.textContent = text;
    },
    parentNode: (node) => node.parentNode,
    nextSibling: (node) => node.nextSibling,
    querySelector: (selector) => doc.querySelector(selector),
    setScopeId(el, id) {
      el.setAttribute(id, "");
    },
    // __UNSAFE__
    // Reason: innerHTML.
    // Static content here can only come from compiled templates.
    // As long as the user only uses trusted templates, this is safe.
    insertStaticContent(content, parent, anchor, namespace, start, end) {
      const before = anchor ? anchor.previousSibling : parent.lastChild;
      if (start && (start === end || start.nextSibling)) {
        while (true) {
          parent.insertBefore(start.cloneNode(true), anchor);
          if (start === end || !(start = start.nextSibling)) break;
        }
      } else {
        templateContainer.innerHTML = unsafeToTrustedHTML(
          namespace === "svg" ? `<svg>${content}</svg>` : namespace === "mathml" ? `<math>${content}</math>` : content
        );
        const template = templateContainer.content;
        if (namespace === "svg" || namespace === "mathml") {
          const wrapper = template.firstChild;
          while (wrapper.firstChild) {
            template.appendChild(wrapper.firstChild);
          }
          template.removeChild(wrapper);
        }
        parent.insertBefore(template, anchor);
      }
      return [
        // first
        before ? before.nextSibling : parent.firstChild,
        // last
        anchor ? anchor.previousSibling : parent.lastChild
      ];
    }
  };
  const TRANSITION = "transition";
  const ANIMATION = "animation";
  const vtcKey = Symbol("_vtc");
  const DOMTransitionPropsValidators = {
    name: String,
    type: String,
    css: {
      type: Boolean,
      default: true
    },
    duration: [String, Number, Object],
    enterFromClass: String,
    enterActiveClass: String,
    enterToClass: String,
    appearFromClass: String,
    appearActiveClass: String,
    appearToClass: String,
    leaveFromClass: String,
    leaveActiveClass: String,
    leaveToClass: String
  };
  const TransitionPropsValidators = /* @__PURE__ */ extend(
    {},
    BaseTransitionPropsValidators,
    DOMTransitionPropsValidators
  );
  const decorate$1 = (t) => {
    t.displayName = "Transition";
    t.props = TransitionPropsValidators;
    return t;
  };
  const Transition = /* @__PURE__ */ decorate$1(
    (props, { slots }) => h(BaseTransition, resolveTransitionProps(props), slots)
  );
  const callHook = (hook, args = []) => {
    if (isArray(hook)) {
      hook.forEach((h2) => h2(...args));
    } else if (hook) {
      hook(...args);
    }
  };
  const hasExplicitCallback = (hook) => {
    return hook ? isArray(hook) ? hook.some((h2) => h2.length > 1) : hook.length > 1 : false;
  };
  function resolveTransitionProps(rawProps) {
    const baseProps = {};
    for (const key in rawProps) {
      if (!(key in DOMTransitionPropsValidators)) {
        baseProps[key] = rawProps[key];
      }
    }
    if (rawProps.css === false) {
      return baseProps;
    }
    const {
      name = "v",
      type,
      duration,
      enterFromClass = `${name}-enter-from`,
      enterActiveClass = `${name}-enter-active`,
      enterToClass = `${name}-enter-to`,
      appearFromClass = enterFromClass,
      appearActiveClass = enterActiveClass,
      appearToClass = enterToClass,
      leaveFromClass = `${name}-leave-from`,
      leaveActiveClass = `${name}-leave-active`,
      leaveToClass = `${name}-leave-to`
    } = rawProps;
    const durations = normalizeDuration(duration);
    const enterDuration = durations && durations[0];
    const leaveDuration = durations && durations[1];
    const {
      onBeforeEnter,
      onEnter,
      onEnterCancelled,
      onLeave,
      onLeaveCancelled,
      onBeforeAppear = onBeforeEnter,
      onAppear = onEnter,
      onAppearCancelled = onEnterCancelled
    } = baseProps;
    const finishEnter = (el, isAppear, done, isCancelled) => {
      el._enterCancelled = isCancelled;
      removeTransitionClass(el, isAppear ? appearToClass : enterToClass);
      removeTransitionClass(el, isAppear ? appearActiveClass : enterActiveClass);
      done && done();
    };
    const finishLeave = (el, done) => {
      el._isLeaving = false;
      removeTransitionClass(el, leaveFromClass);
      removeTransitionClass(el, leaveToClass);
      removeTransitionClass(el, leaveActiveClass);
      done && done();
    };
    const makeEnterHook = (isAppear) => {
      return (el, done) => {
        const hook = isAppear ? onAppear : onEnter;
        const resolve2 = () => finishEnter(el, isAppear, done);
        callHook(hook, [el, resolve2]);
        nextFrame(() => {
          removeTransitionClass(el, isAppear ? appearFromClass : enterFromClass);
          addTransitionClass(el, isAppear ? appearToClass : enterToClass);
          if (!hasExplicitCallback(hook)) {
            whenTransitionEnds(el, type, enterDuration, resolve2);
          }
        });
      };
    };
    return extend(baseProps, {
      onBeforeEnter(el) {
        callHook(onBeforeEnter, [el]);
        addTransitionClass(el, enterFromClass);
        addTransitionClass(el, enterActiveClass);
      },
      onBeforeAppear(el) {
        callHook(onBeforeAppear, [el]);
        addTransitionClass(el, appearFromClass);
        addTransitionClass(el, appearActiveClass);
      },
      onEnter: makeEnterHook(false),
      onAppear: makeEnterHook(true),
      onLeave(el, done) {
        el._isLeaving = true;
        const resolve2 = () => finishLeave(el, done);
        addTransitionClass(el, leaveFromClass);
        if (!el._enterCancelled) {
          forceReflow();
          addTransitionClass(el, leaveActiveClass);
        } else {
          addTransitionClass(el, leaveActiveClass);
          forceReflow();
        }
        nextFrame(() => {
          if (!el._isLeaving) {
            return;
          }
          removeTransitionClass(el, leaveFromClass);
          addTransitionClass(el, leaveToClass);
          if (!hasExplicitCallback(onLeave)) {
            whenTransitionEnds(el, type, leaveDuration, resolve2);
          }
        });
        callHook(onLeave, [el, resolve2]);
      },
      onEnterCancelled(el) {
        finishEnter(el, false, void 0, true);
        callHook(onEnterCancelled, [el]);
      },
      onAppearCancelled(el) {
        finishEnter(el, true, void 0, true);
        callHook(onAppearCancelled, [el]);
      },
      onLeaveCancelled(el) {
        finishLeave(el);
        callHook(onLeaveCancelled, [el]);
      }
    });
  }
  function normalizeDuration(duration) {
    if (duration == null) {
      return null;
    } else if (isObject$1(duration)) {
      return [NumberOf(duration.enter), NumberOf(duration.leave)];
    } else {
      const n = NumberOf(duration);
      return [n, n];
    }
  }
  function NumberOf(val) {
    const res = toNumber(val);
    return res;
  }
  function addTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c) => c && el.classList.add(c));
    (el[vtcKey] || (el[vtcKey] = /* @__PURE__ */ new Set())).add(cls);
  }
  function removeTransitionClass(el, cls) {
    cls.split(/\s+/).forEach((c) => c && el.classList.remove(c));
    const _vtc = el[vtcKey];
    if (_vtc) {
      _vtc.delete(cls);
      if (!_vtc.size) {
        el[vtcKey] = void 0;
      }
    }
  }
  function nextFrame(cb) {
    requestAnimationFrame(() => {
      requestAnimationFrame(cb);
    });
  }
  let endId = 0;
  function whenTransitionEnds(el, expectedType, explicitTimeout, resolve2) {
    const id = el._endId = ++endId;
    const resolveIfNotStale = () => {
      if (id === el._endId) {
        resolve2();
      }
    };
    if (explicitTimeout != null) {
      return setTimeout(resolveIfNotStale, explicitTimeout);
    }
    const { type, timeout, propCount } = getTransitionInfo(el, expectedType);
    if (!type) {
      return resolve2();
    }
    const endEvent = type + "end";
    let ended = 0;
    const end = () => {
      el.removeEventListener(endEvent, onEnd);
      resolveIfNotStale();
    };
    const onEnd = (e) => {
      if (e.target === el && ++ended >= propCount) {
        end();
      }
    };
    setTimeout(() => {
      if (ended < propCount) {
        end();
      }
    }, timeout + 1);
    el.addEventListener(endEvent, onEnd);
  }
  function getTransitionInfo(el, expectedType) {
    const styles = window.getComputedStyle(el);
    const getStyleProperties = (key) => (styles[key] || "").split(", ");
    const transitionDelays = getStyleProperties(`${TRANSITION}Delay`);
    const transitionDurations = getStyleProperties(`${TRANSITION}Duration`);
    const transitionTimeout = getTimeout(transitionDelays, transitionDurations);
    const animationDelays = getStyleProperties(`${ANIMATION}Delay`);
    const animationDurations = getStyleProperties(`${ANIMATION}Duration`);
    const animationTimeout = getTimeout(animationDelays, animationDurations);
    let type = null;
    let timeout = 0;
    let propCount = 0;
    if (expectedType === TRANSITION) {
      if (transitionTimeout > 0) {
        type = TRANSITION;
        timeout = transitionTimeout;
        propCount = transitionDurations.length;
      }
    } else if (expectedType === ANIMATION) {
      if (animationTimeout > 0) {
        type = ANIMATION;
        timeout = animationTimeout;
        propCount = animationDurations.length;
      }
    } else {
      timeout = Math.max(transitionTimeout, animationTimeout);
      type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
      propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
    }
    const hasTransform = type === TRANSITION && /\b(transform|all)(,|$)/.test(
      getStyleProperties(`${TRANSITION}Property`).toString()
    );
    return {
      type,
      timeout,
      propCount,
      hasTransform
    };
  }
  function getTimeout(delays, durations) {
    while (delays.length < durations.length) {
      delays = delays.concat(delays);
    }
    return Math.max(...durations.map((d, i) => toMs(d) + toMs(delays[i])));
  }
  function toMs(s) {
    if (s === "auto") return 0;
    return Number(s.slice(0, -1).replace(",", ".")) * 1e3;
  }
  function forceReflow() {
    return document.body.offsetHeight;
  }
  function patchClass(el, value, isSVG) {
    const transitionClasses = el[vtcKey];
    if (transitionClasses) {
      value = (value ? [value, ...transitionClasses] : [...transitionClasses]).join(" ");
    }
    if (value == null) {
      el.removeAttribute("class");
    } else if (isSVG) {
      el.setAttribute("class", value);
    } else {
      el.className = value;
    }
  }
  const vShowOriginalDisplay = Symbol("_vod");
  const vShowHidden = Symbol("_vsh");
  const vShow = {
    beforeMount(el, { value }, { transition }) {
      el[vShowOriginalDisplay] = el.style.display === "none" ? "" : el.style.display;
      if (transition && value) {
        transition.beforeEnter(el);
      } else {
        setDisplay(el, value);
      }
    },
    mounted(el, { value }, { transition }) {
      if (transition && value) {
        transition.enter(el);
      }
    },
    updated(el, { value, oldValue }, { transition }) {
      if (!value === !oldValue) return;
      if (transition) {
        if (value) {
          transition.beforeEnter(el);
          setDisplay(el, true);
          transition.enter(el);
        } else {
          transition.leave(el, () => {
            setDisplay(el, false);
          });
        }
      } else {
        setDisplay(el, value);
      }
    },
    beforeUnmount(el, { value }) {
      setDisplay(el, value);
    }
  };
  function setDisplay(el, value) {
    el.style.display = value ? el[vShowOriginalDisplay] : "none";
    el[vShowHidden] = !value;
  }
  const CSS_VAR_TEXT = Symbol("");
  function useCssVars(getter) {
    const instance = getCurrentInstance();
    if (!instance) {
      return;
    }
    const updateTeleports = instance.ut = (vars = getter(instance.proxy)) => {
      Array.from(
        document.querySelectorAll(`[data-v-owner="${instance.uid}"]`)
      ).forEach((node) => setVarsOnNode(node, vars));
    };
    const setVars = () => {
      const vars = getter(instance.proxy);
      if (instance.ce) {
        setVarsOnNode(instance.ce, vars);
      } else {
        setVarsOnVNode(instance.subTree, vars);
      }
      updateTeleports(vars);
    };
    onBeforeUpdate(() => {
      queuePostFlushCb(setVars);
    });
    onMounted(() => {
      watch(setVars, NOOP, { flush: "post" });
      const ob = new MutationObserver(setVars);
      ob.observe(instance.subTree.el.parentNode, { childList: true });
      onUnmounted(() => ob.disconnect());
    });
  }
  function setVarsOnVNode(vnode, vars) {
    if (vnode.shapeFlag & 128) {
      const suspense = vnode.suspense;
      vnode = suspense.activeBranch;
      if (suspense.pendingBranch && !suspense.isHydrating) {
        suspense.effects.push(() => {
          setVarsOnVNode(suspense.activeBranch, vars);
        });
      }
    }
    while (vnode.component) {
      vnode = vnode.component.subTree;
    }
    if (vnode.shapeFlag & 1 && vnode.el) {
      setVarsOnNode(vnode.el, vars);
    } else if (vnode.type === Fragment) {
      vnode.children.forEach((c) => setVarsOnVNode(c, vars));
    } else if (vnode.type === Static) {
      let { el, anchor } = vnode;
      while (el) {
        setVarsOnNode(el, vars);
        if (el === anchor) break;
        el = el.nextSibling;
      }
    }
  }
  function setVarsOnNode(el, vars) {
    if (el.nodeType === 1) {
      const style = el.style;
      let cssText = "";
      for (const key in vars) {
        const value = normalizeCssVarValue(vars[key]);
        style.setProperty(`--${key}`, value);
        cssText += `--${key}: ${value};`;
      }
      style[CSS_VAR_TEXT] = cssText;
    }
  }
  const displayRE = /(^|;)\s*display\s*:/;
  function patchStyle(el, prev, next) {
    const style = el.style;
    const isCssString = isString(next);
    let hasControlledDisplay = false;
    if (next && !isCssString) {
      if (prev) {
        if (!isString(prev)) {
          for (const key in prev) {
            if (next[key] == null) {
              setStyle(style, key, "");
            }
          }
        } else {
          for (const prevStyle of prev.split(";")) {
            const key = prevStyle.slice(0, prevStyle.indexOf(":")).trim();
            if (next[key] == null) {
              setStyle(style, key, "");
            }
          }
        }
      }
      for (const key in next) {
        if (key === "display") {
          hasControlledDisplay = true;
        }
        setStyle(style, key, next[key]);
      }
    } else {
      if (isCssString) {
        if (prev !== next) {
          const cssVarText = style[CSS_VAR_TEXT];
          if (cssVarText) {
            next += ";" + cssVarText;
          }
          style.cssText = next;
          hasControlledDisplay = displayRE.test(next);
        }
      } else if (prev) {
        el.removeAttribute("style");
      }
    }
    if (vShowOriginalDisplay in el) {
      el[vShowOriginalDisplay] = hasControlledDisplay ? style.display : "";
      if (el[vShowHidden]) {
        style.display = "none";
      }
    }
  }
  const importantRE = /\s*!important$/;
  function setStyle(style, name, val) {
    if (isArray(val)) {
      val.forEach((v) => setStyle(style, name, v));
    } else {
      if (val == null) val = "";
      if (name.startsWith("--")) {
        style.setProperty(name, val);
      } else {
        const prefixed = autoPrefix(style, name);
        if (importantRE.test(val)) {
          style.setProperty(
            hyphenate(prefixed),
            val.replace(importantRE, ""),
            "important"
          );
        } else {
          style[prefixed] = val;
        }
      }
    }
  }
  const prefixes = ["Webkit", "Moz", "ms"];
  const prefixCache = {};
  function autoPrefix(style, rawName) {
    const cached = prefixCache[rawName];
    if (cached) {
      return cached;
    }
    let name = camelize(rawName);
    if (name !== "filter" && name in style) {
      return prefixCache[rawName] = name;
    }
    name = capitalize(name);
    for (let i = 0; i < prefixes.length; i++) {
      const prefixed = prefixes[i] + name;
      if (prefixed in style) {
        return prefixCache[rawName] = prefixed;
      }
    }
    return rawName;
  }
  const xlinkNS = "http://www.w3.org/1999/xlink";
  function patchAttr(el, key, value, isSVG, instance, isBoolean = isSpecialBooleanAttr(key)) {
    if (isSVG && key.startsWith("xlink:")) {
      if (value == null) {
        el.removeAttributeNS(xlinkNS, key.slice(6, key.length));
      } else {
        el.setAttributeNS(xlinkNS, key, value);
      }
    } else {
      if (value == null || isBoolean && !includeBooleanAttr(value)) {
        el.removeAttribute(key);
      } else {
        el.setAttribute(
          key,
          isBoolean ? "" : isSymbol(value) ? String(value) : value
        );
      }
    }
  }
  function patchDOMProp(el, key, value, parentComponent, attrName) {
    if (key === "innerHTML" || key === "textContent") {
      if (value != null) {
        el[key] = key === "innerHTML" ? unsafeToTrustedHTML(value) : value;
      }
      return;
    }
    const tag = el.tagName;
    if (key === "value" && tag !== "PROGRESS" && // custom elements may use _value internally
    !tag.includes("-")) {
      const oldValue = tag === "OPTION" ? el.getAttribute("value") || "" : el.value;
      const newValue = value == null ? (
        // #11647: value should be set as empty string for null and undefined,
        // but <input type="checkbox"> should be set as 'on'.
        el.type === "checkbox" ? "on" : ""
      ) : String(value);
      if (oldValue !== newValue || !("_value" in el)) {
        el.value = newValue;
      }
      if (value == null) {
        el.removeAttribute(key);
      }
      el._value = value;
      return;
    }
    let needRemove = false;
    if (value === "" || value == null) {
      const type = typeof el[key];
      if (type === "boolean") {
        value = includeBooleanAttr(value);
      } else if (value == null && type === "string") {
        value = "";
        needRemove = true;
      } else if (type === "number") {
        value = 0;
        needRemove = true;
      }
    }
    try {
      el[key] = value;
    } catch (e) {
    }
    needRemove && el.removeAttribute(attrName || key);
  }
  function addEventListener(el, event, handler, options) {
    el.addEventListener(event, handler, options);
  }
  function removeEventListener(el, event, handler, options) {
    el.removeEventListener(event, handler, options);
  }
  const veiKey = Symbol("_vei");
  function patchEvent(el, rawName, prevValue, nextValue, instance = null) {
    const invokers = el[veiKey] || (el[veiKey] = {});
    const existingInvoker = invokers[rawName];
    if (nextValue && existingInvoker) {
      existingInvoker.value = nextValue;
    } else {
      const [name, options] = parseName(rawName);
      if (nextValue) {
        const invoker = invokers[rawName] = createInvoker(
          nextValue,
          instance
        );
        addEventListener(el, name, invoker, options);
      } else if (existingInvoker) {
        removeEventListener(el, name, existingInvoker, options);
        invokers[rawName] = void 0;
      }
    }
  }
  const optionsModifierRE = /(?:Once|Passive|Capture)$/;
  function parseName(name) {
    let options;
    if (optionsModifierRE.test(name)) {
      options = {};
      let m;
      while (m = name.match(optionsModifierRE)) {
        name = name.slice(0, name.length - m[0].length);
        options[m[0].toLowerCase()] = true;
      }
    }
    const event = name[2] === ":" ? name.slice(3) : hyphenate(name.slice(2));
    return [event, options];
  }
  let cachedNow = 0;
  const p = /* @__PURE__ */ Promise.resolve();
  const getNow = () => cachedNow || (p.then(() => cachedNow = 0), cachedNow = Date.now());
  function createInvoker(initialValue, instance) {
    const invoker = (e) => {
      if (!e._vts) {
        e._vts = Date.now();
      } else if (e._vts <= invoker.attached) {
        return;
      }
      callWithAsyncErrorHandling(
        patchStopImmediatePropagation(e, invoker.value),
        instance,
        5,
        [e]
      );
    };
    invoker.value = initialValue;
    invoker.attached = getNow();
    return invoker;
  }
  function patchStopImmediatePropagation(e, value) {
    if (isArray(value)) {
      const originalStop = e.stopImmediatePropagation;
      e.stopImmediatePropagation = () => {
        originalStop.call(e);
        e._stopped = true;
      };
      return value.map(
        (fn) => (e2) => !e2._stopped && fn && fn(e2)
      );
    } else {
      return value;
    }
  }
  const isNativeOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // lowercase letter
  key.charCodeAt(2) > 96 && key.charCodeAt(2) < 123;
  const patchProp = (el, key, prevValue, nextValue, namespace, parentComponent) => {
    const isSVG = namespace === "svg";
    if (key === "class") {
      patchClass(el, nextValue, isSVG);
    } else if (key === "style") {
      patchStyle(el, prevValue, nextValue);
    } else if (isOn(key)) {
      if (!isModelListener(key)) {
        patchEvent(el, key, prevValue, nextValue, parentComponent);
      }
    } else if (key[0] === "." ? (key = key.slice(1), true) : key[0] === "^" ? (key = key.slice(1), false) : shouldSetAsProp(el, key, nextValue, isSVG)) {
      patchDOMProp(el, key, nextValue);
      if (!el.tagName.includes("-") && (key === "value" || key === "checked" || key === "selected")) {
        patchAttr(el, key, nextValue, isSVG, parentComponent, key !== "value");
      }
    } else if (
      // #11081 force set props for possible async custom element
      el._isVueCE && (/[A-Z]/.test(key) || !isString(nextValue))
    ) {
      patchDOMProp(el, camelize(key), nextValue, parentComponent, key);
    } else {
      if (key === "true-value") {
        el._trueValue = nextValue;
      } else if (key === "false-value") {
        el._falseValue = nextValue;
      }
      patchAttr(el, key, nextValue, isSVG);
    }
  };
  function shouldSetAsProp(el, key, value, isSVG) {
    if (isSVG) {
      if (key === "innerHTML" || key === "textContent") {
        return true;
      }
      if (key in el && isNativeOn(key) && isFunction(value)) {
        return true;
      }
      return false;
    }
    if (key === "spellcheck" || key === "draggable" || key === "translate" || key === "autocorrect") {
      return false;
    }
    if (key === "form") {
      return false;
    }
    if (key === "list" && el.tagName === "INPUT") {
      return false;
    }
    if (key === "type" && el.tagName === "TEXTAREA") {
      return false;
    }
    if (key === "width" || key === "height") {
      const tag = el.tagName;
      if (tag === "IMG" || tag === "VIDEO" || tag === "CANVAS" || tag === "SOURCE") {
        return false;
      }
    }
    if (isNativeOn(key) && isString(value)) {
      return false;
    }
    return key in el;
  }
  const positionMap = /* @__PURE__ */ new WeakMap();
  const newPositionMap = /* @__PURE__ */ new WeakMap();
  const moveCbKey = Symbol("_moveCb");
  const enterCbKey = Symbol("_enterCb");
  const decorate = (t) => {
    delete t.props.mode;
    return t;
  };
  const TransitionGroupImpl = /* @__PURE__ */ decorate({
    name: "TransitionGroup",
    props: /* @__PURE__ */ extend({}, TransitionPropsValidators, {
      tag: String,
      moveClass: String
    }),
    setup(props, { slots }) {
      const instance = getCurrentInstance();
      const state2 = useTransitionState();
      let prevChildren;
      let children;
      onUpdated(() => {
        if (!prevChildren.length) {
          return;
        }
        const moveClass = props.moveClass || `${props.name || "v"}-move`;
        if (!hasCSSTransform(
          prevChildren[0].el,
          instance.vnode.el,
          moveClass
        )) {
          prevChildren = [];
          return;
        }
        prevChildren.forEach(callPendingCbs);
        prevChildren.forEach(recordPosition);
        const movedChildren = prevChildren.filter(applyTranslation);
        forceReflow();
        movedChildren.forEach((c) => {
          const el = c.el;
          const style = el.style;
          addTransitionClass(el, moveClass);
          style.transform = style.webkitTransform = style.transitionDuration = "";
          const cb = el[moveCbKey] = (e) => {
            if (e && e.target !== el) {
              return;
            }
            if (!e || /transform$/.test(e.propertyName)) {
              el.removeEventListener("transitionend", cb);
              el[moveCbKey] = null;
              removeTransitionClass(el, moveClass);
            }
          };
          el.addEventListener("transitionend", cb);
        });
        prevChildren = [];
      });
      return () => {
        const rawProps = toRaw(props);
        const cssTransitionProps = resolveTransitionProps(rawProps);
        let tag = rawProps.tag || Fragment;
        prevChildren = [];
        if (children) {
          for (let i = 0; i < children.length; i++) {
            const child = children[i];
            if (child.el && child.el instanceof Element) {
              prevChildren.push(child);
              setTransitionHooks(
                child,
                resolveTransitionHooks(
                  child,
                  cssTransitionProps,
                  state2,
                  instance
                )
              );
              positionMap.set(
                child,
                child.el.getBoundingClientRect()
              );
            }
          }
        }
        children = slots.default ? getTransitionRawChildren(slots.default()) : [];
        for (let i = 0; i < children.length; i++) {
          const child = children[i];
          if (child.key != null) {
            setTransitionHooks(
              child,
              resolveTransitionHooks(child, cssTransitionProps, state2, instance)
            );
          }
        }
        return createVNode(tag, null, children);
      };
    }
  });
  const TransitionGroup = TransitionGroupImpl;
  function callPendingCbs(c) {
    const el = c.el;
    if (el[moveCbKey]) {
      el[moveCbKey]();
    }
    if (el[enterCbKey]) {
      el[enterCbKey]();
    }
  }
  function recordPosition(c) {
    newPositionMap.set(c, c.el.getBoundingClientRect());
  }
  function applyTranslation(c) {
    const oldPos = positionMap.get(c);
    const newPos = newPositionMap.get(c);
    const dx = oldPos.left - newPos.left;
    const dy = oldPos.top - newPos.top;
    if (dx || dy) {
      const s = c.el.style;
      s.transform = s.webkitTransform = `translate(${dx}px,${dy}px)`;
      s.transitionDuration = "0s";
      return c;
    }
  }
  function hasCSSTransform(el, root, moveClass) {
    const clone = el.cloneNode();
    const _vtc = el[vtcKey];
    if (_vtc) {
      _vtc.forEach((cls) => {
        cls.split(/\s+/).forEach((c) => c && clone.classList.remove(c));
      });
    }
    moveClass.split(/\s+/).forEach((c) => c && clone.classList.add(c));
    clone.style.display = "none";
    const container = root.nodeType === 1 ? root : root.parentNode;
    container.appendChild(clone);
    const { hasTransform } = getTransitionInfo(clone);
    container.removeChild(clone);
    return hasTransform;
  }
  const getModelAssigner = (vnode) => {
    const fn = vnode.props["onUpdate:modelValue"] || false;
    return isArray(fn) ? (value) => invokeArrayFns(fn, value) : fn;
  };
  function onCompositionStart(e) {
    e.target.composing = true;
  }
  function onCompositionEnd(e) {
    const target = e.target;
    if (target.composing) {
      target.composing = false;
      target.dispatchEvent(new Event("input"));
    }
  }
  const assignKey = Symbol("_assign");
  const vModelText = {
    created(el, { modifiers: { lazy, trim, number } }, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      const castToNumber = number || vnode.props && vnode.props.type === "number";
      addEventListener(el, lazy ? "change" : "input", (e) => {
        if (e.target.composing) return;
        let domValue = el.value;
        if (trim) {
          domValue = domValue.trim();
        }
        if (castToNumber) {
          domValue = looseToNumber(domValue);
        }
        el[assignKey](domValue);
      });
      if (trim) {
        addEventListener(el, "change", () => {
          el.value = el.value.trim();
        });
      }
      if (!lazy) {
        addEventListener(el, "compositionstart", onCompositionStart);
        addEventListener(el, "compositionend", onCompositionEnd);
        addEventListener(el, "change", onCompositionEnd);
      }
    },
    // set value on mounted so it's after min/max for type="range"
    mounted(el, { value }) {
      el.value = value == null ? "" : value;
    },
    beforeUpdate(el, { value, oldValue, modifiers: { lazy, trim, number } }, vnode) {
      el[assignKey] = getModelAssigner(vnode);
      if (el.composing) return;
      const elValue = (number || el.type === "number") && !/^0\d/.test(el.value) ? looseToNumber(el.value) : el.value;
      const newValue = value == null ? "" : value;
      if (elValue === newValue) {
        return;
      }
      if (document.activeElement === el && el.type !== "range") {
        if (lazy && value === oldValue) {
          return;
        }
        if (trim && el.value.trim() === newValue) {
          return;
        }
      }
      el.value = newValue;
    }
  };
  const vModelSelect = {
    // <select multiple> value need to be deep traversed
    deep: true,
    created(el, { value, modifiers: { number } }, vnode) {
      const isSetModel = isSet(value);
      addEventListener(el, "change", () => {
        const selectedVal = Array.prototype.filter.call(el.options, (o) => o.selected).map(
          (o) => number ? looseToNumber(getValue(o)) : getValue(o)
        );
        el[assignKey](
          el.multiple ? isSetModel ? new Set(selectedVal) : selectedVal : selectedVal[0]
        );
        el._assigning = true;
        nextTick(() => {
          el._assigning = false;
        });
      });
      el[assignKey] = getModelAssigner(vnode);
    },
    // set value in mounted & updated because <select> relies on its children
    // <option>s.
    mounted(el, { value }) {
      setSelected(el, value);
    },
    beforeUpdate(el, _binding, vnode) {
      el[assignKey] = getModelAssigner(vnode);
    },
    updated(el, { value }) {
      if (!el._assigning) {
        setSelected(el, value);
      }
    }
  };
  function setSelected(el, value) {
    const isMultiple = el.multiple;
    const isArrayValue = isArray(value);
    if (isMultiple && !isArrayValue && !isSet(value)) {
      return;
    }
    for (let i = 0, l = el.options.length; i < l; i++) {
      const option = el.options[i];
      const optionValue = getValue(option);
      if (isMultiple) {
        if (isArrayValue) {
          const optionType = typeof optionValue;
          if (optionType === "string" || optionType === "number") {
            option.selected = value.some((v) => String(v) === String(optionValue));
          } else {
            option.selected = looseIndexOf(value, optionValue) > -1;
          }
        } else {
          option.selected = value.has(optionValue);
        }
      } else if (looseEqual(getValue(option), value)) {
        if (el.selectedIndex !== i) el.selectedIndex = i;
        return;
      }
    }
    if (!isMultiple && el.selectedIndex !== -1) {
      el.selectedIndex = -1;
    }
  }
  function getValue(el) {
    return "_value" in el ? el._value : el.value;
  }
  const systemModifiers = ["ctrl", "shift", "alt", "meta"];
  const modifierGuards = {
    stop: (e) => e.stopPropagation(),
    prevent: (e) => e.preventDefault(),
    self: (e) => e.target !== e.currentTarget,
    ctrl: (e) => !e.ctrlKey,
    shift: (e) => !e.shiftKey,
    alt: (e) => !e.altKey,
    meta: (e) => !e.metaKey,
    left: (e) => "button" in e && e.button !== 0,
    middle: (e) => "button" in e && e.button !== 1,
    right: (e) => "button" in e && e.button !== 2,
    exact: (e, modifiers) => systemModifiers.some((m) => e[`${m}Key`] && !modifiers.includes(m))
  };
  const withModifiers = (fn, modifiers) => {
    const cache = fn._withMods || (fn._withMods = {});
    const cacheKey = modifiers.join(".");
    return cache[cacheKey] || (cache[cacheKey] = (event, ...args) => {
      for (let i = 0; i < modifiers.length; i++) {
        const guard = modifierGuards[modifiers[i]];
        if (guard && guard(event, modifiers)) return;
      }
      return fn(event, ...args);
    });
  };
  const keyNames = {
    esc: "escape",
    space: " ",
    up: "arrow-up",
    left: "arrow-left",
    right: "arrow-right",
    down: "arrow-down",
    delete: "backspace"
  };
  const withKeys = (fn, modifiers) => {
    const cache = fn._withKeys || (fn._withKeys = {});
    const cacheKey = modifiers.join(".");
    return cache[cacheKey] || (cache[cacheKey] = (event) => {
      if (!("key" in event)) {
        return;
      }
      const eventKey = hyphenate(event.key);
      if (modifiers.some(
        (k) => k === eventKey || keyNames[k] === eventKey
      )) {
        return fn(event);
      }
    });
  };
  const rendererOptions = /* @__PURE__ */ extend({ patchProp }, nodeOps);
  let renderer;
  function ensureRenderer() {
    return renderer || (renderer = createRenderer(rendererOptions));
  }
  const createApp = (...args) => {
    const app2 = ensureRenderer().createApp(...args);
    const { mount } = app2;
    app2.mount = (containerOrSelector) => {
      const container = normalizeContainer(containerOrSelector);
      if (!container) return;
      const component = app2._component;
      if (!isFunction(component) && !component.render && !component.template) {
        component.template = container.innerHTML;
      }
      if (container.nodeType === 1) {
        container.textContent = "";
      }
      const proxy = mount(container, false, resolveRootNamespace(container));
      if (container instanceof Element) {
        container.removeAttribute("v-cloak");
        container.setAttribute("data-v-app", "");
      }
      return proxy;
    };
    return app2;
  };
  function resolveRootNamespace(container) {
    if (container instanceof SVGElement) {
      return "svg";
    }
    if (typeof MathMLElement === "function" && container instanceof MathMLElement) {
      return "mathml";
    }
  }
  function normalizeContainer(container) {
    if (isString(container)) {
      const res = document.querySelector(container);
      return res;
    }
    return container;
  }
  function getDevtoolsGlobalHook() {
    return getTarget().__VUE_DEVTOOLS_GLOBAL_HOOK__;
  }
  function getTarget() {
    return typeof navigator !== "undefined" && typeof window !== "undefined" ? window : typeof globalThis !== "undefined" ? globalThis : {};
  }
  const isProxyAvailable = typeof Proxy === "function";
  const HOOK_SETUP = "devtools-plugin:setup";
  const HOOK_PLUGIN_SETTINGS_SET = "plugin:settings:set";
  let supported;
  let perf;
  function isPerformanceSupported() {
    var _a;
    if (supported !== void 0) {
      return supported;
    }
    if (typeof window !== "undefined" && window.performance) {
      supported = true;
      perf = window.performance;
    } else if (typeof globalThis !== "undefined" && ((_a = globalThis.perf_hooks) === null || _a === void 0 ? void 0 : _a.performance)) {
      supported = true;
      perf = globalThis.perf_hooks.performance;
    } else {
      supported = false;
    }
    return supported;
  }
  function now() {
    return isPerformanceSupported() ? perf.now() : Date.now();
  }
  class ApiProxy {
    constructor(plugin, hook) {
      this.target = null;
      this.targetQueue = [];
      this.onQueue = [];
      this.plugin = plugin;
      this.hook = hook;
      const defaultSettings = {};
      if (plugin.settings) {
        for (const id in plugin.settings) {
          const item = plugin.settings[id];
          defaultSettings[id] = item.defaultValue;
        }
      }
      const localSettingsSaveId = `__vue-devtools-plugin-settings__${plugin.id}`;
      let currentSettings = Object.assign({}, defaultSettings);
      try {
        const raw = localStorage.getItem(localSettingsSaveId);
        const data = JSON.parse(raw);
        Object.assign(currentSettings, data);
      } catch (e) {
      }
      this.fallbacks = {
        getSettings() {
          return currentSettings;
        },
        setSettings(value) {
          try {
            localStorage.setItem(localSettingsSaveId, JSON.stringify(value));
          } catch (e) {
          }
          currentSettings = value;
        },
        now() {
          return now();
        }
      };
      if (hook) {
        hook.on(HOOK_PLUGIN_SETTINGS_SET, (pluginId, value) => {
          if (pluginId === this.plugin.id) {
            this.fallbacks.setSettings(value);
          }
        });
      }
      this.proxiedOn = new Proxy({}, {
        get: (_target, prop) => {
          if (this.target) {
            return this.target.on[prop];
          } else {
            return (...args) => {
              this.onQueue.push({
                method: prop,
                args
              });
            };
          }
        }
      });
      this.proxiedTarget = new Proxy({}, {
        get: (_target, prop) => {
          if (this.target) {
            return this.target[prop];
          } else if (prop === "on") {
            return this.proxiedOn;
          } else if (Object.keys(this.fallbacks).includes(prop)) {
            return (...args) => {
              this.targetQueue.push({
                method: prop,
                args,
                resolve: () => {
                }
              });
              return this.fallbacks[prop](...args);
            };
          } else {
            return (...args) => {
              return new Promise((resolve2) => {
                this.targetQueue.push({
                  method: prop,
                  args,
                  resolve: resolve2
                });
              });
            };
          }
        }
      });
    }
    setRealTarget(target) {
      return __async(this, null, function* () {
        this.target = target;
        for (const item of this.onQueue) {
          this.target.on[item.method](...item.args);
        }
        for (const item of this.targetQueue) {
          item.resolve(yield this.target[item.method](...item.args));
        }
      });
    }
  }
  function setupDevtoolsPlugin(pluginDescriptor, setupFn) {
    const descriptor = pluginDescriptor;
    const target = getTarget();
    const hook = getDevtoolsGlobalHook();
    const enableProxy = isProxyAvailable && descriptor.enableEarlyProxy;
    if (hook && (target.__VUE_DEVTOOLS_PLUGIN_API_AVAILABLE__ || !enableProxy)) {
      hook.emit(HOOK_SETUP, pluginDescriptor, setupFn);
    } else {
      const proxy = enableProxy ? new ApiProxy(descriptor, hook) : null;
      const list = target.__VUE_DEVTOOLS_PLUGINS__ = target.__VUE_DEVTOOLS_PLUGINS__ || [];
      list.push({
        pluginDescriptor: descriptor,
        setupFn,
        proxy
      });
      if (proxy) {
        setupFn(proxy.proxiedTarget);
      }
    }
  }
  /*!
   * vuex v4.1.0
   * (c) 2022 Evan You
   * @license MIT
   */
  var storeKey = "store";
  function forEachValue(obj, fn) {
    Object.keys(obj).forEach(function(key) {
      return fn(obj[key], key);
    });
  }
  function isObject(obj) {
    return obj !== null && typeof obj === "object";
  }
  function isPromise(val) {
    return val && typeof val.then === "function";
  }
  function partial(fn, arg) {
    return function() {
      return fn(arg);
    };
  }
  function genericSubscribe(fn, subs, options) {
    if (subs.indexOf(fn) < 0) {
      options && options.prepend ? subs.unshift(fn) : subs.push(fn);
    }
    return function() {
      var i = subs.indexOf(fn);
      if (i > -1) {
        subs.splice(i, 1);
      }
    };
  }
  function resetStore(store2, hot) {
    store2._actions = /* @__PURE__ */ Object.create(null);
    store2._mutations = /* @__PURE__ */ Object.create(null);
    store2._wrappedGetters = /* @__PURE__ */ Object.create(null);
    store2._modulesNamespaceMap = /* @__PURE__ */ Object.create(null);
    var state2 = store2.state;
    installModule(store2, state2, [], store2._modules.root, true);
    resetStoreState(store2, state2, hot);
  }
  function resetStoreState(store2, state2, hot) {
    var oldState = store2._state;
    var oldScope = store2._scope;
    store2.getters = {};
    store2._makeLocalGettersCache = /* @__PURE__ */ Object.create(null);
    var wrappedGetters = store2._wrappedGetters;
    var computedObj = {};
    var computedCache = {};
    var scope = effectScope(true);
    scope.run(function() {
      forEachValue(wrappedGetters, function(fn, key) {
        computedObj[key] = partial(fn, store2);
        computedCache[key] = computed(function() {
          return computedObj[key]();
        });
        Object.defineProperty(store2.getters, key, {
          get: function() {
            return computedCache[key].value;
          },
          enumerable: true
          // for local getters
        });
      });
    });
    store2._state = reactive({
      data: state2
    });
    store2._scope = scope;
    if (store2.strict) {
      enableStrictMode(store2);
    }
    if (oldState) {
      if (hot) {
        store2._withCommit(function() {
          oldState.data = null;
        });
      }
    }
    if (oldScope) {
      oldScope.stop();
    }
  }
  function installModule(store2, rootState, path, module, hot) {
    var isRoot = !path.length;
    var namespace = store2._modules.getNamespace(path);
    if (module.namespaced) {
      if (store2._modulesNamespaceMap[namespace] && false) ;
      store2._modulesNamespaceMap[namespace] = module;
    }
    if (!isRoot && !hot) {
      var parentState = getNestedState(rootState, path.slice(0, -1));
      var moduleName = path[path.length - 1];
      store2._withCommit(function() {
        parentState[moduleName] = module.state;
      });
    }
    var local = module.context = makeLocalContext(store2, namespace, path);
    module.forEachMutation(function(mutation, key) {
      var namespacedType = namespace + key;
      registerMutation(store2, namespacedType, mutation, local);
    });
    module.forEachAction(function(action, key) {
      var type = action.root ? key : namespace + key;
      var handler = action.handler || action;
      registerAction(store2, type, handler, local);
    });
    module.forEachGetter(function(getter, key) {
      var namespacedType = namespace + key;
      registerGetter(store2, namespacedType, getter, local);
    });
    module.forEachChild(function(child, key) {
      installModule(store2, rootState, path.concat(key), child, hot);
    });
  }
  function makeLocalContext(store2, namespace, path) {
    var noNamespace = namespace === "";
    var local = {
      dispatch: noNamespace ? store2.dispatch : function(_type, _payload, _options) {
        var args = unifyObjectStyle(_type, _payload, _options);
        var payload = args.payload;
        var options = args.options;
        var type = args.type;
        if (!options || !options.root) {
          type = namespace + type;
        }
        return store2.dispatch(type, payload);
      },
      commit: noNamespace ? store2.commit : function(_type, _payload, _options) {
        var args = unifyObjectStyle(_type, _payload, _options);
        var payload = args.payload;
        var options = args.options;
        var type = args.type;
        if (!options || !options.root) {
          type = namespace + type;
        }
        store2.commit(type, payload, options);
      }
    };
    Object.defineProperties(local, {
      getters: {
        get: noNamespace ? function() {
          return store2.getters;
        } : function() {
          return makeLocalGetters(store2, namespace);
        }
      },
      state: {
        get: function() {
          return getNestedState(store2.state, path);
        }
      }
    });
    return local;
  }
  function makeLocalGetters(store2, namespace) {
    if (!store2._makeLocalGettersCache[namespace]) {
      var gettersProxy = {};
      var splitPos = namespace.length;
      Object.keys(store2.getters).forEach(function(type) {
        if (type.slice(0, splitPos) !== namespace) {
          return;
        }
        var localType = type.slice(splitPos);
        Object.defineProperty(gettersProxy, localType, {
          get: function() {
            return store2.getters[type];
          },
          enumerable: true
        });
      });
      store2._makeLocalGettersCache[namespace] = gettersProxy;
    }
    return store2._makeLocalGettersCache[namespace];
  }
  function registerMutation(store2, type, handler, local) {
    var entry = store2._mutations[type] || (store2._mutations[type] = []);
    entry.push(function wrappedMutationHandler(payload) {
      handler.call(store2, local.state, payload);
    });
  }
  function registerAction(store2, type, handler, local) {
    var entry = store2._actions[type] || (store2._actions[type] = []);
    entry.push(function wrappedActionHandler(payload) {
      var res = handler.call(store2, {
        dispatch: local.dispatch,
        commit: local.commit,
        getters: local.getters,
        state: local.state,
        rootGetters: store2.getters,
        rootState: store2.state
      }, payload);
      if (!isPromise(res)) {
        res = Promise.resolve(res);
      }
      if (store2._devtoolHook) {
        return res.catch(function(err) {
          store2._devtoolHook.emit("vuex:error", err);
          throw err;
        });
      } else {
        return res;
      }
    });
  }
  function registerGetter(store2, type, rawGetter, local) {
    if (store2._wrappedGetters[type]) {
      return;
    }
    store2._wrappedGetters[type] = function wrappedGetter(store22) {
      return rawGetter(
        local.state,
        // local state
        local.getters,
        // local getters
        store22.state,
        // root state
        store22.getters
        // root getters
      );
    };
  }
  function enableStrictMode(store2) {
    watch(function() {
      return store2._state.data;
    }, function() {
    }, { deep: true, flush: "sync" });
  }
  function getNestedState(state2, path) {
    return path.reduce(function(state22, key) {
      return state22[key];
    }, state2);
  }
  function unifyObjectStyle(type, payload, options) {
    if (isObject(type) && type.type) {
      options = payload;
      payload = type;
      type = type.type;
    }
    return { type, payload, options };
  }
  var LABEL_VUEX_BINDINGS = "vuex bindings";
  var MUTATIONS_LAYER_ID = "vuex:mutations";
  var ACTIONS_LAYER_ID = "vuex:actions";
  var INSPECTOR_ID = "vuex";
  var actionId = 0;
  function addDevtools(app2, store2) {
    setupDevtoolsPlugin(
      {
        id: "org.vuejs.vuex",
        app: app2,
        label: "Vuex",
        homepage: "https://next.vuex.vuejs.org/",
        logo: "https://vuejs.org/images/icons/favicon-96x96.png",
        packageName: "vuex",
        componentStateTypes: [LABEL_VUEX_BINDINGS]
      },
      function(api) {
        api.addTimelineLayer({
          id: MUTATIONS_LAYER_ID,
          label: "Vuex Mutations",
          color: COLOR_LIME_500
        });
        api.addTimelineLayer({
          id: ACTIONS_LAYER_ID,
          label: "Vuex Actions",
          color: COLOR_LIME_500
        });
        api.addInspector({
          id: INSPECTOR_ID,
          label: "Vuex",
          icon: "storage",
          treeFilterPlaceholder: "Filter stores..."
        });
        api.on.getInspectorTree(function(payload) {
          if (payload.app === app2 && payload.inspectorId === INSPECTOR_ID) {
            if (payload.filter) {
              var nodes = [];
              flattenStoreForInspectorTree(nodes, store2._modules.root, payload.filter, "");
              payload.rootNodes = nodes;
            } else {
              payload.rootNodes = [
                formatStoreForInspectorTree(store2._modules.root, "")
              ];
            }
          }
        });
        api.on.getInspectorState(function(payload) {
          if (payload.app === app2 && payload.inspectorId === INSPECTOR_ID) {
            var modulePath = payload.nodeId;
            makeLocalGetters(store2, modulePath);
            payload.state = formatStoreForInspectorState(
              getStoreModule(store2._modules, modulePath),
              modulePath === "root" ? store2.getters : store2._makeLocalGettersCache,
              modulePath
            );
          }
        });
        api.on.editInspectorState(function(payload) {
          if (payload.app === app2 && payload.inspectorId === INSPECTOR_ID) {
            var modulePath = payload.nodeId;
            var path = payload.path;
            if (modulePath !== "root") {
              path = modulePath.split("/").filter(Boolean).concat(path);
            }
            store2._withCommit(function() {
              payload.set(store2._state.data, path, payload.state.value);
            });
          }
        });
        store2.subscribe(function(mutation, state2) {
          var data = {};
          if (mutation.payload) {
            data.payload = mutation.payload;
          }
          data.state = state2;
          api.notifyComponentUpdate();
          api.sendInspectorTree(INSPECTOR_ID);
          api.sendInspectorState(INSPECTOR_ID);
          api.addTimelineEvent({
            layerId: MUTATIONS_LAYER_ID,
            event: {
              time: Date.now(),
              title: mutation.type,
              data
            }
          });
        });
        store2.subscribeAction({
          before: function(action, state2) {
            var data = {};
            if (action.payload) {
              data.payload = action.payload;
            }
            action._id = actionId++;
            action._time = Date.now();
            data.state = state2;
            api.addTimelineEvent({
              layerId: ACTIONS_LAYER_ID,
              event: {
                time: action._time,
                title: action.type,
                groupId: action._id,
                subtitle: "start",
                data
              }
            });
          },
          after: function(action, state2) {
            var data = {};
            var duration = Date.now() - action._time;
            data.duration = {
              _custom: {
                type: "duration",
                display: duration + "ms",
                tooltip: "Action duration",
                value: duration
              }
            };
            if (action.payload) {
              data.payload = action.payload;
            }
            data.state = state2;
            api.addTimelineEvent({
              layerId: ACTIONS_LAYER_ID,
              event: {
                time: Date.now(),
                title: action.type,
                groupId: action._id,
                subtitle: "end",
                data
              }
            });
          }
        });
      }
    );
  }
  var COLOR_LIME_500 = 8702998;
  var COLOR_DARK = 6710886;
  var COLOR_WHITE = 16777215;
  var TAG_NAMESPACED = {
    label: "namespaced",
    textColor: COLOR_WHITE,
    backgroundColor: COLOR_DARK
  };
  function extractNameFromPath(path) {
    return path && path !== "root" ? path.split("/").slice(-2, -1)[0] : "Root";
  }
  function formatStoreForInspectorTree(module, path) {
    return {
      id: path || "root",
      // all modules end with a `/`, we want the last segment only
      // cart/ -> cart
      // nested/cart/ -> cart
      label: extractNameFromPath(path),
      tags: module.namespaced ? [TAG_NAMESPACED] : [],
      children: Object.keys(module._children).map(
        function(moduleName) {
          return formatStoreForInspectorTree(
            module._children[moduleName],
            path + moduleName + "/"
          );
        }
      )
    };
  }
  function flattenStoreForInspectorTree(result, module, filter, path) {
    if (path.includes(filter)) {
      result.push({
        id: path || "root",
        label: path.endsWith("/") ? path.slice(0, path.length - 1) : path || "Root",
        tags: module.namespaced ? [TAG_NAMESPACED] : []
      });
    }
    Object.keys(module._children).forEach(function(moduleName) {
      flattenStoreForInspectorTree(result, module._children[moduleName], filter, path + moduleName + "/");
    });
  }
  function formatStoreForInspectorState(module, getters2, path) {
    getters2 = path === "root" ? getters2 : getters2[path];
    var gettersKeys = Object.keys(getters2);
    var storeState = {
      state: Object.keys(module.state).map(function(key) {
        return {
          key,
          editable: true,
          value: module.state[key]
        };
      })
    };
    if (gettersKeys.length) {
      var tree = transformPathsToObjectTree(getters2);
      storeState.getters = Object.keys(tree).map(function(key) {
        return {
          key: key.endsWith("/") ? extractNameFromPath(key) : key,
          editable: false,
          value: canThrow(function() {
            return tree[key];
          })
        };
      });
    }
    return storeState;
  }
  function transformPathsToObjectTree(getters2) {
    var result = {};
    Object.keys(getters2).forEach(function(key) {
      var path = key.split("/");
      if (path.length > 1) {
        var target = result;
        var leafKey = path.pop();
        path.forEach(function(p2) {
          if (!target[p2]) {
            target[p2] = {
              _custom: {
                value: {},
                display: p2,
                tooltip: "Module",
                abstract: true
              }
            };
          }
          target = target[p2]._custom.value;
        });
        target[leafKey] = canThrow(function() {
          return getters2[key];
        });
      } else {
        result[key] = canThrow(function() {
          return getters2[key];
        });
      }
    });
    return result;
  }
  function getStoreModule(moduleMap, path) {
    var names2 = path.split("/").filter(function(n) {
      return n;
    });
    return names2.reduce(
      function(module, moduleName, i) {
        var child = module[moduleName];
        if (!child) {
          throw new Error('Missing module "' + moduleName + '" for path "' + path + '".');
        }
        return i === names2.length - 1 ? child : child._children;
      },
      path === "root" ? moduleMap : moduleMap.root._children
    );
  }
  function canThrow(cb) {
    try {
      return cb();
    } catch (e) {
      return e;
    }
  }
  var Module = function Module2(rawModule, runtime) {
    this.runtime = runtime;
    this._children = /* @__PURE__ */ Object.create(null);
    this._rawModule = rawModule;
    var rawState = rawModule.state;
    this.state = (typeof rawState === "function" ? rawState() : rawState) || {};
  };
  var prototypeAccessors$1 = { namespaced: { configurable: true } };
  prototypeAccessors$1.namespaced.get = function() {
    return !!this._rawModule.namespaced;
  };
  Module.prototype.addChild = function addChild(key, module) {
    this._children[key] = module;
  };
  Module.prototype.removeChild = function removeChild(key) {
    delete this._children[key];
  };
  Module.prototype.getChild = function getChild(key) {
    return this._children[key];
  };
  Module.prototype.hasChild = function hasChild(key) {
    return key in this._children;
  };
  Module.prototype.update = function update(rawModule) {
    this._rawModule.namespaced = rawModule.namespaced;
    if (rawModule.actions) {
      this._rawModule.actions = rawModule.actions;
    }
    if (rawModule.mutations) {
      this._rawModule.mutations = rawModule.mutations;
    }
    if (rawModule.getters) {
      this._rawModule.getters = rawModule.getters;
    }
  };
  Module.prototype.forEachChild = function forEachChild(fn) {
    forEachValue(this._children, fn);
  };
  Module.prototype.forEachGetter = function forEachGetter(fn) {
    if (this._rawModule.getters) {
      forEachValue(this._rawModule.getters, fn);
    }
  };
  Module.prototype.forEachAction = function forEachAction(fn) {
    if (this._rawModule.actions) {
      forEachValue(this._rawModule.actions, fn);
    }
  };
  Module.prototype.forEachMutation = function forEachMutation(fn) {
    if (this._rawModule.mutations) {
      forEachValue(this._rawModule.mutations, fn);
    }
  };
  Object.defineProperties(Module.prototype, prototypeAccessors$1);
  var ModuleCollection = function ModuleCollection2(rawRootModule) {
    this.register([], rawRootModule, false);
  };
  ModuleCollection.prototype.get = function get(path) {
    return path.reduce(function(module, key) {
      return module.getChild(key);
    }, this.root);
  };
  ModuleCollection.prototype.getNamespace = function getNamespace(path) {
    var module = this.root;
    return path.reduce(function(namespace, key) {
      module = module.getChild(key);
      return namespace + (module.namespaced ? key + "/" : "");
    }, "");
  };
  ModuleCollection.prototype.update = function update$1(rawRootModule) {
    update2([], this.root, rawRootModule);
  };
  ModuleCollection.prototype.register = function register(path, rawModule, runtime) {
    var this$1$1 = this;
    if (runtime === void 0) runtime = true;
    var newModule = new Module(rawModule, runtime);
    if (path.length === 0) {
      this.root = newModule;
    } else {
      var parent = this.get(path.slice(0, -1));
      parent.addChild(path[path.length - 1], newModule);
    }
    if (rawModule.modules) {
      forEachValue(rawModule.modules, function(rawChildModule, key) {
        this$1$1.register(path.concat(key), rawChildModule, runtime);
      });
    }
  };
  ModuleCollection.prototype.unregister = function unregister(path) {
    var parent = this.get(path.slice(0, -1));
    var key = path[path.length - 1];
    var child = parent.getChild(key);
    if (!child) {
      return;
    }
    if (!child.runtime) {
      return;
    }
    parent.removeChild(key);
  };
  ModuleCollection.prototype.isRegistered = function isRegistered(path) {
    var parent = this.get(path.slice(0, -1));
    var key = path[path.length - 1];
    if (parent) {
      return parent.hasChild(key);
    }
    return false;
  };
  function update2(path, targetModule, newModule) {
    targetModule.update(newModule);
    if (newModule.modules) {
      for (var key in newModule.modules) {
        if (!targetModule.getChild(key)) {
          return;
        }
        update2(
          path.concat(key),
          targetModule.getChild(key),
          newModule.modules[key]
        );
      }
    }
  }
  function createStore(options) {
    return new Store(options);
  }
  var Store = function Store2(options) {
    var this$1$1 = this;
    if (options === void 0) options = {};
    var plugins = options.plugins;
    if (plugins === void 0) plugins = [];
    var strict = options.strict;
    if (strict === void 0) strict = false;
    var devtools = options.devtools;
    this._committing = false;
    this._actions = /* @__PURE__ */ Object.create(null);
    this._actionSubscribers = [];
    this._mutations = /* @__PURE__ */ Object.create(null);
    this._wrappedGetters = /* @__PURE__ */ Object.create(null);
    this._modules = new ModuleCollection(options);
    this._modulesNamespaceMap = /* @__PURE__ */ Object.create(null);
    this._subscribers = [];
    this._makeLocalGettersCache = /* @__PURE__ */ Object.create(null);
    this._scope = null;
    this._devtools = devtools;
    var store2 = this;
    var ref2 = this;
    var dispatch2 = ref2.dispatch;
    var commit2 = ref2.commit;
    this.dispatch = function boundDispatch(type, payload) {
      return dispatch2.call(store2, type, payload);
    };
    this.commit = function boundCommit(type, payload, options2) {
      return commit2.call(store2, type, payload, options2);
    };
    this.strict = strict;
    var state2 = this._modules.root.state;
    installModule(this, state2, [], this._modules.root);
    resetStoreState(this, state2);
    plugins.forEach(function(plugin) {
      return plugin(this$1$1);
    });
  };
  var prototypeAccessors = { state: { configurable: true } };
  Store.prototype.install = function install(app2, injectKey) {
    app2.provide(injectKey || storeKey, this);
    app2.config.globalProperties.$store = this;
    var useDevtools = this._devtools !== void 0 ? this._devtools : false;
    if (useDevtools) {
      addDevtools(app2, this);
    }
  };
  prototypeAccessors.state.get = function() {
    return this._state.data;
  };
  prototypeAccessors.state.set = function(v) {
  };
  Store.prototype.commit = function commit(_type, _payload, _options) {
    var this$1$1 = this;
    var ref2 = unifyObjectStyle(_type, _payload, _options);
    var type = ref2.type;
    var payload = ref2.payload;
    var mutation = { type, payload };
    var entry = this._mutations[type];
    if (!entry) {
      return;
    }
    this._withCommit(function() {
      entry.forEach(function commitIterator(handler) {
        handler(payload);
      });
    });
    this._subscribers.slice().forEach(function(sub) {
      return sub(mutation, this$1$1.state);
    });
  };
  Store.prototype.dispatch = function dispatch(_type, _payload) {
    var this$1$1 = this;
    var ref2 = unifyObjectStyle(_type, _payload);
    var type = ref2.type;
    var payload = ref2.payload;
    var action = { type, payload };
    var entry = this._actions[type];
    if (!entry) {
      return;
    }
    try {
      this._actionSubscribers.slice().filter(function(sub) {
        return sub.before;
      }).forEach(function(sub) {
        return sub.before(action, this$1$1.state);
      });
    } catch (e) {
    }
    var result = entry.length > 1 ? Promise.all(entry.map(function(handler) {
      return handler(payload);
    })) : entry[0](payload);
    return new Promise(function(resolve2, reject) {
      result.then(function(res) {
        try {
          this$1$1._actionSubscribers.filter(function(sub) {
            return sub.after;
          }).forEach(function(sub) {
            return sub.after(action, this$1$1.state);
          });
        } catch (e) {
        }
        resolve2(res);
      }, function(error) {
        try {
          this$1$1._actionSubscribers.filter(function(sub) {
            return sub.error;
          }).forEach(function(sub) {
            return sub.error(action, this$1$1.state, error);
          });
        } catch (e) {
        }
        reject(error);
      });
    });
  };
  Store.prototype.subscribe = function subscribe(fn, options) {
    return genericSubscribe(fn, this._subscribers, options);
  };
  Store.prototype.subscribeAction = function subscribeAction(fn, options) {
    var subs = typeof fn === "function" ? { before: fn } : fn;
    return genericSubscribe(subs, this._actionSubscribers, options);
  };
  Store.prototype.watch = function watch$12(getter, cb, options) {
    var this$1$1 = this;
    return watch(function() {
      return getter(this$1$1.state, this$1$1.getters);
    }, cb, Object.assign({}, options));
  };
  Store.prototype.replaceState = function replaceState(state2) {
    var this$1$1 = this;
    this._withCommit(function() {
      this$1$1._state.data = state2;
    });
  };
  Store.prototype.registerModule = function registerModule(path, rawModule, options) {
    if (options === void 0) options = {};
    if (typeof path === "string") {
      path = [path];
    }
    this._modules.register(path, rawModule);
    installModule(this, this.state, path, this._modules.get(path), options.preserveState);
    resetStoreState(this, this.state);
  };
  Store.prototype.unregisterModule = function unregisterModule(path) {
    var this$1$1 = this;
    if (typeof path === "string") {
      path = [path];
    }
    this._modules.unregister(path);
    this._withCommit(function() {
      var parentState = getNestedState(this$1$1.state, path.slice(0, -1));
      delete parentState[path[path.length - 1]];
    });
    resetStore(this);
  };
  Store.prototype.hasModule = function hasModule(path) {
    if (typeof path === "string") {
      path = [path];
    }
    return this._modules.isRegistered(path);
  };
  Store.prototype.hotUpdate = function hotUpdate(newOptions) {
    this._modules.update(newOptions);
    resetStore(this, true);
  };
  Store.prototype._withCommit = function _withCommit(fn) {
    var committing = this._committing;
    this._committing = true;
    fn();
    this._committing = committing;
  };
  Object.defineProperties(Store.prototype, prototypeAccessors);
  var mapGetters = normalizeNamespace(function(namespace, getters2) {
    var res = {};
    normalizeMap(getters2).forEach(function(ref2) {
      var key = ref2.key;
      var val = ref2.val;
      val = namespace + val;
      res[key] = function mappedGetter() {
        if (namespace && !getModuleByNamespace(this.$store, "mapGetters", namespace)) {
          return;
        }
        return this.$store.getters[val];
      };
      res[key].vuex = true;
    });
    return res;
  });
  var mapActions = normalizeNamespace(function(namespace, actions2) {
    var res = {};
    normalizeMap(actions2).forEach(function(ref2) {
      var key = ref2.key;
      var val = ref2.val;
      res[key] = function mappedAction() {
        var args = [], len = arguments.length;
        while (len--) args[len] = arguments[len];
        var dispatch2 = this.$store.dispatch;
        if (namespace) {
          var module = getModuleByNamespace(this.$store, "mapActions", namespace);
          if (!module) {
            return;
          }
          dispatch2 = module.context.dispatch;
        }
        return typeof val === "function" ? val.apply(this, [dispatch2].concat(args)) : dispatch2.apply(this.$store, [val].concat(args));
      };
    });
    return res;
  });
  function normalizeMap(map) {
    if (!isValidMap(map)) {
      return [];
    }
    return Array.isArray(map) ? map.map(function(key) {
      return { key, val: key };
    }) : Object.keys(map).map(function(key) {
      return { key, val: map[key] };
    });
  }
  function isValidMap(map) {
    return Array.isArray(map) || isObject(map);
  }
  function normalizeNamespace(fn) {
    return function(namespace, map) {
      if (typeof namespace !== "string") {
        map = namespace;
        namespace = "";
      } else if (namespace.charAt(namespace.length - 1) !== "/") {
        namespace += "/";
      }
      return fn(namespace, map);
    };
  }
  function getModuleByNamespace(store2, helper, namespace) {
    var module = store2._modulesNamespaceMap[namespace];
    return module;
  }
  const _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };
  let $ = jQuery;
  const _sfc_main$m = {
    methods: {
      showPageOptions(event) {
        event.preventDefault();
        var params = {}, options = window.ZnPbData.page_options;
        params.modal_ajax_hook = "znpb_get_page_options";
        params.modal_backdrop_class = "zn-modal-transparent";
        params.modal_ajax_params = {
          page_options: options,
          post_id: window.ZnPbData.postId
        };
        params.modal_title = "Page options";
        params.modal_on_close = function(e) {
          this.save_page_options(e.modal);
          $.page_builder.show_editor();
        }.bind(this);
        params.modal_on_ajax_load = function(e) {
          e.modal.find(".zn-modal-form");
          $.page_builder.isolate_scroll(e.modal);
        };
        new $.ZnModal(params);
      },
      // This will save the page options to the pb factory
      save_page_options(scope) {
        var form = scope.find(".zn-modal-form").first();
        window.ZnPbData.page_options = $.page_builder.get_form_values(form);
      }
    }
  };
  function _sfc_render$l(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("a", {
      class: "zn_pb_icon",
      href: "#",
      onClick: _cache[0] || (_cache[0] = (...args) => $options.showPageOptions && $options.showPageOptions(...args)),
      "data-tooltip": "Page options"
    }, _cache[1] || (_cache[1] = [
      createBaseVNode(
        "span",
        { class: "dashicons dashicons-admin-generic" },
        null,
        -1
        /* CACHED */
      )
    ]));
  }
  const pageOptions = /* @__PURE__ */ _export_sfc(_sfc_main$m, [["render", _sfc_render$l]]);
  const _sfc_main$l = {
    methods: __spreadProps(__spreadValues({}, mapActions(["showEditor", "setActiveTab"])), {
      filterElementsBySearch(event) {
        let keyword = event.target.value;
        this.$store.dispatch("setActiveCategory", "");
        if (keyword.length >= 3) {
          this.showEditor();
          this.setActiveTab("znb-tab-elements");
          this.$store.dispatch("filterElementsBySearch", keyword);
        } else {
          this.$store.dispatch("filterElementsBySearch", "");
        }
      }
    })
  };
  function _sfc_render$k(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", null, [
      createBaseVNode(
        "input",
        {
          class: "zn_pb_search",
          onKeyup: _cache[0] || (_cache[0] = (...args) => $options.filterElementsBySearch && $options.filterElementsBySearch(...args)),
          type: "search",
          placeholder: "Search for an element",
          autofocus: ""
        },
        null,
        32
        /* NEED_HYDRATION */
      )
    ]);
  }
  const searchInput = /* @__PURE__ */ _export_sfc(_sfc_main$l, [["render", _sfc_render$k]]);
  const _sfc_main$k = {
    name: "znb-editor-header",
    computed: __spreadProps(__spreadValues({}, mapGetters(["activeTab", "registeredTabs"])), {
      visibilityButton: function() {
        return this.$store.getters.isEditorVisible ? "dashicons-arrow-down-alt2" : "dashicons-arrow-up-alt2";
      }
    }),
    data: function() {
      return {};
    },
    methods: __spreadProps(__spreadValues({}, mapActions(["toggleEditor", "showEditor", "setActiveTab"])), {
      toggleTab(tab) {
        this.showEditor();
        this.setActiveTab(tab);
      },
      publishPage(event) {
        var fw = jQuery.page_builder;
        fw.hide_editor();
        fw.show_page_loading(true);
        var JsonData = fw.build_map(jQuery(".zn_pb_wrapper > .zn_pb_section"));
        var data = {
          action: "znpb_publish_page",
          template: JSON.stringify(JsonData),
          post_id: window.ZnPbData.postId,
          security: ZnAjax.security,
          page_options: window.ZnPbData.page_options
        };
        jQuery.post(ZnAjax.ajaxurl, data, function(response) {
          if (response) {
            new jQuery.ZnModalMessage("Page saved succesfully !");
            fw.hide_page_loading(true);
          } else {
            fw.hide_page_loading(true);
            new jQuery.ZnModalMessage("There was a problem saving the page !");
          }
        });
      },
      savePageOnCTRLS(event) {
        jQuery.page_builder;
        if ((event.ctrlKey || event.metaKey) && !event.altKey) {
          switch (String.fromCharCode(event.which).toLowerCase()) {
            case "s":
              event.preventDefault();
              this.publishPage();
              break;
          }
        }
      }
    }),
    components: {
      "znb-page-options": pageOptions,
      "znb-elements-search": searchInput
    },
    created: function() {
      document.addEventListener("keydown", this.savePageOnCTRLS);
    },
    destroyed: function() {
      document.removeEventListener("keydown", this.savePageOnCTRLS);
    }
  };
  const _hoisted_1$g = { class: "znpbEditorHeader clearfix" };
  const _hoisted_2$c = { class: "zn_fpb_buttons zn_left" };
  const _hoisted_3$6 = { id: "klpb-toolbar" };
  const _hoisted_4$4 = ["onClick"];
  const _hoisted_5$1 = { class: "zn_fpb_buttons zn_right" };
  const _hoisted_6$1 = { class: "zn_pb_editor_right_action" };
  function _sfc_render$j(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_znb_page_options = resolveComponent("znb-page-options");
    const _component_znb_elements_search = resolveComponent("znb-elements-search");
    return openBlock(), createElementBlock("div", _hoisted_1$g, [
      createBaseVNode("div", _hoisted_2$c, [
        createBaseVNode("span", _hoisted_3$6, [
          createBaseVNode("a", {
            class: "zn_pb_icon zn_pb_close_panel",
            href: "#",
            onClick: _cache[0] || (_cache[0] = withModifiers((...args) => _ctx.toggleEditor && _ctx.toggleEditor(...args), ["prevent"]))
          }, [
            createBaseVNode(
              "span",
              {
                class: normalizeClass(["dashicons", $options.visibilityButton])
              },
              null,
              2
              /* CLASS */
            )
          ]),
          createVNode(_component_znb_page_options)
        ]),
        (openBlock(true), createElementBlock(
          Fragment,
          null,
          renderList(_ctx.registeredTabs, (tab) => {
            return openBlock(), createElementBlock("a", {
              href: "#",
              onClick: withModifiers(($event) => $options.toggleTab(tab.tabComponent), ["prevent"]),
              class: normalizeClass([{ "zn-pb-active-tab": _ctx.activeTab === tab.tabComponent }, "zn_pb_add_el"])
            }, toDisplayString(tab.tabTitle), 11, _hoisted_4$4);
          }),
          256
          /* UNKEYED_FRAGMENT */
        )),
        _cache[2] || (_cache[2] = createBaseVNode(
          "a",
          {
            class: "zn_pb_icon zn_pb_help_icon",
            href: "http://docs.kallyas.net/",
            target: "_blank",
            "data-tooltip": "Access Documentation"
          },
          [
            createBaseVNode("span", { class: "dashicons dashicons-editor-help" })
          ],
          -1
          /* CACHED */
        ))
      ]),
      createBaseVNode("div", _hoisted_5$1, [
        createBaseVNode("div", _hoisted_6$1, [
          createVNode(_component_znb_elements_search)
        ]),
        createBaseVNode("a", {
          class: "zn_publish",
          onClick: _cache[1] || (_cache[1] = withModifiers((...args) => $options.publishPage && $options.publishPage(...args), ["prevent"])),
          href: "#"
        }, _cache[3] || (_cache[3] = [
          createBaseVNode(
            "span",
            { class: "zn_publish_loading" },
            null,
            -1
            /* CACHED */
          ),
          createBaseVNode(
            "span",
            { class: "zn_publish_text" },
            "PUBLISH",
            -1
            /* CACHED */
          )
        ]))
      ])
    ]);
  }
  const headerComponent = /* @__PURE__ */ _export_sfc(_sfc_main$k, [["render", _sfc_render$j]]);
  const _sfc_main$j = {
    data: function() {
      return {
        //Set the starting mouse position to a min variable
        startY: 0,
        startEditorHeight: 0
      };
    },
    computed: __spreadValues({}, mapGetters(["editorHeight", "isEditorResizing"])),
    methods: {
      startEditorDrag(event) {
        event.preventDefault();
        this.startEditorHeight = this.editorHeight;
        this.startY = event.clientY;
        this.$store.dispatch("setEditorResizing", true);
        window.addEventListener("mousemove", this.resizeEditor);
        window.addEventListener("mouseup", this.disableEditorDrag);
      },
      disableEditorDrag(context) {
        this.allowDragging = false;
        this.$store.dispatch("setEditorResizing", false);
        window.removeEventListener("mousemove", this.resizeEditor);
        window.removeEventListener("mouseup", this.disableEditorDrag);
      },
      resizeEditor(event) {
        let newHeight = this.startEditorHeight + this.startY - event.clientY;
        let windowTopLimit = 200;
        let windowHeight = window.jQuery(window).height();
        let windowBounds = windowHeight - windowTopLimit;
        newHeight = Math.max(0, newHeight);
        newHeight = Math.min(windowBounds, newHeight);
        this.$store.dispatch("changeHeight", newHeight);
      }
    }
  };
  function _sfc_render$i(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock(
      "div",
      {
        class: "znpbEditorDragbar",
        onMousedown: _cache[0] || (_cache[0] = (...args) => $options.startEditorDrag && $options.startEditorDrag(...args))
      },
      null,
      32
      /* NEED_HYDRATION */
    );
  }
  const dragBar = /* @__PURE__ */ _export_sfc(_sfc_main$j, [["render", _sfc_render$i]]);
  const draggableOptions = {
    methods: __spreadProps(__spreadValues({}, mapActions(["showEditor", "hideEditor"])), {
      get_draggable_options: function() {
        let fw = jQuery.page_builder;
        var self2 = this;
        return {
          revert: true,
          containment: "document",
          iframeFix: true,
          cursorAt: { top: 0 },
          appendTo: "body",
          connectToSortable: this.element.level == "2" ? ".zn_pb_wrapper .zn_columns_container" : ".zn_pb_wrapper .zn_sortable_content, .zn_pb_wrapper",
          helper: "clone",
          start: function(a, b) {
            self2.hideEditor();
            fw.body.addClass("zn_dragg_enabled");
          },
          stop: function() {
            self2.showEditor();
            fw.body.removeClass("zn_dragg_enabled");
          },
          zIndex: 1e3
        };
      }
    })
  };
  const draggableElement = {
    mounted: function() {
      jQuery.page_builder;
      jQuery(this.$el).draggable(this.get_draggable_options());
      document.addEventListener("mouseup", this.documentOnMouseUp);
    },
    beforeDestroy: function() {
      jQuery(this.$el).draggable("destroy");
      document.removeEventListener("mouseup", this.documentOnMouseUp);
    },
    methods: {
      onMouseDown(event) {
        jQuery(event.currentTarget);
        var self2 = this;
        if (this.element.level == "2") {
          jQuery(".zn_sortable_content").sortable("disable");
        } else {
          jQuery(".zn_columns_container").sortable("disable");
        }
        jQuery(".ui-sortable").each(function() {
          if (jQuery(this).data("droplevel") >= self2.element.level) {
            jQuery(this).sortable("disable");
          } else {
            jQuery(this).addClass("zn_drop_allowed");
          }
        });
      },
      onMouseUp(event) {
        var fw = jQuery.page_builder;
        fw.body.removeClass("zn_dragg_enabled");
      },
      documentOnMouseUp() {
        jQuery(".ui-sortable-disabled").sortable("enable");
        jQuery(".zn_drop_allowed").removeClass(".zn_drop_allowed");
      }
    }
  };
  const _sfc_main$i = {
    props: ["element"],
    mixins: [draggableOptions, draggableElement]
  };
  const _hoisted_1$f = ["data-object", "data-widget"];
  const _hoisted_2$b = ["src"];
  const _hoisted_3$5 = { class: "zn_pb_el_title" };
  const _hoisted_4$3 = { class: "zn_pb_el_category" };
  function _sfc_render$h(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", {
      class: "zn_pb_element",
      "data-object": $props.element.class,
      onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.onMouseDown && _ctx.onMouseDown(...args)),
      onMouseup: _cache[1] || (_cache[1] = (...args) => _ctx.onMouseUp && _ctx.onMouseUp(...args)),
      "data-widget": $props.element.widget_id
    }, [
      createBaseVNode("img", {
        class: "zn_pb_el_icon",
        src: $props.element.icon
      }, null, 8, _hoisted_2$b),
      createBaseVNode(
        "div",
        _hoisted_3$5,
        toDisplayString($props.element.name),
        1
        /* TEXT */
      ),
      createBaseVNode(
        "div",
        _hoisted_4$3,
        toDisplayString($props.element.category),
        1
        /* TEXT */
      )
    ], 40, _hoisted_1$f);
  }
  const singleElement = /* @__PURE__ */ _export_sfc(_sfc_main$i, [["render", _sfc_render$h]]);
  const _sfc_main$h = {
    computed: __spreadValues({}, mapGetters([
      "elementCategories",
      "visibleElements",
      "activeCategory",
      "filterElementsByLevel"
    ])),
    data: function() {
      return {};
    },
    components: {
      "znb-elements-single": singleElement
    },
    methods: {
      filterElementsByCategory(category, event) {
        event.preventDefault();
        this.$store.dispatch("filterElementsByCategory", category.filter);
      },
      filterNoContent(event) {
        if (event.target.matches(".zn_pb_no_content")) {
          if (event.target.hasAttribute("data-droplevel")) {
            let elementDropLevel = event.target.getAttribute("data-droplevel");
            this.$store.dispatch(
              "filterElementsByLevel",
              parseInt(elementDropLevel)
            );
          }
        }
      }
    },
    created: function() {
      window.addEventListener("click", this.filterNoContent);
    }
  };
  const _hoisted_1$e = { class: "zn_pb_tab" };
  const _hoisted_2$a = { class: "znpbElementsSidebar zn-sidebar-scroll" };
  const _hoisted_3$4 = { class: "znpbElementsSidebarCategoryList" };
  const _hoisted_4$2 = ["onClick"];
  function _sfc_render$g(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_znb_elements_single = resolveComponent("znb-elements-single");
    return openBlock(), createElementBlock("div", _hoisted_1$e, [
      createBaseVNode("div", _hoisted_2$a, [
        createBaseVNode("ul", _hoisted_3$4, [
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(_ctx.elementCategories, (category) => {
              return openBlock(), createElementBlock("li", null, [
                createBaseVNode("a", {
                  href: "#",
                  onClick: ($event) => $options.filterElementsByCategory(category, $event),
                  class: normalizeClass({ zn_pb_selected: _ctx.activeCategory == category.filter })
                }, toDisplayString(category.name), 11, _hoisted_4$2)
              ]);
            }),
            256
            /* UNKEYED_FRAGMENT */
          ))
        ])
      ]),
      createVNode(TransitionGroup, {
        name: "pb_element",
        tag: "div",
        class: "zn_pb_elements zn_pb_tab_content",
        id: "znpb_editor_elements"
      }, {
        default: withCtx(() => [
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(_ctx.visibleElements, (element) => {
              return openBlock(), createElementBlock("div", {
                key: element.id,
                class: "pb_element"
              }, [
                createCommentVNode(" TODO: Switch from visibleElements to a computed propery that shows the element. It is needed for transitions "),
                createVNode(_component_znb_elements_single, { element }, null, 8, ["element"])
              ]);
            }),
            128
            /* KEYED_FRAGMENT */
          ))
        ]),
        _: 1
        /* STABLE */
      })
    ]);
  }
  const elementsTabContent = /* @__PURE__ */ _export_sfc(_sfc_main$h, [["render", _sfc_render$g]]);
  const _sfc_main$g = {
    props: ["element", "single"],
    mixins: [draggableOptions, draggableElement],
    data: function() {
      return {
        isOptionsVisible: false
      };
    },
    methods: {
      exportElement(event) {
        var that = this, fw = jQuery.page_builder;
        let template_name = this.element.name;
        var data = {
          action: "znpb_export_indv_template",
          template_name,
          level: that.element.level,
          isSingle: that.single,
          security: ZnAjax.security
        };
        fw.show_page_loading(true);
        jQuery.post(ZnAjax.ajaxurl, data, function(response) {
          if (response.success === true) {
            window.showed_message = true;
            location.href = ZnAjax.ajaxurl + "?action=znpb_download_export&file_name=" + template_name + "&nonce=" + ZnAjax.security;
          } else if (response.message.length > 0) {
            new jQuery.ZnModalMessage(response.mesage);
          } else {
            new jQuery.ZnModalMessage(
              "There was a problem exporting the template !"
            );
          }
          fw.hide_page_loading(true);
        });
      },
      deleteElement(event) {
        var that = this, fw = jQuery.page_builder;
        var data = {
          action: "zn_delete_template",
          template_name: that.element.name,
          isSingle: that.single,
          // TODO: normalize nonces
          security: ZnAjax.security,
          post_id: window.ZnPbData.postId
        };
        var callback = function() {
          fw.show_page_loading(true);
          jQuery.post(ZnAjax.ajaxurl, data, function(response) {
            if (response.success === true) {
              new jQuery.ZnModalMessage(response.message);
              fw.hide_page_loading(true);
              if (that.single) {
                that.$store.dispatch("removeSingleElement", that.element);
              } else {
                that.$store.dispatch("removeTemplate", that.element);
              }
            } else {
              fw.hide_page_loading(true);
              new jQuery.ZnModalMessage(
                "There was a problem saving the template !"
              );
            }
          });
        };
        new jQuery.ZnModalConfirm(
          "Are you sure you want to delete this template ?",
          "No",
          "Yes",
          callback
        );
      }
    }
  };
  const _hoisted_1$d = ["data-is_single", "data-template"];
  const _hoisted_2$9 = { class: "zn_pb_template" };
  const _hoisted_3$3 = { class: "zn_pb_el_title" };
  const _hoisted_4$1 = { class: "zn_pb_tpl_subactions-panel" };
  function _sfc_render$f(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", {
      class: "znbSingleTemplate zn_pb_element",
      "data-is_single": $props.single,
      "data-template": $props.element.name,
      onMousedown: _cache[3] || (_cache[3] = (...args) => _ctx.onMouseDown && _ctx.onMouseDown(...args)),
      onMouseup: _cache[4] || (_cache[4] = (...args) => _ctx.onMouseUp && _ctx.onMouseUp(...args))
    }, [
      createBaseVNode("div", _hoisted_2$9, [
        createCommentVNode(" TODO: ADD DEFAULT ICON FROM PHP "),
        _cache[8] || (_cache[8] = createBaseVNode(
          "img",
          {
            class: "zn_pb_el_icon",
            src: "https://demo.kallyas.net/wp-content/themes/kallyas/framework/zion-builder/assets/img/default_icon.png"
          },
          null,
          -1
          /* CACHED */
        )),
        createBaseVNode(
          "div",
          _hoisted_3$3,
          toDisplayString($props.element.name),
          1
          /* TEXT */
        ),
        createBaseVNode(
          "div",
          {
            class: normalizeClass(["zn_pb_tpl_actions", { "zn_pb_tpl_subactions-panel--panelOpen": _ctx.isOptionsVisible }])
          },
          [
            createBaseVNode("span", {
              onClick: _cache[0] || (_cache[0] = ($event) => _ctx.isOptionsVisible = !_ctx.isOptionsVisible),
              class: "zn_pb_tpl_subactions-trig"
            }, "···"),
            withDirectives(createBaseVNode(
              "div",
              _hoisted_4$1,
              [
                createBaseVNode("a", {
                  onClick: _cache[1] || (_cache[1] = withModifiers((...args) => $options.exportElement && $options.exportElement(...args), ["prevent"])),
                  href: "#",
                  class: "zn_pb_export_indv_template zn_pb_tpl_actions-btn tooltip-bottom",
                  "data-tooltip": "EXPORT"
                }, _cache[5] || (_cache[5] = [
                  createBaseVNode(
                    "span",
                    { class: "dashicons dashicons-upload" },
                    null,
                    -1
                    /* CACHED */
                  )
                ])),
                createBaseVNode("a", {
                  onClick: _cache[2] || (_cache[2] = withModifiers((...args) => $options.deleteElement && $options.deleteElement(...args), ["prevent"])),
                  href: "#",
                  class: "zn_pb_delete_saved_el zn_pb_tpl_actions-btn tooltip-bottom",
                  "data-tooltip": "DELETE"
                }, _cache[6] || (_cache[6] = [
                  createBaseVNode(
                    "span",
                    { class: "dashicons dashicons-trash" },
                    null,
                    -1
                    /* CACHED */
                  )
                ]))
              ],
              512
              /* NEED_PATCH */
            ), [
              [vShow, _ctx.isOptionsVisible]
            ]),
            _cache[7] || (_cache[7] = createBaseVNode(
              "span",
              { class: "zn_pb_tpl_actions-text-btn" },
              "DRAG TO PAGE",
              -1
              /* CACHED */
            ))
          ],
          2
          /* CLASS */
        )
      ])
    ], 40, _hoisted_1$d);
  }
  const singleTemplate = /* @__PURE__ */ _export_sfc(_sfc_main$g, [["render", _sfc_render$f]]);
  const _sfc_main$f = {
    name: "templateImporter",
    data: () => {
      return {
        isFileUploading: false,
        uploadProgress: ""
      };
    },
    props: {
      single: {
        type: Boolean,
        default() {
          return false;
        }
      }
    },
    methods: {
      importFile(event) {
        var that = this, fileData = event.target.files[0];
        this.isFileUploading = true;
        var data = new FormData();
        data.append("file", fileData);
        data.append("action", "zn_import_template");
        data.append("isSingle", this.single);
        data.append("security", ZnAjax.security);
        jQuery.ajax({
          url: ZnAjax.ajaxurl,
          // point to server-side PHP script
          dataType: "json",
          // what to expect back from the PHP script, if anything
          cache: false,
          contentType: false,
          processData: false,
          data,
          type: "post",
          xhr: function() {
            var xhr = jQuery.ajaxSettings.xhr(), hasOnProgress = "onprogress" in xhr;
            if (!hasOnProgress) {
              return;
            }
            if (xhr instanceof window.XMLHttpRequest) {
              xhr.addEventListener("progress", this.progress, false);
            }
            if (xhr.upload) {
              xhr.upload.addEventListener("progress", this.progress, false);
            }
            return xhr;
          },
          progress: function(e) {
            if (e.lengthComputable) {
              var pct = parseInt(e.loaded / e.total * 100);
              that.uploadProgress = pct;
            } else {
              console.warn("Content Length not reported!");
            }
          },
          success: function(response) {
            if (response.success) {
              new jQuery.ZnModalMessage(response.data.message);
              that.$emit("file-upload-success", response.data);
            } else {
              new jQuery.ZnModalMessage(
                "There was a problem importing the template !"
              );
              that.$emit("file-upload-error", response.data);
            }
          },
          error: function(error) {
            console.log("ERROR: " + error);
          },
          complete: function() {
            that.uploadProgress = "";
            that.isFileUploading = false;
          }
        });
      }
    }
  };
  const _hoisted_1$c = { class: "zn_pb_template zn_pb_uploadtpl" };
  function _sfc_render$e(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", _hoisted_1$c, [
      createBaseVNode(
        "label",
        {
          class: normalizeClass([{ "is-uploading": _ctx.isFileUploading }, "zn_pb_el_icon zn_pb_el_uploadicon js-znpb_upload_template"]),
          for: "znpb_upload_input"
        },
        [
          _cache[1] || (_cache[1] = createBaseVNode(
            "svg",
            {
              width: "100px",
              height: "100px",
              viewBox: "0 0 100 100",
              version: "1.1",
              xmlns: "http://www.w3.org/2000/svg",
              "xmlns:xlink": "http://www.w3.org/1999/xlink"
            },
            [
              createBaseVNode("path", {
                d: "M61.6702128,62.6293333 L39.3297872,62.6293333 C38.6691489,62.6293333 38.1329787,62.0917333 38.1329787,61.4293333 L38.1329787,46.5189333 C38.1329787,45.856 38.6691489,45.3189333 39.3297872,45.3189333 L44.3164894,45.3189333 C44.9771277,45.3189333 45.5132979,45.856 45.5132979,46.5189333 C45.5132979,47.1813333 44.9771277,47.7189333 44.3164894,47.7189333 L40.5265957,47.7189333 L40.5265957,60.2293333 L60.4734043,60.2293333 L60.4734043,47.7189333 L56.6835106,47.7189333 C56.0228723,47.7189333 55.4867021,47.1813333 55.4867021,46.5189333 C55.4867021,45.856 56.0228723,45.3189333 56.6835106,45.3189333 L61.6702128,45.3189333 C62.3308511,45.3189333 62.8670213,45.856 62.8670213,46.5189333 L62.8670213,61.4293333 C62.8670213,62.0917333 62.3308511,62.6293333 61.6702128,62.6293333 Z M55.3851064,53.5018667 L51.3478723,57.5498667 C51.2914894,57.6064 51.2271277,57.6581333 51.1606383,57.7018667 C51.1005319,57.7418667 51.0361702,57.7770667 50.9696809,57.8064 C50.9260638,57.8250667 50.8867021,57.8373333 50.8430851,57.8501333 C50.8074468,57.8624 50.7680851,57.8752 50.7308511,57.8773333 C50.7180851,57.8810667 50.7058511,57.8853333 50.6909574,57.8853333 C50.6308511,57.8981333 50.5664894,57.9018667 50.5042553,57.9018667 C50.4441489,57.9018667 50.3835106,57.8981333 50.3255319,57.8853333 C50.3090426,57.8853333 50.2941489,57.8810667 50.2776596,57.8773333 C50.2425532,57.8730667 50.2090426,57.8645333 50.1739362,57.8522667 C50.0904255,57.8272 50.0095745,57.7957333 49.9351064,57.7562667 C49.8702128,57.7210667 49.8079787,57.6773333 49.7521277,57.6293333 C49.7207447,57.6064 49.687766,57.5770667 49.6606383,57.5498667 L45.6234043,53.5018667 C45.1558511,53.0330667 45.1558511,52.2752 45.6234043,51.8064 C46.0909574,51.3376 46.8473404,51.3376 47.3148936,51.8064 L49.3095745,53.8021333 L49.3095745,40.5706667 C49.3095745,39.9104 49.843617,39.3706667 50.506383,39.3706667 C51.1648936,39.3706667 51.7031915,39.9104 51.7031915,40.5706667 L51.7031915,53.8021333 L53.693617,51.8064 C54.1611702,51.3376 54.9212766,51.3376 55.3888298,51.8064 C55.8505319,52.2752 55.8505319,53.0352 55.3851064,53.5018667 Z",
                fill: "#757780"
              }),
              createBaseVNode("rect", {
                stroke: "#979797",
                "stroke-width": "3",
                x: "3",
                y: "3",
                width: "94",
                height: "94",
                rx: "8"
              })
            ],
            -1
            /* CACHED */
          )),
          createBaseVNode(
            "span",
            {
              class: normalizeClass([{ "is-flashing": _ctx.isFileUploading }, "zn_pb_el_uploadicon-progress"])
            },
            toDisplayString(_ctx.uploadProgress),
            3
            /* TEXT, CLASS */
          )
        ],
        2
        /* CLASS */
      ),
      createBaseVNode(
        "input",
        {
          id: "znpb_upload_input",
          onChange: _cache[0] || (_cache[0] = (...args) => $options.importFile && $options.importFile(...args)),
          class: "znpb_upload_input",
          type: "file",
          name: "znpb_template_upload_input"
        },
        null,
        32
        /* NEED_HYDRATION */
      ),
      _cache[2] || (_cache[2] = createBaseVNode(
        "div",
        { class: "zn_pb_el_title" },
        "IMPORT TEMPLATE",
        -1
        /* CACHED */
      ))
    ]);
  }
  const templateImporter = /* @__PURE__ */ _export_sfc(_sfc_main$f, [["render", _sfc_render$e]]);
  const _sfc_main$e = {
    computed: __spreadValues({}, mapGetters(["allTemplates"])),
    data: function() {
      return {
        isOptionsVisible: false,
        templateSaveName: "",
        hasError: false,
        // For template import
        uploadProgress: ""
      };
    },
    components: {
      "znb-templates-single": singleTemplate,
      templateImporter
    },
    methods: {
      checkInputEmpty() {
        if (this.templateSaveName.length == 0) {
          this.hasError = true;
          return false;
        }
        this.hasError = false;
        return true;
      },
      saveTemplate(event) {
        var that = this, fw = jQuery.page_builder;
        if (!this.checkInputEmpty()) {
          return;
        }
        fw.show_page_loading(true);
        var JsonData = fw.build_map(
          jQuery(".zn_pb_wrapper > .zn_pb_section"),
          true
        );
        var data = {
          action: "zn_save_template",
          template_name: that.templateSaveName,
          template: JSON.stringify(JsonData),
          page_options: window.ZnPbData.page_options,
          post_id: window.ZnPbData.postId,
          // TODO: normalize nonces
          security: ZnAjax.security
        };
        jQuery.post(ZnAjax.ajaxurl, data, function(response) {
          if (response.message) {
            new jQuery.ZnModalMessage(response.message);
            that.$store.dispatch("addTemplate", {
              name: that.templateSaveName,
              level: 1
            });
            fw.hide_page_loading(true);
          } else {
            fw.hide_page_loading(true);
            new jQuery.ZnModalMessage(
              "There was a problem saving the template !"
            );
          }
          that.templateSaveName = "";
        });
      },
      exportTemplate() {
        var fw = jQuery.page_builder;
        let template_name = this.templateSaveName;
        if (!this.checkInputEmpty()) {
          return;
        }
        fw.show_page_loading(true);
        var JsonData = fw.build_map(
          jQuery(".zn_pb_wrapper > .zn_pb_section"),
          true
        );
        var data = {
          action: "zn_export_template",
          template_name,
          template: JSON.stringify(JsonData),
          page_options: window.ZnPbData.page_options,
          security: ZnAjax.security
        };
        jQuery.post(ZnAjax.ajaxurl, data, function(response) {
          fw.hide_page_loading(true);
          if (response.success === true) {
            window.showed_message = true;
            location.href = ZnAjax.ajaxurl + "?action=znpb_download_export&file_name=" + template_name + "&nonce=" + ZnAjax.security;
          } else {
            new jQuery.ZnModalMessage(
              "There was a problem exporting the template: " + response.data
            );
            console.error("Error: ", response.data);
          }
        });
      },
      clearPageElements() {
        jQuery.page_builder;
        var that = this, current_layout = jQuery(".zn_pb_wrapper"), all_elements = current_layout.find(".zn_pb_el_container"), reordered = all_elements.get().reverse(), callback = function() {
          if (jQuery(reordered).length > 0) {
            jQuery(reordered).each(function(el) {
              var element_container = jQuery(this).parent();
              jQuery(this).remove();
              if (element_container.children().length < 1) {
                element_container.addClass("zn_pb_no_content");
              }
              if (element_container.has(".ui-sortable")) {
                element_container.sortable("refreshPositions");
                element_container.sortable("refresh");
              }
            });
          }
          that.isOptionsVisible = false;
        };
        new jQuery.ZnModalConfirm(
          "Are you sure you want to remove all the elements on this page?",
          "No",
          "Yes",
          callback
        );
      },
      fileUploadSuccess(response) {
        console.log(response);
        this.$store.dispatch("addTemplate", {
          name: response.name,
          level: response.level,
          isSingle: response.isSingle
        });
      }
    }
  };
  const _hoisted_1$b = {
    id: "zn_pb_templates",
    class: "zn_pb_templates zn_pb_tab"
  };
  const _hoisted_2$8 = { class: "znpbElementsSidebar" };
  const _hoisted_3$2 = { class: "zn_pb_sidebar_more" };
  const _hoisted_4 = { class: "zn_pb_sidebar_more-panel" };
  const _hoisted_5 = { class: "zn_pb_sidebar_btn-wrapper" };
  const _hoisted_6 = { class: "zn_pb_sidebar-inner zn-sidebar-scroll" };
  const _hoisted_7 = { class: "zn_pb_sidebar-content" };
  const _hoisted_8 = { class: "zn_pb_templates_container zn_pb_tab_content" };
  const _hoisted_9 = { class: "znbTemplatesWrapper" };
  function _sfc_render$d(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_template_importer = resolveComponent("template-importer");
    const _component_znb_templates_single = resolveComponent("znb-templates-single");
    return openBlock(), createElementBlock("div", _hoisted_1$b, [
      createBaseVNode("div", _hoisted_2$8, [
        createBaseVNode("div", _hoisted_3$2, [
          createBaseVNode("span", {
            class: "zn_pb_sidebar_more-trig",
            onClick: _cache[0] || (_cache[0] = ($event) => _ctx.isOptionsVisible = !_ctx.isOptionsVisible)
          }, "···"),
          createVNode(Transition, {
            name: "grow",
            persisted: ""
          }, {
            default: withCtx(() => [
              withDirectives(createBaseVNode(
                "div",
                _hoisted_4,
                [
                  createBaseVNode("a", {
                    href: "#",
                    onClick: _cache[1] || (_cache[1] = withModifiers((...args) => $options.clearPageElements && $options.clearPageElements(...args), ["prevent"]))
                  }, _cache[5] || (_cache[5] = [
                    createBaseVNode(
                      "span",
                      { class: "dashicons dashicons-trash" },
                      null,
                      -1
                      /* CACHED */
                    ),
                    createTextVNode(
                      " CLEAR PAGE ELEMENTS",
                      -1
                      /* CACHED */
                    )
                  ]))
                ],
                512
                /* NEED_PATCH */
              ), [
                [vShow, _ctx.isOptionsVisible]
              ])
            ]),
            _: 1
            /* STABLE */
          })
        ]),
        createBaseVNode("div", _hoisted_5, [
          createBaseVNode("span", {
            class: "zn_pb_sidebar_btn zn_pb_save_template",
            onClick: _cache[2] || (_cache[2] = withModifiers((...args) => $options.saveTemplate && $options.saveTemplate(...args), ["prevent"]))
          }, "SAVE"),
          createBaseVNode("span", {
            class: "zn_pb_sidebar_btn zn_pb_export_template",
            onClick: _cache[3] || (_cache[3] = withModifiers((...args) => $options.exportTemplate && $options.exportTemplate(...args), ["prevent"]))
          }, "EXPORT")
        ]),
        createBaseVNode("div", _hoisted_6, [
          createBaseVNode("div", _hoisted_7, [
            _cache[6] || (_cache[6] = createBaseVNode(
              "h4",
              { class: "zn_pb_sidebar-content-title" },
              [
                createTextVNode("Save / Export"),
                createBaseVNode("br"),
                createTextVNode("Template")
              ],
              -1
              /* CACHED */
            )),
            withDirectives(createBaseVNode(
              "input",
              {
                type: "text",
                class: normalizeClass([{ zn_error: _ctx.hasError }, "znpb-template-name-input zn_pb_sidebar-content-input"]),
                "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.templateSaveName = $event),
                placeholder: "Template name"
              },
              null,
              2
              /* CLASS */
            ), [
              [vModelText, _ctx.templateSaveName]
            ])
          ])
        ])
      ]),
      createBaseVNode("div", _hoisted_8, [
        createBaseVNode("div", _hoisted_9, [
          createVNode(_component_template_importer, { onFileUploadSuccess: $options.fileUploadSuccess }, null, 8, ["onFileUploadSuccess"]),
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(_ctx.allTemplates, (element) => {
              return openBlock(), createBlock(_component_znb_templates_single, {
                key: element.name,
                element,
                single: false
              }, null, 8, ["element"]);
            }),
            128
            /* KEYED_FRAGMENT */
          ))
        ])
      ])
    ]);
  }
  const templatesTabContent = /* @__PURE__ */ _export_sfc(_sfc_main$e, [["render", _sfc_render$d]]);
  const _sfc_main$d = {
    computed: __spreadValues({}, mapGetters(["allSavedElements"])),
    data: function() {
      return {
        // For template import
        templateFile: null,
        isFileUploading: false,
        uploadProgress: ""
      };
    },
    components: {
      "znb-templates-single": singleTemplate,
      templateImporter
    },
    methods: {
      fileUploadSuccess(response) {
        this.$store.dispatch("addSavedElement", {
          name: response.name,
          level: response.level
        });
      }
    }
  };
  const _hoisted_1$a = {
    id: "zn_pb_el_templates",
    class: "zn_pb_el_templates zn_pb_tab"
  };
  const _hoisted_2$7 = { class: "zn_pb_templates_container zn_pb_tab_content" };
  const _hoisted_3$1 = { class: "znbTemplatesWrapper" };
  function _sfc_render$c(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_template_importer = resolveComponent("template-importer");
    const _component_znb_templates_single = resolveComponent("znb-templates-single");
    return openBlock(), createElementBlock("div", _hoisted_1$a, [
      _cache[0] || (_cache[0] = createStaticVNode('<div class="znpbElementsSidebar"><div class="zn_pb_sidebar-inner zn-sidebar-scroll"><div class="zn_pb_sidebar-content"><h4 class="zn_pb_sidebar-content-title">Saved elements</h4><div class="zn_pb_sidebar-content-desc"><p>Here you will find all your saved elements. If you want to add a saved element to your page, just dragg it into your desired location.</p></div></div></div></div>', 1)),
      createBaseVNode("div", _hoisted_2$7, [
        createBaseVNode("div", _hoisted_3$1, [
          createVNode(_component_template_importer, {
            onFileUploadSuccess: $options.fileUploadSuccess,
            single: true
          }, null, 8, ["onFileUploadSuccess"]),
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(_ctx.allSavedElements, (element) => {
              return openBlock(), createBlock(_component_znb_templates_single, {
                key: element.name,
                element,
                single: true
              }, null, 8, ["element"]);
            }),
            128
            /* KEYED_FRAGMENT */
          ))
        ])
      ])
    ]);
  }
  const savedElementsTabContent = /* @__PURE__ */ _export_sfc(_sfc_main$d, [["render", _sfc_render$c]]);
  const _sfc_main$c = {
    props: ["icon"],
    data: function() {
      return {
        isPopOverVisible: false
      };
    },
    computed: {
      buttonClasses() {
        let classes = [];
        if (typeof this.icon !== "undefined") {
          classes.push("zn_pb_icon");
          classes.push(this.icon);
        }
        if (this.isPopOverVisible) {
          classes.push("zion-inline-editor-button--active");
        }
        return classes.join(" ");
      }
    }
  };
  const _hoisted_1$9 = { class: "zion-inline-editorPopoverWrapper" };
  const _hoisted_2$6 = {
    key: 0,
    class: "zion-inline-editor-container zion-inline-editor-dropdown zion-inline-editor-dropdown--popover zion-inline-editor-dropdown__arrow--bottom"
  };
  function _sfc_render$b(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", _hoisted_1$9, [
      createBaseVNode(
        "button",
        {
          class: normalizeClass(["zion-inline-editor-button", $options.buttonClasses]),
          name: "Text Align",
          onClick: _cache[0] || (_cache[0] = withModifiers(($event) => _ctx.isPopOverVisible = !_ctx.isPopOverVisible, ["prevent"]))
        },
        null,
        2
        /* CLASS */
      ),
      createVNode(Transition, { name: "bar-show" }, {
        default: withCtx(() => [
          _ctx.isPopOverVisible ? (openBlock(), createElementBlock("div", _hoisted_2$6, [
            renderSlot(_ctx.$slots, "default")
          ])) : createCommentVNode("v-if", true)
        ]),
        _: 3
        /* FORWARDED */
      })
    ]);
  }
  const popOver = /* @__PURE__ */ _export_sfc(_sfc_main$c, [["render", _sfc_render$b]]);
  const _sfc_main$b = {
    props: ["icon", "buttontext", "direction"],
    data: function() {
      return {
        isPanelvisibile: false
      };
    },
    computed: {
      buttonClasses() {
        let classes = [];
        if (typeof this.icon !== "undefined") {
          classes.push("zn_pb_icon");
          classes.push(this.icon);
        }
        if (this.isPanelvisibile) {
          classes.push("zion-inline-editor-button--active");
        }
        return classes.join(" ");
      },
      classes() {
        let classes = [];
        if (typeof this.direction !== "undefined") {
          classes.push("zion-inline-editor-dropdown--panel--direction-row");
        }
        return classes.join(" ");
      }
    },
    methods: {
      togglePanel() {
        if (this.isPanelvisibile) {
          this.hide_panel();
        } else {
          this.show_panel();
        }
      },
      show_panel() {
        this.isPanelvisibile = true;
        this.$emit("open-panel", this);
      },
      hide_panel() {
        this.isPanelvisibile = false;
        this.$emit("close-panel", this);
      },
      getPanelVisibility() {
        return this.isPanelvisibile;
      }
    }
  };
  const _hoisted_1$8 = { class: "zion-inline-editor-panel-wrapper" };
  function _sfc_render$a(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", _hoisted_1$8, [
      createBaseVNode(
        "button",
        {
          class: normalizeClass(["zion-inline-editor-button", $options.buttonClasses]),
          onClick: _cache[0] || (_cache[0] = ($event) => $options.togglePanel())
        },
        toDisplayString($props.buttontext),
        3
        /* TEXT, CLASS */
      ),
      createVNode(Transition, { name: "panel-show" }, {
        default: withCtx(() => [
          _ctx.isPanelvisibile ? (openBlock(), createElementBlock(
            "div",
            {
              key: 0,
              class: normalizeClass([$options.classes, "zion-inline-editor-container zion-inline-editor-dropdown zion-inline-editor-dropdown--panel"])
            },
            [
              renderSlot(_ctx.$slots, "default")
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true)
        ]),
        _: 3
        /* FORWARDED */
      })
    ]);
  }
  const panel = /* @__PURE__ */ _export_sfc(_sfc_main$b, [["render", _sfc_render$a]]);
  function getDefaultExportFromCjs(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
  }
  function getAugmentedNamespace(n) {
    if (n.__esModule) return n;
    var f = n.default;
    if (typeof f == "function") {
      var a = function a2() {
        if (this instanceof a2) {
          return Reflect.construct(f, arguments, this.constructor);
        }
        return f.apply(this, arguments);
      };
      a.prototype = f.prototype;
    } else a = {};
    Object.defineProperty(a, "__esModule", { value: true });
    Object.keys(n).forEach(function(k) {
      var d = Object.getOwnPropertyDescriptor(n, k);
      Object.defineProperty(a, k, d.get ? d : {
        enumerable: true,
        get: function() {
          return n[k];
        }
      });
    });
    return a;
  }
  /*!
   * vue-range-slider v0.6.0
   * https://github.com/ktsn/vue-range-slider
   *
   * @license
   * Copyright (c) 2016-2018 katashin
   * Released under the MIT license
   * https://github.com/ktsn/vue-range-slider/blob/master/LICENSE
   */
  var DocumentEventHelper = {
    created: function created() {
      if (typeof document === "undefined") return;
      forEachListener(this, function(key, listener) {
        on(document, key, listener);
      });
    },
    beforeDestroy: function beforeDestroy() {
      if (typeof document === "undefined") return;
      forEachListener(this, function(key, listener) {
        off(document, key, listener);
      });
    }
  };
  var isBrowser = typeof window !== "undefined";
  var hasPassive = isBrowser && function() {
    var supported2 = false;
    try {
      var desc = {
        get: function get() {
          supported2 = true;
        }
      };
      var opts = Object.defineProperty({}, "passive", desc);
      window.addEventListener("test", null, opts);
      window.removeEventListener("test", null, opts);
    } catch (e) {
      supported2 = false;
    }
    return supported2;
  }();
  function forEachListener(vm, f) {
    var events = vm.$options.events;
    Object.keys(events).forEach(function(key) {
      f(key, function(event) {
        return events[key].call(vm, event);
      });
    });
  }
  function on(el, name, fn) {
    var options = hasPassive ? { passive: false } : void 0;
    el.addEventListener(name, fn, options);
  }
  function off(el, name, fn) {
    var options = hasPassive ? { passive: false } : void 0;
    el.removeEventListener(name, fn, options);
  }
  function relativeMouseOffset(offset, base) {
    var bounds = base.getBoundingClientRect();
    return {
      left: offset.clientX - bounds.left,
      top: offset.clientY - bounds.top
    };
  }
  function round(value, min, max, step) {
    if (value <= min) {
      return min;
    }
    var roundedMax = Math.floor((max - min) / step) * step + min;
    if (value >= roundedMax) {
      return roundedMax;
    }
    var normalize = (value - min) / step;
    var decimal = Math.floor(normalize);
    var fraction = normalize - decimal;
    if (fraction === 0) return value;
    if (fraction < 0.5) {
      return step * decimal + min;
    } else {
      return step * (decimal + 1) + min;
    }
  }
  var DragHelper = {
    mixins: [DocumentEventHelper],
    props: {
      disabled: Boolean
    },
    data: function data() {
      return {
        isDrag: false
      };
    },
    events: {
      mousedown: function mousedown(event) {
        return this.dragStart(event, this.offsetByMouse);
      },
      mousemove: function mousemove(event) {
        return this.dragMove(event, this.offsetByMouse);
      },
      mouseup: function mouseup(event) {
        return this.dragEnd(event, this.offsetByMouse);
      },
      touchstart: function touchstart(event) {
        return this.dragStart(event, this.offsetByTouch);
      },
      touchmove: function touchmove(event) {
        return this.dragMove(event, this.offsetByTouch);
      },
      touchend: function touchend(event) {
        return this.dragEnd(event, this.offsetByTouch);
      },
      touchcancel: function touchcancel(event) {
        return this.dragEnd(event, this.offsetByTouch);
      }
    },
    methods: {
      isInTarget: function isInTarget(el) {
        if (!el) return false;
        if (el === this.$el) {
          return true;
        } else {
          return this.isInTarget(el.parentElement);
        }
      },
      offsetByMouse: function offsetByMouse(event) {
        return relativeMouseOffset(event, this.$el);
      },
      offsetByTouch: function offsetByTouch(event) {
        var touch = event.touches.length === 0 ? event.changedTouches[0] : event.touches[0];
        return relativeMouseOffset(touch, this.$el);
      },
      dragStart: function dragStart(event, f) {
        if (this.disabled || event.button !== void 0 && event.button !== 0 || !this.isInTarget(event.target)) {
          return;
        }
        event.preventDefault();
        this.isDrag = true;
        this.$emit("dragstart", event, f(event), this.$el);
      },
      dragMove: function dragMove(event, f) {
        if (!this.isDrag) return;
        event.preventDefault();
        this.$emit("drag", event, f(event), this.$el);
      },
      dragEnd: function dragEnd(event, f) {
        if (!this.isDrag) return;
        event.preventDefault();
        this.isDrag = false;
        this.$emit("dragend", event, f(event), this.$el);
      }
    },
    render: function render() {
      return this.$slots.default && this.$slots.default[0];
    }
  };
  var RangeSlider = {
    render: function render() {
      var _vm = this;
      var _h = _vm.$createElement;
      var _c = _vm._self._c || _h;
      return _c("span", { staticClass: "range-slider", class: { disabled: _vm.disabled } }, [_c("drag-helper", { attrs: { "disabled": _vm.disabled }, on: { "dragstart": _vm.dragStart, "drag": _vm.drag, "dragend": _vm.dragEnd } }, [_c("span", { ref: "inner", staticClass: "range-slider-inner" }, [_c("input", { staticClass: "range-slider-hidden", attrs: { "type": "text", "name": _vm.name, "disabled": _vm.disabled }, domProps: { "value": _vm.actualValue } }), _vm._v(" "), _c("span", { staticClass: "range-slider-rail" }), _vm._v(" "), _c("span", { staticClass: "range-slider-fill", style: { width: _vm.valuePercent + "%" } }), _vm._v(" "), _c("span", { ref: "knob", staticClass: "range-slider-knob", style: { left: _vm.valuePercent + "%" } }, [_vm._t("knob")], 2)])])], 1);
    },
    staticRenderFns: [],
    props: {
      name: String,
      value: [String, Number],
      disabled: {
        type: Boolean,
        default: false
      },
      min: {
        type: [String, Number],
        default: 0
      },
      max: {
        type: [String, Number],
        default: 100
      },
      step: {
        type: [String, Number],
        default: 1
      }
    },
    data: function data() {
      return {
        actualValue: null,
        dragStartValue: null
      };
    },
    created: function created() {
      var min = this._min, max = this._max;
      var defaultValue = Number(this.value);
      if (this.value == null || isNaN(defaultValue)) {
        if (min > max) {
          defaultValue = min;
        } else {
          defaultValue = (min + max) / 2;
        }
      }
      this.actualValue = this.round(defaultValue);
    },
    computed: {
      _min: function _min() {
        return Number(this.min);
      },
      _max: function _max() {
        return Number(this.max);
      },
      _step: function _step() {
        return Number(this.step);
      },
      valuePercent: function valuePercent() {
        return (this.actualValue - this._min) / (this._max - this._min) * 100;
      }
    },
    watch: {
      value: function value(newValue) {
        var value2 = Number(newValue);
        if (newValue != null && !isNaN(value2)) {
          this.actualValue = this.round(value2);
        }
      },
      min: function min() {
        this.actualValue = this.round(this.actualValue);
      },
      max: function max() {
        this.actualValue = this.round(this.actualValue);
      }
    },
    methods: {
      dragStart: function dragStart(event, offset) {
        this.dragStartValue = this.actualValue;
        if (event.target === this.$refs.knob) {
          return;
        }
        this.drag(event, offset);
      },
      drag: function drag(event, offset) {
        var offsetWidth = this.$refs.inner.offsetWidth;
        this.actualValue = this.round(this.valueFromBounds(offset.left, offsetWidth));
        this.emitInput(this.actualValue);
      },
      dragEnd: function dragEnd(event, offset) {
        var offsetWidth = this.$refs.inner.offsetWidth;
        this.actualValue = this.round(this.valueFromBounds(offset.left, offsetWidth));
        if (this.dragStartValue !== this.actualValue) {
          this.emitChange(this.actualValue);
        }
      },
      emitInput: function emitInput(value) {
        this.$emit("input", value);
      },
      emitChange: function emitChange(value) {
        this.$emit("change", value);
      },
      valueFromBounds: function valueFromBounds(point, width) {
        return point / width * (this._max - this._min) + this._min;
      },
      round: function round$$1(value) {
        return round(value, this._min, this._max, this._step);
      }
    },
    components: {
      DragHelper
    }
  };
  var vueRangeSlider_cjs = RangeSlider;
  const RangeSlider$1 = /* @__PURE__ */ getDefaultExportFromCjs(vueRangeSlider_cjs);
  const _sfc_main$a = {
    data() {
      return {
        sliderValue: 16
      };
    },
    components: {
      RangeSlider: RangeSlider$1
    },
    beforeMount: function() {
      tinymce.activeEditor.on("NodeChange", this.onNodeChange);
      this.getFontSize(tinymce.activeEditor.selection.getNode());
    },
    beforeDestroy() {
      tinymce.activeEditor.off("NodeChange", this.onNodeChange);
    },
    methods: {
      onNodeChange(node) {
        this.getFontSize(node.element);
      },
      getFontSize(node) {
        let fontSize2 = window.getComputedStyle(node).getPropertyValue("font-size");
        this.sliderValue = parseFloat(fontSize2);
      }
    },
    watch: {
      sliderValue: function(value) {
        tinymce.activeEditor.formatter.apply("fontsize", { value: value + "px" });
      }
    }
  };
  const _hoisted_1$7 = { class: "zion-inline-editor-sliderArea" };
  const _hoisted_2$5 = { class: "zion-inline-editor-sliderArea--value" };
  function _sfc_render$9(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_range_slider = resolveComponent("range-slider");
    return openBlock(), createElementBlock("div", _hoisted_1$7, [
      createBaseVNode(
        "span",
        _hoisted_2$5,
        toDisplayString($data.sliderValue),
        1
        /* TEXT */
      ),
      _cache[1] || (_cache[1] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--smallValue" },
        "A",
        -1
        /* CACHED */
      )),
      createVNode(_component_range_slider, {
        class: "zion-inline-editor-sliderArea--slider",
        min: "0",
        max: "100",
        step: "1",
        modelValue: $data.sliderValue,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.sliderValue = $event)
      }, null, 8, ["modelValue"]),
      _cache[2] || (_cache[2] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--bigValue" },
        "A",
        -1
        /* CACHED */
      ))
    ]);
  }
  const fontSize = /* @__PURE__ */ _export_sfc(_sfc_main$a, [["render", _sfc_render$9]]);
  const _sfc_main$9 = {
    data() {
      return {
        sliderValue: 16
      };
    },
    components: {
      RangeSlider: RangeSlider$1
    },
    beforeMount: function() {
      tinymce.activeEditor.on("NodeChange", this.onNodeChange);
      this.getLineHeight(tinymce.activeEditor.selection.getNode());
    },
    beforeDestroy() {
      tinymce.activeEditor.off("NodeChange", this.onNodeChange);
    },
    methods: {
      onNodeChange(node) {
        this.getLineHeight(node.element);
      },
      getLineHeight(node) {
        let lineHeight2 = window.getComputedStyle(node).getPropertyValue("line-height");
        this.sliderValue = parseFloat(lineHeight2);
      }
    },
    watch: {
      sliderValue: function(value) {
        tinymce.activeEditor.formatter.apply("lineheight", { value: value + "px" });
      }
    }
  };
  const _hoisted_1$6 = { class: "zion-inline-editor-sliderArea" };
  const _hoisted_2$4 = { class: "zion-inline-editor-sliderArea--value" };
  function _sfc_render$8(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_range_slider = resolveComponent("range-slider");
    return openBlock(), createElementBlock("div", _hoisted_1$6, [
      createBaseVNode(
        "span",
        _hoisted_2$4,
        toDisplayString($data.sliderValue),
        1
        /* TEXT */
      ),
      _cache[1] || (_cache[1] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--smallValue" },
        "-",
        -1
        /* CACHED */
      )),
      createVNode(_component_range_slider, {
        class: "zion-inline-editor-sliderArea--slider",
        min: "0",
        max: "100",
        step: "1",
        modelValue: $data.sliderValue,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.sliderValue = $event)
      }, null, 8, ["modelValue"]),
      _cache[2] || (_cache[2] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--bigValue" },
        "+",
        -1
        /* CACHED */
      ))
    ]);
  }
  const lineHeight = /* @__PURE__ */ _export_sfc(_sfc_main$9, [["render", _sfc_render$8]]);
  const _sfc_main$8 = {
    data() {
      return {
        sliderValue: 16
      };
    },
    components: {
      RangeSlider: RangeSlider$1
    },
    beforeMount: function() {
      tinymce.activeEditor.on("NodeChange", this.onNodeChange);
      this.getLetterSpacing(tinymce.activeEditor.selection.getNode());
    },
    beforeDestroy() {
      tinymce.activeEditor.off("NodeChange", this.onNodeChange);
    },
    methods: {
      onNodeChange(node) {
        this.getLetterSpacing(node.element);
      },
      getLetterSpacing(node) {
        let letterSpacing2 = window.getComputedStyle(node).getPropertyValue("letter-spacing");
        this.sliderValue = isNaN(parseFloat(letterSpacing2)) ? 0 : parseFloat(letterSpacing2);
      }
    },
    watch: {
      sliderValue: function(value) {
        tinymce.activeEditor.formatter.apply("letterspacing", { value: value + "px" });
      }
    }
  };
  const _hoisted_1$5 = { class: "zion-inline-editor-sliderArea" };
  const _hoisted_2$3 = { class: "zion-inline-editor-sliderArea--value" };
  function _sfc_render$7(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_range_slider = resolveComponent("range-slider");
    return openBlock(), createElementBlock("div", _hoisted_1$5, [
      createBaseVNode(
        "span",
        _hoisted_2$3,
        toDisplayString($data.sliderValue),
        1
        /* TEXT */
      ),
      _cache[1] || (_cache[1] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--smallValue" },
        "-",
        -1
        /* CACHED */
      )),
      createVNode(_component_range_slider, {
        class: "zion-inline-editor-sliderArea--slider",
        min: "0",
        max: "100",
        step: "1",
        modelValue: $data.sliderValue,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => $data.sliderValue = $event)
      }, null, 8, ["modelValue"]),
      _cache[2] || (_cache[2] = createBaseVNode(
        "span",
        { class: "zion-inline-editor-sliderArea--bigValue" },
        "+",
        -1
        /* CACHED */
      ))
    ]);
  }
  const letterSpacing = /* @__PURE__ */ _export_sfc(_sfc_main$8, [["render", _sfc_render$7]]);
  const _sfc_main$7 = {
    props: ["formatter", "icon", "buttontext", "value"],
    data: function() {
      return {
        isActive: null
      };
    },
    computed: {
      classses() {
        let classes = [];
        if (typeof this.icon !== "undefined") {
          classes.push("zn_pb_icon");
          classes.push(this.icon);
        }
        if (this.isActive) {
          classes.push("zion-inline-editor-button--active");
        }
        return classes.join(" ");
      }
    },
    beforeMount: function() {
      var self2 = this;
      tinymce.activeEditor.formatter.formatChanged(this.formatter, function(state2, args) {
        self2.isActive = state2;
      });
      this.isActive = this.hasFormat(this.formatter);
    },
    methods: {
      // Apply button style
      setTextStyle(styleType, event) {
        tinymce.activeEditor.formatter.toggle(styleType);
      },
      // Check if the selection has a specific style applied
      hasFormat(styleType) {
        return tinymce.activeEditor.formatter.match(styleType);
      }
    }
  };
  function _sfc_render$6(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock(
      "button",
      {
        class: normalizeClass(["zion-inline-editor-button", $options.classses]),
        onClick: _cache[0] || (_cache[0] = ($event) => $options.setTextStyle($props.formatter))
      },
      toDisplayString($props.buttontext),
      3
      /* TEXT, CLASS */
    );
  }
  const buttonComponent = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["render", _sfc_render$6]]);
  const _sfc_main$6 = {
    props: ["direction"],
    data: function() {
      return {
        panels: [],
        active_panel: ""
      };
    },
    components: {
      "zion-inline-editor-font-size": fontSize,
      "zion-inline-editor-line-height": lineHeight,
      "zion-inline-editor-letter-spacing": letterSpacing,
      "zion-inline-editor-panel": panel,
      "zion-inline-editor-button": buttonComponent
    },
    created() {
      this.panels = this.$children;
    },
    methods: {
      closeOtherPanels: function(clickedPanel) {
        this.panels.forEach((element) => {
          if (element !== clickedPanel) {
            element.hide_panel();
          }
        });
      }
    }
  };
  const _hoisted_1$4 = { class: "zion-inline-editor-container" };
  function _sfc_render$5(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_zion_inline_editor_font_size = resolveComponent("zion-inline-editor-font-size");
    const _component_zion_inline_editor_panel = resolveComponent("zion-inline-editor-panel");
    const _component_zion_inline_editor_button = resolveComponent("zion-inline-editor-button");
    const _component_zion_inline_editor_line_height = resolveComponent("zion-inline-editor-line-height");
    const _component_zion_inline_editor_letter_spacing = resolveComponent("zion-inline-editor-letter-spacing");
    return openBlock(), createElementBlock("div", _hoisted_1$4, [
      createCommentVNode(" TODO: find an icon for this "),
      createVNode(_component_zion_inline_editor_panel, {
        icon: "znpb_icon-text-height",
        onOpenPanel: $options.closeOtherPanels
      }, {
        default: withCtx(() => [
          createVNode(_component_zion_inline_editor_font_size)
        ]),
        _: 1
        /* STABLE */
      }, 8, ["onOpenPanel"]),
      createVNode(_component_zion_inline_editor_panel, {
        buttontext: "H1",
        direction: "row",
        onOpenPanel: $options.closeOtherPanels
      }, {
        default: withCtx(() => [
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h1",
            buttontext: "H1"
          }),
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h2",
            buttontext: "H2"
          }),
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h3",
            buttontext: "H3"
          }),
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h4",
            buttontext: "H4"
          }),
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h5",
            buttontext: "H5"
          }),
          createVNode(_component_zion_inline_editor_button, {
            formatter: "h6",
            buttontext: "H6"
          })
        ]),
        _: 1
        /* STABLE */
      }, 8, ["onOpenPanel"]),
      createVNode(_component_zion_inline_editor_panel, {
        icon: "znpb_icon-resize-vertical",
        onOpenPanel: $options.closeOtherPanels
      }, {
        default: withCtx(() => [
          createVNode(_component_zion_inline_editor_line_height)
        ]),
        _: 1
        /* STABLE */
      }, 8, ["onOpenPanel"]),
      createVNode(_component_zion_inline_editor_panel, {
        icon: "znpb_icon-resize-horizontal",
        onOpenPanel: $options.closeOtherPanels
      }, {
        default: withCtx(() => [
          createVNode(_component_zion_inline_editor_letter_spacing)
        ]),
        _: 1
        /* STABLE */
      }, 8, ["onOpenPanel"])
    ]);
  }
  const group = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["render", _sfc_render$5]]);
  const _sfc_main$5 = {
    data: function() {
      return {
        fontsList: window.ZnPbData.fonts_list,
        activeFont: null
      };
    },
    beforeMount: function() {
      var self2 = this;
      tinymce.activeEditor.formatter.formatChanged("fontname", function(state2, args) {
        self2.activeFont = args.node.style["fontFamily"];
      }, true);
      this.activeFont = this.getFont();
    },
    methods: {
      isActive(fontName) {
        return this.activeFont == fontName ? "zion-inline-editor__font-list-item--active" : "";
      },
      changeFont(fontName, event) {
        this.activeFont = fontName;
        tinymce.activeEditor.formatter.toggle("fontname", {
          value: fontName
        });
      },
      getCurrentFont() {
        var fontFamily;
        tinymce.activeEditor.dom.getParents(tinymce.activeEditor.selection.getStart(), function(elm) {
          var value;
          if (value = elm.style["fontFamily"]) {
            fontFamily = value;
          }
        });
        return fontFamily;
      },
      // Check if the selection has a specific style applied
      hasFormat(fontFamily) {
        return tinymce.activeEditor.formatter.match("", {
          value: fontFamily
        });
      },
      getFont() {
        return tinymce.activeEditor.formatter.get("fontFamily");
      }
    }
  };
  const _hoisted_1$3 = { class: "zion-inline-editor-container zion-inline-editor__font-panel" };
  const _hoisted_2$2 = { class: "zion-inline-editor__font-list" };
  const _hoisted_3 = ["onClick"];
  function _sfc_render$4(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock("div", _hoisted_1$3, [
      createBaseVNode("ul", _hoisted_2$2, [
        (openBlock(true), createElementBlock(
          Fragment,
          null,
          renderList(_ctx.fontsList, (fontName) => {
            return openBlock(), createElementBlock("li", {
              onClick: ($event) => $options.changeFont(fontName, $event)
            }, [
              createBaseVNode(
                "button",
                {
                  class: normalizeClass(["zion-inline-editor__font-list-item", { "zion-inline-editor__font-list-item--active": $options.isActive(fontName) }])
                },
                toDisplayString(fontName),
                3
                /* TEXT, CLASS */
              )
            ], 8, _hoisted_3);
          }),
          256
          /* UNKEYED_FRAGMENT */
        ))
      ])
    ]);
  }
  const fontList = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["render", _sfc_render$4]]);
  function ve(e) {
    "@babel/helpers - typeof";
    return ve = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(t) {
      return typeof t;
    } : function(t) {
      return t && typeof Symbol == "function" && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t;
    }, ve(e);
  }
  var Ke = /^\s+/, ze = /\s+$/;
  function g(e, t) {
    if (e = e || "", t = t || {}, e instanceof g)
      return e;
    if (!(this instanceof g))
      return new g(e, t);
    var a = je(e);
    this._originalInput = e, this._r = a.r, this._g = a.g, this._b = a.b, this._a = a.a, this._roundA = Math.round(100 * this._a) / 100, this._format = t.format || a.format, this._gradientType = t.gradientType, this._r < 1 && (this._r = Math.round(this._r)), this._g < 1 && (this._g = Math.round(this._g)), this._b < 1 && (this._b = Math.round(this._b)), this._ok = a.ok;
  }
  g.prototype = {
    isDark: function() {
      return this.getBrightness() < 128;
    },
    isLight: function() {
      return !this.isDark();
    },
    isValid: function() {
      return this._ok;
    },
    getOriginalInput: function() {
      return this._originalInput;
    },
    getFormat: function() {
      return this._format;
    },
    getAlpha: function() {
      return this._a;
    },
    getBrightness: function() {
      var t = this.toRgb();
      return (t.r * 299 + t.g * 587 + t.b * 114) / 1e3;
    },
    getLuminance: function() {
      var t = this.toRgb(), a, r, l, n, i, o;
      return a = t.r / 255, r = t.g / 255, l = t.b / 255, a <= 0.03928 ? n = a / 12.92 : n = Math.pow((a + 0.055) / 1.055, 2.4), r <= 0.03928 ? i = r / 12.92 : i = Math.pow((r + 0.055) / 1.055, 2.4), l <= 0.03928 ? o = l / 12.92 : o = Math.pow((l + 0.055) / 1.055, 2.4), 0.2126 * n + 0.7152 * i + 0.0722 * o;
    },
    setAlpha: function(t) {
      return this._a = Ne(t), this._roundA = Math.round(100 * this._a) / 100, this;
    },
    toHsv: function() {
      var t = Re(this._r, this._g, this._b);
      return {
        h: t.h * 360,
        s: t.s,
        v: t.v,
        a: this._a
      };
    },
    toHsvString: function() {
      var t = Re(this._r, this._g, this._b), a = Math.round(t.h * 360), r = Math.round(t.s * 100), l = Math.round(t.v * 100);
      return this._a == 1 ? "hsv(" + a + ", " + r + "%, " + l + "%)" : "hsva(" + a + ", " + r + "%, " + l + "%, " + this._roundA + ")";
    },
    toHsl: function() {
      var t = Me(this._r, this._g, this._b);
      return {
        h: t.h * 360,
        s: t.s,
        l: t.l,
        a: this._a
      };
    },
    toHslString: function() {
      var t = Me(this._r, this._g, this._b), a = Math.round(t.h * 360), r = Math.round(t.s * 100), l = Math.round(t.l * 100);
      return this._a == 1 ? "hsl(" + a + ", " + r + "%, " + l + "%)" : "hsla(" + a + ", " + r + "%, " + l + "%, " + this._roundA + ")";
    },
    toHex: function(t) {
      return Ve(this._r, this._g, this._b, t);
    },
    toHexString: function(t) {
      return "#" + this.toHex(t);
    },
    toHex8: function(t) {
      return qe(this._r, this._g, this._b, this._a, t);
    },
    toHex8String: function(t) {
      return "#" + this.toHex8(t);
    },
    toRgb: function() {
      return {
        r: Math.round(this._r),
        g: Math.round(this._g),
        b: Math.round(this._b),
        a: this._a
      };
    },
    toRgbString: function() {
      return this._a == 1 ? "rgb(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ")" : "rgba(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ", " + this._roundA + ")";
    },
    toPercentageRgb: function() {
      return {
        r: Math.round(L(this._r, 255) * 100) + "%",
        g: Math.round(L(this._g, 255) * 100) + "%",
        b: Math.round(L(this._b, 255) * 100) + "%",
        a: this._a
      };
    },
    toPercentageRgbString: function() {
      return this._a == 1 ? "rgb(" + Math.round(L(this._r, 255) * 100) + "%, " + Math.round(L(this._g, 255) * 100) + "%, " + Math.round(L(this._b, 255) * 100) + "%)" : "rgba(" + Math.round(L(this._r, 255) * 100) + "%, " + Math.round(L(this._g, 255) * 100) + "%, " + Math.round(L(this._b, 255) * 100) + "%, " + this._roundA + ")";
    },
    toName: function() {
      return this._a === 0 ? "transparent" : this._a < 1 ? false : it[Ve(this._r, this._g, this._b, true)] || false;
    },
    toFilter: function(t) {
      var a = "#" + He(this._r, this._g, this._b, this._a), r = a, l = this._gradientType ? "GradientType = 1, " : "";
      if (t) {
        var n = g(t);
        r = "#" + He(n._r, n._g, n._b, n._a);
      }
      return "progid:DXImageTransform.Microsoft.gradient(" + l + "startColorstr=" + a + ",endColorstr=" + r + ")";
    },
    toString: function(t) {
      var a = !!t;
      t = t || this._format;
      var r = false, l = this._a < 1 && this._a >= 0, n = !a && l && (t === "hex" || t === "hex6" || t === "hex3" || t === "hex4" || t === "hex8" || t === "name");
      return n ? t === "name" && this._a === 0 ? this.toName() : this.toRgbString() : (t === "rgb" && (r = this.toRgbString()), t === "prgb" && (r = this.toPercentageRgbString()), (t === "hex" || t === "hex6") && (r = this.toHexString()), t === "hex3" && (r = this.toHexString(true)), t === "hex4" && (r = this.toHex8String(true)), t === "hex8" && (r = this.toHex8String()), t === "name" && (r = this.toName()), t === "hsl" && (r = this.toHslString()), t === "hsv" && (r = this.toHsvString()), r || this.toHexString());
    },
    clone: function() {
      return g(this.toString());
    },
    _applyModification: function(t, a) {
      var r = t.apply(null, [this].concat([].slice.call(a)));
      return this._r = r._r, this._g = r._g, this._b = r._b, this.setAlpha(r._a), this;
    },
    lighten: function() {
      return this._applyModification(et, arguments);
    },
    brighten: function() {
      return this._applyModification(tt, arguments);
    },
    darken: function() {
      return this._applyModification(at, arguments);
    },
    desaturate: function() {
      return this._applyModification(Ze, arguments);
    },
    saturate: function() {
      return this._applyModification(Je, arguments);
    },
    greyscale: function() {
      return this._applyModification(Qe, arguments);
    },
    spin: function() {
      return this._applyModification(lt, arguments);
    },
    _applyCombination: function(t, a) {
      return t.apply(null, [this].concat([].slice.call(a)));
    },
    analogous: function() {
      return this._applyCombination(ot, arguments);
    },
    complement: function() {
      return this._applyCombination(nt, arguments);
    },
    monochromatic: function() {
      return this._applyCombination(st, arguments);
    },
    splitcomplement: function() {
      return this._applyCombination(rt, arguments);
    },
    // Disabled until https://github.com/bgrins/TinyColor/issues/254
    // polyad: function (number) {
    //   return this._applyCombination(polyad, [number]);
    // },
    triad: function() {
      return this._applyCombination(Be, [3]);
    },
    tetrad: function() {
      return this._applyCombination(Be, [4]);
    }
  };
  g.fromRatio = function(e, t) {
    if (ve(e) == "object") {
      var a = {};
      for (var r in e)
        e.hasOwnProperty(r) && (r === "a" ? a[r] = e[r] : a[r] = ue(e[r]));
      e = a;
    }
    return g(e, t);
  };
  function je(e) {
    var t = {
      r: 0,
      g: 0,
      b: 0
    }, a = 1, r = null, l = null, n = null, i = false, o = false;
    return typeof e == "string" && (e = ft(e)), ve(e) == "object" && (Y(e.r) && Y(e.g) && Y(e.b) ? (t = Xe(e.r, e.g, e.b), i = true, o = String(e.r).substr(-1) === "%" ? "prgb" : "rgb") : Y(e.h) && Y(e.s) && Y(e.v) ? (r = ue(e.s), l = ue(e.v), t = We(e.h, r, l), i = true, o = "hsv") : Y(e.h) && Y(e.s) && Y(e.l) && (r = ue(e.s), n = ue(e.l), t = Ye(e.h, r, n), i = true, o = "hsl"), e.hasOwnProperty("a") && (a = e.a)), a = Ne(a), {
      ok: i,
      format: e.format || o,
      r: Math.min(255, Math.max(t.r, 0)),
      g: Math.min(255, Math.max(t.g, 0)),
      b: Math.min(255, Math.max(t.b, 0)),
      a
    };
  }
  function Xe(e, t, a) {
    return {
      r: L(e, 255) * 255,
      g: L(t, 255) * 255,
      b: L(a, 255) * 255
    };
  }
  function Me(e, t, a) {
    e = L(e, 255), t = L(t, 255), a = L(a, 255);
    var r = Math.max(e, t, a), l = Math.min(e, t, a), n, i, o = (r + l) / 2;
    if (r == l)
      n = i = 0;
    else {
      var f = r - l;
      switch (i = o > 0.5 ? f / (2 - r - l) : f / (r + l), r) {
        case e:
          n = (t - a) / f + (t < a ? 6 : 0);
          break;
        case t:
          n = (a - e) / f + 2;
          break;
        case a:
          n = (e - t) / f + 4;
          break;
      }
      n /= 6;
    }
    return {
      h: n,
      s: i,
      l: o
    };
  }
  function Ye(e, t, a) {
    var r, l, n;
    e = L(e, 360), t = L(t, 100), a = L(a, 100);
    function i(s, c, p2) {
      return p2 < 0 && (p2 += 1), p2 > 1 && (p2 -= 1), p2 < 1 / 6 ? s + (c - s) * 6 * p2 : p2 < 1 / 2 ? c : p2 < 2 / 3 ? s + (c - s) * (2 / 3 - p2) * 6 : s;
    }
    if (t === 0)
      r = l = n = a;
    else {
      var o = a < 0.5 ? a * (1 + t) : a + t - a * t, f = 2 * a - o;
      r = i(f, o, e + 1 / 3), l = i(f, o, e), n = i(f, o, e - 1 / 3);
    }
    return {
      r: r * 255,
      g: l * 255,
      b: n * 255
    };
  }
  function Re(e, t, a) {
    e = L(e, 255), t = L(t, 255), a = L(a, 255);
    var r = Math.max(e, t, a), l = Math.min(e, t, a), n, i, o = r, f = r - l;
    if (i = r === 0 ? 0 : f / r, r == l)
      n = 0;
    else {
      switch (r) {
        case e:
          n = (t - a) / f + (t < a ? 6 : 0);
          break;
        case t:
          n = (a - e) / f + 2;
          break;
        case a:
          n = (e - t) / f + 4;
          break;
      }
      n /= 6;
    }
    return {
      h: n,
      s: i,
      v: o
    };
  }
  function We(e, t, a) {
    e = L(e, 360) * 6, t = L(t, 100), a = L(a, 100);
    var r = Math.floor(e), l = e - r, n = a * (1 - t), i = a * (1 - l * t), o = a * (1 - (1 - l) * t), f = r % 6, s = [a, i, n, n, o, a][f], c = [o, a, a, i, n, n][f], p2 = [n, n, o, a, a, i][f];
    return {
      r: s * 255,
      g: c * 255,
      b: p2 * 255
    };
  }
  function Ve(e, t, a, r) {
    var l = [z(Math.round(e).toString(16)), z(Math.round(t).toString(16)), z(Math.round(a).toString(16))];
    return r && l[0].charAt(0) == l[0].charAt(1) && l[1].charAt(0) == l[1].charAt(1) && l[2].charAt(0) == l[2].charAt(1) ? l[0].charAt(0) + l[1].charAt(0) + l[2].charAt(0) : l.join("");
  }
  function qe(e, t, a, r, l) {
    var n = [z(Math.round(e).toString(16)), z(Math.round(t).toString(16)), z(Math.round(a).toString(16)), z(Te(r))];
    return l && n[0].charAt(0) == n[0].charAt(1) && n[1].charAt(0) == n[1].charAt(1) && n[2].charAt(0) == n[2].charAt(1) && n[3].charAt(0) == n[3].charAt(1) ? n[0].charAt(0) + n[1].charAt(0) + n[2].charAt(0) + n[3].charAt(0) : n.join("");
  }
  function He(e, t, a, r) {
    var l = [z(Te(r)), z(Math.round(e).toString(16)), z(Math.round(t).toString(16)), z(Math.round(a).toString(16))];
    return l.join("");
  }
  g.equals = function(e, t) {
    return !e || !t ? false : g(e).toRgbString() == g(t).toRgbString();
  };
  g.random = function() {
    return g.fromRatio({
      r: Math.random(),
      g: Math.random(),
      b: Math.random()
    });
  };
  function Ze(e, t) {
    t = t === 0 ? 0 : t || 10;
    var a = g(e).toHsl();
    return a.s -= t / 100, a.s = ge(a.s), g(a);
  }
  function Je(e, t) {
    t = t === 0 ? 0 : t || 10;
    var a = g(e).toHsl();
    return a.s += t / 100, a.s = ge(a.s), g(a);
  }
  function Qe(e) {
    return g(e).desaturate(100);
  }
  function et(e, t) {
    t = t === 0 ? 0 : t || 10;
    var a = g(e).toHsl();
    return a.l += t / 100, a.l = ge(a.l), g(a);
  }
  function tt(e, t) {
    t = t === 0 ? 0 : t || 10;
    var a = g(e).toRgb();
    return a.r = Math.max(0, Math.min(255, a.r - Math.round(255 * -(t / 100)))), a.g = Math.max(0, Math.min(255, a.g - Math.round(255 * -(t / 100)))), a.b = Math.max(0, Math.min(255, a.b - Math.round(255 * -(t / 100)))), g(a);
  }
  function at(e, t) {
    t = t === 0 ? 0 : t || 10;
    var a = g(e).toHsl();
    return a.l -= t / 100, a.l = ge(a.l), g(a);
  }
  function lt(e, t) {
    var a = g(e).toHsl(), r = (a.h + t) % 360;
    return a.h = r < 0 ? 360 + r : r, g(a);
  }
  function nt(e) {
    var t = g(e).toHsl();
    return t.h = (t.h + 180) % 360, g(t);
  }
  function Be(e, t) {
    if (isNaN(t) || t <= 0)
      throw new Error("Argument to polyad must be a positive number");
    for (var a = g(e).toHsl(), r = [g(e)], l = 360 / t, n = 1; n < t; n++)
      r.push(g({
        h: (a.h + n * l) % 360,
        s: a.s,
        l: a.l
      }));
    return r;
  }
  function rt(e) {
    var t = g(e).toHsl(), a = t.h;
    return [g(e), g({
      h: (a + 72) % 360,
      s: t.s,
      l: t.l
    }), g({
      h: (a + 216) % 360,
      s: t.s,
      l: t.l
    })];
  }
  function ot(e, t, a) {
    t = t || 6, a = a || 30;
    var r = g(e).toHsl(), l = 360 / a, n = [g(e)];
    for (r.h = (r.h - (l * t >> 1) + 720) % 360; --t; )
      r.h = (r.h + l) % 360, n.push(g(r));
    return n;
  }
  function st(e, t) {
    t = t || 6;
    for (var a = g(e).toHsv(), r = a.h, l = a.s, n = a.v, i = [], o = 1 / t; t--; )
      i.push(g({
        h: r,
        s: l,
        v: n
      })), n = (n + o) % 1;
    return i;
  }
  g.mix = function(e, t, a) {
    a = a === 0 ? 0 : a || 50;
    var r = g(e).toRgb(), l = g(t).toRgb(), n = a / 100, i = {
      r: (l.r - r.r) * n + r.r,
      g: (l.g - r.g) * n + r.g,
      b: (l.b - r.b) * n + r.b,
      a: (l.a - r.a) * n + r.a
    };
    return g(i);
  };
  g.readability = function(e, t) {
    var a = g(e), r = g(t);
    return (Math.max(a.getLuminance(), r.getLuminance()) + 0.05) / (Math.min(a.getLuminance(), r.getLuminance()) + 0.05);
  };
  g.isReadable = function(e, t, a) {
    var r = g.readability(e, t), l, n;
    switch (n = false, l = ht(a), l.level + l.size) {
      case "AAsmall":
      case "AAAlarge":
        n = r >= 4.5;
        break;
      case "AAlarge":
        n = r >= 3;
        break;
      case "AAAsmall":
        n = r >= 7;
        break;
    }
    return n;
  };
  g.mostReadable = function(e, t, a) {
    var r = null, l = 0, n, i, o, f;
    a = a || {}, i = a.includeFallbackColors, o = a.level, f = a.size;
    for (var s = 0; s < t.length; s++)
      n = g.readability(e, t[s]), n > l && (l = n, r = g(t[s]));
    return g.isReadable(e, r, {
      level: o,
      size: f
    }) || !i ? r : (a.includeFallbackColors = false, g.mostReadable(e, ["#fff", "#000"], a));
  };
  var xe = g.names = {
    aliceblue: "f0f8ff",
    antiquewhite: "faebd7",
    aqua: "0ff",
    aquamarine: "7fffd4",
    azure: "f0ffff",
    beige: "f5f5dc",
    bisque: "ffe4c4",
    black: "000",
    blanchedalmond: "ffebcd",
    blue: "00f",
    blueviolet: "8a2be2",
    brown: "a52a2a",
    burlywood: "deb887",
    burntsienna: "ea7e5d",
    cadetblue: "5f9ea0",
    chartreuse: "7fff00",
    chocolate: "d2691e",
    coral: "ff7f50",
    cornflowerblue: "6495ed",
    cornsilk: "fff8dc",
    crimson: "dc143c",
    cyan: "0ff",
    darkblue: "00008b",
    darkcyan: "008b8b",
    darkgoldenrod: "b8860b",
    darkgray: "a9a9a9",
    darkgreen: "006400",
    darkgrey: "a9a9a9",
    darkkhaki: "bdb76b",
    darkmagenta: "8b008b",
    darkolivegreen: "556b2f",
    darkorange: "ff8c00",
    darkorchid: "9932cc",
    darkred: "8b0000",
    darksalmon: "e9967a",
    darkseagreen: "8fbc8f",
    darkslateblue: "483d8b",
    darkslategray: "2f4f4f",
    darkslategrey: "2f4f4f",
    darkturquoise: "00ced1",
    darkviolet: "9400d3",
    deeppink: "ff1493",
    deepskyblue: "00bfff",
    dimgray: "696969",
    dimgrey: "696969",
    dodgerblue: "1e90ff",
    firebrick: "b22222",
    floralwhite: "fffaf0",
    forestgreen: "228b22",
    fuchsia: "f0f",
    gainsboro: "dcdcdc",
    ghostwhite: "f8f8ff",
    gold: "ffd700",
    goldenrod: "daa520",
    gray: "808080",
    green: "008000",
    greenyellow: "adff2f",
    grey: "808080",
    honeydew: "f0fff0",
    hotpink: "ff69b4",
    indianred: "cd5c5c",
    indigo: "4b0082",
    ivory: "fffff0",
    khaki: "f0e68c",
    lavender: "e6e6fa",
    lavenderblush: "fff0f5",
    lawngreen: "7cfc00",
    lemonchiffon: "fffacd",
    lightblue: "add8e6",
    lightcoral: "f08080",
    lightcyan: "e0ffff",
    lightgoldenrodyellow: "fafad2",
    lightgray: "d3d3d3",
    lightgreen: "90ee90",
    lightgrey: "d3d3d3",
    lightpink: "ffb6c1",
    lightsalmon: "ffa07a",
    lightseagreen: "20b2aa",
    lightskyblue: "87cefa",
    lightslategray: "789",
    lightslategrey: "789",
    lightsteelblue: "b0c4de",
    lightyellow: "ffffe0",
    lime: "0f0",
    limegreen: "32cd32",
    linen: "faf0e6",
    magenta: "f0f",
    maroon: "800000",
    mediumaquamarine: "66cdaa",
    mediumblue: "0000cd",
    mediumorchid: "ba55d3",
    mediumpurple: "9370db",
    mediumseagreen: "3cb371",
    mediumslateblue: "7b68ee",
    mediumspringgreen: "00fa9a",
    mediumturquoise: "48d1cc",
    mediumvioletred: "c71585",
    midnightblue: "191970",
    mintcream: "f5fffa",
    mistyrose: "ffe4e1",
    moccasin: "ffe4b5",
    navajowhite: "ffdead",
    navy: "000080",
    oldlace: "fdf5e6",
    olive: "808000",
    olivedrab: "6b8e23",
    orange: "ffa500",
    orangered: "ff4500",
    orchid: "da70d6",
    palegoldenrod: "eee8aa",
    palegreen: "98fb98",
    paleturquoise: "afeeee",
    palevioletred: "db7093",
    papayawhip: "ffefd5",
    peachpuff: "ffdab9",
    peru: "cd853f",
    pink: "ffc0cb",
    plum: "dda0dd",
    powderblue: "b0e0e6",
    purple: "800080",
    rebeccapurple: "663399",
    red: "f00",
    rosybrown: "bc8f8f",
    royalblue: "4169e1",
    saddlebrown: "8b4513",
    salmon: "fa8072",
    sandybrown: "f4a460",
    seagreen: "2e8b57",
    seashell: "fff5ee",
    sienna: "a0522d",
    silver: "c0c0c0",
    skyblue: "87ceeb",
    slateblue: "6a5acd",
    slategray: "708090",
    slategrey: "708090",
    snow: "fffafa",
    springgreen: "00ff7f",
    steelblue: "4682b4",
    tan: "d2b48c",
    teal: "008080",
    thistle: "d8bfd8",
    tomato: "ff6347",
    turquoise: "40e0d0",
    violet: "ee82ee",
    wheat: "f5deb3",
    white: "fff",
    whitesmoke: "f5f5f5",
    yellow: "ff0",
    yellowgreen: "9acd32"
  }, it = g.hexNames = ut(xe);
  function ut(e) {
    var t = {};
    for (var a in e)
      e.hasOwnProperty(a) && (t[e[a]] = a);
    return t;
  }
  function Ne(e) {
    return e = parseFloat(e), (isNaN(e) || e < 0 || e > 1) && (e = 1), e;
  }
  function L(e, t) {
    dt(e) && (e = "100%");
    var a = ct(e);
    return e = Math.min(t, Math.max(0, parseFloat(e))), a && (e = parseInt(e * t, 10) / 100), Math.abs(e - t) < 1e-6 ? 1 : e % t / parseFloat(t);
  }
  function ge(e) {
    return Math.min(1, Math.max(0, e));
  }
  function P(e) {
    return parseInt(e, 16);
  }
  function dt(e) {
    return typeof e == "string" && e.indexOf(".") != -1 && parseFloat(e) === 1;
  }
  function ct(e) {
    return typeof e == "string" && e.indexOf("%") != -1;
  }
  function z(e) {
    return e.length == 1 ? "0" + e : "" + e;
  }
  function ue(e) {
    return e <= 1 && (e = e * 100 + "%"), e;
  }
  function Te(e) {
    return Math.round(parseFloat(e) * 255).toString(16);
  }
  function Le(e) {
    return P(e) / 255;
  }
  var K = function() {
    var e = "[-\\+]?\\d+%?", t = "[-\\+]?\\d*\\.\\d+%?", a = "(?:" + t + ")|(?:" + e + ")", r = "[\\s|\\(]+(" + a + ")[,|\\s]+(" + a + ")[,|\\s]+(" + a + ")\\s*\\)?", l = "[\\s|\\(]+(" + a + ")[,|\\s]+(" + a + ")[,|\\s]+(" + a + ")[,|\\s]+(" + a + ")\\s*\\)?";
    return {
      CSS_UNIT: new RegExp(a),
      rgb: new RegExp("rgb" + r),
      rgba: new RegExp("rgba" + l),
      hsl: new RegExp("hsl" + r),
      hsla: new RegExp("hsla" + l),
      hsv: new RegExp("hsv" + r),
      hsva: new RegExp("hsva" + l),
      hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
      hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
    };
  }();
  function Y(e) {
    return !!K.CSS_UNIT.exec(e);
  }
  function ft(e) {
    e = e.replace(Ke, "").replace(ze, "").toLowerCase();
    var t = false;
    if (xe[e])
      e = xe[e], t = true;
    else if (e == "transparent")
      return {
        r: 0,
        g: 0,
        b: 0,
        a: 0,
        format: "name"
      };
    var a;
    return (a = K.rgb.exec(e)) ? {
      r: a[1],
      g: a[2],
      b: a[3]
    } : (a = K.rgba.exec(e)) ? {
      r: a[1],
      g: a[2],
      b: a[3],
      a: a[4]
    } : (a = K.hsl.exec(e)) ? {
      h: a[1],
      s: a[2],
      l: a[3]
    } : (a = K.hsla.exec(e)) ? {
      h: a[1],
      s: a[2],
      l: a[3],
      a: a[4]
    } : (a = K.hsv.exec(e)) ? {
      h: a[1],
      s: a[2],
      v: a[3]
    } : (a = K.hsva.exec(e)) ? {
      h: a[1],
      s: a[2],
      v: a[3],
      a: a[4]
    } : (a = K.hex8.exec(e)) ? {
      r: P(a[1]),
      g: P(a[2]),
      b: P(a[3]),
      a: Le(a[4]),
      format: t ? "name" : "hex8"
    } : (a = K.hex6.exec(e)) ? {
      r: P(a[1]),
      g: P(a[2]),
      b: P(a[3]),
      format: t ? "name" : "hex"
    } : (a = K.hex4.exec(e)) ? {
      r: P(a[1] + "" + a[1]),
      g: P(a[2] + "" + a[2]),
      b: P(a[3] + "" + a[3]),
      a: Le(a[4] + "" + a[4]),
      format: t ? "name" : "hex8"
    } : (a = K.hex3.exec(e)) ? {
      r: P(a[1] + "" + a[1]),
      g: P(a[2] + "" + a[2]),
      b: P(a[3] + "" + a[3]),
      format: t ? "name" : "hex"
    } : false;
  }
  function ht(e) {
    var t, a;
    return e = e || {
      level: "AA",
      size: "small"
    }, t = (e.level || "AA").toUpperCase(), a = (e.size || "small").toLowerCase(), t !== "AA" && t !== "AAA" && (t = "AA"), a !== "small" && a !== "large" && (a = "small"), {
      level: t,
      size: a
    };
  }
  const Ee = (e, t, a = false) => {
    if (a)
      switch (t) {
        case "rgb":
          return e.toRgb();
        case "prgb":
          return e.toPercentageRgb();
        case "hsl":
          return e.toHsl();
        case "hsv":
          return e.toHsv();
        default:
          return null;
      }
    else {
      let r = t;
      t === "hex" && e.getAlpha() < 1 && (r = "hex8");
      let l = e.toString(r);
      try {
        l = JSON.parse(l);
      } catch (e2) {
      }
      return l;
    }
  }, ye = (e, t) => !!(Object.prototype.hasOwnProperty.call(e, t) && typeof e[t] < "u"), he = (e) => typeof e > "u", I = ["update:tinyColor", "update:modelValue", "input"];
  function U(e, t, a) {
    let r, l;
    const n = computed({
      get: () => {
        var _a;
        const { modelValue: o, tinyColor: f, value: s } = e, c = (_a = f != null ? f : o) != null ? _a : s;
        return he(l) && (he(s) || (l = g(s).getFormat()), he(o) || (l = g(o).getFormat())), he(r) && (typeof s == "object" && !(s instanceof g) && (r = true), typeof o == "object" && (r = true)), g(c);
      },
      set: (o) => {
        i(o);
      }
    }), i = (o) => {
      const f = g(o);
      if (ye(e, "tinyColor") && t("update:tinyColor", f), ye(e, "modelValue")) {
        const s = Ee(f, l, r);
        t("update:modelValue", s);
      }
      if (ye(e, "value")) {
        const s = Ee(f, l, r);
        t("input", s);
      }
    };
    return n;
  }
  const Ie = (e) => {
    var _a, _b, _c, _d;
    const t = { x: 0, y: 0 };
    return e instanceof MouseEvent && (t.x = e.pageX, t.y = e.pageY), typeof TouchEvent < "u" && e instanceof TouchEvent && (t.x = ((_a = e.touches) == null ? void 0 : _a[0]) ? e.touches[0].pageX : ((_b = e.changedTouches) == null ? void 0 : _b[0]) ? e.changedTouches[0].pageX : 0, t.y = ((_c = e.touches) == null ? void 0 : _c[0]) ? e.touches[0].pageY : ((_d = e.changedTouches) == null ? void 0 : _d[0]) ? e.changedTouches[0].pageY : 0), t;
  }, vt = () => {
    const e = window.scrollX || window.pageXOffset || document.documentElement.scrollLeft || 0, t = window.scrollY || window.pageYOffset || document.documentElement.scrollTop || 0;
    return { x: e, y: t };
  }, Ue = (e) => {
    const { x: t, y: a } = vt(), r = e.getBoundingClientRect();
    return {
      x: r.left + t,
      y: r.top + a
    };
  }, Fe = (e) => e.code === "ArrowUp" || e.keyCode === 38 ? "up" : e.code === "ArrowDown" || e.keyCode === 40 ? "down" : e.code === "ArrowLeft" || e.keyCode === 37 ? "left" : e.code === "ArrowRight" || e.keyCode === 39 ? "right" : null;
  function bt(e) {
    const t = e.toString();
    return t.indexOf(".") !== -1 ? t.split(".")[1].length : 0;
  }
  function Ce(e, t, a) {
    return Math.min(Math.max(e, t), a);
  }
  const Pe = (e, t = 20) => {
    let a, r, l;
    return (...n) => {
      a ? (clearTimeout(r), r = setTimeout(() => {
        Date.now() - l >= t && (e(...n), l = Date.now());
      }, Math.max(t - (Date.now() - l), 0))) : (e(...n), l = Date.now(), a = true);
    };
  }, pt = ["aria-valuetext"], gt = /* @__PURE__ */ defineComponent({
    __name: "SaturationSlider",
    props: {
      hue: {},
      tinyColor: {},
      modelValue: {},
      value: {}
    },
    emits: ["change"].concat(I),
    setup(e, { emit: t }) {
      const a = t, r = e, l = ref(0), n = U(r, a), i = computed(() => n.value.toHsv()), o = computed(() => {
        var _a;
        return (_a = r.hue) != null ? _a : i.value.h;
      }), f = computed(() => `hsl(${o.value}, 100%, 50%)`), s = computed(() => -(i.value.v * 100) + 1 + 100 + "%"), c = computed(() => i.value.v <= 0.01 ? l.value * 100 + "%" : i.value.s * 100 + "%"), p2 = ref(null);
      function _(h2) {
        const v = p2.value;
        if (!v)
          return;
        const B = v.clientWidth, Z = v.clientHeight, { x: ne, y: R } = Ue(v), { x: $2, y: F } = Ie(h2), fe = Ce($2 - ne, 0, B), ie = Ce(F - R, 0, Z), Ae = fe / B, Ge = Ce(1 - ie / Z, 0, 1);
        l.value = Ae;
        let me = Math.round(Ae * 100), _e = Math.round(Ge * 100);
        me === 1 && (me = 0.01), _e === 1 && (_e = 0.01), m({
          h: o.value,
          s: me,
          v: _e,
          a: i.value.a
        });
      }
      function m(h2) {
        n.value = h2;
      }
      const d = Pe(_, 20);
      function A(h2) {
        h2.preventDefault(), h2.type.startsWith("mouse") ? (window.addEventListener("mousemove", d), window.addEventListener("mouseup", d), window.addEventListener("mouseup", k)) : h2.type.startsWith("touch") && (window.addEventListener("touchmove", d), window.addEventListener("touchend", d), window.addEventListener("touchend", k));
      }
      function k() {
        H();
      }
      function H() {
        window.removeEventListener("mousemove", d), window.removeEventListener("mouseup", d), window.removeEventListener("mouseup", k), window.removeEventListener("touchmove", d), window.removeEventListener("touchend", d), window.removeEventListener("touchend", k);
      }
      function x(h2) {
        switch (h2.preventDefault(), Fe(h2)) {
          case "left": {
            const B = i.value.s - 0.01;
            m(__spreadProps(__spreadValues({}, i.value), {
              s: B >= 0 ? B : 0
            }));
            break;
          }
          case "right": {
            const B = i.value.s + 0.01;
            m(__spreadProps(__spreadValues({}, i.value), {
              s: B > 1 ? 1 : B
            }));
            break;
          }
          case "up": {
            const B = i.value.v + 0.01;
            m(__spreadProps(__spreadValues({}, i.value), {
              v: B > 1 ? 1 : B
            }));
            break;
          }
          case "down": {
            const B = i.value.v - 0.01;
            m(__spreadProps(__spreadValues({}, i.value), {
              v: B < 0 ? 0 : B
            }));
            break;
          }
        }
      }
      return onUnmounted(() => {
        H();
      }), (h2, v) => (openBlock(), createElementBlock("div", {
        class: "vc-saturation-slider bg",
        style: normalizeStyle({ background: f.value }),
        ref_key: "containerRef",
        ref: p2,
        onMousedown: A,
        onTouchstart: A,
        role: "application",
        "aria-label": "Saturation and brightness picker"
      }, [
        v[1] || (v[1] = createBaseVNode("div", { class: "bg white" }, null, -1)),
        v[2] || (v[2] = createBaseVNode("div", { class: "bg black" }, null, -1)),
        createBaseVNode("div", {
          class: "picker-wrap",
          style: normalizeStyle({ top: s.value, left: c.value }),
          role: "slider",
          tabindex: "0",
          "aria-valuemin": "0",
          "aria-valuemax": "1",
          "aria-label": "press arrow to change saturation or brightness",
          "aria-valuenow": "?",
          "aria-valuetext": `saturation: ${i.value.s.toFixed(0)}%, brightness: ${i.value.v.toFixed(0)}%`,
          onKeydown: x
        }, v[0] || (v[0] = [
          createBaseVNode("div", { class: "picker" }, null, -1)
        ]), 44, pt)
      ], 36));
    }
  }), N = (e, t) => {
    const a = e.__vccOpts || e;
    for (const [r, l] of t)
      a[r] = l;
    return a;
  }, Se = /* @__PURE__ */ N(gt, [["__scopeId", "data-v-2d73e50b"]]), $e = (e) => typeof e < "u", mt = { class: "vc-base-slider" }, _t = {
    key: 0,
    class: "background"
  }, yt = ["aria-label", "aria-valuemax", "aria-valuenow"], Ct = /* @__PURE__ */ defineComponent({
    __name: "BaseSlider",
    props: {
      direction: { default: "horizontal" },
      modelValue: { default: 0 },
      value: { default: 0 },
      max: { default: 100 },
      step: {},
      ariaLabel: { default: "slider" }
    },
    emits: ["input", "update:modelValue"],
    setup(e, { emit: t }) {
      const a = e, r = t, l = computed(() => {
        var _a;
        return (_a = a.modelValue) != null ? _a : a.value;
      }), n = computed(() => {
        let d = l.value / a.max;
        return a.direction === "vertical" && (d = 1 - d), 100 * d + "%";
      }), i = ref(null);
      function o(d) {
        $e(d) && (r("input", d), r("update:modelValue", d));
      }
      function f(d) {
        const { direction: A, max: k } = a, H = i.value;
        if (!H)
          return;
        const x = H.clientWidth, h2 = H.clientHeight, { x: v, y: B } = Ue(H), { x: Z, y: ne } = Ie(d), R = Z - v, $2 = ne - B;
        let F;
        A === "vertical" ? $2 < 0 ? F = k : $2 > h2 ? F = 0 : F = (1 - $2 / h2) * k : R < 0 ? F = 0 : R > x ? F = k : F = R / x * k, o(F);
      }
      const s = Pe(f);
      function c(d) {
        f(d), d.type.startsWith("mouse") ? (window.addEventListener("mousemove", s), window.addEventListener("mouseup", p2)) : (window.addEventListener("touchmove", s), window.addEventListener("touchend", p2));
      }
      function p2() {
        _();
      }
      function _() {
        window.removeEventListener("mousemove", s), window.removeEventListener("mouseup", p2), window.removeEventListener("touchmove", s), window.removeEventListener("touchend", p2);
      }
      function m(d) {
        var _a;
        d.preventDefault();
        const { direction: A, max: k } = a, H = Fe(d), x = (_a = a.step) != null ? _a : k / 100, h2 = l.value;
        let v;
        switch (H) {
          case "left": {
            if (A !== "horizontal")
              return;
            v = h2 - x < 0 ? 0 : h2 - x;
            break;
          }
          case "right": {
            if (A !== "horizontal")
              return;
            v = h2 + x > k ? k : h2 + x;
            break;
          }
          case "down": {
            if (A !== "vertical")
              return;
            v = h2 - x < 0 ? 0 : h2 - x;
            break;
          }
          case "up": {
            if (A !== "vertical")
              return;
            v = h2 + x > k ? k : h2 + x;
            break;
          }
        }
        o(v);
      }
      return onUnmounted(() => {
        _();
      }), (d, A) => (openBlock(), createElementBlock("div", mt, [
        d.$slots.background ? (openBlock(), createElementBlock("div", _t, [
          renderSlot(d.$slots, "background", {}, void 0, true)
        ])) : createCommentVNode("", true),
        createBaseVNode("div", {
          class: normalizeClass({
            slider: true,
            horizontal: d.direction === "horizontal",
            vertical: d.direction === "vertical"
          }),
          ref_key: "containerRef",
          ref: i,
          onMousedown: c,
          onTouchstart: c,
          role: "slider",
          "aria-label": d.ariaLabel,
          "aria-valuemax": d.max,
          "aria-valuemin": "0",
          "aria-valuenow": l.value.toFixed(1),
          tabindex: "0",
          onKeydown: m
        }, [
          createBaseVNode("div", {
            class: "picker-wrap",
            style: normalizeStyle({
              left: d.direction === "horizontal" ? n.value : 0,
              top: d.direction === "vertical" ? n.value : 0
            }),
            role: "presentation"
          }, [
            renderSlot(d.$slots, "picker", {}, () => [
              A[0] || (A[0] = createBaseVNode("div", { class: "picker" }, null, -1))
            ], true)
          ], 4)
        ], 42, yt)
      ]));
    }
  }), W = /* @__PURE__ */ N(Ct, [["__scopeId", "data-v-b6b65dfc"]]), kt = /* @__PURE__ */ defineComponent({
    __name: "HueSlider",
    props: {
      direction: { default: "horizontal" },
      modelValue: { default: 0 }
    },
    emits: ["update:modelValue"],
    setup(e, { emit: t }) {
      useCssVars((c) => ({
        "2f44f39d": l.value
      }));
      const a = e, r = t, l = computed(() => `linear-gradient(to ${a.direction === "horizontal" ? "right" : "top"}, #f00 0%, #ff0 17%, #0f0 33%, #0ff 50%, #00f 67%, #f0f 83%, #f00 100%)`), n = computed(() => {
        const c = Number(a.modelValue);
        return Number.isNaN(c) ? 0 : c;
      }), i = ref();
      watch(n, (c, p2) => {
        c !== 0 && c - p2 > 0 && (i.value = "right"), c !== 0 && c - p2 < 0 && (i.value = "left");
      });
      const o = computed(() => a.direction === "vertical" ? n.value === 0 && i.value === "right" ? 0 : n.value : a.direction === "horizontal" ? n.value === 0 && i.value === "right" ? 360 : n.value : 0);
      function f(c) {
        s(Math.round(c));
      }
      function s(c) {
        r("update:modelValue", c);
      }
      return (c, p2) => (openBlock(), createBlock(W, {
        class: "vc-hue-slider",
        max: 360,
        step: 1,
        modelValue: o.value,
        direction: c.direction,
        "onUpdate:modelValue": f,
        "aria-label": "Hue"
      }, {
        background: withCtx(() => p2[0] || (p2[0] = [
          createBaseVNode("div", { class: "gradient" }, null, -1)
        ])),
        picker: withCtx(() => [
          renderSlot(c.$slots, "default", {}, void 0, true)
        ]),
        _: 3
      }, 8, ["modelValue", "direction"]));
    }
  }), le = /* @__PURE__ */ N(kt, [["__scopeId", "data-v-5367c985"]]), wt = /* @__PURE__ */ defineComponent({
    __name: "CheckerboardBG",
    props: {
      size: { default: 8 },
      white: { default: "#fff" },
      grey: { default: "#e6e6e6" }
    },
    setup(e) {
      const t = e;
      function a(n, i, o) {
        if (typeof document > "u")
          return null;
        var f = document.createElement("canvas");
        f.width = f.height = o * 2;
        var s = f.getContext("2d");
        return s ? (s.fillStyle = n, s.fillRect(0, 0, f.width, f.height), s.fillStyle = i, s.fillRect(0, 0, o, o), s.translate(o, o), s.fillRect(0, 0, o, o), f.toDataURL()) : null;
      }
      function r(n, i, o) {
        return a(n, i, o);
      }
      const l = computed(() => `url(${r(t.white, t.grey, t.size)})`);
      return (n, i) => (openBlock(), createElementBlock("div", {
        class: "vc-checkerboard",
        style: normalizeStyle({ backgroundImage: l.value })
      }, null, 4));
    }
  }), be = /* @__PURE__ */ N(wt, [["__scopeId", "data-v-37d61ccd"]]), xt = /* @__PURE__ */ defineComponent({
    __name: "AlphaSlider",
    props: {
      tinyColor: {},
      modelValue: {},
      value: {}
    },
    emits: I,
    setup(e, { emit: t }) {
      const l = U(e, t), n = computed(() => {
        const f = l.value.toRgb(), s = [f.r, f.g, f.b].join(",");
        return "linear-gradient(to right, rgba(" + s + ", 0) 0%, rgba(" + s + ", 1) 100%)";
      }), i = computed(() => l.value.getAlpha());
      function o(f) {
        l.value = l.value.setAlpha(f).clone();
      }
      return (f, s) => (openBlock(), createBlock(W, {
        class: "vc-alpha-slider",
        modelValue: i.value,
        max: 1,
        "aria-label": "Transparency",
        "onUpdate:modelValue": o
      }, {
        background: withCtx(() => [
          createVNode(be),
          createBaseVNode("div", {
            class: "gradient",
            style: normalizeStyle({ background: n.value })
          }, null, 4)
        ]),
        _: 1
      }, 8, ["modelValue"]));
    }
  }), oe = /* @__PURE__ */ N(xt, [["__scopeId", "data-v-07dd346b"]]), $t = { class: "vc-editable-input" }, Ft = ["value", "aria-label"], St = {
    key: 0,
    class: "vc-input-desc",
    "aria-hidden": "true"
  }, At = /* @__PURE__ */ defineComponent({
    __name: "EditableInput",
    props: {
      value: {},
      label: {},
      desc: {},
      max: {},
      min: {},
      step: { default: 1 },
      a11y: {}
    },
    emits: ["change"],
    setup(e, { emit: t }) {
      var _a, _b;
      const a = e, r = t, l = (_b = (_a = a.a11y) == null ? void 0 : _a.label) != null ? _b : a.label, n = `input__label__${l}__${Math.random().toString().slice(2, 5)}`;
      function i(s) {
        const { min: c, max: p2 } = a;
        if ($e(p2) && +s > p2) {
          r("change", p2);
          return;
        }
        if ($e(c) && +s < c) {
          r("change", c);
          return;
        }
        r("change", s);
      }
      function o(s) {
        var _a2;
        i((_a2 = s.target) == null ? void 0 : _a2.value);
      }
      function f(s) {
        let c = Number(a.value);
        if (!isNaN(c)) {
          let p2 = a.step;
          const _ = bt(p2), m = Fe(s);
          m === "up" && (i((c + p2).toFixed(_)), s.preventDefault()), m === "down" && (i((c - p2).toFixed(_)), s.preventDefault());
        }
      }
      return (s, c) => (openBlock(), createElementBlock("div", $t, [
        createBaseVNode("input", {
          class: "vc-input-input",
          value: a.value,
          onKeydown: f,
          onInput: o,
          "aria-label": unref(l),
          id: n
        }, null, 40, Ft),
        createBaseVNode("label", {
          for: n,
          class: "vc-input-label",
          "aria-hidden": "true"
        }, toDisplayString(a.label), 1),
        s.desc ? (openBlock(), createElementBlock("span", St, toDisplayString(s.desc), 1)) : createCommentVNode("", true)
      ]));
    }
  }), S = /* @__PURE__ */ N(At, [["__scopeId", "data-v-4a4df1fd"]]);
  function Mt() {
    const e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    return e.charAt(Math.floor(Math.random() * e.length)) + e.charAt(Math.floor(Math.random() * e.length));
  }
  const se = (e) => {
    const t = ref(0), a = `__from__vc__hue__${Mt()}`;
    return watch(e, (l) => {
      if (l[a])
        return;
      const n = l.toHsl().h;
      n === 0 && t.value !== 0 || (t.value = n);
    }, { immediate: true }), { hueRef: t, updateHueRef: (l) => {
      const n = g(__spreadProps(__spreadValues({}, e.value.toHsl()), {
        h: l
      }));
      n[a] = true, e.value = n, t.value = l;
    } };
  }, ce = (e) => g(e).isValid(), Vt = { class: "saturation" }, Ht = { class: "body" }, Bt = { class: "controls" }, Lt = { class: "color-wrap" }, Et = ["aria-label"], Dt = { class: "sliders" }, Nt = { class: "hue-wrap" }, Tt = {
    key: 0,
    class: "alpha-wrap"
  }, It = {
    key: 0,
    class: "fieldsWrap",
    "data-testid": "fields"
  }, Ut = {
    key: 0,
    class: "fields"
  }, Pt = { class: "field" }, Gt = { class: "field" }, Ot = { class: "field" }, Kt = {
    key: 0,
    class: "field"
  }, zt = {
    key: 1,
    class: "fields"
  }, jt = { class: "field" }, Xt = {
    key: 2,
    class: "fields"
  }, Yt = { class: "field" }, Wt = { class: "field" }, qt = { class: "field" }, Zt = {
    key: 0,
    class: "field"
  }, Jt = {
    class: "toggle-icon",
    role: "presentation"
  }, Qt = {
    style: { width: "24px", height: "24px" },
    viewBox: "0 0 24 24"
  }, ea = {
    class: "toggle-icon_highlighted",
    role: "presentation"
  }, ta = /* @__PURE__ */ defineComponent({
    __name: "ChromePicker",
    props: {
      disableAlpha: { type: Boolean },
      disableFields: { type: Boolean },
      formats: { default: () => ["rgb", "hex", "hsl"] },
      tinyColor: {},
      modelValue: {},
      value: {}
    },
    emits: I,
    setup(e, { emit: t }) {
      const a = e, l = U(a, t), { hueRef: n, updateHueRef: i } = se(l), o = ref(0);
      let f = ref(false);
      const s = computed(() => {
        const R = l.value.toRgb();
        return "rgba(" + [R.r, R.g, R.b, l.value.getAlpha()].join(",") + ")";
      }), c = computed(() => {
        const { h: R, s: $2, l: F } = l.value.toHsl();
        return {
          h: R.toFixed(),
          s: `${($2 * 100).toFixed()}%`,
          l: `${(F * 100).toFixed()}%`
        };
      }), p2 = computed(() => l.value.toRgb()), _ = computed(() => Number(l.value.getAlpha().toFixed(2))), m = /* @__PURE__ */ new Set(["hex", "hsl", "rgb"]), d = computed(() => {
        const R = /* @__PURE__ */ new Set(), $2 = [], F = a.formats;
        for (const fe of F)
          if (m.has(fe)) {
            const ie = fe;
            R.has(ie) || (R.add(ie), $2.push(ie));
          }
        return $2;
      }), A = computed(() => {
        const { disableFields: R, formats: $2 } = a;
        return !(R === true || !Array.isArray($2) || d.value.length === 0);
      }), k = (R) => d.value.includes(R), H = (R) => d.value.indexOf(R), x = (R) => {
        R && ce(R) && (l.value = R);
      }, h2 = (R, $2) => {
        if (!$2 || isNaN(Number($2)))
          return;
        const F = { [R]: $2 };
        l.value = __spreadValues(__spreadProps(__spreadValues({}, p2.value), {
          a: _.value
        }), F);
      }, v = (R, $2) => {
        if (!$2)
          return;
        const F = { [R]: +$2 };
        (R === "s" || R === "l") && (F[R] = +$2.replace("%", "") / 100), l.value = __spreadValues(__spreadProps(__spreadValues({}, l.value.toHsl()), {
          a: _.value
        }), F);
      }, B = () => {
        if (o.value === d.value.length - 1) {
          o.value = 0;
          return;
        }
        o.value++;
      }, Z = () => {
        f.value = true;
      }, ne = () => {
        f.value = false;
      };
      return (R, $2) => (openBlock(), createElementBlock("div", {
        role: "application",
        "aria-label": "Chrome Color Picker",
        class: normalizeClass(["vc-chrome-picker", R.disableAlpha ? "alpha-disabled" : ""])
      }, [
        createBaseVNode("div", Vt, [
          createVNode(Se, {
            tinyColor: unref(l),
            "onUpdate:tinyColor": $2[0] || ($2[0] = (F) => isRef(l) ? l.value = F : null),
            hue: unref(n)
          }, null, 8, ["tinyColor", "hue"])
        ]),
        createBaseVNode("div", Ht, [
          createBaseVNode("div", Bt, [
            createBaseVNode("div", Lt, [
              createBaseVNode("div", {
                class: "active-color",
                style: normalizeStyle({ backgroundColor: s.value }),
                role: "presentation",
                "aria-live": "polite",
                "aria-label": `Current color is ${s.value}`
              }, null, 12, Et),
              a.disableAlpha ? createCommentVNode("", true) : (openBlock(), createBlock(be, { key: 0 }))
            ]),
            createBaseVNode("div", Dt, [
              createBaseVNode("div", Nt, [
                createVNode(le, {
                  modelValue: unref(n),
                  "onUpdate:modelValue": unref(i)
                }, null, 8, ["modelValue", "onUpdate:modelValue"])
              ]),
              a.disableAlpha ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Tt, [
                createVNode(oe, {
                  tinyColor: unref(l),
                  "onUpdate:tinyColor": $2[1] || ($2[1] = (F) => isRef(l) ? l.value = F : null)
                }, null, 8, ["tinyColor"])
              ]))
            ])
          ]),
          A.value ? (openBlock(), createElementBlock("div", It, [
            k("rgb") ? withDirectives((openBlock(), createElementBlock("div", Ut, [
              createBaseVNode("div", Pt, [
                createVNode(S, {
                  label: "r",
                  value: p2.value.r,
                  onChange: $2[2] || ($2[2] = (F) => h2("r", F)),
                  a11y: { label: "Red" }
                }, null, 8, ["value"])
              ]),
              createBaseVNode("div", Gt, [
                createVNode(S, {
                  label: "g",
                  value: p2.value.g,
                  onChange: $2[3] || ($2[3] = (F) => h2("g", F)),
                  a11y: { label: "Green" }
                }, null, 8, ["value"])
              ]),
              createBaseVNode("div", Ot, [
                createVNode(S, {
                  label: "b",
                  value: p2.value.b,
                  onChange: $2[4] || ($2[4] = (F) => h2("b", F)),
                  a11y: { label: "Blue" }
                }, null, 8, ["value"])
              ]),
              R.disableAlpha ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Kt, [
                createVNode(S, {
                  label: "a",
                  value: _.value,
                  step: 0.01,
                  max: 1,
                  onChange: $2[5] || ($2[5] = (F) => h2("a", F)),
                  a11y: { label: "Transparency" }
                }, null, 8, ["value"])
              ]))
            ], 512)), [
              [vShow, o.value === H("rgb")]
            ]) : createCommentVNode("", true),
            k("hex") ? withDirectives((openBlock(), createElementBlock("div", zt, [
              createBaseVNode("div", jt, [
                _.value === 1 ? (openBlock(), createBlock(S, {
                  key: 0,
                  label: "hex",
                  value: unref(l).toHexString(),
                  onChange: x,
                  a11y: { label: "Hex" }
                }, null, 8, ["value"])) : createCommentVNode("", true),
                _.value !== 1 ? (openBlock(), createBlock(S, {
                  key: 1,
                  label: "hex",
                  value: unref(l).toHex8String(),
                  onChange: x,
                  a11y: { label: "Hex with transparency" }
                }, null, 8, ["value"])) : createCommentVNode("", true)
              ])
            ], 512)), [
              [vShow, o.value === H("hex")]
            ]) : createCommentVNode("", true),
            k("hsl") ? withDirectives((openBlock(), createElementBlock("div", Xt, [
              createBaseVNode("div", Yt, [
                createVNode(S, {
                  label: "h",
                  value: unref(n).toFixed(),
                  onChange: $2[6] || ($2[6] = (F) => v("h", F)),
                  a11y: { label: "Hue" }
                }, null, 8, ["value"])
              ]),
              createBaseVNode("div", Wt, [
                createVNode(S, {
                  label: "s",
                  value: c.value.s,
                  onChange: $2[7] || ($2[7] = (F) => v("s", F)),
                  a11y: { label: "Saturation" }
                }, null, 8, ["value"])
              ]),
              createBaseVNode("div", qt, [
                createVNode(S, {
                  label: "l",
                  value: c.value.l,
                  onChange: $2[8] || ($2[8] = (F) => v("l", F)),
                  a11y: { label: "Lightness" }
                }, null, 8, ["value"])
              ]),
              R.disableAlpha ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Zt, [
                createVNode(S, {
                  label: "a",
                  value: _.value,
                  step: 0.01,
                  max: 1,
                  onChange: $2[9] || ($2[9] = (F) => v("a", F)),
                  a11y: { label: "Transparency" }
                }, null, 8, ["value"])
              ]))
            ], 512)), [
              [vShow, o.value === H("hsl")]
            ]) : createCommentVNode("", true),
            d.value.length > 1 ? (openBlock(), createElementBlock("div", {
              key: 3,
              class: "toggle-btn",
              onClick: B,
              onKeydown: [
                withKeys(B, ["enter"]),
                withKeys(B, ["space"])
              ],
              onMouseover: Z,
              onMouseenter: Z,
              onMouseout: ne,
              onFocus: Z,
              onBlur: ne,
              role: "button",
              "aria-label": "Change color format",
              tabindex: "0"
            }, [
              createBaseVNode("div", Jt, [
                (openBlock(), createElementBlock("svg", Qt, $2[10] || ($2[10] = [
                  createBaseVNode("path", {
                    fill: "currentColor",
                    d: "M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"
                  }, null, -1)
                ])))
              ]),
              withDirectives(createBaseVNode("div", ea, null, 512), [
                [vShow, unref(f)]
              ])
            ], 32)) : createCommentVNode("", true)
          ])) : createCommentVNode("", true)
        ])
      ], 2));
    }
  }), pn = /* @__PURE__ */ N(ta, [["__scopeId", "data-v-abf90852"]]), ya = {
    class: "title",
    "aria-hidden": "true"
  }, Ca = { class: "body" }, ka = { class: "saturation" }, wa = { class: "hue" }, xa = { class: "preview" }, $a = {
    class: "preview-label",
    "aria-hidden": "true"
  }, Fa = { class: "preview-swatches" }, Sa = ["aria-label"], Aa = ["aria-label"], Ma = {
    class: "preview-label",
    "aria-hidden": "true"
  }, Ra = {
    key: 0,
    class: "actions"
  }, Va = ["aria-label"], Ha = { class: "fields" }, Ba = ["aria-label"];
  /* @__PURE__ */ defineComponent({
    __name: "PhotoshopPicker",
    props: {
      title: { default: "Color picker" },
      disableFields: { type: Boolean, default: false },
      hasResetButton: { type: Boolean, default: false },
      okLabel: { default: "OK" },
      cancelLabel: { default: "Cancel" },
      resetLabel: { default: "Reset" },
      newLabel: { default: "new" },
      currentLabel: { default: "current" },
      currentColor: { default: "#fff" },
      tinyColor: {},
      modelValue: {},
      value: {}
    },
    emits: I.concat(["ok", "cancel", "reset"]),
    setup(e, { emit: t }) {
      const a = e, r = t, l = U(a, r), { hueRef: n, updateHueRef: i } = se(l), o = ref(a.currentColor), f = computed(() => l.value.toHsv()), s = computed(() => {
        const x = l.value.toHexString();
        return x && x.replace("#", "");
      }), c = computed(() => l.value.toRgb()), p2 = () => {
        l.value = o.value;
      }, _ = (x) => {
        x && ce(x) && (l.value = x);
      }, m = (x, h2) => {
        if (!h2 || isNaN(Number(h2)))
          return;
        const v = { [x]: h2 };
        l.value = __spreadValues(__spreadValues({}, c.value), v);
      }, d = (x, h2) => {
        if (!h2 || isNaN(Number(h2)))
          return;
        const v = { [x]: Number(h2) };
        l.value = __spreadValues(__spreadValues({}, f.value), v);
      }, A = () => {
        r("ok");
      }, k = () => {
        r("cancel");
      }, H = () => {
        r("reset");
      };
      return (x, h2) => (openBlock(), createElementBlock("div", {
        role: "application",
        "aria-label": "PhotoShop color picker",
        class: normalizeClass(["vc-photoshop-picker", x.disableFields ? "fields_disabled" : ""])
      }, [
        createBaseVNode("div", ya, toDisplayString(x.title), 1),
        createBaseVNode("div", Ca, [
          createBaseVNode("div", ka, [
            createVNode(Se, {
              tinyColor: unref(l),
              "onUpdate:tinyColor": h2[0] || (h2[0] = (v) => isRef(l) ? l.value = v : null),
              hue: unref(n)
            }, null, 8, ["tinyColor", "hue"])
          ]),
          createBaseVNode("div", wa, [
            createVNode(le, {
              direction: "vertical",
              modelValue: unref(n),
              "onUpdate:modelValue": unref(i)
            }, {
              default: withCtx(() => h2[7] || (h2[7] = [
                createBaseVNode("div", { class: "hue-picker" }, [
                  createBaseVNode("i", { class: "hue-picker-left" }),
                  createBaseVNode("i", { class: "hue-picker-right" })
                ], -1)
              ])),
              _: 1,
              __: [7]
            }, 8, ["modelValue", "onUpdate:modelValue"])
          ]),
          createBaseVNode("div", {
            class: normalizeClass(["controls", x.disableFields ? "controls_fields_disabled" : ""])
          }, [
            createBaseVNode("div", xa, [
              createBaseVNode("div", $a, toDisplayString(x.newLabel), 1),
              createBaseVNode("div", Fa, [
                createBaseVNode("div", {
                  class: "preview-color",
                  "aria-label": `New color is #${s.value}`,
                  style: normalizeStyle({ background: `#${s.value}` })
                }, null, 12, Sa),
                createBaseVNode("div", {
                  class: "preview-color",
                  style: normalizeStyle({ background: o.value }),
                  onClick: p2,
                  role: "button",
                  "aria-label": `Current color is ${o.value}`,
                  onKeydown: withKeys(p2, ["space"]),
                  tabindex: "0"
                }, null, 44, Aa)
              ]),
              createBaseVNode("div", Ma, toDisplayString(x.currentLabel), 1)
            ]),
            x.disableFields ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Ra, [
              createBaseVNode("div", {
                class: "action-btn",
                role: "button",
                "aria-label": "Click to apply new color",
                onClick: A,
                onKeydown: withKeys(p2, ["space"]),
                tabindex: "0"
              }, toDisplayString(x.okLabel), 33),
              createBaseVNode("div", {
                class: "action-btn",
                role: "button",
                "aria-label": x.cancelLabel,
                onClick: k,
                onKeydown: withKeys(p2, ["space"]),
                tabindex: "0"
              }, toDisplayString(x.cancelLabel), 41, Va),
              createBaseVNode("div", Ha, [
                createVNode(S, {
                  label: "h",
                  desc: "°",
                  value: f.value.h.toFixed(),
                  onChange: h2[1] || (h2[1] = (v) => d("h", v)),
                  a11y: { label: "Hue" }
                }, null, 8, ["value"]),
                createVNode(S, {
                  label: "s",
                  desc: "%",
                  value: (f.value.s * 100).toFixed(),
                  min: 0,
                  max: 100,
                  onChange: h2[2] || (h2[2] = (v) => d("s", v)),
                  a11y: { label: "Saturation" }
                }, null, 8, ["value"]),
                createVNode(S, {
                  label: "v",
                  desc: "%",
                  value: (f.value.v * 100).toFixed(),
                  min: 0,
                  max: 100,
                  onChange: h2[3] || (h2[3] = (v) => d("v", v)),
                  a11y: { label: "Value" }
                }, null, 8, ["value"]),
                h2[8] || (h2[8] = createBaseVNode("div", { class: "fields-divider" }, null, -1)),
                createVNode(S, {
                  label: "r",
                  value: c.value.r,
                  onChange: h2[4] || (h2[4] = (v) => m("r", v)),
                  a11y: { label: "Red" }
                }, null, 8, ["value"]),
                createVNode(S, {
                  label: "g",
                  value: c.value.g,
                  onChange: h2[5] || (h2[5] = (v) => m("g", v)),
                  a11y: { label: "Green" }
                }, null, 8, ["value"]),
                createVNode(S, {
                  label: "b",
                  value: c.value.b,
                  onChange: h2[6] || (h2[6] = (v) => m("b", v)),
                  a11y: { label: "Blue" }
                }, null, 8, ["value"]),
                h2[9] || (h2[9] = createBaseVNode("div", { class: "fields-divider" }, null, -1)),
                createVNode(S, {
                  label: "#",
                  class: "hex",
                  value: s.value,
                  onChange: _,
                  a11y: { label: "Hex" }
                }, null, 8, ["value"])
              ]),
              x.hasResetButton ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: "action-btn",
                onClick: H,
                role: "button",
                "aria-label": x.resetLabel,
                onKeydown: withKeys(H, ["space"]),
                tabindex: "0"
              }, toDisplayString(x.resetLabel), 41, Ba)) : createCommentVNode("", true)
            ]))
          ], 2)
        ])
      ], 2));
    }
  });
  function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof(obj);
  }
  var trimLeft = /^\s+/;
  var trimRight = /\s+$/;
  function tinycolor(color, opts) {
    color = color ? color : "";
    opts = opts || {};
    if (color instanceof tinycolor) {
      return color;
    }
    if (!(this instanceof tinycolor)) {
      return new tinycolor(color, opts);
    }
    var rgb = inputToRGB(color);
    this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;
    this._gradientType = opts.gradientType;
    if (this._r < 1) this._r = Math.round(this._r);
    if (this._g < 1) this._g = Math.round(this._g);
    if (this._b < 1) this._b = Math.round(this._b);
    this._ok = rgb.ok;
  }
  tinycolor.prototype = {
    isDark: function isDark() {
      return this.getBrightness() < 128;
    },
    isLight: function isLight() {
      return !this.isDark();
    },
    isValid: function isValid() {
      return this._ok;
    },
    getOriginalInput: function getOriginalInput() {
      return this._originalInput;
    },
    getFormat: function getFormat() {
      return this._format;
    },
    getAlpha: function getAlpha() {
      return this._a;
    },
    getBrightness: function getBrightness() {
      var rgb = this.toRgb();
      return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1e3;
    },
    getLuminance: function getLuminance() {
      var rgb = this.toRgb();
      var RsRGB, GsRGB, BsRGB, R, G, B;
      RsRGB = rgb.r / 255;
      GsRGB = rgb.g / 255;
      BsRGB = rgb.b / 255;
      if (RsRGB <= 0.03928) R = RsRGB / 12.92;
      else R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);
      if (GsRGB <= 0.03928) G = GsRGB / 12.92;
      else G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);
      if (BsRGB <= 0.03928) B = BsRGB / 12.92;
      else B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);
      return 0.2126 * R + 0.7152 * G + 0.0722 * B;
    },
    setAlpha: function setAlpha(value) {
      this._a = boundAlpha(value);
      this._roundA = Math.round(100 * this._a) / 100;
      return this;
    },
    toHsv: function toHsv() {
      var hsv = rgbToHsv(this._r, this._g, this._b);
      return {
        h: hsv.h * 360,
        s: hsv.s,
        v: hsv.v,
        a: this._a
      };
    },
    toHsvString: function toHsvString() {
      var hsv = rgbToHsv(this._r, this._g, this._b);
      var h2 = Math.round(hsv.h * 360), s = Math.round(hsv.s * 100), v = Math.round(hsv.v * 100);
      return this._a == 1 ? "hsv(" + h2 + ", " + s + "%, " + v + "%)" : "hsva(" + h2 + ", " + s + "%, " + v + "%, " + this._roundA + ")";
    },
    toHsl: function toHsl() {
      var hsl = rgbToHsl(this._r, this._g, this._b);
      return {
        h: hsl.h * 360,
        s: hsl.s,
        l: hsl.l,
        a: this._a
      };
    },
    toHslString: function toHslString() {
      var hsl = rgbToHsl(this._r, this._g, this._b);
      var h2 = Math.round(hsl.h * 360), s = Math.round(hsl.s * 100), l = Math.round(hsl.l * 100);
      return this._a == 1 ? "hsl(" + h2 + ", " + s + "%, " + l + "%)" : "hsla(" + h2 + ", " + s + "%, " + l + "%, " + this._roundA + ")";
    },
    toHex: function toHex(allow3Char) {
      return rgbToHex(this._r, this._g, this._b, allow3Char);
    },
    toHexString: function toHexString(allow3Char) {
      return "#" + this.toHex(allow3Char);
    },
    toHex8: function toHex8(allow4Char) {
      return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
    },
    toHex8String: function toHex8String(allow4Char) {
      return "#" + this.toHex8(allow4Char);
    },
    toRgb: function toRgb() {
      return {
        r: Math.round(this._r),
        g: Math.round(this._g),
        b: Math.round(this._b),
        a: this._a
      };
    },
    toRgbString: function toRgbString() {
      return this._a == 1 ? "rgb(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ")" : "rgba(" + Math.round(this._r) + ", " + Math.round(this._g) + ", " + Math.round(this._b) + ", " + this._roundA + ")";
    },
    toPercentageRgb: function toPercentageRgb() {
      return {
        r: Math.round(bound01(this._r, 255) * 100) + "%",
        g: Math.round(bound01(this._g, 255) * 100) + "%",
        b: Math.round(bound01(this._b, 255) * 100) + "%",
        a: this._a
      };
    },
    toPercentageRgbString: function toPercentageRgbString() {
      return this._a == 1 ? "rgb(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%)" : "rgba(" + Math.round(bound01(this._r, 255) * 100) + "%, " + Math.round(bound01(this._g, 255) * 100) + "%, " + Math.round(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
    },
    toName: function toName() {
      if (this._a === 0) {
        return "transparent";
      }
      if (this._a < 1) {
        return false;
      }
      return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
    },
    toFilter: function toFilter(secondColor) {
      var hex8String = "#" + rgbaToArgbHex(this._r, this._g, this._b, this._a);
      var secondHex8String = hex8String;
      var gradientType = this._gradientType ? "GradientType = 1, " : "";
      if (secondColor) {
        var s = tinycolor(secondColor);
        secondHex8String = "#" + rgbaToArgbHex(s._r, s._g, s._b, s._a);
      }
      return "progid:DXImageTransform.Microsoft.gradient(" + gradientType + "startColorstr=" + hex8String + ",endColorstr=" + secondHex8String + ")";
    },
    toString: function toString(format) {
      var formatSet = !!format;
      format = format || this._format;
      var formattedString = false;
      var hasAlpha = this._a < 1 && this._a >= 0;
      var needsAlphaFormat = !formatSet && hasAlpha && (format === "hex" || format === "hex6" || format === "hex3" || format === "hex4" || format === "hex8" || format === "name");
      if (needsAlphaFormat) {
        if (format === "name" && this._a === 0) {
          return this.toName();
        }
        return this.toRgbString();
      }
      if (format === "rgb") {
        formattedString = this.toRgbString();
      }
      if (format === "prgb") {
        formattedString = this.toPercentageRgbString();
      }
      if (format === "hex" || format === "hex6") {
        formattedString = this.toHexString();
      }
      if (format === "hex3") {
        formattedString = this.toHexString(true);
      }
      if (format === "hex4") {
        formattedString = this.toHex8String(true);
      }
      if (format === "hex8") {
        formattedString = this.toHex8String();
      }
      if (format === "name") {
        formattedString = this.toName();
      }
      if (format === "hsl") {
        formattedString = this.toHslString();
      }
      if (format === "hsv") {
        formattedString = this.toHsvString();
      }
      return formattedString || this.toHexString();
    },
    clone: function clone() {
      return tinycolor(this.toString());
    },
    _applyModification: function _applyModification(fn, args) {
      var color = fn.apply(null, [this].concat([].slice.call(args)));
      this._r = color._r;
      this._g = color._g;
      this._b = color._b;
      this.setAlpha(color._a);
      return this;
    },
    lighten: function lighten() {
      return this._applyModification(_lighten, arguments);
    },
    brighten: function brighten() {
      return this._applyModification(_brighten, arguments);
    },
    darken: function darken() {
      return this._applyModification(_darken, arguments);
    },
    desaturate: function desaturate() {
      return this._applyModification(_desaturate, arguments);
    },
    saturate: function saturate() {
      return this._applyModification(_saturate, arguments);
    },
    greyscale: function greyscale() {
      return this._applyModification(_greyscale, arguments);
    },
    spin: function spin() {
      return this._applyModification(_spin, arguments);
    },
    _applyCombination: function _applyCombination(fn, args) {
      return fn.apply(null, [this].concat([].slice.call(args)));
    },
    analogous: function analogous() {
      return this._applyCombination(_analogous, arguments);
    },
    complement: function complement() {
      return this._applyCombination(_complement, arguments);
    },
    monochromatic: function monochromatic() {
      return this._applyCombination(_monochromatic, arguments);
    },
    splitcomplement: function splitcomplement() {
      return this._applyCombination(_splitcomplement, arguments);
    },
    // Disabled until https://github.com/bgrins/TinyColor/issues/254
    // polyad: function (number) {
    //   return this._applyCombination(polyad, [number]);
    // },
    triad: function triad() {
      return this._applyCombination(polyad, [3]);
    },
    tetrad: function tetrad() {
      return this._applyCombination(polyad, [4]);
    }
  };
  tinycolor.fromRatio = function(color, opts) {
    if (_typeof(color) == "object") {
      var newColor = {};
      for (var i in color) {
        if (color.hasOwnProperty(i)) {
          if (i === "a") {
            newColor[i] = color[i];
          } else {
            newColor[i] = convertToPercentage(color[i]);
          }
        }
      }
      color = newColor;
    }
    return tinycolor(color, opts);
  };
  function inputToRGB(color) {
    var rgb = {
      r: 0,
      g: 0,
      b: 0
    };
    var a = 1;
    var s = null;
    var v = null;
    var l = null;
    var ok = false;
    var format = false;
    if (typeof color == "string") {
      color = stringInputToObject(color);
    }
    if (_typeof(color) == "object") {
      if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
        rgb = rgbToRgb(color.r, color.g, color.b);
        ok = true;
        format = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
      } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
        s = convertToPercentage(color.s);
        v = convertToPercentage(color.v);
        rgb = hsvToRgb(color.h, s, v);
        ok = true;
        format = "hsv";
      } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
        s = convertToPercentage(color.s);
        l = convertToPercentage(color.l);
        rgb = hslToRgb(color.h, s, l);
        ok = true;
        format = "hsl";
      }
      if (color.hasOwnProperty("a")) {
        a = color.a;
      }
    }
    a = boundAlpha(a);
    return {
      ok,
      format: color.format || format,
      r: Math.min(255, Math.max(rgb.r, 0)),
      g: Math.min(255, Math.max(rgb.g, 0)),
      b: Math.min(255, Math.max(rgb.b, 0)),
      a
    };
  }
  function rgbToRgb(r, g2, b) {
    return {
      r: bound01(r, 255) * 255,
      g: bound01(g2, 255) * 255,
      b: bound01(b, 255) * 255
    };
  }
  function rgbToHsl(r, g2, b) {
    r = bound01(r, 255);
    g2 = bound01(g2, 255);
    b = bound01(b, 255);
    var max = Math.max(r, g2, b), min = Math.min(r, g2, b);
    var h2, s, l = (max + min) / 2;
    if (max == min) {
      h2 = s = 0;
    } else {
      var d = max - min;
      s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
      switch (max) {
        case r:
          h2 = (g2 - b) / d + (g2 < b ? 6 : 0);
          break;
        case g2:
          h2 = (b - r) / d + 2;
          break;
        case b:
          h2 = (r - g2) / d + 4;
          break;
      }
      h2 /= 6;
    }
    return {
      h: h2,
      s,
      l
    };
  }
  function hslToRgb(h2, s, l) {
    var r, g2, b;
    h2 = bound01(h2, 360);
    s = bound01(s, 100);
    l = bound01(l, 100);
    function hue2rgb(p3, q2, t) {
      if (t < 0) t += 1;
      if (t > 1) t -= 1;
      if (t < 1 / 6) return p3 + (q2 - p3) * 6 * t;
      if (t < 1 / 2) return q2;
      if (t < 2 / 3) return p3 + (q2 - p3) * (2 / 3 - t) * 6;
      return p3;
    }
    if (s === 0) {
      r = g2 = b = l;
    } else {
      var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      var p2 = 2 * l - q;
      r = hue2rgb(p2, q, h2 + 1 / 3);
      g2 = hue2rgb(p2, q, h2);
      b = hue2rgb(p2, q, h2 - 1 / 3);
    }
    return {
      r: r * 255,
      g: g2 * 255,
      b: b * 255
    };
  }
  function rgbToHsv(r, g2, b) {
    r = bound01(r, 255);
    g2 = bound01(g2, 255);
    b = bound01(b, 255);
    var max = Math.max(r, g2, b), min = Math.min(r, g2, b);
    var h2, s, v = max;
    var d = max - min;
    s = max === 0 ? 0 : d / max;
    if (max == min) {
      h2 = 0;
    } else {
      switch (max) {
        case r:
          h2 = (g2 - b) / d + (g2 < b ? 6 : 0);
          break;
        case g2:
          h2 = (b - r) / d + 2;
          break;
        case b:
          h2 = (r - g2) / d + 4;
          break;
      }
      h2 /= 6;
    }
    return {
      h: h2,
      s,
      v
    };
  }
  function hsvToRgb(h2, s, v) {
    h2 = bound01(h2, 360) * 6;
    s = bound01(s, 100);
    v = bound01(v, 100);
    var i = Math.floor(h2), f = h2 - i, p2 = v * (1 - s), q = v * (1 - f * s), t = v * (1 - (1 - f) * s), mod = i % 6, r = [v, q, p2, p2, t, v][mod], g2 = [t, v, v, q, p2, p2][mod], b = [p2, p2, t, v, v, q][mod];
    return {
      r: r * 255,
      g: g2 * 255,
      b: b * 255
    };
  }
  function rgbToHex(r, g2, b, allow3Char) {
    var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g2).toString(16)), pad2(Math.round(b).toString(16))];
    if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {
      return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
    }
    return hex.join("");
  }
  function rgbaToHex(r, g2, b, a, allow4Char) {
    var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g2).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];
    if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {
      return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
    }
    return hex.join("");
  }
  function rgbaToArgbHex(r, g2, b, a) {
    var hex = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g2).toString(16)), pad2(Math.round(b).toString(16))];
    return hex.join("");
  }
  tinycolor.equals = function(color1, color2) {
    if (!color1 || !color2) return false;
    return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();
  };
  tinycolor.random = function() {
    return tinycolor.fromRatio({
      r: Math.random(),
      g: Math.random(),
      b: Math.random()
    });
  };
  function _desaturate(color, amount) {
    amount = amount === 0 ? 0 : amount || 10;
    var hsl = tinycolor(color).toHsl();
    hsl.s -= amount / 100;
    hsl.s = clamp01(hsl.s);
    return tinycolor(hsl);
  }
  function _saturate(color, amount) {
    amount = amount === 0 ? 0 : amount || 10;
    var hsl = tinycolor(color).toHsl();
    hsl.s += amount / 100;
    hsl.s = clamp01(hsl.s);
    return tinycolor(hsl);
  }
  function _greyscale(color) {
    return tinycolor(color).desaturate(100);
  }
  function _lighten(color, amount) {
    amount = amount === 0 ? 0 : amount || 10;
    var hsl = tinycolor(color).toHsl();
    hsl.l += amount / 100;
    hsl.l = clamp01(hsl.l);
    return tinycolor(hsl);
  }
  function _brighten(color, amount) {
    amount = amount === 0 ? 0 : amount || 10;
    var rgb = tinycolor(color).toRgb();
    rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));
    rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));
    rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));
    return tinycolor(rgb);
  }
  function _darken(color, amount) {
    amount = amount === 0 ? 0 : amount || 10;
    var hsl = tinycolor(color).toHsl();
    hsl.l -= amount / 100;
    hsl.l = clamp01(hsl.l);
    return tinycolor(hsl);
  }
  function _spin(color, amount) {
    var hsl = tinycolor(color).toHsl();
    var hue = (hsl.h + amount) % 360;
    hsl.h = hue < 0 ? 360 + hue : hue;
    return tinycolor(hsl);
  }
  function _complement(color) {
    var hsl = tinycolor(color).toHsl();
    hsl.h = (hsl.h + 180) % 360;
    return tinycolor(hsl);
  }
  function polyad(color, number) {
    if (isNaN(number) || number <= 0) {
      throw new Error("Argument to polyad must be a positive number");
    }
    var hsl = tinycolor(color).toHsl();
    var result = [tinycolor(color)];
    var step = 360 / number;
    for (var i = 1; i < number; i++) {
      result.push(tinycolor({
        h: (hsl.h + i * step) % 360,
        s: hsl.s,
        l: hsl.l
      }));
    }
    return result;
  }
  function _splitcomplement(color) {
    var hsl = tinycolor(color).toHsl();
    var h2 = hsl.h;
    return [tinycolor(color), tinycolor({
      h: (h2 + 72) % 360,
      s: hsl.s,
      l: hsl.l
    }), tinycolor({
      h: (h2 + 216) % 360,
      s: hsl.s,
      l: hsl.l
    })];
  }
  function _analogous(color, results, slices) {
    results = results || 6;
    slices = slices || 30;
    var hsl = tinycolor(color).toHsl();
    var part = 360 / slices;
    var ret = [tinycolor(color)];
    for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results; ) {
      hsl.h = (hsl.h + part) % 360;
      ret.push(tinycolor(hsl));
    }
    return ret;
  }
  function _monochromatic(color, results) {
    results = results || 6;
    var hsv = tinycolor(color).toHsv();
    var h2 = hsv.h, s = hsv.s, v = hsv.v;
    var ret = [];
    var modification = 1 / results;
    while (results--) {
      ret.push(tinycolor({
        h: h2,
        s,
        v
      }));
      v = (v + modification) % 1;
    }
    return ret;
  }
  tinycolor.mix = function(color1, color2, amount) {
    amount = amount === 0 ? 0 : amount || 50;
    var rgb1 = tinycolor(color1).toRgb();
    var rgb2 = tinycolor(color2).toRgb();
    var p2 = amount / 100;
    var rgba = {
      r: (rgb2.r - rgb1.r) * p2 + rgb1.r,
      g: (rgb2.g - rgb1.g) * p2 + rgb1.g,
      b: (rgb2.b - rgb1.b) * p2 + rgb1.b,
      a: (rgb2.a - rgb1.a) * p2 + rgb1.a
    };
    return tinycolor(rgba);
  };
  tinycolor.readability = function(color1, color2) {
    var c1 = tinycolor(color1);
    var c2 = tinycolor(color2);
    return (Math.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c1.getLuminance(), c2.getLuminance()) + 0.05);
  };
  tinycolor.isReadable = function(color1, color2, wcag2) {
    var readability = tinycolor.readability(color1, color2);
    var wcag2Parms, out;
    out = false;
    wcag2Parms = validateWCAG2Parms(wcag2);
    switch (wcag2Parms.level + wcag2Parms.size) {
      case "AAsmall":
      case "AAAlarge":
        out = readability >= 4.5;
        break;
      case "AAlarge":
        out = readability >= 3;
        break;
      case "AAAsmall":
        out = readability >= 7;
        break;
    }
    return out;
  };
  tinycolor.mostReadable = function(baseColor, colorList, args) {
    var bestColor = null;
    var bestScore = 0;
    var readability;
    var includeFallbackColors, level, size;
    args = args || {};
    includeFallbackColors = args.includeFallbackColors;
    level = args.level;
    size = args.size;
    for (var i = 0; i < colorList.length; i++) {
      readability = tinycolor.readability(baseColor, colorList[i]);
      if (readability > bestScore) {
        bestScore = readability;
        bestColor = tinycolor(colorList[i]);
      }
    }
    if (tinycolor.isReadable(baseColor, bestColor, {
      level,
      size
    }) || !includeFallbackColors) {
      return bestColor;
    } else {
      args.includeFallbackColors = false;
      return tinycolor.mostReadable(baseColor, ["#fff", "#000"], args);
    }
  };
  var names = tinycolor.names = {
    aliceblue: "f0f8ff",
    antiquewhite: "faebd7",
    aqua: "0ff",
    aquamarine: "7fffd4",
    azure: "f0ffff",
    beige: "f5f5dc",
    bisque: "ffe4c4",
    black: "000",
    blanchedalmond: "ffebcd",
    blue: "00f",
    blueviolet: "8a2be2",
    brown: "a52a2a",
    burlywood: "deb887",
    burntsienna: "ea7e5d",
    cadetblue: "5f9ea0",
    chartreuse: "7fff00",
    chocolate: "d2691e",
    coral: "ff7f50",
    cornflowerblue: "6495ed",
    cornsilk: "fff8dc",
    crimson: "dc143c",
    cyan: "0ff",
    darkblue: "00008b",
    darkcyan: "008b8b",
    darkgoldenrod: "b8860b",
    darkgray: "a9a9a9",
    darkgreen: "006400",
    darkgrey: "a9a9a9",
    darkkhaki: "bdb76b",
    darkmagenta: "8b008b",
    darkolivegreen: "556b2f",
    darkorange: "ff8c00",
    darkorchid: "9932cc",
    darkred: "8b0000",
    darksalmon: "e9967a",
    darkseagreen: "8fbc8f",
    darkslateblue: "483d8b",
    darkslategray: "2f4f4f",
    darkslategrey: "2f4f4f",
    darkturquoise: "00ced1",
    darkviolet: "9400d3",
    deeppink: "ff1493",
    deepskyblue: "00bfff",
    dimgray: "696969",
    dimgrey: "696969",
    dodgerblue: "1e90ff",
    firebrick: "b22222",
    floralwhite: "fffaf0",
    forestgreen: "228b22",
    fuchsia: "f0f",
    gainsboro: "dcdcdc",
    ghostwhite: "f8f8ff",
    gold: "ffd700",
    goldenrod: "daa520",
    gray: "808080",
    green: "008000",
    greenyellow: "adff2f",
    grey: "808080",
    honeydew: "f0fff0",
    hotpink: "ff69b4",
    indianred: "cd5c5c",
    indigo: "4b0082",
    ivory: "fffff0",
    khaki: "f0e68c",
    lavender: "e6e6fa",
    lavenderblush: "fff0f5",
    lawngreen: "7cfc00",
    lemonchiffon: "fffacd",
    lightblue: "add8e6",
    lightcoral: "f08080",
    lightcyan: "e0ffff",
    lightgoldenrodyellow: "fafad2",
    lightgray: "d3d3d3",
    lightgreen: "90ee90",
    lightgrey: "d3d3d3",
    lightpink: "ffb6c1",
    lightsalmon: "ffa07a",
    lightseagreen: "20b2aa",
    lightskyblue: "87cefa",
    lightslategray: "789",
    lightslategrey: "789",
    lightsteelblue: "b0c4de",
    lightyellow: "ffffe0",
    lime: "0f0",
    limegreen: "32cd32",
    linen: "faf0e6",
    magenta: "f0f",
    maroon: "800000",
    mediumaquamarine: "66cdaa",
    mediumblue: "0000cd",
    mediumorchid: "ba55d3",
    mediumpurple: "9370db",
    mediumseagreen: "3cb371",
    mediumslateblue: "7b68ee",
    mediumspringgreen: "00fa9a",
    mediumturquoise: "48d1cc",
    mediumvioletred: "c71585",
    midnightblue: "191970",
    mintcream: "f5fffa",
    mistyrose: "ffe4e1",
    moccasin: "ffe4b5",
    navajowhite: "ffdead",
    navy: "000080",
    oldlace: "fdf5e6",
    olive: "808000",
    olivedrab: "6b8e23",
    orange: "ffa500",
    orangered: "ff4500",
    orchid: "da70d6",
    palegoldenrod: "eee8aa",
    palegreen: "98fb98",
    paleturquoise: "afeeee",
    palevioletred: "db7093",
    papayawhip: "ffefd5",
    peachpuff: "ffdab9",
    peru: "cd853f",
    pink: "ffc0cb",
    plum: "dda0dd",
    powderblue: "b0e0e6",
    purple: "800080",
    rebeccapurple: "663399",
    red: "f00",
    rosybrown: "bc8f8f",
    royalblue: "4169e1",
    saddlebrown: "8b4513",
    salmon: "fa8072",
    sandybrown: "f4a460",
    seagreen: "2e8b57",
    seashell: "fff5ee",
    sienna: "a0522d",
    silver: "c0c0c0",
    skyblue: "87ceeb",
    slateblue: "6a5acd",
    slategray: "708090",
    slategrey: "708090",
    snow: "fffafa",
    springgreen: "00ff7f",
    steelblue: "4682b4",
    tan: "d2b48c",
    teal: "008080",
    thistle: "d8bfd8",
    tomato: "ff6347",
    turquoise: "40e0d0",
    violet: "ee82ee",
    wheat: "f5deb3",
    white: "fff",
    whitesmoke: "f5f5f5",
    yellow: "ff0",
    yellowgreen: "9acd32"
  };
  var hexNames = tinycolor.hexNames = flip(names);
  function flip(o) {
    var flipped = {};
    for (var i in o) {
      if (o.hasOwnProperty(i)) {
        flipped[o[i]] = i;
      }
    }
    return flipped;
  }
  function boundAlpha(a) {
    a = parseFloat(a);
    if (isNaN(a) || a < 0 || a > 1) {
      a = 1;
    }
    return a;
  }
  function bound01(n, max) {
    if (isOnePointZero(n)) n = "100%";
    var processPercent = isPercentage(n);
    n = Math.min(max, Math.max(0, parseFloat(n)));
    if (processPercent) {
      n = parseInt(n * max, 10) / 100;
    }
    if (Math.abs(n - max) < 1e-6) {
      return 1;
    }
    return n % max / parseFloat(max);
  }
  function clamp01(val) {
    return Math.min(1, Math.max(0, val));
  }
  function parseIntFromHex(val) {
    return parseInt(val, 16);
  }
  function isOnePointZero(n) {
    return typeof n == "string" && n.indexOf(".") != -1 && parseFloat(n) === 1;
  }
  function isPercentage(n) {
    return typeof n === "string" && n.indexOf("%") != -1;
  }
  function pad2(c) {
    return c.length == 1 ? "0" + c : "" + c;
  }
  function convertToPercentage(n) {
    if (n <= 1) {
      n = n * 100 + "%";
    }
    return n;
  }
  function convertDecimalToHex(d) {
    return Math.round(parseFloat(d) * 255).toString(16);
  }
  function convertHexToDecimal(h2) {
    return parseIntFromHex(h2) / 255;
  }
  var matchers = function() {
    var CSS_INTEGER = "[-\\+]?\\d+%?";
    var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
    var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
    var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
    var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
    return {
      CSS_UNIT: new RegExp(CSS_UNIT),
      rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
      rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
      hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
      hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
      hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
      hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
      hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
      hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
    };
  }();
  function isValidCSSUnit(color) {
    return !!matchers.CSS_UNIT.exec(color);
  }
  function stringInputToObject(color) {
    color = color.replace(trimLeft, "").replace(trimRight, "").toLowerCase();
    var named = false;
    if (names[color]) {
      color = names[color];
      named = true;
    } else if (color == "transparent") {
      return {
        r: 0,
        g: 0,
        b: 0,
        a: 0,
        format: "name"
      };
    }
    var match;
    if (match = matchers.rgb.exec(color)) {
      return {
        r: match[1],
        g: match[2],
        b: match[3]
      };
    }
    if (match = matchers.rgba.exec(color)) {
      return {
        r: match[1],
        g: match[2],
        b: match[3],
        a: match[4]
      };
    }
    if (match = matchers.hsl.exec(color)) {
      return {
        h: match[1],
        s: match[2],
        l: match[3]
      };
    }
    if (match = matchers.hsla.exec(color)) {
      return {
        h: match[1],
        s: match[2],
        l: match[3],
        a: match[4]
      };
    }
    if (match = matchers.hsv.exec(color)) {
      return {
        h: match[1],
        s: match[2],
        v: match[3]
      };
    }
    if (match = matchers.hsva.exec(color)) {
      return {
        h: match[1],
        s: match[2],
        v: match[3],
        a: match[4]
      };
    }
    if (match = matchers.hex8.exec(color)) {
      return {
        r: parseIntFromHex(match[1]),
        g: parseIntFromHex(match[2]),
        b: parseIntFromHex(match[3]),
        a: convertHexToDecimal(match[4]),
        format: named ? "name" : "hex8"
      };
    }
    if (match = matchers.hex6.exec(color)) {
      return {
        r: parseIntFromHex(match[1]),
        g: parseIntFromHex(match[2]),
        b: parseIntFromHex(match[3]),
        format: named ? "name" : "hex"
      };
    }
    if (match = matchers.hex4.exec(color)) {
      return {
        r: parseIntFromHex(match[1] + "" + match[1]),
        g: parseIntFromHex(match[2] + "" + match[2]),
        b: parseIntFromHex(match[3] + "" + match[3]),
        a: convertHexToDecimal(match[4] + "" + match[4]),
        format: named ? "name" : "hex8"
      };
    }
    if (match = matchers.hex3.exec(color)) {
      return {
        r: parseIntFromHex(match[1] + "" + match[1]),
        g: parseIntFromHex(match[2] + "" + match[2]),
        b: parseIntFromHex(match[3] + "" + match[3]),
        format: named ? "name" : "hex"
      };
    }
    return false;
  }
  function validateWCAG2Parms(parms) {
    var level, size;
    parms = parms || {
      level: "AA",
      size: "small"
    };
    level = (parms.level || "AA").toUpperCase();
    size = (parms.size || "small").toLowerCase();
    if (level !== "AA" && level !== "AAA") {
      level = "AA";
    }
    if (size !== "small" && size !== "large") {
      size = "small";
    }
    return {
      level,
      size
    };
  }
  const _hoisted_1$2 = { class: "zion-inline-editor-panel-wrapper" };
  const _hoisted_2$1 = {
    key: 0,
    class: "zion-inline-editor-container zion-inline-editor-dropdown zion-inline-editor-dropdown--panel zion-inline-editor-dropdown--panelColor"
  };
  const _sfc_main$4 = {
    __name: "colorPicker",
    props: {
      "modelValue": {
        default: "#ffffff"
      },
      "modelModifiers": {}
    },
    emits: ["update:modelValue"],
    setup(__props) {
      const isPanelvisibile = ref(false);
      const activeColor = useModel(__props, "modelValue");
      const justChangedNode = ref(false);
      const buttonClass = computed(() => ({
        "background-color": activeColor.value || "#fff"
      }));
      const setActiveColor = () => {
        if (justChangedNode.value) {
          justChangedNode.value = false;
          return;
        }
        const currentActiveColor = tinymce.activeEditor.queryCommandValue("ForeColor");
        activeColor.value = tinycolor(currentActiveColor).toHexString();
        justChangedNode.value = true;
      };
      watch(activeColor, (newColors) => {
        if (justChangedNode.value) {
          justChangedNode.value = false;
          return;
        }
        tinymce.activeEditor.formatter.apply("forecolor", { value: newColors });
        justChangedNode.value = true;
      });
      onMounted(() => {
        tinymce.activeEditor.on("NodeChange", setActiveColor);
        setActiveColor();
      });
      onBeforeUnmount(() => {
        tinymce.activeEditor.off("NodeChange", setActiveColor);
      });
      return (_ctx, _cache) => {
        return openBlock(), createElementBlock("div", _hoisted_1$2, [
          createBaseVNode("button", {
            class: "zion-inline-editor-button",
            onClick: _cache[0] || (_cache[0] = withModifiers(($event) => isPanelvisibile.value = !isPanelvisibile.value, ["prevent"]))
          }, [
            createBaseVNode(
              "span",
              {
                class: "zion-inline-editor-color-picker-button",
                style: normalizeStyle(buttonClass.value)
              },
              null,
              4
              /* STYLE */
            )
          ]),
          createVNode(Transition, { name: "panel-show" }, {
            default: withCtx(() => [
              isPanelvisibile.value ? (openBlock(), createElementBlock("div", _hoisted_2$1, [
                createVNode(unref(pn), {
                  modelValue: activeColor.value,
                  "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => activeColor.value = $event)
                }, null, 8, ["modelValue"])
              ])) : createCommentVNode("v-if", true)
            ]),
            _: 1
            /* STABLE */
          })
        ]);
      };
    }
  };
  const _sfc_main$3 = {
    props: ["formatter", "icon", "buttontext"],
    data: function() {
      return {
        isActive: null
      };
    },
    components: {
      "zion-inline-editor-panel": panel
    },
    computed: {
      classses() {
        let classes = [];
        if (typeof this.icon !== "undefined") {
          classes.push("zn_pb_icon");
          classes.push(this.icon);
        }
        if (this.isActive) {
          classes.push("zion-inline-editor-button--active");
        }
        return classes.join(" ");
      }
    },
    beforeMount: function() {
      var self2 = this;
      tinymce.activeEditor.formatter.formatChanged(this.formatter, function(state2) {
        self2.isActive = state2;
      });
      this.isActive = this.hasFormat(this.formatter);
    },
    methods: {
      // Apply button style
      setTextStyle(styleType, event) {
        tinymce.activeEditor.formatter.toggle(styleType);
      },
      // Check if the selection has a specific style applied
      hasFormat(styleType) {
        return tinymce.activeEditor.formatter.match(styleType);
      }
    }
  };
  function _sfc_render$3(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_zion_inline_editor_panel = resolveComponent("zion-inline-editor-panel");
    return openBlock(), createBlock(_component_zion_inline_editor_panel, { icon: "zn_pb_icon znpb_icon-link" }, {
      default: withCtx(() => [
        createBaseVNode(
          "button",
          {
            class: normalizeClass(["zion-inline-editor-button znpb_icon-link", $options.classses]),
            onClick: _cache[0] || (_cache[0] = ($event) => $options.setTextStyle($props.formatter))
          },
          toDisplayString($props.buttontext),
          3
          /* TEXT, CLASS */
        )
      ]),
      _: 1
      /* STABLE */
    });
  }
  const link = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["render", _sfc_render$3]]);
  const _sfc_main$2 = {
    props: ["formatter", "icon", "buttontext", "value"],
    data: function() {
      return {
        isActive: null
      };
    },
    computed: {
      classses() {
        let classes = [];
        if (this.isActive) {
          classes.push("zion-inline-editor-button--active");
        }
        return classes.join(" ");
      }
    },
    beforeMount: function() {
      tinymce.activeEditor.onNodeChange.add(this.hasFormat);
    },
    methods: {
      // Apply button style
      setTextStyle(event) {
        tinymce.activeEditor.formatter.apply("fontweight", { value: this.value });
      },
      // Check if the selection has a specific style applied
      hasFormat() {
        this.isActive = tinymce.activeEditor.formatter.match("fontweight", { value: this.value });
      }
    }
  };
  function _sfc_render$2(_ctx, _cache, $props, $setup, $data, $options) {
    return openBlock(), createElementBlock(
      "button",
      {
        class: normalizeClass(["zion-inline-editor-button", $options.classses]),
        onClick: _cache[0] || (_cache[0] = (...args) => $options.setTextStyle && $options.setTextStyle(...args))
      },
      toDisplayString($props.value),
      3
      /* TEXT, CLASS */
    );
  }
  const fontWeight = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["render", _sfc_render$2]]);
  const _sfc_main$1 = {
    data: function() {
      let data = {
        //Visibility Variables
        isinlineEditorVisible: false,
        isLinkPanelVisible: false,
        //This is for the link panel component (after you press the link btn)
        //??
        isButtonClick: false,
        //TinyMCE Components
        activeEditor: null,
        activeElement: null,
        activeEditorOptionId: null,
        //Link config
        linkTarget: "_self",
        linkUrl: "",
        //Font weights
        fontWeights: [100, 200, 300, 400, 500, 600, 700, 800, 900],
        //Inline Editor position on page
        position: {
          offsetY: 75,
          offsetX: 0,
          posX: 0,
          posY: 0
        },
        //Out of bounds variables
        dragButtonOnScreen: true
        //False if the editor drag button is out of the browser window
      };
      return data;
    },
    components: {
      "zion-inline-editor-popover": popOver,
      "zion-inline-editor-panel": panel,
      "zion-inline-editor-group": group,
      "zion-inline-editor-font-list": fontList,
      "zion-inline-editor-button": buttonComponent,
      "zion-inline-editor-color-picker": _sfc_main$4,
      "zion-inline-editor-link": link,
      "zion-inline-editor-font-weight": fontWeight
    },
    computed: {
      //This is the initial bar position setter (through a style element)
      barStyles: function() {
        let styles = {
          top: this.position.posY - this.position.offsetY + "px",
          left: this.position.posX - this.position.offsetX + "px"
        };
        return styles;
      },
      //Check if the bar is loaded on screen
      isActiveBar: function() {
        return this.isinlineEditorVisible || this.isLinkPanelVisible;
      }
    },
    methods: __spreadProps(__spreadValues({}, mapActions(["hideEditor"])), {
      onMouseDown(event) {
        this.isButtonClick = true;
      },
      onMouseUp(event) {
        this.isButtonClick = false;
      },
      startDrag(event) {
        window.addEventListener("mouseup", this.stopDrag);
        document.getElementsByClassName("zion-inline-editor-dropdown__arrow--bottom")[0].style.transition = "none";
        let mouseCoordsX, mouseCoordsY;
        let barPosition = this.position;
        let initialOffsetX = this.position.offsetX;
        let initialOffsetY = this.position.offsetY;
        let mouseInitCoordsX = window.event.pageX;
        let mouseInitCoordsY = window.event.pageY;
        function findAndUpdateMouseCoords(mouseEvent) {
          if (mouseEvent) {
            mouseCoordsX = mouseEvent.pageX;
            mouseCoordsY = mouseEvent.pageY;
          } else {
            mouseCoordsX = window.event.pageX;
            mouseCoordsY = window.event.pageY;
          }
          if (mouseCoordsX - mouseInitCoordsX) {
            barPosition.offsetX = initialOffsetX - (mouseCoordsX - mouseInitCoordsX);
          }
          if (mouseCoordsY - mouseInitCoordsY) {
            barPosition.offsetY = initialOffsetY - (mouseCoordsY - mouseInitCoordsY);
          }
        }
        window.onmousemove = findAndUpdateMouseCoords;
      },
      stopDrag(event) {
        document.getElementsByClassName("zion-inline-editor-dropdown__arrow--bottom")[0].style.transition = "all .5s";
        window.onmousemove = null;
        this.checkDragButtonOnScreen();
        window.removeEventListener("mouseup", this.stopDrag);
      },
      getInlineEditorRect() {
        return this.$el.getBoundingClientRect();
      },
      getPositionByMouseLocation(mouseLocationX) {
        let inlineEditorRect = this.getInlineEditorRect();
        return { x: mouseLocationX - inlineEditorRect.width / 2 };
      },
      isDragButtonOutOfBounds() {
        let inlineEditorPosition = this.getInlineEditorRect();
        return inlineEditorPosition.x < 40;
      },
      checkDragButtonOnScreen() {
        this.dragButtonOnScreen = !this.isDragButtonOutOfBounds();
      },
      checkDragButtonOnScreenByMouseLocation(mouseLocationX) {
        let inlineEditorPosition = this.getPositionByMouseLocation(mouseLocationX);
        this.dragButtonOnScreen = inlineEditorPosition.x > 40;
      },
      toggleLinkPanel(event) {
        this.isinlineEditorVisible = !this.isinlineEditorVisible;
        this.isLinkPanelVisible = !this.isLinkPanelVisible;
        let node = tinymce.activeEditor.selection.getStart(), link2 = tinymce.activeEditor.dom.getParent(node, "a[href]");
        if (link2) {
          this.linkTarget = link2.target || "_self";
          this.linkUrl = link2.href;
        }
      },
      addLink() {
        if (this.linkUrl.length > 0) {
          tinymce.activeEditor.formatter.apply("link", {
            href: this.linkUrl,
            target: this.linkTarget
          });
        } else {
          tinymce.activeEditor.formatter.remove("link");
        }
        this.toggleLinkPanel();
      },
      unlink() {
        tinymce.activeEditor.execCommand("Unlink");
        this.linkTarget = "_self";
        this.linkUrl = "";
        this.toggleLinkPanel();
      },
      init() {
        if (typeof tinymce === "undefined") {
          return;
        }
        jQuery(document).on("ZnBeforeElementRemove", this.disableTinyMce);
        jQuery(document).on("ZnNewContent", this.enableTinyMce);
        document.addEventListener("keydown", this.hideEditorOnEscapeKey);
        var self2 = this;
        var initPosition = {
          offsetY: 75,
          offsetX: 0
        };
        this.initTinyMCE(".znhg-editable-area");
        jQuery(".zn_pb_wrapper ").on("mousedown", ".znhg-editable-area", function(event) {
          self2.activeEditor = event.currentTarget.id;
          self2.activeElement = event.currentTarget;
          self2.activeEditorOptionId = event.currentTarget.getAttribute("data-optionid");
          self2.position.offsetY = initPosition.offsetY;
          self2.position.offsetX = initPosition.offsetX;
        });
        jQuery(".zn_pb_wrapper ").on("mouseup", ".znhg-editable-area", function(event) {
          if (!self2.isActiveBar) {
            self2.isinlineEditorVisible = true;
            self2.hideEditor();
          }
          self2.position = Object.assign({}, self2.position, {
            posX: event.pageX,
            posY: event.pageY
          });
          self2.$nextTick(function() {
            self2.checkDragButtonOnScreenByMouseLocation(self2.position.posX);
          });
        });
        jQuery(".zn_pb_wrapper").on("blur", ".znhg-editable-area", function(event) {
          if (!self2.isButtonClick) {
            self2.saveContent();
            self2.isinlineEditorVisible = false;
          }
          self2.isButtonClick = false;
        });
        jQuery(window).on("mousedown", function(event) {
          if (jQuery(event.target).is(".zion-inline-editor") || jQuery(event.target).closest(".zion-inline-editor").length > 0) {
            return true;
          }
          if (jQuery(event.target).is(".znhg-editable-area") || jQuery(event.target).closest(".znhg-editable-area").length > 0) {
            return true;
          }
          if (self2.isActiveBar) {
            if (!self2.isButtonClick) {
              self2.saveContent();
              self2.isinlineEditorVisible = false;
            }
            self2.isButtonClick = false;
          }
        });
      },
      saveContent() {
        let editor2 = tinymce.get(this.activeEditor), editorContent = null;
        if (editor2) {
          editorContent = editor2.getContent();
          window.klpb.app.set_element_option(this.activeEditorOptionId, editorContent, this.activeElement);
        }
      },
      initTinyMCE(selector, target) {
        let config = {
          selector,
          entity_encoding: "raw",
          toolbar: false,
          menubar: false,
          selection_toolbar: false,
          inline: true,
          target,
          object_resizing: false,
          formats: {
            lineheight: { inline: "span", classes: "zn-lineheight", styles: { lineHeight: "%value" } },
            letterspacing: { inline: "span", classes: "zn-letterspacing", styles: { letterSpacing: "%value" } },
            fontweight: { inline: "span", classes: "zn-fontweight", styles: { fontWeight: "%value" } },
            uppercase: { inline: "span", classes: "zn-uppercase", styles: { textTransform: "uppercase" } }
          }
        };
        if (typeof tinymce !== "undefined") {
          tinymce.init(config);
        }
      },
      enableTinyMce(event) {
        let inlineEditors;
        if (event.content.length > 0) {
          inlineEditors = event.content[0].querySelectorAll(".znhg-editable-area");
          if (inlineEditors.length > 0) {
            for (let inlineEditor2 of inlineEditors) {
              this.initTinyMCE(null, inlineEditor2);
            }
          }
        }
      },
      disableTinyMce(event) {
        let enabledEditors = event.content[0].querySelectorAll(".znhg-editable-area");
        if (enabledEditors.length > 0) {
          for (let enabledEditor of enabledEditors) {
            if (tinymce.get(enabledEditor.id)) {
              tinymce.get(enabledEditor.id).remove();
            }
          }
        }
      },
      hideEditorOnEscapeKey(event) {
        if (event.keyCode === 27) {
          this.isinlineEditorVisible = false;
          this.isLinkPanelVisible = false;
        }
      }
    }),
    created: function() {
      window.addEventListener("load", this.init);
    },
    beforeDestroy: function() {
      jQuery(document).off("ZnBeforeElementRemove", this.disableTinyMce);
      window.removeEventListener("load", this.init);
      document.removeEventListener("keydown", this.hideEditorOnEscapeKey);
      window.removeEventListener("mouseup", this.stopDrag);
    },
    watch: {
      isActiveBar: function(isActiveBar) {
        if (isActiveBar) {
          document.body.className += " zion-inline-editor--visible";
        } else {
          document.body.className = document.body.className.replace(/\bzion-inline-editor--visible\b/, "");
        }
      },
      isinlineEditorVisible: function(isinlineEditorVisible) {
        if (this.isinlineEditorVisible) {
          this.$nextTick(function() {
            this.checkDragButtonOnScreen();
          });
        }
      }
    }
  };
  const _hoisted_1$1 = {
    key: 1,
    class: "zion-inline-editor-container"
  };
  const _hoisted_2 = {
    key: 3,
    class: "zion-inline-editor-container"
  };
  function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_zion_inline_editor_group = resolveComponent("zion-inline-editor-group");
    const _component_zion_inline_editor_font_list = resolveComponent("zion-inline-editor-font-list");
    const _component_zion_inline_editor_panel = resolveComponent("zion-inline-editor-panel");
    const _component_zion_inline_editor_font_weight = resolveComponent("zion-inline-editor-font-weight");
    const _component_zion_inline_editor_popover = resolveComponent("zion-inline-editor-popover");
    const _component_zion_inline_editor_button = resolveComponent("zion-inline-editor-button");
    const _component_zion_inline_editor_color_picker = resolveComponent("zion-inline-editor-color-picker");
    return openBlock(), createBlock(Transition, { name: "barShow" }, {
      default: withCtx(() => [
        $options.isActiveBar ? (openBlock(), createElementBlock(
          "div",
          {
            key: 0,
            class: "zion-inline-editor zion-inline-editor-container zion-inline-editor-dropdown__arrow--bottom",
            style: normalizeStyle($options.barStyles),
            onMousedown: _cache[9] || (_cache[9] = (...args) => $options.onMouseDown && $options.onMouseDown(...args)),
            onMouseup: _cache[10] || (_cache[10] = (...args) => $options.onMouseUp && $options.onMouseUp(...args))
          },
          [
            createCommentVNode("Normally positioned drag button"),
            _ctx.dragButtonOnScreen ? (openBlock(), createElementBlock(
              "div",
              {
                key: 0,
                class: "zion-inline-editor-dragbutton",
                onMousedown: _cache[0] || (_cache[0] = (...args) => $options.startDrag && $options.startDrag(...args)),
                onMouseup: _cache[1] || (_cache[1] = (...args) => $options.stopDrag && $options.stopDrag(...args))
              },
              "|||",
              32
              /* NEED_HYDRATION */
            )) : createCommentVNode("v-if", true),
            createCommentVNode("Editing tools container"),
            _ctx.isinlineEditorVisible ? (openBlock(), createElementBlock("div", _hoisted_1$1, [
              createCommentVNode(" Fonts & text style panel "),
              createVNode(_component_zion_inline_editor_panel, { buttontext: "Aa" }, {
                default: withCtx(() => [
                  createVNode(_component_zion_inline_editor_group),
                  createVNode(_component_zion_inline_editor_font_list)
                ]),
                _: 1
                /* STABLE */
              }),
              createCommentVNode(" Bold popover "),
              createVNode(_component_zion_inline_editor_popover, { icon: "znpb_icon-bold" }, {
                default: withCtx(() => [
                  (openBlock(true), createElementBlock(
                    Fragment,
                    null,
                    renderList(_ctx.fontWeights, (fontWeight2) => {
                      return openBlock(), createBlock(_component_zion_inline_editor_font_weight, {
                        key: fontWeight2,
                        value: fontWeight2
                      }, null, 8, ["value"]);
                    }),
                    128
                    /* KEYED_FRAGMENT */
                  ))
                ]),
                _: 1
                /* STABLE */
              }),
              createCommentVNode(" Italic button "),
              createVNode(_component_zion_inline_editor_button, {
                formatter: "italic",
                icon: "znpb_icon-italic"
              }),
              createCommentVNode(" Underline button "),
              createVNode(_component_zion_inline_editor_button, {
                formatter: "underline",
                icon: "znpb_icon-underline"
              }),
              createCommentVNode(" Uppercase button "),
              createVNode(_component_zion_inline_editor_button, {
                formatter: "uppercase",
                buttontext: "TT"
              }),
              createCommentVNode(" Link button "),
              createBaseVNode("button", {
                class: "zion-inline-editor-button zn_pb_icon znpb_icon-link",
                onClick: _cache[2] || (_cache[2] = (...args) => $options.toggleLinkPanel && $options.toggleLinkPanel(...args))
              }),
              createCommentVNode(" Quote button "),
              createVNode(_component_zion_inline_editor_button, {
                formatter: "blockquote",
                icon: "znpb_icon-quote-right"
              }),
              createCommentVNode(" Color Picker "),
              createVNode(_component_zion_inline_editor_color_picker),
              createCommentVNode(" Text align button "),
              createVNode(_component_zion_inline_editor_popover, { icon: "znpb_icon-align-center" }, {
                default: withCtx(() => [
                  createCommentVNode(" Align left "),
                  createVNode(_component_zion_inline_editor_button, {
                    formatter: "alignleft",
                    icon: "znpb_icon-align-left"
                  }),
                  createCommentVNode(" Align center "),
                  createVNode(_component_zion_inline_editor_button, {
                    formatter: "aligncenter",
                    icon: "znpb_icon-align-center"
                  }),
                  createCommentVNode(" Align right "),
                  createVNode(_component_zion_inline_editor_button, {
                    formatter: "alignright",
                    icon: "znpb_icon-align-right"
                  }),
                  createCommentVNode(" Align justify "),
                  createVNode(_component_zion_inline_editor_button, {
                    formatter: "alignjustify",
                    icon: "znpb_icon-align-justify"
                  })
                ]),
                _: 1
                /* STABLE */
              })
            ])) : createCommentVNode("v-if", true),
            createCommentVNode("Alternatively positioned drag button (if the normal one is out of bounds)"),
            !_ctx.dragButtonOnScreen ? (openBlock(), createElementBlock(
              "div",
              {
                key: 2,
                class: "zion-inline-editor-dragbutton",
                onMousedown: _cache[3] || (_cache[3] = (...args) => $options.startDrag && $options.startDrag(...args)),
                onMouseup: _cache[4] || (_cache[4] = (...args) => $options.stopDrag && $options.stopDrag(...args))
              },
              "|||",
              32
              /* NEED_HYDRATION */
            )) : createCommentVNode("v-if", true),
            createCommentVNode("Link Panel"),
            _ctx.isLinkPanelVisible ? (openBlock(), createElementBlock("div", _hoisted_2, [
              createBaseVNode("button", {
                class: "zion-inline-editor-button zn_pb_icon znpb_icon-unlink",
                onClick: _cache[5] || (_cache[5] = withModifiers((...args) => $options.unlink && $options.unlink(...args), ["prevent"]))
              }),
              withDirectives(createBaseVNode(
                "select",
                {
                  "onUpdate:modelValue": _cache[6] || (_cache[6] = ($event) => _ctx.linkTarget = $event),
                  class: "zion-inline-editor-link-target",
                  placeholder: "Select target"
                },
                _cache[11] || (_cache[11] = [
                  createBaseVNode(
                    "option",
                    { value: "_self" },
                    "self",
                    -1
                    /* CACHED */
                  ),
                  createBaseVNode(
                    "option",
                    { value: "_blank" },
                    "blank",
                    -1
                    /* CACHED */
                  )
                ]),
                512
                /* NEED_PATCH */
              ), [
                [vModelSelect, _ctx.linkTarget]
              ]),
              withDirectives(createBaseVNode(
                "input",
                {
                  "onUpdate:modelValue": _cache[7] || (_cache[7] = ($event) => _ctx.linkUrl = $event),
                  class: "zion-inline-editor-link-url",
                  type: "text"
                },
                null,
                512
                /* NEED_PATCH */
              ), [
                [vModelText, _ctx.linkUrl]
              ]),
              createBaseVNode("button", {
                class: "zion-inline-editor-button zn_pb_icon znpb_icon-link",
                onClick: _cache[8] || (_cache[8] = (...args) => $options.addLink && $options.addLink(...args))
              })
            ])) : createCommentVNode("v-if", true)
          ],
          36
          /* STYLE, NEED_HYDRATION */
        )) : createCommentVNode("v-if", true)
      ]),
      _: 1
      /* STABLE */
    });
  }
  const inlineEditor = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render$1]]);
  const _sfc_main = {
    name: "app",
    data() {
      return {
        tabs: [
          {
            tabTitle: "ADD ELEMENTS",
            tabComponent: "znb-tab-elements"
          },
          {
            tabTitle: "TEMPLATES",
            tabComponent: "znb-tab-templates"
          },
          {
            tabTitle: "SAVED ELEMENTS",
            tabComponent: "znb-tab-saved-elements"
          }
        ]
      };
    },
    computed: __spreadProps(__spreadValues({}, mapGetters(["isEditorResizing", "isEditorVisible", "activeTab"])), {
      styles: function() {
        return {
          height: this.$store.getters.editorHeight + "px"
        };
      },
      placeholderStyles: function() {
        return {
          height: this.$store.getters.editorHeight + 49 + "px"
        };
      }
    }),
    components: {
      "znb-editor-header": headerComponent,
      "znb-dragbar": dragBar,
      "znb-tab-elements": elementsTabContent,
      "znb-tab-templates": templatesTabContent,
      "znb-tab-saved-elements": savedElementsTabContent,
      "zion-inlineeditor": inlineEditor
    },
    methods: {
      // ALLOW EDITOR HIDE BY PRESSING CTRL + H
      hideEditorOnCTRLH(event) {
        if (event.keyCode == 72 && event.ctrlKey) {
          event.preventDefault();
          this.$store.dispatch("toggleEditor");
        }
      }
    },
    created: function() {
      document.addEventListener("keydown", this.hideEditorOnCTRLH);
      for (let i = 0; i < this.tabs.length; i++) {
        this.$store.dispatch("registerTab", this.tabs[i]);
      }
      this.$store.dispatch("setActiveTab", this.tabs[0].tabComponent);
    },
    destroyed: function() {
      document.removeEventListener("keydown", this.hideEditorOnCTRLH);
    }
  };
  const _hoisted_1 = { class: "znpbEditorContentWrapper" };
  function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_znb_dragbar = resolveComponent("znb-dragbar");
    const _component_znb_editor_header = resolveComponent("znb-editor-header");
    const _component_zion_inlineeditor = resolveComponent("zion-inlineeditor");
    return openBlock(), createElementBlock(
      "div",
      {
        class: normalizeClass(["znpbEditorWrapper", { znpbEditorResizing: _ctx.isEditorResizing }])
      },
      [
        createBaseVNode(
          "div",
          {
            class: "znpbEditorHeightPlaceholder",
            style: normalizeStyle($options.placeholderStyles)
          },
          null,
          4
          /* STYLE */
        ),
        createBaseVNode("div", _hoisted_1, [
          withDirectives(createVNode(
            _component_znb_dragbar,
            null,
            null,
            512
            /* NEED_PATCH */
          ), [
            [vShow, _ctx.isEditorVisible]
          ]),
          createVNode(_component_znb_editor_header),
          createBaseVNode(
            "div",
            {
              class: "zn_pb_tab_wrapper",
              style: normalizeStyle($options.styles)
            },
            [
              (openBlock(), createBlock(
                KeepAlive,
                null,
                [
                  (openBlock(), createBlock(resolveDynamicComponent(_ctx.activeTab)))
                ],
                1024
                /* DYNAMIC_SLOTS */
              ))
            ],
            4
            /* STYLE */
          )
        ]),
        createVNode(_component_zion_inlineeditor),
        createCommentVNode(' <zion-tooltip v-show="isTooltipActive">{{tooltipContent}}</zion-tooltip> ')
      ],
      2
      /* CLASS */
    );
  }
  const App = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);
  const CHANGE_EDITOR_HEIGHT = "CHANGE_EDITOR_HEIGHT";
  const CHANGE_EDITOR_AUX_HEIGHT = "CHANGE_EDITOR_AUX_HEIGHT";
  const SET_EDITOR_VISIBILITY = "SET_EDITOR_VISIBILITY";
  const SET_EDITOR_RESIZING = "SET_EDITOR_RESIZING";
  const SET_VISIBLE_ELEMENTS = "SET_VISIBLE_ELEMENTS";
  const SET_ELEMENTS_ACTIVE_CATEGORY = "SET_ELEMENTS_ACTIVE_CATEGORY";
  const SET_ACTIVE_TAB = "SET_ACTIVE_TAB";
  const REGISTER_TAB = "REGISTER_TAB";
  const ADD_TEMPLATE = "ADD_TEMPLATE";
  const REMOVE_TEMPLATE = "REMOVE_TEMPLATE";
  const ADD_SAVED_ELEMENT = "ADD_SAVED_ELEMENT";
  const REMOVE_SAVED_ELEMENT = "REMOVE_SAVED_ELEMENT";
  let initialEditorHeight = 230;
  const state$4 = {
    editorHeight: initialEditorHeight,
    editorAuxHeight: initialEditorHeight,
    //We are using this to remember the height whenever the editor is hidden
    isEditorVisible: true,
    isEditorResizing: false
  };
  const getters$4 = {
    editorHeight: (state2) => state2.editorHeight,
    editorAuxHeight: (state2) => state2.editorAuxHeight,
    isEditorVisible: (state2) => state2.isEditorVisible,
    isEditorResizing: (state2) => state2.isEditorResizing
  };
  const actions$4 = {
    //Change the editor height
    changeHeight: ({ commit }, newHeight) => {
      commit(CHANGE_EDITOR_HEIGHT, newHeight);
    },
    //Set a flag whenever the editor is resizing
    setEditorResizing: ({ commit }, isResizing) => {
      commit(SET_EDITOR_RESIZING, isResizing);
    },
    //Show or hide the editor
    toggleEditor: ({ commit, state: state2 }, event) => {
      let editorHeight = state2.isEditorVisible ? 0 : state2.editorAuxHeight;
      commit(CHANGE_EDITOR_AUX_HEIGHT, state2.editorHeight);
      commit(CHANGE_EDITOR_HEIGHT, editorHeight);
      commit(SET_EDITOR_VISIBILITY, !state2.isEditorVisible);
    },
    showEditor({ commit }) {
      commit(CHANGE_EDITOR_HEIGHT, state$4.editorAuxHeight);
      commit(SET_EDITOR_VISIBILITY, true);
    },
    hideEditor({ commit }) {
      let editorHeight = state$4.editorHeight ? state$4.editorHeight : state$4.editorAuxHeight;
      commit(CHANGE_EDITOR_AUX_HEIGHT, editorHeight);
      commit(CHANGE_EDITOR_HEIGHT, 0);
      commit(SET_EDITOR_VISIBILITY, false);
    }
  };
  const mutations$4 = {
    //Change editor height
    [CHANGE_EDITOR_HEIGHT](state2, newHeight) {
      state2.editorHeight = newHeight;
    },
    //Change the editor auxiliary height (so we keep the height it even when the editor is hidden for example)
    [CHANGE_EDITOR_AUX_HEIGHT](state2, newHeight) {
      state2.editorAuxHeight = newHeight;
    },
    //Set editor visibility
    [SET_EDITOR_VISIBILITY](state2, editorVisibility) {
      state2.isEditorVisible = editorVisibility;
    },
    //Set editor resizing
    [SET_EDITOR_RESIZING](state2, isEditorResizing) {
      state2.isEditorResizing = isEditorResizing;
    }
  };
  const editor = {
    state: state$4,
    getters: getters$4,
    actions: actions$4,
    mutations: mutations$4
  };
  const state$3 = {
    allElements: window.ZnPbData.elements_data,
    elementCategories: window.ZnPbData.pb_menu,
    visibleElements: window.ZnPbData.elements_data,
    activeCategory: ""
  };
  const getters$3 = {
    allElements: (state2) => state2.allElements,
    elementCategories: (state2) => state2.elementCategories,
    activeCategory: (state2) => state2.activeCategory,
    visibleElements: (state2) => state2.visibleElements
  };
  const actions$3 = {
    setActiveCategory({ commit, state: state2 }, category) {
      commit(SET_ELEMENTS_ACTIVE_CATEGORY, category);
    },
    filterElementsByCategory({ commit, state: state2 }, category) {
      let visibleElements = Object.assign(
        [],
        state2.allElements.filter((element) => {
          return element.category.toLowerCase().indexOf(category) !== -1;
        })
      );
      commit(SET_ELEMENTS_ACTIVE_CATEGORY, category);
      commit(SET_VISIBLE_ELEMENTS, visibleElements);
    },
    filterElementsBySearch({ commit, state: state2 }, searchTerm) {
      let visibleElements = Object.assign(
        [],
        state2.allElements.filter((element) => {
          return element.name.toLowerCase().indexOf(searchTerm.toLowerCase()) !== -1 || element.keywords.join().toLowerCase().indexOf(searchTerm.toLowerCase()) !== -1;
        })
      );
      commit(SET_VISIBLE_ELEMENTS, visibleElements);
    },
    filterElementsByLevel({ commit, state: state2 }, elementDropLevel) {
      let visibleElements = Object.assign(
        [],
        state2.allElements.filter((element) => {
          if (elementDropLevel === 1) {
            return parseInt(element.level) === 2;
          } else if (elementDropLevel === 2) {
            return parseInt(element.level) === 3;
          } else {
            return parseInt(element.level) === 3 || parseInt(element.level) === 1;
          }
        })
      );
      commit(SET_VISIBLE_ELEMENTS, visibleElements);
    }
  };
  const mutations$3 = {
    [SET_VISIBLE_ELEMENTS](state2, visibleElements) {
      state2.visibleElements = visibleElements;
    },
    [SET_ELEMENTS_ACTIVE_CATEGORY](state2, activeCategory) {
      state2.activeCategory = activeCategory;
    }
  };
  const elements = {
    state: state$3,
    getters: getters$3,
    actions: actions$3,
    mutations: mutations$3
  };
  const state$2 = {
    activeTab: null,
    registeredTabs: []
  };
  const getters$2 = {
    activeTab: (state2) => state2.activeTab,
    registeredTabs: (state2) => state2.registeredTabs
  };
  const actions$2 = {
    // Change the editor height
    setActiveTab: ({ commit }, newTab) => {
      commit(SET_ACTIVE_TAB, newTab);
    },
    registerTab: ({ commit }, tabComponent) => {
      commit(REGISTER_TAB, tabComponent);
    }
  };
  const mutations$2 = {
    [SET_ACTIVE_TAB](state2, newTab) {
      state2.activeTab = newTab;
    },
    [REGISTER_TAB](state2, newTab) {
      state2.registeredTabs.push(newTab);
    }
  };
  const tabs = {
    state: state$2,
    getters: getters$2,
    actions: actions$2,
    mutations: mutations$2
  };
  const state$1 = {
    allTemplates: window.ZnPbData.allTemplates
  };
  const getters$1 = {
    allTemplates: (state2) => state2.allTemplates
  };
  const actions$1 = {
    // Add a new template
    addTemplate: ({ commit }, template) => {
      commit(ADD_TEMPLATE, template);
    },
    removeTemplate: ({ commit }, template) => {
      commit(REMOVE_TEMPLATE, template);
    }
  };
  const mutations$1 = {
    [ADD_TEMPLATE](state2, template) {
      state2.allTemplates.push(template);
    },
    [REMOVE_TEMPLATE](state2, template) {
      let allElements = state2.allTemplates;
      allElements.splice(allElements.indexOf(template), 1);
    }
  };
  const templates = {
    state: state$1,
    getters: getters$1,
    actions: actions$1,
    mutations: mutations$1
  };
  const state = {
    allSavedElements: window.ZnPbData.allSavedElements
  };
  const getters = {
    allSavedElements: (state2) => state2.allSavedElements
  };
  const actions = {
    // Add a new saved element
    addSavedElement: ({ commit }, element) => {
      commit(ADD_SAVED_ELEMENT, element);
    },
    removeSingleElement: ({ commit }, element) => {
      commit(REMOVE_SAVED_ELEMENT, element);
    }
  };
  const mutations = {
    [ADD_SAVED_ELEMENT](state2, element) {
      state2.allSavedElements.push(element);
    },
    [REMOVE_SAVED_ELEMENT](state2, element) {
      let allElements = state2.allSavedElements;
      allElements.splice(allElements.indexOf(element), 1);
    }
  };
  const savedElements = {
    state,
    getters,
    actions,
    mutations
  };
  const debug = false;
  const store = createStore({
    modules: {
      editor,
      elements,
      tabs,
      templates,
      savedElements
    },
    strict: debug
  });
  if (ZnAjax.debug === true) {
    window.showed_message = true;
  } else {
    window.showed_message = false;
    document.onkeydown = check_message;
  }
  window.onbeforeunload = function(e) {
    if (window.showed_message === true) {
      window.showed_message = false;
    } else {
      return "Any unsaved changes will be lost !";
    }
  };
  function check_message(e) {
    if ((e.which || e.keyCode) == 116 || // F5
    e.ctrlKey && e.keyCode == 82 || // CTRL + R
    e.ctrlKey && e.keyCode == 16 && e.keyCode == 82) {
      e.preventDefault();
      new jQuery.ZnModalConfirm(
        "You are about to refresh the page. Any unsaved changes will be lost. <br>Are you sure you want to reload the page ?",
        "Stay on page",
        "Refresh page",
        function() {
          window.showed_message = true;
          location.reload();
        },
        function() {
          window.showed_message = false;
        }
      );
    }
  }
  var classCallCheck = function(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };
  var createClass = /* @__PURE__ */ function() {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    return function(Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();
  var inherits = function(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  };
  var possibleConstructorReturn = function(self2, call) {
    if (!self2) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return call && (typeof call === "object" || typeof call === "function") ? call : self2;
  };
  var TypeRegistry = function() {
    function TypeRegistry2() {
      var initial = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      classCallCheck(this, TypeRegistry2);
      this.registeredTypes = initial;
    }
    createClass(TypeRegistry2, [{
      key: "get",
      value: function get(type) {
        if (typeof this.registeredTypes[type] !== "undefined") {
          return this.registeredTypes[type];
        } else {
          return this.registeredTypes["default"];
        }
      }
    }, {
      key: "register",
      value: function register(type, item) {
        if (typeof this.registeredTypes[type] === "undefined") {
          this.registeredTypes[type] = item;
        }
      }
    }, {
      key: "registerDefault",
      value: function registerDefault(item) {
        this.register("default", item);
      }
    }]);
    return TypeRegistry2;
  }();
  var KeyExtractors = function(_TypeRegistry) {
    inherits(KeyExtractors2, _TypeRegistry);
    function KeyExtractors2(options) {
      classCallCheck(this, KeyExtractors2);
      var _this = possibleConstructorReturn(this, (KeyExtractors2.__proto__ || Object.getPrototypeOf(KeyExtractors2)).call(this, options));
      _this.registerDefault(function(el) {
        return el.getAttribute("name") || "";
      });
      return _this;
    }
    return KeyExtractors2;
  }(TypeRegistry);
  var InputReaders = function(_TypeRegistry) {
    inherits(InputReaders2, _TypeRegistry);
    function InputReaders2(options) {
      classCallCheck(this, InputReaders2);
      var _this = possibleConstructorReturn(this, (InputReaders2.__proto__ || Object.getPrototypeOf(InputReaders2)).call(this, options));
      _this.registerDefault(function(el) {
        return el.value;
      });
      _this.register("checkbox", function(el) {
        return el.getAttribute("value") !== null ? el.checked ? el.getAttribute("value") : null : el.checked;
      });
      _this.register("select", function(el) {
        return getSelectValue(el);
      });
      return _this;
    }
    return InputReaders2;
  }(TypeRegistry);
  function getSelectValue(elem) {
    var value, option, i;
    var options = elem.options;
    var index = elem.selectedIndex;
    var one = elem.type === "select-one";
    var values = one ? null : [];
    var max = one ? index + 1 : options.length;
    if (index < 0) {
      i = max;
    } else {
      i = one ? index : 0;
    }
    for (; i < max; i++) {
      option = options[i];
      if ((option.selected || i === index) && // Don't return options that are disabled or in a disabled optgroup
      !option.disabled && !(option.parentNode.disabled && option.parentNode.tagName.toLowerCase() === "optgroup")) {
        value = option.value;
        if (one) {
          return value;
        }
        values.push(value);
      }
    }
    return values;
  }
  var KeyAssignmentValidators = function(_TypeRegistry) {
    inherits(KeyAssignmentValidators2, _TypeRegistry);
    function KeyAssignmentValidators2(options) {
      classCallCheck(this, KeyAssignmentValidators2);
      var _this = possibleConstructorReturn(this, (KeyAssignmentValidators2.__proto__ || Object.getPrototypeOf(KeyAssignmentValidators2)).call(this, options));
      _this.registerDefault(function() {
        return true;
      });
      _this.register("radio", function(el) {
        return el.checked;
      });
      return _this;
    }
    return KeyAssignmentValidators2;
  }(TypeRegistry);
  function keySplitter(key) {
    var matches2 = key.match(/[^[\]]+/g);
    var lastKey = void 0;
    if (key.length > 1 && key.indexOf("[]") === key.length - 2) {
      lastKey = matches2.pop();
      matches2.push([lastKey]);
    }
    return matches2;
  }
  function getElementType(el) {
    var typeAttr = void 0;
    var tagName = el.tagName;
    var type = tagName;
    if (tagName.toLowerCase() === "input") {
      typeAttr = el.getAttribute("type");
      if (typeAttr) {
        type = typeAttr;
      } else {
        type = "text";
      }
    }
    return type.toLowerCase();
  }
  function getInputElements(element, options) {
    return Array.prototype.filter.call(element.querySelectorAll("input,select,textarea"), function(el) {
      if (el.tagName.toLowerCase() === "input" && (el.type === "submit" || el.type === "reset")) {
        return false;
      }
      var myType = getElementType(el);
      var extractor = options.keyExtractors.get(myType);
      var identifier = extractor(el);
      var foundInInclude = (options.include || []).indexOf(identifier) !== -1;
      var foundInExclude = (options.exclude || []).indexOf(identifier) !== -1;
      var foundInIgnored = false;
      var reject = false;
      if (options.ignoredTypes) {
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = void 0;
        try {
          for (var _iterator = options.ignoredTypes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var selector = _step.value;
            if (el.matches(selector)) {
              foundInIgnored = true;
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      }
      if (foundInInclude) {
        reject = false;
      } else {
        if (options.include) {
          reject = true;
        } else {
          reject = foundInExclude || foundInIgnored;
        }
      }
      return !reject;
    });
  }
  function assignKeyValue(obj, keychain, value) {
    if (!keychain) {
      return obj;
    }
    var key = keychain.shift();
    if (!obj[key]) {
      obj[key] = Array.isArray(key) ? [] : {};
    }
    if (keychain.length === 0) {
      if (!Array.isArray(obj[key])) {
        obj[key] = value;
      } else if (value !== null) {
        obj[key].push(value);
      }
    }
    if (keychain.length > 0) {
      assignKeyValue(obj[key], keychain, value);
    }
    return obj;
  }
  function serialize(element) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var data = {};
    options.keySplitter = options.keySplitter || keySplitter;
    options.keyExtractors = new KeyExtractors(options.keyExtractors || {});
    options.inputReaders = new InputReaders(options.inputReaders || {});
    options.keyAssignmentValidators = new KeyAssignmentValidators(options.keyAssignmentValidators || {});
    Array.prototype.forEach.call(getInputElements(element, options), function(el) {
      var type = getElementType(el);
      var keyExtractor = options.keyExtractors.get(type);
      var key = keyExtractor(el);
      var inputReader = options.inputReaders.get(type);
      var value = inputReader(el);
      var validKeyAssignment = options.keyAssignmentValidators.get(type);
      if (validKeyAssignment(el, key, value)) {
        var keychain = options.keySplitter(key);
        data = assignKeyValue(data, keychain, value);
      }
    });
    return data;
  }
  (function(_TypeRegistry) {
    inherits(InputWriters, _TypeRegistry);
    function InputWriters(options) {
      classCallCheck(this, InputWriters);
      var _this = possibleConstructorReturn(this, (InputWriters.__proto__ || Object.getPrototypeOf(InputWriters)).call(this, options));
      _this.registerDefault(function(el, value) {
        el.value = value;
      });
      _this.register("checkbox", function(el, value) {
        if (value === null) {
          el.indeterminate = true;
        } else {
          el.checked = Array.isArray(value) ? value.indexOf(el.value) !== -1 : value;
        }
      });
      _this.register("radio", function(el, value) {
        if (value !== void 0) {
          el.checked = el.value === value.toString();
        }
      });
      _this.register("select", setSelectValue);
      return _this;
    }
    return InputWriters;
  })(TypeRegistry);
  function makeArray(arr) {
    var ret = [];
    if (arr !== null) {
      if (Array.isArray(arr)) {
        ret.push.apply(ret, arr);
      } else {
        ret.push(arr);
      }
    }
    return ret;
  }
  function setSelectValue(elem, value) {
    var optionSet, option;
    var options = elem.options;
    var values = makeArray(value);
    var i = options.length;
    while (i--) {
      option = options[i];
      if (values.indexOf(option.value) > -1) {
        option.setAttribute("selected", true);
        optionSet = true;
      }
    }
    if (!optionSet) {
      elem.selectedIndex = -1;
    }
  }
  const __viteBrowserExternal = {};
  const __viteBrowserExternal$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    default: __viteBrowserExternal
  }, Symbol.toStringTag, { value: "Module" }));
  const require$$0 = /* @__PURE__ */ getAugmentedNamespace(__viteBrowserExternal$1);
  var utf8_encode;
  var hasRequiredUtf8_encode;
  function requireUtf8_encode() {
    if (hasRequiredUtf8_encode) return utf8_encode;
    hasRequiredUtf8_encode = 1;
    utf8_encode = function utf8_encode2(argString) {
      if (argString === null || typeof argString === "undefined") {
        return "";
      }
      var string = argString + "";
      var utftext = "";
      var start = void 0;
      var end = void 0;
      var stringl = 0;
      start = end = 0;
      stringl = string.length;
      for (var n = 0; n < stringl; n++) {
        var c1 = string.charCodeAt(n);
        var enc = null;
        if (c1 < 128) {
          end++;
        } else if (c1 > 127 && c1 < 2048) {
          enc = String.fromCharCode(c1 >> 6 | 192, c1 & 63 | 128);
        } else if ((c1 & 63488) !== 55296) {
          enc = String.fromCharCode(c1 >> 12 | 224, c1 >> 6 & 63 | 128, c1 & 63 | 128);
        } else {
          if ((c1 & 64512) !== 55296) {
            throw new RangeError("Unmatched trail surrogate at " + n);
          }
          var c2 = string.charCodeAt(++n);
          if ((c2 & 64512) !== 56320) {
            throw new RangeError("Unmatched lead surrogate at " + (n - 1));
          }
          c1 = ((c1 & 1023) << 10) + (c2 & 1023) + 65536;
          enc = String.fromCharCode(c1 >> 18 | 240, c1 >> 12 & 63 | 128, c1 >> 6 & 63 | 128, c1 & 63 | 128);
        }
        if (enc !== null) {
          if (end > start) {
            utftext += string.slice(start, end);
          }
          utftext += enc;
          start = end = n + 1;
        }
      }
      if (end > start) {
        utftext += string.slice(start, stringl);
      }
      return utftext;
    };
    return utf8_encode;
  }
  var md5 = function md52(str) {
    var hash = void 0;
    try {
      var crypto = require$$0;
      var md5sum = crypto.createHash("md5");
      md5sum.update(str);
      hash = md5sum.digest("hex");
    } catch (e) {
      hash = void 0;
    }
    if (hash !== void 0) {
      return hash;
    }
    var utf8Encode = requireUtf8_encode();
    var xl = void 0;
    var _rotateLeft = function _rotateLeft2(lValue, iShiftBits) {
      return lValue << iShiftBits | lValue >>> 32 - iShiftBits;
    };
    var _addUnsigned = function _addUnsigned2(lX, lY) {
      var lX4 = void 0, lY4 = void 0, lX8 = void 0, lY8 = void 0, lResult = void 0;
      lX8 = lX & 2147483648;
      lY8 = lY & 2147483648;
      lX4 = lX & 1073741824;
      lY4 = lY & 1073741824;
      lResult = (lX & 1073741823) + (lY & 1073741823);
      if (lX4 & lY4) {
        return lResult ^ 2147483648 ^ lX8 ^ lY8;
      }
      if (lX4 | lY4) {
        if (lResult & 1073741824) {
          return lResult ^ 3221225472 ^ lX8 ^ lY8;
        } else {
          return lResult ^ 1073741824 ^ lX8 ^ lY8;
        }
      } else {
        return lResult ^ lX8 ^ lY8;
      }
    };
    var _F = function _F2(x2, y, z2) {
      return x2 & y | ~x2 & z2;
    };
    var _G = function _G2(x2, y, z2) {
      return x2 & z2 | y & ~z2;
    };
    var _H = function _H2(x2, y, z2) {
      return x2 ^ y ^ z2;
    };
    var _I = function _I2(x2, y, z2) {
      return y ^ (x2 | ~z2);
    };
    var _FF = function _FF2(a2, b2, c2, d2, x2, s, ac) {
      a2 = _addUnsigned(a2, _addUnsigned(_addUnsigned(_F(b2, c2, d2), x2), ac));
      return _addUnsigned(_rotateLeft(a2, s), b2);
    };
    var _GG = function _GG2(a2, b2, c2, d2, x2, s, ac) {
      a2 = _addUnsigned(a2, _addUnsigned(_addUnsigned(_G(b2, c2, d2), x2), ac));
      return _addUnsigned(_rotateLeft(a2, s), b2);
    };
    var _HH = function _HH2(a2, b2, c2, d2, x2, s, ac) {
      a2 = _addUnsigned(a2, _addUnsigned(_addUnsigned(_H(b2, c2, d2), x2), ac));
      return _addUnsigned(_rotateLeft(a2, s), b2);
    };
    var _II = function _II2(a2, b2, c2, d2, x2, s, ac) {
      a2 = _addUnsigned(a2, _addUnsigned(_addUnsigned(_I(b2, c2, d2), x2), ac));
      return _addUnsigned(_rotateLeft(a2, s), b2);
    };
    var _convertToWordArray = function _convertToWordArray2(str2) {
      var lWordCount = void 0;
      var lMessageLength = str2.length;
      var lNumberOfWordsTemp1 = lMessageLength + 8;
      var lNumberOfWordsTemp2 = (lNumberOfWordsTemp1 - lNumberOfWordsTemp1 % 64) / 64;
      var lNumberOfWords = (lNumberOfWordsTemp2 + 1) * 16;
      var lWordArray = new Array(lNumberOfWords - 1);
      var lBytePosition = 0;
      var lByteCount = 0;
      while (lByteCount < lMessageLength) {
        lWordCount = (lByteCount - lByteCount % 4) / 4;
        lBytePosition = lByteCount % 4 * 8;
        lWordArray[lWordCount] = lWordArray[lWordCount] | str2.charCodeAt(lByteCount) << lBytePosition;
        lByteCount++;
      }
      lWordCount = (lByteCount - lByteCount % 4) / 4;
      lBytePosition = lByteCount % 4 * 8;
      lWordArray[lWordCount] = lWordArray[lWordCount] | 128 << lBytePosition;
      lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
      lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
      return lWordArray;
    };
    var _wordToHex = function _wordToHex2(lValue) {
      var wordToHexValue = "";
      var wordToHexValueTemp = "";
      var lByte = void 0;
      var lCount = void 0;
      for (lCount = 0; lCount <= 3; lCount++) {
        lByte = lValue >>> lCount * 8 & 255;
        wordToHexValueTemp = "0" + lByte.toString(16);
        wordToHexValue = wordToHexValue + wordToHexValueTemp.substr(wordToHexValueTemp.length - 2, 2);
      }
      return wordToHexValue;
    };
    var x = [];
    var k = void 0;
    var AA = void 0;
    var BB = void 0;
    var CC = void 0;
    var DD = void 0;
    var a = void 0;
    var b = void 0;
    var c = void 0;
    var d = void 0;
    var S11 = 7;
    var S12 = 12;
    var S13 = 17;
    var S14 = 22;
    var S21 = 5;
    var S22 = 9;
    var S23 = 14;
    var S24 = 20;
    var S31 = 4;
    var S32 = 11;
    var S33 = 16;
    var S34 = 23;
    var S41 = 6;
    var S42 = 10;
    var S43 = 15;
    var S44 = 21;
    str = utf8Encode(str);
    x = _convertToWordArray(str);
    a = 1732584193;
    b = 4023233417;
    c = 2562383102;
    d = 271733878;
    xl = x.length;
    for (k = 0; k < xl; k += 16) {
      AA = a;
      BB = b;
      CC = c;
      DD = d;
      a = _FF(a, b, c, d, x[k + 0], S11, 3614090360);
      d = _FF(d, a, b, c, x[k + 1], S12, 3905402710);
      c = _FF(c, d, a, b, x[k + 2], S13, 606105819);
      b = _FF(b, c, d, a, x[k + 3], S14, 3250441966);
      a = _FF(a, b, c, d, x[k + 4], S11, 4118548399);
      d = _FF(d, a, b, c, x[k + 5], S12, 1200080426);
      c = _FF(c, d, a, b, x[k + 6], S13, 2821735955);
      b = _FF(b, c, d, a, x[k + 7], S14, 4249261313);
      a = _FF(a, b, c, d, x[k + 8], S11, 1770035416);
      d = _FF(d, a, b, c, x[k + 9], S12, 2336552879);
      c = _FF(c, d, a, b, x[k + 10], S13, 4294925233);
      b = _FF(b, c, d, a, x[k + 11], S14, 2304563134);
      a = _FF(a, b, c, d, x[k + 12], S11, 1804603682);
      d = _FF(d, a, b, c, x[k + 13], S12, 4254626195);
      c = _FF(c, d, a, b, x[k + 14], S13, 2792965006);
      b = _FF(b, c, d, a, x[k + 15], S14, 1236535329);
      a = _GG(a, b, c, d, x[k + 1], S21, 4129170786);
      d = _GG(d, a, b, c, x[k + 6], S22, 3225465664);
      c = _GG(c, d, a, b, x[k + 11], S23, 643717713);
      b = _GG(b, c, d, a, x[k + 0], S24, 3921069994);
      a = _GG(a, b, c, d, x[k + 5], S21, 3593408605);
      d = _GG(d, a, b, c, x[k + 10], S22, 38016083);
      c = _GG(c, d, a, b, x[k + 15], S23, 3634488961);
      b = _GG(b, c, d, a, x[k + 4], S24, 3889429448);
      a = _GG(a, b, c, d, x[k + 9], S21, 568446438);
      d = _GG(d, a, b, c, x[k + 14], S22, 3275163606);
      c = _GG(c, d, a, b, x[k + 3], S23, 4107603335);
      b = _GG(b, c, d, a, x[k + 8], S24, 1163531501);
      a = _GG(a, b, c, d, x[k + 13], S21, 2850285829);
      d = _GG(d, a, b, c, x[k + 2], S22, 4243563512);
      c = _GG(c, d, a, b, x[k + 7], S23, 1735328473);
      b = _GG(b, c, d, a, x[k + 12], S24, 2368359562);
      a = _HH(a, b, c, d, x[k + 5], S31, 4294588738);
      d = _HH(d, a, b, c, x[k + 8], S32, 2272392833);
      c = _HH(c, d, a, b, x[k + 11], S33, 1839030562);
      b = _HH(b, c, d, a, x[k + 14], S34, 4259657740);
      a = _HH(a, b, c, d, x[k + 1], S31, 2763975236);
      d = _HH(d, a, b, c, x[k + 4], S32, 1272893353);
      c = _HH(c, d, a, b, x[k + 7], S33, 4139469664);
      b = _HH(b, c, d, a, x[k + 10], S34, 3200236656);
      a = _HH(a, b, c, d, x[k + 13], S31, 681279174);
      d = _HH(d, a, b, c, x[k + 0], S32, 3936430074);
      c = _HH(c, d, a, b, x[k + 3], S33, 3572445317);
      b = _HH(b, c, d, a, x[k + 6], S34, 76029189);
      a = _HH(a, b, c, d, x[k + 9], S31, 3654602809);
      d = _HH(d, a, b, c, x[k + 12], S32, 3873151461);
      c = _HH(c, d, a, b, x[k + 15], S33, 530742520);
      b = _HH(b, c, d, a, x[k + 2], S34, 3299628645);
      a = _II(a, b, c, d, x[k + 0], S41, 4096336452);
      d = _II(d, a, b, c, x[k + 7], S42, 1126891415);
      c = _II(c, d, a, b, x[k + 14], S43, 2878612391);
      b = _II(b, c, d, a, x[k + 5], S44, 4237533241);
      a = _II(a, b, c, d, x[k + 12], S41, 1700485571);
      d = _II(d, a, b, c, x[k + 3], S42, 2399980690);
      c = _II(c, d, a, b, x[k + 10], S43, 4293915773);
      b = _II(b, c, d, a, x[k + 1], S44, 2240044497);
      a = _II(a, b, c, d, x[k + 8], S41, 1873313359);
      d = _II(d, a, b, c, x[k + 15], S42, 4264355552);
      c = _II(c, d, a, b, x[k + 6], S43, 2734768916);
      b = _II(b, c, d, a, x[k + 13], S44, 1309151649);
      a = _II(a, b, c, d, x[k + 4], S41, 4149444226);
      d = _II(d, a, b, c, x[k + 11], S42, 3174756917);
      c = _II(c, d, a, b, x[k + 2], S43, 718787259);
      b = _II(b, c, d, a, x[k + 9], S44, 3951481745);
      a = _addUnsigned(a, AA);
      b = _addUnsigned(b, BB);
      c = _addUnsigned(c, CC);
      d = _addUnsigned(d, DD);
    }
    var temp = _wordToHex(a) + _wordToHex(b) + _wordToHex(c) + _wordToHex(d);
    return temp.toLowerCase();
  };
  const md5$1 = /* @__PURE__ */ getDefaultExportFromCjs(md5);
  (function($2) {
    jQuery.fn.isolatedScroll = function() {
      return this.on("mousewheel DOMMouseScroll", function(e) {
        var bottomOverflow, delta, topOverflow;
        delta = e.wheelDelta || e.originalEvent && e.originalEvent.wheelDelta || -e.detail;
        bottomOverflow = this.scrollTop + jQuery(this).outerHeight() - this.scrollHeight >= 0;
        topOverflow = this.scrollTop <= 0;
        if (delta < 0 && bottomOverflow || delta > 0 && topOverflow) {
          return e.preventDefault();
        }
      });
    };
  })(jQuery);
  (function($2) {
    $2.ZnFramework = function() {
      this.scope = $2(".zn_pb_wrapper");
      this.publish_button = $2(".zn_publish");
      this.columns_widths = "col-md-12 col-md-11 col-md-10 col-md-9 col-md-8 col-md-7 col-md-6 col-md-5 col-md-4 col-md-3 col-md-2 col-md-1-5 col-sm-12 col-sm-11 col-sm-10 col-sm-9 col-sm-8 col-sm-7 col-sm-6 col-sm-5 col-sm-4 col-sm-3 col-sm-2 col-sm-1-5";
      this.body = $2("body");
      this.zinit();
    };
    $2.ZnFramework.prototype = {
      zinit: function() {
        var fw = this;
        fw.addactions();
        fw.refresh_events(this.body);
        fw.remove_el();
        fw.zn_bind_sortable();
        fw.check_element_content();
      },
      /**
       * Refresh and start the pagebuilder
       */
      refresh_events: function(content) {
        var fw = this;
        fw.show_element_save(content);
        fw.launch_sortable(content);
        fw.check_sortable_content();
        fw.clone_el(content);
      },
      refresh_fw_content: function(content) {
        var fw = this;
        fw.do_live_change(content);
        fw.enable_options_tabs(content);
      },
      /**
       * Bind specific actions
       */
      addactions: function() {
        var fw = this;
        fw.show_element_options();
        fw.select_width();
        fw.showHideElement();
        fw.scope.on("ZnNewContent", function(e) {
          fw.refresh_events(e.content);
        });
        fw.scope.on("ZnNewFWContent", function(e) {
          fw.refresh_fw_content(e.content);
        });
      },
      check_element_content: function() {
        $2(".zn_pb_wrapper .zn_pb_el_container").each(function() {
          if ($2(this).height() < 2 && $2(this).is(":visible")) {
            $2(this).append(
              '<div class="zn-pb-notification">Please configure the element options.</div>'
            );
          }
        });
      },
      isolate_scroll: function(scope) {
        $2(scope).find(".zn-modal-form").isolatedScroll();
      },
      getElementData: function(elementUid, prop) {
        var elementData = {};
        if (elementUid && window.ZnPbData.current_layout[elementUid]) {
          if (prop) {
            elementData = window.ZnPbData.current_layout[elementUid]["data"][prop];
          } else {
            elementData = window.ZnPbData.current_layout[elementUid];
          }
        }
        return elementData;
      },
      /**
       * Will fire up all the sortables ( columns and elements )
       */
      launch_sortable: function(scope) {
        var fw = this;
        $2(scope).find(".zn_columns_container").sortable(fw.sortable_arguments("column_element"));
        $2(scope).find(".zn_sortable_content").sortable(fw.sortable_arguments("content_element"));
      },
      /**
       * Returns the sortable arguments for each type
       */
      sortable_arguments: function(scope) {
        var fw = this, element = scope == "content_element" ? ".zn_pb_wrapper .zn_sortable_content, .zn_pb_wrapper" : ".zn_pb_wrapper .zn_columns_container", placeholder = scope == "content_element" ? "zn_element_placeholder" : "zn_columns_placeholder", cusorAt = scope == "content_element" ? { left: 125, top: 0 } : { left: 0, top: 0 }, tolerance = scope == "content_element" ? "pointer" : "intersect";
        return {
          tolerance,
          cursorAt: cusorAt,
          connectWith: element,
          helper: function() {
            return '<div class="zn_dragging_placeholder"></div>';
          },
          handle: "> .zn_el_options_bar > a.zn_pb_group_handle",
          placeholder,
          start: function(event, ui) {
            $2(".ui-sortable").sortable("refreshPositions");
            fw.body.addClass("zn_dragg_enabled");
            if (scope == "content_element") {
              ui.placeholder.html('<div class="znpb-placeholder"></div>');
            } else {
              $2(".zn_columns_container").addClass("zn_drop_allowed");
              ui.placeholder.html('<div class="znpb-placeholder"></div>');
            }
          },
          change: function(event, ui) {
            if (scope !== "content_element") {
              var helper_height = $2(ui.helper).prev().height();
              ui.placeholder.css("height", helper_height);
            }
          },
          stop: function(event, ui) {
            if (ui.item.hasClass("zn_pb_element")) {
              fw.place_draggable(event, ui);
            }
            $2(".ui-sortable-disabled").sortable("enable");
            fw.body.removeClass("zn_dragg_enabled");
            $2(".zn_drop_allowed").removeClass("zn_drop_allowed");
            fw.check_sortable_content();
            fw.scope.trigger({ type: "ZnWidthChanged", content: ui.item });
            $2(ui.helper).remove();
          },
          receive: function() {
            fw.check_sortable_content();
          }
        };
      },
      place_draggable: function(event, ui) {
        var fw = this;
        var el = $2(ui.item);
        if (el.hasClass("znpb_cancel_drop")) {
          $2(event.target).sortable("cancel");
          el.remove();
          return false;
        }
        $2(event.target).removeClass("zn_pb_no_content");
        var saved_element_name = $2(el).data("template"), widget_id = $2(el).data("widget");
        var saveElementConfig = {
          elementName: saved_element_name,
          isSingle: $2(el).data("is_single") || false
        };
        fw.render_element(
          el,
          "znpb_render_module",
          false,
          saveElementConfig,
          widget_id
        );
      },
      set_element_option: function(option_id, option_value, el) {
        var fw = this, $el = $2(el).hasClass(".zn_pb_el_container") ? $2(el) : $2(el).closest(".zn_pb_el_container"), element_uid = $el.data("uid");
        if (!$el.length) {
          return;
        }
        var options = fw.get_values($el);
        if (!$2.isEmptyObject(options)) {
          options[option_id] = option_value;
          window.ZnPbData.current_layout[element_uid].options = options;
        }
      },
      // GETS SAVED VALUES FROM VAULT
      get_values: function(el) {
        var element_uid = $2(el).data("uid"), values = {};
        if (element_uid && window.ZnPbData.current_layout[element_uid]) {
          values = window.ZnPbData.current_layout[element_uid].data.options;
        }
        return values;
      },
      build_map: function(scope, removeUIds, widget) {
        var fw = this, JsonData = {};
        scope.each(function(sectionIndex, a) {
          var el = $2(this), contenta = {}, zoptions = fw.get_values(el);
          var content = el.find(".zn_content").filter(function() {
            return $2(this).parentsUntil(el, ".zn_content").length === 0;
          });
          if (el.data("has_multiple")) {
            if (fw.stop_order && fw.stop_order != "undefined" && !$2.isEmptyObject(fw.stop_order)) {
              var cached_stop_order = fw.stop_order;
              fw.stop_order = {};
              $2.each(cached_stop_order, function(k, v) {
                if (v === "deleted") {
                  return true;
                }
                if (typeof v.refreshUid !== "undefined" && v.refreshUid) {
                  removeUIds = true;
                }
                contenta[k] = fw.build_map(v, removeUIds);
              });
            } else {
              for (var i = 0; i < content.length; i++) {
                contenta[i] = fw.build_map(
                  $2(content[i]).children(".zn_pb_section"),
                  removeUIds
                );
              }
            }
            contenta.has_multiple = true;
          } else {
            contenta = fw.build_map(
              content.children(".zn_pb_section"),
              removeUIds
            );
          }
          if (widget) {
            zoptions.widget = widget;
          }
          var sectionconfig = {
            object: el.data("object") || "",
            options: zoptions || "",
            content: contenta || "",
            width: fw.get_col_size(el)[0] || "",
            //   widget: widget || "",
            isHidden: fw.getElementData(el.data("uid"), "isHidden")
          };
          if (!removeUIds) {
            sectionconfig.uid = el.data("uid");
          }
          JsonData[sectionIndex] = sectionconfig;
        });
        return JsonData;
      },
      render_element: function(scope, action, clean_uid, saveElementConfig, widget) {
        var fw = this, JsonData = fw.build_map(scope, clean_uid, widget), placeholder = $2(scope), data = {
          action,
          template: JSON.stringify(JsonData),
          post_id: window.ZnPbData.postId,
          security: ZnAjax.security
        };
        if (typeof saveElementConfig != "undefined") {
          data.template_name = saveElementConfig.elementName;
          data.isSingle = saveElementConfig.isSingle;
        }
        if (action == "znpb_clone_element") {
          placeholder = $2(
            '<div class="zn_loading_placeholder"></div>'
          ).insertAfter(scope);
        }
        fw.scope.trigger({
          type: "ZnBeforePlaceholderReplace",
          content: $2(placeholder)
        });
        $2(placeholder).replaceWith(
          '<div class="znpb-loading-bar"> <div class="znpb-loading-bar-inner"><div class="znpb-loading-bar-inner-loading"></div></div></div>'
        );
        fw.show_page_loading(false);
        $2(".znpb-loading-bar-inner-loading").width(50 + Math.random() * 30 + "%");
        jQuery.post(
          ZnAjax.ajaxurl,
          data,
          function(response) {
            if (response) {
              $2(".znpb-loading-bar-inner-loading").width("100%").delay(200).fadeIn(400, function() {
                var new_content = $2(response.template).filter(".zn_pb_el_container").addClass("znpb-animated ZnBounceIn");
                fw.scope.trigger({
                  type: "ZnNewContent_before",
                  content: new_content
                });
                try {
                  $2(".znpb-loading-bar").replaceWith(new_content);
                  var hasImages = new_content.find("img");
                  if (hasImages.length > 0) {
                    new_content.one("load", function() {
                      if (new_content.height() < 2) {
                        new_content.append(
                          '<div class="zn-pb-notification">Please configure the element options.</div>'
                        );
                      }
                    });
                  } else {
                    if (new_content.height() < 2) {
                      new_content.append(
                        '<div class="zn-pb-notification">Please configure the element options.</div>'
                      );
                    }
                  }
                } catch (e) {
                  console.warn("ZnTheme Error received: " + e);
                }
                fw.scope.trigger({
                  type: "ZnNewContent",
                  content: new_content
                });
                fw.add_to_factory(response.current_layout);
                fw.hide_page_loading(false);
              });
            }
          },
          "json"
        ).fail(function() {
          alert("There was an error");
          fw.hide_page_loading(false);
          $2(".znpb-loading-bar").remove();
        });
      },
      add_to_factory: function(data) {
        $2.each(data, function() {
          window.ZnPbData.current_layout[this.data.uid] = this;
        });
      },
      enable_options_tabs: function(scope) {
        var elements2 = scope ? scope.find(".zn-options-tab-header > a") : $2(".zn-options-tab-header > a");
        elements2.on("click", function(e) {
          e.preventDefault();
          var tab = $2(this).data("zntab"), modal = $2(this).closest(".zn-modal-form");
          modal[0].scrollTop = 0;
          $2(this).closest(".zn-tabs-container").children(".zn-options-tab-content.zn-tab-active").removeClass("zn-tab-active");
          $2(this).closest(".zn-tabs-container").find("> .zn-options-tab-header > .zn-tab-active").removeClass("zn-tab-active");
          $2(this).closest(".zn-tabs-container").find(".zn-tab-key-" + tab).add($2(this)).addClass("zn-tab-active");
        });
      },
      zn_apply_live_style: function(config, that) {
        var el = config.css_class, type = config.type, val_prepend = config.val_prepend, input_el = $2(":input", that).is('[data-live-input="1"]') ? $2('[data-live-input="1"]:input', that) : $2(":input", that), input_el = input_el.not('[type="button"]'), val = input_el.val(), input = input_el.last();
        if (typeof config.is_in_group != "undefined") {
          var modal_instanceNr = $2.ZnModal.openInstance.length - 1, opt_form_placeholder = $2(
            ".zn_modal_placeholder_" + modal_instanceNr
          ).closest(".zn_group"), position = $2(opt_form_placeholder).index();
          el = $2(el).eq(position);
        }
        if (type == "css") {
          var unit = $2(":input", that).is('[data-live-unit="1"]') ? $2('[data-live-unit="1"]:input', that).val() : config.unit;
          var rules = $2(":input", that).is("[data-live-property]") ? $2("[data-live-property]:input", that) : config.css_rule.split(",");
          var rules_to_apply = {};
          $2(rules).each(function(i, property) {
            var v = val + (val ? unit : "");
            if ($2(property).is("[data-live-property]")) {
              if (!$2(property).is(":checked")) {
                v = "";
              }
              property = $2(property).attr("data-live-property");
            }
            rules_to_apply[property] = v;
          });
          $2(el).css(rules_to_apply);
        } else if (type == "boxmodel") {
          input_el.each(function(index, property) {
            var boxRule = config.css_rule;
            $2(el).css(
              boxRule + "-" + $2(property).attr("data-side"),
              $2(property).val()
            );
          });
        } else if (type == "font") {
          input_el.each(function(index, property) {
            $2(el).css(
              $2(property).attr("data-live-font-property"),
              $2(property).val()
            );
          });
        } else if (type == "font_icon") {
          var font_family = $2(":input.zn_icon_family", that).val(), zn_icon_unicode = $2(":input.zn_icon_unicode", that).val();
          var unicode = zn_icon_unicode.split("u").join("0x");
          var converted_unicode = String.fromCharCode(unicode);
          if ($2(el).length === 0) {
            $2(that).closest(".zn_option_container").removeClass("zn_live_change");
          } else {
            $2(el).attr("data-zniconfam", font_family).attr("data-zn_icon", converted_unicode);
          }
        } else if (type == "hide") {
          if (input.is(":checked")) {
            $2(el).show();
          } else {
            $2(el).hide();
          }
        } else if (type == "class") {
          if (input.attr("type") == "checkbox") {
            if (input.is(":checked")) {
              $2(el).addClass(input.val());
            } else {
              $2(el).removeClass(input.val());
            }
          } else {
            var values;
            if (input.attr("type") == "radio") {
              values = $2.map($2("input", that), function(option) {
                return option.value;
              });
              var selectedInput = input_el.filter(":checked");
              val = selectedInput.val();
            } else {
              values = $2.map($2("select option", that), function(option) {
                return option.value;
              });
            }
            if (typeof val_prepend != "undefined" && val_prepend.length > 0) {
              values = $2.map(values, function(option) {
                return val_prepend + option;
              });
              val = val_prepend + val;
            }
            $2(el).removeClass(values.join(" "));
            $2(el).addClass(val);
          }
        }
        if (typeof config.tasks != "undefined") {
          var tasks = config.tasks;
          if (!jQuery.isEmptyObject(tasks)) {
            $2.each(tasks, function(idx, task) {
              var condition_type = task.condition_type, css_class = task.css_class, property = task.property, options = task.options, property_value = task.property_value;
              var can_set = false;
              for (var key in options) {
                if (options[key] === val) {
                  can_set = true;
                }
              }
              if (can_set) {
                if (condition_type === "set") {
                  $2(css_class).css(property, property_value);
                }
                if (condition_type === "remove") {
                  $2(css_class).css(property, "");
                }
              }
            });
          }
        }
      },
      do_live_change: function(scope) {
        var elements2 = scope ? scope.find(".zn_live_change") : $2(".zn_live_change"), fw = this;
        elements2.on("change zn_change", function() {
          var config = $2(this).data("live_setup"), that = this;
          if (typeof config.multiple != "undefined" && config.multiple.length > 0) {
            for (var i = config.multiple.length - 1; i >= 0; i--) {
              fw.zn_apply_live_style(config.multiple[i], that);
            }
          } else {
            fw.zn_apply_live_style(config, that);
          }
        });
      },
      select_width: function() {
        var fw = this;
        fw.scope.on(
          "click",
          ".zn_pb_select_width .znpb_sizes_container span",
          function() {
            var section = $2(this).closest(".zn_pb_section"), selected_width = $2(this).data("width");
            section.removeClass(fw.columns_widths);
            section.addClass(selected_width);
            var small_class = selected_width.replace("col-md-", "col-sm-");
            section.addClass(small_class);
            section.find(".selected_width").first().removeClass("selected_width");
            $2(this).addClass("selected_width");
            fw.scope.trigger({ type: "ZnWidthChanged", content: section });
          }
        );
      },
      get_col_size: function(column) {
        if (column.hasClass("col-md-12"))
          return ["col-md-12", "col-md-12", "col-md-11", "12/12"];
        else if (column.hasClass("col-md-11"))
          return ["col-md-11", "col-md-12", "col-md-10", "11/12"];
        else if (column.hasClass("col-md-10"))
          return ["col-md-10", "col-md-11", "col-md-9", "10/12"];
        else if (column.hasClass("col-md-9"))
          return ["col-md-9", "col-md-10", "col-md-8", "9/12"];
        else if (column.hasClass("col-md-8"))
          return ["col-md-8", "col-md-9", "col-md-7", "8/12"];
        else if (column.hasClass("col-md-7"))
          return ["col-md-7", "col-md-8", "col-md-6", "7/12"];
        else if (column.hasClass("col-md-6"))
          return ["col-md-6", "col-md-7", "col-md-5", "6/12"];
        else if (column.hasClass("col-md-5"))
          return ["col-md-5", "col-md-6", "col-md-4", "5/12"];
        else if (column.hasClass("col-md-4"))
          return ["col-md-4", "col-md-5", "col-md-3", "4/12"];
        else if (column.hasClass("col-md-3"))
          return ["col-md-3", "col-md-4", "col-md-2", "3/12"];
        else if (column.hasClass("col-md-2"))
          return ["col-md-2", "col-md-3", "col-md-2", "2/12"];
        else if (column.hasClass("col-md-1-5"))
          return ["col-md-1-5", "col-md-2", "col-md-1-5", "1/5"];
        else return false;
      },
      zn_bind_sortable: function() {
        var fw = this;
        fw.scope.on("mousedown", ".zn_pb_group_handle", function(e) {
          var that = $2(this), currentLevel = that.data("level");
          $2(".zn_sortable_content").each(function() {
            var $this = $2(this);
            if ($this.data("droplevel") >= currentLevel) {
              $this.sortable("disable");
            } else {
              $2(this).addClass("zn_drop_allowed");
            }
          });
        });
        $2(document).on("mouseup", ".zn_pb_group_handle", function() {
          fw.body.removeClass("zn_dragg_enabled");
        });
      },
      /**
       * Check if the sortable UI's are empty
       */
      check_sortable_content: function() {
        $2(
          ".zn_pb_wrapper, .zn_pb_wrapper .zn_sortable_content , .zn_pb_wrapper .zn_columns_container"
        ).each(function() {
          if ($2(this).children().length === 0) {
            $2(this).addClass("zn_pb_no_content");
          } else if ($2(this).children().length > 0) {
            $2(this).removeClass("zn_pb_no_content");
          }
        });
      },
      hide_editor: function() {
        store.dispatch("hideEditor");
      },
      show_editor: function() {
        store.dispatch("showEditor");
      },
      show_page_loading: function(full) {
        var body = $2("body");
        body.addClass("znpb-loading-in-progress");
        this.publish_button.addClass("zn_active");
        if (full) {
          body.addClass("zn_pb_loading");
        }
      },
      hide_page_loading: function(full) {
        var body = $2("body");
        body.removeClass("znpb-loading-in-progress");
        this.publish_button.removeClass("zn_active");
        if (full) {
          body.removeClass("zn_pb_loading");
        }
      },
      //ELEMENT ACTIONS
      clone_el: function(scope) {
        var fw = this, element = scope ? scope.find(".zn_pb_clone_button") : $2(".zn_pb_clone_button");
        $2(element).on("click", function() {
          var el = $2(this).closest(".zn_pb_section");
          fw.render_element(el, "znpb_clone_element", true);
        });
      },
      remove_el: function() {
        var fw = this;
        $2(document).on("click", ".zn_pb_remove", function(e) {
          e.preventDefault();
          var element_to_delete = $2(this).closest(".zn_pb_el_container"), element_container = element_to_delete.parent(), el = this, callback = function() {
            fw.scope.trigger({
              type: "ZnBeforeElementRemove",
              content: $2(element_to_delete)
            });
            element_to_delete.remove();
            if (element_container.children().length < 1) {
              element_container.addClass("zn_pb_no_content");
            }
            if (element_container.has(".ui-sortable")) {
              element_container.sortable("refreshPositions");
              element_container.sortable("refresh");
            }
            element_to_delete = null;
            element_container = null;
            $2(document).off("click", el);
          };
          new $2.ZnModalConfirm(
            "Are you sure you want to remove this element ?",
            "No",
            "Yes",
            callback
          );
        });
      },
      show_element_save: function(scope) {
        var fw = this, element = scope ? scope.find(".znpb-element-save-trigger") : $2(".znpb-element-save-trigger");
        $2(element).on("click", function(e) {
          e.preventDefault();
          fw.hide_editor();
          var params = {}, element_uid = $2(this).data("uid"), main_element = $2(this).closest(".zn_pb_el_container"), level = $2(this).closest(".zn_pb_el_container").data("level");
          params.modal_ajax_hook = "znpb_save_module";
          params.modal_backdrop_class = "zn-modal-transparent";
          params.modal_ajax_params = {
            element_uid,
            element_level: level,
            post_id: window.ZnPbData.postId
          };
          params.modal_title = "Save element";
          params.extra_data = main_element;
          params.modal_on_ajax_load = function(e2) {
            fw.znpb_save_element(e2.modal, e2);
            fw.export_element(e2.modal, e2);
          };
          new $2.ZnModal(params);
        });
        return false;
      },
      znpb_save_element: function(scope, modal) {
        var fw = this, element = scope ? scope.find(".zn_button_save_element") : $2(".zn_button_save_element");
        $2(".zn_save_element_form").on("submit", function(e) {
          e.preventDefault();
        });
        element.click(function(e) {
          e.preventDefault();
          var data = {}, input = $2(this).closest(".zn_save_element_form").find(".zn_input"), saved_name = input.val();
          $2(this).data("uid");
          var level = $2(this).data("level"), JsonData = fw.build_map($2(modal.options.extra_data), true);
          if (typeof saved_name == "undefined" || saved_name.length === 0) {
            alert("Please enter a name for this saved element");
            return;
          }
          data = {
            action: "znpb_do_save_element",
            template: JSON.stringify(JsonData),
            level,
            template_name: saved_name,
            post_id: window.ZnPbData.postId,
            security: ZnAjax.security
          };
          fw.show_page_loading(true);
          jQuery.post(ZnAjax.ajaxurl, data, function(response) {
            if (response.message) {
              new $2.ZnModalMessage(response.message);
              store.dispatch("addSavedElement", {
                name: saved_name,
                level
              });
              input.val("");
              modal.close();
            } else {
              input.val("");
              modal.close();
              new $2.ZnModalMessage("There was a problem saving the template !");
            }
            fw.show_editor();
            $2(".znpb_saved_elements").trigger("click");
          });
          fw.hide_page_loading(true);
        });
      },
      export_element: function(scope, modal) {
        var fw = this, element = scope ? scope.find(".zn_button_export_element") : $2(".zn_button_export_element");
        element.click(function(e) {
          e.preventDefault();
          var data = {}, input = $2(this).closest(".zn_save_element_form").find(".zn_input"), saved_name = input.val();
          $2(this).data("uid");
          var level = $2(this).data("level"), JsonData = fw.build_map($2(modal.options.extra_data), true);
          if (typeof saved_name == "undefined" || saved_name.length === 0) {
            alert("Please enter a name for this saved element");
            return;
          }
          data = {
            action: "zn_export_template",
            template: JSON.stringify(JsonData),
            level,
            template_name: saved_name,
            post_id: window.ZnPbData.postId,
            security: ZnAjax.security
          };
          fw.show_page_loading(true);
          jQuery.post(ZnAjax.ajaxurl, data, function(response) {
            fw.hide_page_loading(true);
            if (response.success === true) {
              window.showed_message = true;
              location.href = ZnAjax.ajaxurl + "?action=znpb_download_export&file_name=" + saved_name + "&nonce=" + ZnAjax.security;
            } else {
              new $2.ZnModalMessage(
                "There was a problem exporting the template: " + saved_name
              );
              console.error("Error: ", saved_name);
            }
            modal.close();
            fw.show_editor();
          });
        });
      },
      show_element_options: function() {
        var fw = this;
        fw.scope.on("click", ".znpb-element-options-trigger", function(e) {
          e.preventDefault();
          fw.hide_editor();
          var params = {}, element_uid = $2(this).data("uid"), main_element = $2(this).closest(".zn_pb_el_container"), options = window.ZnPbData.current_layout[element_uid];
          if (typeof options === "undefined") {
            window.ZnPbData.current_layout[element_uid] = {
              object: "ZnColumn",
              width: fw.get_col_size(main_element)[0] || "",
              // GET OPTION CONTAINER
              uid: element_uid,
              options: {},
              content: {}
            };
            options = window.ZnPbData.current_layout[element_uid];
          }
          if (typeof options.data !== "undefined" && typeof options.data.content !== "undefined" && !$2.isEmptyObject(options.data.content)) {
            options.data.content = {};
          }
          params.modal_ajax_hook = "znpb_get_module_option";
          params.modal_class = "znpb-main-modal";
          params.close_button_title = "Close without saving";
          params.modal_backdrop_class = "zn-modal-transparent";
          params.modal_ajax_params = {
            element_options: JSON.stringify(options),
            post_id: window.ZnPbData.postId
          };
          params.modal_title = $2(this).closest(".zn_pb_section").data("el-name");
          params.modal_on_close = function(e2) {
            var colorPickers = e2.modal.find(".wp-color-picker");
            if (colorPickers.length > 0) {
              colorPickers.each(function(el) {
                if (typeof $2(this).data("wpWpColorPicker") !== "undefined") {
                  $2(this).wpColorPicker("close");
                }
              });
            }
            var form = e2.modal.find(".zn-modal-form"), new_content_checksum = md5$1(fw.get_checksum(form));
            if (form.length > 0 && $2.page_builder.active_edit_checksum !== null && new_content_checksum !== fw.active_edit_checksum) {
              var callback = function() {
                e2.preventClose = false;
                fw.stop_order = {};
                e2.close(true);
              };
              new $2.ZnModalConfirm(
                "You have unsaved options! Any unsaved options will be lost! <br /><b>Are you sure you want to close the options panel?</b>",
                "No",
                "Yes",
                callback
              );
              e2.preventClose = true;
            }
          };
          params.modal_on_ajax_load = function(e2) {
            var form = e2.modal.find(".zn-modal-form");
            form.on("submit", function(e3) {
              e3.preventDefault();
            });
            if (typeof wp !== "undefined" && typeof options !== "undefined" && options.class === "ZnWidgetElement") {
              if (wp.textWidgets) {
                let widgetContainer = form.find(".zn-pb-widget-fields");
                widgetContainer.addClass("open");
                var event = new jQuery.Event("widget-added");
                wp.textWidgets.handleWidgetAdded(event, widgetContainer);
                wp.mediaWidgets.handleWidgetAdded(event, widgetContainer);
                if (wp.customHtmlWidgets) {
                  wp.customHtmlWidgets.handleWidgetAdded(event, widgetContainer);
                }
              }
            }
            function save_order(sort_option2, initial_setup2) {
              sort_option2.children().each(function(idx, element) {
                var x = initial_setup2[$2(element).data("idx")];
                if (x && typeof x != "undefined") {
                  fw.stop_order[idx] = x;
                } else {
                  fw.stop_order[idx] = $2("<div></div>");
                }
              });
            }
            if (main_element.data("has_multiple")) {
              var sort_option = form.find(".zn_group_inner").first();
              var elements2 = sort_option.children();
              var content = main_element.find(".zn_content").filter(function() {
                return jQuery(this).parentsUntil(main_element, ".zn_content").length === 0;
              });
              var initial_setup = {};
              fw.stop_order = {};
              elements2.each(function(idx, element) {
                initial_setup[idx] = $2(content[idx]).children(".zn_pb_section");
              });
              sort_option.children().not(".ui-sortable-placeholder").each(function(idx, element) {
                $2(element).data("idx", idx);
              });
              save_order(sort_option, initial_setup);
              sort_option.find(".zn_remove").on("click", function() {
                $2(document).one("znpb:element:removed", function(event2, el) {
                  fw.stop_order[$2(el).data("idx")] = "deleted";
                });
              });
              sort_option.find(".zn_clone_button").on(
                "znpb:element:cloned",
                function(event2, oldContent, newContent) {
                  var clonedElementIndex = newContent.index(), oldContentElementIndex = oldContent.index();
                  newContent.data("idx", clonedElementIndex);
                  initial_setup[clonedElementIndex] = initial_setup[oldContentElementIndex];
                  initial_setup[clonedElementIndex].refreshUid = true;
                  save_order(sort_option, initial_setup);
                }
              );
              sort_option.on("sortupdate", function(event2, ui) {
                save_order(sort_option, initial_setup);
              });
            }
            fw.isolate_scroll(e2.modal);
            fw.active_edit_checksum = md5$1(fw.get_checksum(form));
          };
          params.footer = function(modal) {
            var footer = '<div class="znpb_modal_options_footer">';
            footer += '<a href="#" class="zn-btn-confirm zn-btn-green zn-attach-save-event">SAVE</a>';
            footer += '<a href="#" class="zn-btn-confirm zn-btn-done zn-attach-saveclose-event">SAVE & CLOSE</a>';
            footer += "</div>";
            var $footer = $2(footer);
            $2(".zn-attach-save-event", $footer).on("click", function(e2) {
              e2.preventDefault();
              $2(window).trigger("debouncedresize");
              if (typeof tinyMCE !== "undefined") {
                tinyMCE.triggerSave();
              }
              var form = modal.modal.find(".zn-modal-form");
              fw.update_el(modal.modal);
              fw.active_edit_checksum = md5$1(fw.get_checksum(form));
            });
            $2(".zn-attach-saveclose-event", $footer).on("click", function(e2) {
              e2.preventDefault();
              $2(window).trigger("debouncedresize");
              if (typeof tinyMCE !== "undefined") {
                tinyMCE.triggerSave();
              }
              var colorPickers = modal.modal.find(".wp-color-picker");
              if (colorPickers.length > 0) {
                colorPickers.each(function(el) {
                  if (typeof $2(this).data("wpWpColorPicker") !== "undefined") {
                    $2(this).wpColorPicker("close");
                  }
                });
              }
              fw.update_el(modal.modal);
              fw.stop_order = {};
              modal.close(true);
            });
            return $footer;
          };
          new $2.ZnModal(params);
        });
        return false;
      },
      showHideElement: function() {
        var fw = this;
        $2(document).on("click", ".zn_pb_hide_element_button", function(e) {
          e.preventDefault();
          var $elementContainer = $2(this).closest(".zn_pb_el_container"), isHidden = $elementContainer.hasClass("znklpb-element-hidden");
          if (isHidden) {
            $elementContainer.removeClass("znklpb-element-hidden");
          } else {
            $elementContainer.attr(
              "data-hidden-text",
              window.ZnPbData.l10n.hidden_text
            );
            $elementContainer.addClass("znklpb-element-hidden");
          }
          fw.setElementVisibility($elementContainer, !isHidden);
        });
      },
      setElementVisibility: function($elementContainer, isHidden) {
        var elementUid = $elementContainer.data("uid"), elementData = this.getElementData(elementUid);
        if (!$2.isEmptyObject(elementData)) {
          window.ZnPbData.current_layout[elementUid].data.isHidden = isHidden;
        }
      },
      update_el: function(scope) {
        var fw = this, form = scope.find(".zn-modal-form").first(), element_uid = form.data("uid"), element = $2('.zn_pb_el_container[data-uid="' + element_uid + '"]'), new_content_checksum = md5$1(fw.get_checksum(form));
        if (form.length === 0) {
          return false;
        }
        fw.body.removeClass("znpb-options-opened");
        if (typeof window.ZnPbData.current_layout[element_uid] != "undefined") {
          window.ZnPbData.current_layout[element_uid].data.options = fw.get_form_values(form);
        } else {
          window.ZnPbData.current_layout[element_uid].data.options = fw.get_form_values(form);
        }
        if ($2.page_builder.active_edit_checksum !== null && new_content_checksum === fw.active_edit_checksum) {
          return;
        }
        fw.render_element(element, "znpb_render_module");
      },
      get_form_values: function(scope) {
        var $inputs = $2(":input", scope);
        var values = {};
        $inputs.each(function() {
          values[this.name] = $2(this).val();
        });
        return serialize(scope[0], {
          inputReaders: {
            checkbox: (el) => {
              if (el.parentNode.classList.contains("zn_toggle2")) {
                return el.getAttribute("value") !== null ? el.checked ? el.getAttribute("value") : "zn_dummy_value" : el.checked;
              } else {
                return el.getAttribute("value") !== null ? el.checked ? el.getAttribute("value") : null : el.checked;
              }
            }
          }
        });
      },
      get_checksum: function(scope) {
        var elements2 = $2(scope).find(".zn_option_container").not(".zn_live_change").find(":input").not("[type=button]"), checksum = "";
        elements2.each(function() {
          if ($2(this).is(":checkbox") && !$2(this).is(":checked")) {
            return;
          }
          if ($2(this).is(":radio") && !$2(this).is(":checked")) {
            return;
          }
          checksum += $2(this).attr("name") + $2(this).val();
        });
        return checksum;
      }
    };
    window.klpb = window.klpb || {};
    window.klpb.app = new $2.ZnFramework();
    $2.page_builder = window.klpb.app;
  })(jQuery);
  window.hg = window.hg || {};
  const app = createApp(App);
  app.use(store);
  app.mount("#zionBuilderApp");
  window.hg.zionBuilder = app;
})();
